/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.util.artifact;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.onseven.dbvis.u.l;
import com.onseven.dbvis.util.artifact.Artifact;
import com.onseven.dbvis.util.artifact.ArtifactFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DriverFile
extends ArtifactFile {
    @JacksonXmlProperty(localName="orig", isAttribute=true)
    String originArtifactId;
    @JacksonXmlProperty(localName="artifactType", isAttribute=true)
    Artifact._b artifactType;
    @JacksonXmlElementWrapper(localName="Classes")
    @JacksonXmlProperty(localName="Class")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private List<l> classInfos = new ArrayList<l>();

    public DriverFile(String string, ArtifactFile._b _b2, String string2, Artifact._b _b3) {
        super(string, _b2);
        this.originArtifactId = string2;
        this.artifactType = _b3;
    }

    public DriverFile(String string, Artifact._b _b2) {
        this.originArtifactId = string;
        this.artifactType = _b2;
    }

    public DriverFile(DriverFile driverFile) {
        super(driverFile.getFilePath(), driverFile.getArtifactFileType());
        this.originArtifactId = driverFile.originArtifactId;
        this.artifactType = driverFile.artifactType;
        this.setRootPath(driverFile.getRootPath());
        this.setArtifactFileType(driverFile.getArtifactFileType());
        List<l> list = driverFile.classInfos;
        for (l l2 : list) {
            this.classInfos.add(new l(l2));
        }
    }

    public DriverFile() {
    }

    public boolean updateClassInfos(List<l> list) {
        boolean bl = false;
        if (this.classInfos == null && list == null) {
            return false;
        }
        if (this.classInfos == null && list != null) {
            this.classInfos = list;
            return true;
        }
        if (this.classInfos != null && list != null && this.classInfos.size() != list.size()) {
            this.classInfos = list;
            return true;
        }
        int n2 = 0;
        if (this.classInfos != null && list != null) {
            for (l l2 : list) {
                if (!l2.d().equals(this.classInfos.get(n2).d()) || !l2.b().equals(this.classInfos.get(n2).b())) {
                    bl = true;
                }
                ++n2;
            }
        }
        this.classInfos = list;
        return bl;
    }

    public String getOriginArtifactId() {
        return this.originArtifactId;
    }

    public void setOriginArtifactId(String string) {
        this.originArtifactId = string;
    }

    public Artifact._b getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(Artifact._b _b2) {
        this.artifactType = _b2;
    }

    public boolean areSame(DriverFile driverFile) {
        if (driverFile == null) {
            return false;
        }
        if (!this.equals(driverFile)) {
            return false;
        }
        if (!Objects.equals(this.originArtifactId, driverFile.originArtifactId) || !Objects.equals((Object)this.artifactType, (Object)driverFile.artifactType)) {
            return false;
        }
        if (this.classInfos == null && driverFile.classInfos == null) {
            return true;
        }
        if (this.classInfos == null || driverFile.classInfos == null) {
            return false;
        }
        if (this.classInfos.size() != driverFile.classInfos.size()) {
            return false;
        }
        int n2 = 0;
        for (l l2 : this.classInfos) {
            l l3 = driverFile.classInfos.get(n2++);
            if (Objects.equals(l2.d(), l3.d()) && Objects.equals(l2.b(), l3.b())) continue;
            return false;
        }
        return true;
    }

    public void addClassInfo(l l2) {
        this.classInfos.add(l2);
    }

    public List<l> getClassInfos() {
        return this.classInfos;
    }

    public String toString() {
        return this.getFilePath();
    }
}

