/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.db.dbinfo.drivertype;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.onseven.dbvis.db.dbinfo.b.b;
import com.onseven.dbvis.db.dbinfo.d;
import com.onseven.dbvis.db.dbinfo.drivertype.DriverCategoryInfo;
import com.onseven.dbvis.db.dbinfo.drivertype.DriverTypeProperty;
import com.onseven.dbvis.db.dbinfo.drivertype.DriverTypePropertyGroup;
import com.onseven.dbvis.db.dbinfo.drivertype.Message;
import com.onseven.dbvis.db.dbinfo.drivertype.WizardUrlFormat;
import com.onseven.dbvis.db.dbinfo.drivertype.f;
import com.onseven.dbvis.db.dbinfo.n;
import com.onseven.dbvis.db.dbinfo.q;
import com.onseven.dbvis.db.dbinfo.x;
import com.onseven.dbvis.u.l;
import com.onseven.dbvis.util.artifact.Artifact;
import com.onseven.dbvis.util.artifact.ArtifactBundle;
import com.onseven.dbvis.util.artifact.ArtifactFile;
import com.onseven.dbvis.util.artifact.DriverFile;
import com.onseven.dbvis.util.artifact.DriverStatus;
import com.onseven.dbvis.util.z;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DriverTypeInfo
extends q
implements n {
    private static final Logger LOG = Logger.getLogger(DriverTypeInfo.class.getName());
    public static final String OTHER_TEMPLATE_ID = "other";
    @JsonProperty(value="OriginId")
    private String originId;
    @JsonProperty(value="OldName")
    private String oldName;
    @JsonProperty(value="DefaultClass")
    private String defaultClass;
    @JsonProperty(value="DatabaseType")
    private String databaseType;
    @JsonProperty(value="Description")
    @JacksonXmlCData
    private String description;
    @JsonProperty(value="IsSupported")
    private boolean isSupported;
    @JacksonXmlProperty(localName="setThreadContext", isAttribute=true)
    private boolean setThreadContext;
    @JsonProperty(value="hidden")
    private final boolean isHidden = false;
    @JsonProperty(value="IconName")
    private String iconName;
    @JsonProperty(value="DriverCategoryId")
    private String driverCategoryId;
    @JsonIgnore
    private DriverCategoryInfo driverCategoryInfo;
    @JacksonXmlElementWrapper(localName="Properties")
    @JacksonXmlProperty(localName="Property")
    private List<DriverTypeProperty> properties = new ArrayList<DriverTypeProperty>();
    @JacksonXmlElementWrapper(localName="PropertyGroups")
    @JacksonXmlProperty(localName="PropertyGroup")
    private List<DriverTypePropertyGroup> propertyGroups = new ArrayList<DriverTypePropertyGroup>();
    @JsonProperty(value="Identifier")
    private String identifier;
    @JsonProperty(value="URLFormat")
    @JacksonXmlCData
    private String urlFormat;
    @JacksonXmlElementWrapper(localName="WizardURLFormats")
    @JacksonXmlProperty(localName="WizardURLFormat")
    private List<WizardUrlFormat> wizardUrlFormats = new ArrayList<WizardUrlFormat>();
    @JsonProperty(value="MessageWhenChosen")
    private Message messageWhenChosen;
    @JsonProperty(value="WebSite")
    private String website;
    @JsonProperty(value="ArtifactBundle")
    private ArtifactBundle artifactBundle = new ArtifactBundle();
    @JacksonXmlElementWrapper(localName="BelongsToDatabaseCategory")
    @JacksonXmlProperty(localName="categoryId")
    private List<String> belongsToCategories = new ArrayList<String>();
    @JsonIgnore
    private List<b> databaseCategoryInfoList = new ArrayList<b>();
    @JsonIgnore
    private d._b packageType;
    @JsonIgnore
    private boolean stored = false;

    public DriverTypeInfo(DriverTypeInfo driverTypeInfo) {
        super(driverTypeInfo);
        this.packageType = driverTypeInfo.packageType;
        this.setLabel(driverTypeInfo.getLabel());
        this.originId = driverTypeInfo.originId;
        this.defaultClass = driverTypeInfo.defaultClass;
        this.iconName = driverTypeInfo.iconName;
        this.driverCategoryId = driverTypeInfo.driverCategoryId;
        this.driverCategoryInfo = driverTypeInfo.driverCategoryInfo;
        this.oldName = driverTypeInfo.oldName;
        this.isSupported = driverTypeInfo.isSupported;
        this.databaseType = driverTypeInfo.databaseType;
        this.setThreadContext = driverTypeInfo.setThreadContext;
        if (driverTypeInfo.properties != null) {
            for (DriverTypeProperty object : driverTypeInfo.properties) {
                this.addDriverTypeProperty(new DriverTypeProperty(object));
            }
        }
        if (driverTypeInfo.propertyGroups != null) {
            for (DriverTypePropertyGroup driverTypePropertyGroup : driverTypeInfo.propertyGroups) {
                this.addPropertyGroup(new DriverTypePropertyGroup(driverTypePropertyGroup));
            }
        }
        this.identifier = driverTypeInfo.identifier;
        this.urlFormat = driverTypeInfo.urlFormat;
        for (WizardUrlFormat wizardUrlFormat : driverTypeInfo.wizardUrlFormats) {
            this.addWizardUrlFormat(new WizardUrlFormat(wizardUrlFormat));
        }
        this.messageWhenChosen = driverTypeInfo.messageWhenChosen != null ? new Message(driverTypeInfo.messageWhenChosen) : null;
        this.website = driverTypeInfo.website;
        this.artifactBundle = new ArtifactBundle(driverTypeInfo.artifactBundle);
        this.belongsToCategories = new ArrayList<String>(driverTypeInfo.belongsToCategories);
        this.description = driverTypeInfo.description;
        for (b b2 : driverTypeInfo.databaseCategoryInfoList) {
            this.addDatabaseCategory(new b(b2));
        }
        this.setStored(false);
    }

    public DriverTypeInfo() {
        this.driverCategoryId = OTHER_TEMPLATE_ID;
    }

    public d._b getPackageType() {
        return this.packageType;
    }

    public void setPackageType(d._b _b2) {
        this.packageType = _b2;
    }

    public String getDriverCategoryId() {
        return this.driverCategoryId;
    }

    public void setDriverCategoryId(String string) {
        this.driverCategoryId = string;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public String getUrlFormat() {
        return this.urlFormat;
    }

    public void setUrlFormat(String string) {
        this.urlFormat = string;
    }

    public void addWizardUrlFormat(WizardUrlFormat wizardUrlFormat) {
        this.wizardUrlFormats.add(wizardUrlFormat);
    }

    public String getWebsite() {
        DriverTypeInfo driverTypeInfo = this.getTemplate();
        if (driverTypeInfo != null) {
            return driverTypeInfo.website;
        }
        return this.website;
    }

    @JsonIgnore
    private DriverTypeInfo getTemplate() {
        if (d._b.b != this.packageType) {
            DriverTypeInfo driverTypeInfo = x.b().h(this);
            return driverTypeInfo;
        }
        return null;
    }

    @JsonGetter(value="WebSite")
    public String getWebsiteRaw() {
        return this.website;
    }

    public void setWebsite(String string) {
        this.website = string;
    }

    public List<DriverTypeProperty> getProperties() {
        return this.properties;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setProperties(List<DriverTypeProperty> list) {
        this.properties = list;
    }

    private void addDriverTypeProperty(DriverTypeProperty driverTypeProperty) {
        this.properties.add(driverTypeProperty);
    }

    public List<WizardUrlFormat> getWizardUrlFormats() {
        DriverTypeInfo driverTypeInfo = this.getTemplate();
        if (driverTypeInfo != null) {
            return driverTypeInfo.wizardUrlFormats;
        }
        return this.wizardUrlFormats;
    }

    @JsonGetter(value="WizardURLFormat")
    public List<WizardUrlFormat> getWizardUrlFormatsRaw() {
        return this.wizardUrlFormats;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setWizardUrlFormats(List<WizardUrlFormat> list) {
        this.wizardUrlFormats = list;
    }

    public Message getMessageWhenChosen() {
        DriverTypeInfo driverTypeInfo = this.getTemplate();
        if (driverTypeInfo != null) {
            return driverTypeInfo.messageWhenChosen;
        }
        return this.messageWhenChosen;
    }

    @JsonGetter(value="MessageWhenChosen")
    public Message getMessageWhenChosenRaw() {
        return this.messageWhenChosen;
    }

    public void setMessageWhenChosen(Message message) {
        this.messageWhenChosen = message;
    }

    public void setArtifactBundle(ArtifactBundle artifactBundle) {
        this.artifactBundle = artifactBundle;
        artifactBundle.setId(this.getId());
    }

    public void setOriginId(String string) {
        this.originId = string;
    }

    public void setIconName(String string) {
        this.iconName = string;
    }

    public void addBelongsToCategory(String string) {
        this.belongsToCategories.add(string);
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setBelongsToCategories(List<String> list) {
        this.belongsToCategories = list;
    }

    public List<String> getBelongsToCategories() {
        DriverTypeInfo driverTypeInfo = this.getTemplate();
        if (driverTypeInfo != null) {
            return driverTypeInfo.belongsToCategories;
        }
        return this.belongsToCategories;
    }

    @JsonGetter(value="categoryId")
    public List<String> getBelongsToCategoriesRaw() {
        return this.belongsToCategories;
    }

    public String getOriginId() {
        return this.originId;
    }

    public String getIconName() {
        return this.iconName;
    }

    @JsonIgnore
    public String getIconPath() {
        Object object;
        String string;
        if (z.j(this.iconName) && (string = this.getFilePathForExistingFile((String)(object = this.getIconFileName(this.iconName)))) != null) {
            return string;
        }
        if (z.j(this.originId) && x.b().c(this.originId) != null) {
            object = x.b().c(this.originId);
            return ((DriverTypeInfo)object).getIconPath();
        }
        if (this.driverCategoryInfo != null) {
            return this.driverCategoryInfo.getIconPath();
        }
        return null;
    }

    public ArtifactBundle getArtifactBundle() {
        return this.artifactBundle;
    }

    public String formatForLog() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.packageType != null) {
            stringBuilder.append(this.packageType.name() + " ");
        }
        stringBuilder.append(this.getLabel());
        Object object = null;
        object = this.getArtifactBundle() != null && this.getArtifactBundle().getDriverStatus() != null ? " (" + this.getArtifactBundle().getDriverStatus().getFiles().size() + " files)" : " - No status";
        stringBuilder.append((String)object);
        return stringBuilder.toString();
    }

    public l getClassInfoForDefaultClass() {
        if (!z.j(this.defaultClass) || this.getArtifactBundle() == null) {
            return null;
        }
        l l2 = f.b(this.defaultClass, this.getArtifactBundle().getDriverStatus());
        if (l2 == null) {
            LOG.log(Level.FINE, "Could not find default class information for driver:" + this.formatId());
        }
        return l2;
    }

    @Override
    public boolean areSame(Object object) {
        int n2;
        if (!(object instanceof DriverTypeInfo)) {
            return false;
        }
        DriverTypeInfo driverTypeInfo = (DriverTypeInfo)object;
        if (Objects.equals(this, driverTypeInfo)) {
            return true;
        }
        if (!(Objects.equals(this.getId(), driverTypeInfo.getId()) && Objects.equals(this.getLabel(), driverTypeInfo.getLabel()) && Objects.equals(this.driverCategoryId, driverTypeInfo.driverCategoryId) && Objects.equals(this.identifier, driverTypeInfo.identifier) && Objects.equals(this.databaseType, driverTypeInfo.databaseType) && Objects.equals(this.urlFormat, driverTypeInfo.urlFormat) && Objects.equals(this.setThreadContext, driverTypeInfo.setThreadContext) && Objects.equals(this.description, driverTypeInfo.description) && Objects.equals(this.website, driverTypeInfo.website))) {
            return false;
        }
        if (this.properties == null && driverTypeInfo.properties != null || this.properties != null && driverTypeInfo.properties == null) {
            return false;
        }
        if (this.properties != null && driverTypeInfo.properties != null) {
            if (this.properties.size() != driverTypeInfo.properties.size()) {
                return false;
            }
            n2 = 0;
            for (DriverTypeProperty object2 : this.properties) {
                if (!object2.areSame(driverTypeInfo.properties.get(n2))) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.wizardUrlFormats == null && driverTypeInfo.wizardUrlFormats != null || this.wizardUrlFormats != null && driverTypeInfo.wizardUrlFormats == null) {
            return false;
        }
        if (this.wizardUrlFormats != null && driverTypeInfo.wizardUrlFormats != null && this.wizardUrlFormats.size() != driverTypeInfo.wizardUrlFormats.size()) {
            return false;
        }
        n2 = 0;
        if (this.wizardUrlFormats != null) {
            for (WizardUrlFormat wizardUrlFormat : this.wizardUrlFormats) {
                if (!wizardUrlFormat.areSame(driverTypeInfo.wizardUrlFormats.get(n2))) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.messageWhenChosen == null && driverTypeInfo.messageWhenChosen != null || this.messageWhenChosen != null && driverTypeInfo.messageWhenChosen == null) {
            return false;
        }
        if (this.artifactBundle != null && !this.artifactBundle.areSame(driverTypeInfo.artifactBundle)) {
            return false;
        }
        if (this.messageWhenChosen == null || driverTypeInfo.messageWhenChosen == null) {
            return Objects.equals(this.messageWhenChosen, driverTypeInfo.messageWhenChosen);
        }
        return this.messageWhenChosen.areSame(driverTypeInfo.messageWhenChosen);
    }

    public boolean isSameStatus(DriverTypeInfo driverTypeInfo) {
        DriverStatus driverStatus;
        DriverStatus driverStatus2 = this.getArtifactBundle().getDriverStatus();
        if (driverStatus2 == (driverStatus = driverTypeInfo.getArtifactBundle().getDriverStatus())) {
            return true;
        }
        return driverStatus2 != null && driverStatus2.areSame(driverStatus);
    }

    public String getDefaultClass() {
        return this.defaultClass;
    }

    public void setDefaultClass(String string) {
        this.defaultClass = string;
    }

    public DriverCategoryInfo getDriverCategoryInfo() {
        return this.driverCategoryInfo;
    }

    public void setDriverCategoryInfo(DriverCategoryInfo driverCategoryInfo) {
        this.driverCategoryInfo = driverCategoryInfo;
    }

    public List<b> getDatabaseCategoryInfoList() {
        return this.databaseCategoryInfoList;
    }

    public void setDatabaseCategoryInfoList(List<b> list) {
        this.databaseCategoryInfoList = list;
    }

    private void addDatabaseCategory(b b2) {
        this.databaseCategoryInfoList.add(b2);
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isStored() {
        return this.stored;
    }

    public void setStored(boolean bl) {
        this.stored = bl;
    }

    public void setOldName(String string) {
        this.oldName = string;
    }

    public void setSupported(boolean bl) {
        this.isSupported = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DriverTypeInfo { ");
        stringBuilder.append("id=").append(this.getId());
        stringBuilder.append("  category=").append(this.driverCategoryId);
        if (this.belongsToCategories.size() > 0) {
            stringBuilder.append(" Belongs to =" + String.join((CharSequence)", ", this.belongsToCategories));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void dump(PrintStream printStream) {
        StringBuilder stringBuilder = new StringBuilder("DriverTypeInfo ");
        stringBuilder.append("  id=").append(this.getId());
        stringBuilder.append("  label=").append(this.getLabel());
        stringBuilder.append("  type=").append((Object)this.getPackageType());
        stringBuilder.append("  driverType=").append(this.databaseType);
        stringBuilder.append("  originId=").append(this.originId);
        stringBuilder.append("  category=").append(this.driverCategoryId).append("\n");
        if (this.belongsToCategories.size() > 0) {
            stringBuilder.append(" Belongs to =" + String.join((CharSequence)", ", this.belongsToCategories)).append("\n");
        }
        stringBuilder.append("  defaultClass=").append(this.defaultClass).append("\n");
        stringBuilder.append("  iconName=").append(this.iconName).append("\n");
        stringBuilder.append("  properties size=").append(this.properties.size()).append("\n");
        stringBuilder.append("  Property Groups size=").append(this.propertyGroups.size()).append("\n");
        stringBuilder.append("  identifier=").append(this.identifier).append("\n");
        stringBuilder.append("  urlFormat=").append(this.urlFormat).append("\n");
        stringBuilder.append("  website=").append(this.website).append("\n");
        stringBuilder.append("  description=").append(this.description).append("\n");
        if (this.artifactBundle.getDriverStatus() != null) {
            stringBuilder.append("  Driver Status: ").append(this.artifactBundle.getDriverStatus().toDebugString(true)).append("\n");
        } else {
            stringBuilder.append("  Driver Status: ").append("-").append("\n");
        }
        printStream.print(stringBuilder);
        this.artifactBundle.dump(printStream);
    }

    public void addProperty(DriverTypeProperty driverTypeProperty) {
        this.properties.add(driverTypeProperty);
    }

    public void addPropertyGroup(DriverTypePropertyGroup driverTypePropertyGroup) {
        this.propertyGroups.add(driverTypePropertyGroup);
    }

    public List<DriverTypePropertyGroup> getPropertyGroups() {
        DriverTypeInfo driverTypeInfo = this.getTemplate();
        if (driverTypeInfo != null) {
            return driverTypeInfo.propertyGroups;
        }
        return this.propertyGroups;
    }

    @JsonGetter(value="PropertyGroup")
    public List<DriverTypePropertyGroup> getPropertyGroupsRaw() {
        return this.propertyGroups;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setPropertyGroups(List<DriverTypePropertyGroup> list) {
        this.propertyGroups = list;
    }

    public void clearProperties() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String formatId() {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append("'" + this.getLabel() + "'").append(" (").append(this.getId()).append(")").toString();
    }

    public void initNonStoredInformation(d._b _b2) {
        this.setStored(true);
        this.setPackageType(_b2);
        for (DriverTypeProperty driverTypeProperty : this.properties) {
            switch (_b2) {
                case b: {
                    driverTypeProperty.setOrigin(DriverTypeProperty._b.b);
                    break;
                }
                case e: 
                case d: {
                    driverTypeProperty.setOrigin(DriverTypeProperty._b.e);
                }
            }
        }
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String string) {
        this.databaseType = string;
    }

    public String getOldName() {
        return this.oldName;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public boolean isSetThreadContext() {
        return this.setThreadContext;
    }

    public void setSetThreadContext(boolean bl) {
        this.setThreadContext = bl;
    }

    public void mergeFrom(DriverTypeInfo driverTypeInfo) {
        DriverTypeInfo driverTypeInfo2 = new DriverTypeInfo(driverTypeInfo);
        this.defaultClass = driverTypeInfo2.defaultClass;
        this.driverCategoryId = driverTypeInfo2.driverCategoryId;
        this.urlFormat = driverTypeInfo2.urlFormat;
        this.driverCategoryInfo = driverTypeInfo2.driverCategoryInfo;
        this.properties = driverTypeInfo2.properties;
        this.propertyGroups = driverTypeInfo2.propertyGroups;
        this.description = driverTypeInfo2.description;
        this.iconName = driverTypeInfo2.iconName;
        this.identifier = driverTypeInfo2.identifier;
        this.wizardUrlFormats = driverTypeInfo2.wizardUrlFormats;
        this.messageWhenChosen = driverTypeInfo2.messageWhenChosen;
        this.website = driverTypeInfo2.website;
        this.belongsToCategories = driverTypeInfo2.belongsToCategories;
        this.packageType = driverTypeInfo2.packageType;
        this.databaseCategoryInfoList = driverTypeInfo2.databaseCategoryInfoList;
        this.oldName = driverTypeInfo2.oldName;
        this.isSupported = driverTypeInfo2.isSupported;
        this.databaseType = driverTypeInfo2.databaseType;
        this.setThreadContext = driverTypeInfo2.setThreadContext;
        this.getArtifactBundle().getArtifacts().clear();
        this.getArtifactBundle().getArtifacts().addAll(driverTypeInfo2.getArtifactBundle().getArtifacts());
    }

    public void cleanDataThatShouldBeFetchedFromTemplate() {
        if (this.properties != null) {
            this.properties.clear();
        }
        if (this.propertyGroups != null) {
            this.propertyGroups.clear();
        }
        this.setDescription(null);
        this.setMessageWhenChosen(null);
        this.setWebsite(null);
        if (this.belongsToCategories != null) {
            this.belongsToCategories.clear();
        }
        if (this.wizardUrlFormats != null) {
            this.wizardUrlFormats.clear();
        }
    }

    public String toExtendedString() {
        StringBuilder stringBuilder = new StringBuilder("*** Driver Information *****************************\n");
        stringBuilder.append("Name: ").append(this.getLabel()).append("\n");
        stringBuilder.append("DefaultClass: ").append(this.getDefaultClass()).append("\n");
        stringBuilder.append("Artifacts: ");
        if (this.getArtifactBundle() == null) {
            stringBuilder.append("-\n");
            return stringBuilder.toString();
        }
        stringBuilder.append("\n");
        DriverStatus driverStatus = this.getArtifactBundle().getDriverStatus();
        Iterator<Artifact> iterator = this.getArtifactBundle().getArtifacts().iterator();
        while (iterator.hasNext()) {
            Iterator<DriverFile> iterator2;
            Artifact artifact = iterator.next();
            stringBuilder.append("  " + artifact.toExtendedString());
            if (artifact.getType() != Artifact._b.d && (iterator2 = driverStatus.getFiles(artifact).iterator()).hasNext()) {
                stringBuilder.append("\n");
                while (iterator2.hasNext()) {
                    DriverFile driverFile = iterator2.next();
                    stringBuilder.append("      ").append(driverFile.getFilePath());
                    if (driverFile.getArtifactFileType() != ArtifactFile._b.d) {
                        stringBuilder.append(" (").append((Object)driverFile.getArtifactFileType()).append(")");
                    }
                    if (!iterator2.hasNext()) continue;
                    stringBuilder.append("\n");
                }
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n*** End Driver Information *************************\n");
        return stringBuilder.toString();
    }
}

