/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.parser;

import com.vertica.dsi.exceptions.ParsingException;
import com.vertica.parser.StatementType;
import com.vertica.parser.Token;
import java.util.ArrayList;

public final class ParsedStatement {
    private String m_sqlText;
    private int m_numParams;
    private StatementType m_type;
    private ArrayList<Token> m_tokens;

    public ParsedStatement(ArrayList<Token> arrayList, int n) throws ParsingException {
        this.m_tokens = arrayList;
        this.m_numParams = n;
        this.m_type = !this.m_tokens.isEmpty() ? StatementType.fromString(this.m_tokens.get(0).toString()) : StatementType.Empty;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.m_tokens.size(); ++i) {
            Token token = this.m_tokens.get(i);
            stringBuilder.append(token.toStringWithDelimiter());
        }
        this.m_sqlText = stringBuilder.toString();
    }

    public int getParameterCount() {
        return this.m_numParams;
    }

    public StatementType getType() {
        return this.m_type;
    }

    public String toString() {
        return this.m_sqlText;
    }
}

