/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.interfaces.IEnvironment;
import com.vertica.dsi.core.interfaces.ITransactionStateListener;
import com.vertica.dsi.core.utilities.AttributeDataMap;
import com.vertica.dsi.core.utilities.ClientInfoData;
import com.vertica.dsi.core.utilities.ConnSettingRequestMap;
import com.vertica.dsi.core.utilities.ConnSettingResponseMap;
import com.vertica.dsi.core.utilities.ConnectionSetting;
import com.vertica.dsi.core.utilities.ConnectionSettingInfo;
import com.vertica.dsi.core.utilities.PromptType;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.impl.DSISimpleArray;
import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.ColumnMetadata;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.BadAttrValException;
import com.vertica.dsi.exceptions.BadAuthException;
import com.vertica.dsi.exceptions.BadPropertyKeyException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.IMessageSource;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.SettingReader;
import com.vertica.support.Warning;
import com.vertica.support.WarningCode;
import com.vertica.support.exceptions.ClientInfoException;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.support.exceptions.ExceptionUtilities;
import com.vertica.support.exceptions.FailedPropertiesReason;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class DSIConnection
implements IConnection {
    public static final String REQ_INDICATOR = "?";
    protected ITransactionStateListener m_transactionListener;
    protected AttributeDataMap m_connectionProperties = new AttributeDataMap();
    private IEnvironment m_environment;
    private IWarningListener m_warningListener = null;
    private Locale m_locale = null;
    private boolean m_isBeingReset = false;
    protected Map<String, ClientInfoData> m_clientInfoProperties = this.initializeClientInfoProperties();
    protected Map<Long, ConnectionSettingInfo> m_connectionSettingInfo = new HashMap<Long, ConnectionSettingInfo>();

    protected DSIConnection(IEnvironment environment) throws ErrorException {
        this.m_environment = environment;
        try {
            this.loadProperties();
            this.m_locale = ExceptionUtilities.createLocale(SettingReader.readSetting("DriverLocale"));
            LogUtilities.logFunctionEntrance(this.getConnectionLog(), environment);
        }
        catch (NumericOverflowException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.NON_TRANSIENT_CONNECTION);
        }
        catch (IncorrectTypeException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.NON_TRANSIENT_CONNECTION);
        }
    }

    @Override
    public void beginTransaction() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public void commit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public void createSavepoint(String name) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), name);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    public void setClientInfoProperty(ClientInfoData clientInfoProperty) throws ErrorException {
        this.m_clientInfoProperties.put(clientInfoProperty.getName(), clientInfoProperty);
    }

    @Override
    public String getClientInfo(String name) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), name);
        if (null != this.m_clientInfoProperties.get(name)) {
            return this.m_clientInfoProperties.get(name).getValue();
        }
        return null;
    }

    @Override
    public Map<String, ClientInfoData> getClientInfoProperties() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return this.m_clientInfoProperties;
    }

    @Override
    public Map<Long, ConnectionSettingInfo> getConnectionSettingInfo() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return this.m_connectionSettingInfo;
    }

    @Override
    public Variant getCustomProperty(int propKey) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), propKey);
        return null;
    }

    @Override
    public int getCustomPropertyType(int propKey) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), propKey);
        return 0;
    }

    @Override
    public String getDataSourceName() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        try {
            return this.getProperty(41).getString();
        }
        catch (BadPropertyKeyException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPKEY.name(), "Data Source Name", (Throwable)e, ExceptionType.DEFAULT);
        }
    }

    @Override
    public Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public void setLocale(Locale locale) {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), locale);
        this.m_locale = locale;
    }

    @Override
    public IMessageSource getMessageSource() {
        return this.m_environment.getMessageSource();
    }

    @Override
    public IEnvironment getParentEnvironment() {
        return this.m_environment;
    }

    @Override
    public Variant getProperty(int propKey) throws BadPropertyKeyException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), propKey);
        if (null == this.m_connectionProperties) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name(), ExceptionType.DEFAULT);
        }
        if (this.m_connectionProperties.isProperty(propKey)) {
            return this.m_connectionProperties.getProperty(propKey);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(propKey));
    }

    @Override
    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean isAlive() {
        Variant var = this.m_connectionProperties.getProperty(20);
        assert (null != var);
        try {
            return var.getLong() != 1L;
        }
        catch (IncorrectTypeException e) {
            return false;
        }
        catch (NumericOverflowException e) {
            return false;
        }
    }

    @Override
    public boolean isCustomProperty(int propKey) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), propKey);
        return false;
    }

    @Override
    public boolean promptDialog(ConnSettingResponseMap connResponseMap, ConnSettingRequestMap connectionSettings, long parentWindow, PromptType promptType) {
        return false;
    }

    @Override
    public void registerTransactionStateListener(ITransactionStateListener listener) {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), listener);
        this.m_transactionListener = listener;
    }

    @Override
    public void registerWarningListener(IWarningListener listener) {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), listener);
        this.m_warningListener = listener;
    }

    @Override
    public void releaseSavepoint(String name) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), name);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws ErrorException {
        assert (!this.m_isBeingReset);
        try {
            this.m_isBeingReset = true;
            try {
                this.loadProperties();
            }
            catch (NumericOverflowException e) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.NON_TRANSIENT_CONNECTION);
            }
            catch (IncorrectTypeException e) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.NON_TRANSIENT_CONNECTION);
            }
            this.doReset();
        }
        finally {
            this.m_isBeingReset = false;
        }
    }

    @Override
    public void rollback() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public void rollback(String name) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), name);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public void setClientInfoProperty(String propName, String propValue) throws ClientInfoException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), propName, propValue);
        ClientInfoData clientInfo = this.m_clientInfoProperties.get(propName);
        if (null != clientInfo) {
            if (null == propValue || propValue.length() <= clientInfo.getMaxLength()) {
                clientInfo.setValue(propValue);
            } else {
                String truncatedValue = propValue.substring(0, clientInfo.getMaxLength() - 1);
                clientInfo.setValue(truncatedValue);
                this.m_warningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 2, DSIMessageKey.BAD_ATTR_VAL.name(), new String[]{propName, propValue}));
            }
        } else {
            HashMap<String, FailedPropertiesReason> failures = new HashMap<String, FailedPropertiesReason>();
            failures.put(propName, FailedPropertiesReason.UNKNOWN_PROPERTY);
            throw (ClientInfoException)DSIDriver.s_DSIMessages.createClientInfoException(DSIMessageKey.INVALID_PROPKEY.name(), propName, failures);
        }
    }

    @Override
    public void setCustomProperty(int propKey, Variant propValue) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), propKey, propValue);
    }

    @Override
    public void setInvokerAndClassLoader(Object invoker, Object classLoader) {
    }

    @Override
    public void setProperty(int propKey, Variant propValue) throws BadAttrValException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), propKey, propValue);
        if (null == this.m_connectionProperties) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name(), ExceptionType.DEFAULT);
        }
        this.m_connectionProperties.setProperty(propKey, propValue);
    }

    @Override
    public String toNativeSQL(String sql) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), sql);
        return String.valueOf(sql);
    }

    protected abstract void doReset() throws ErrorException;

    protected Variant getOptionalSetting(String key, ConnSettingRequestMap requestMap) {
        return requestMap.getProperty(key);
    }

    protected Variant getRequiredSetting(String key, ConnSettingRequestMap requestMap) throws BadAuthException {
        Variant setting = requestMap.getProperty(key);
        if (null == setting) {
            throw new BadAuthException(2, DSIMessageKey.REQ_SETTING_NOT_FOUND.name(), key);
        }
        return setting;
    }

    protected boolean isBeingReset() {
        return this.m_isBeingReset;
    }

    protected void verifyOptionalSetting(String key, ConnSettingRequestMap requestMap, ConnSettingResponseMap responseMap) {
        this.verifyOptionalSetting(key, key, requestMap, responseMap);
    }

    protected void verifyOptionalSetting(String key, String label, ConnSettingRequestMap requestMap, ConnSettingResponseMap responseMap) {
        if (null == requestMap.getProperty(key)) {
            ConnectionSetting setting = new ConnectionSetting(0);
            setting.setLabel(label);
            try {
                setting.insertValue(new Variant(0, REQ_INDICATOR));
            }
            catch (Exception e) {
                try {
                    LogUtilities.logError(e, this.getConnectionLog());
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            responseMap.setProperty(key, setting);
        }
    }

    protected void verifyRequiredSetting(String key, ConnSettingRequestMap requestMap, ConnSettingResponseMap responseMap) {
        this.verifyRequiredSetting(key, key, requestMap, responseMap);
    }

    protected void verifyRequiredSetting(String key, String label, ConnSettingRequestMap requestMap, ConnSettingResponseMap responseMap) {
        if (null == requestMap.getProperty(key)) {
            ConnectionSetting setting = new ConnectionSetting(1);
            setting.setLabel(label);
            try {
                setting.insertValue(new Variant(0, REQ_INDICATOR));
            }
            catch (Exception e) {
                try {
                    LogUtilities.logError(e, this.getConnectionLog());
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            responseMap.setProperty(key, setting);
        }
    }

    private Map<String, ClientInfoData> initializeClientInfoProperties() {
        HashMap<String, ClientInfoData> list = new HashMap<String, ClientInfoData>();
        list.put("APPLICATIONNAME", new ClientInfoData("APPLICATIONNAME", 25, null, "The name of the application currently utilizing the connection."));
        list.put("CLIENTUSER", new ClientInfoData("CLIENTUSER", 25, null, "The name of the user that the application using the connection is performing work for."));
        list.put("CLIENTHOSTNAME", new ClientInfoData("CLIENTHOSTNAME", 25, null, "The hostname of the computer the application using the connection is running on."));
        return list;
    }

    private void loadProperties() throws ErrorException, IncorrectTypeException, NumericOverflowException {
        this.m_connectionProperties.setProperty(1, 0, "Y");
        this.m_connectionProperties.setProperty(2, 0, "Y");
        this.m_connectionProperties.setProperty(3, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(4, 3, 127L);
        this.m_connectionProperties.setProperty(5, 3, 1L);
        this.m_connectionProperties.setProperty(6, 3, 256L);
        this.m_connectionProperties.setProperty(7, 3, 0L);
        this.m_connectionProperties.setProperty(8, 2, Character.valueOf('\u0001'));
        this.m_connectionProperties.setProperty(9, 0, "Y");
        this.m_connectionProperties.setProperty(10, 0, ".");
        this.m_connectionProperties.setProperty(11, 0, "catalog");
        this.m_connectionProperties.setProperty(12, 3, 31L);
        this.m_connectionProperties.setProperty(13, 0, "");
        this.m_connectionProperties.setProperty(14, 0, "Y");
        this.m_connectionProperties.setProperty(15, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(16, 3, 0L);
        this.m_connectionProperties.setProperty(17, 6, 0);
        this.m_connectionProperties.setProperty(18, 3, 1L);
        this.m_connectionProperties.setProperty(19, 3, 1L);
        this.m_connectionProperties.setProperty(21, 3, 0L);
        this.m_connectionProperties.setProperty(20, 3, 0L);
        this.m_connectionProperties.setProperty(22, 0, "");
        this.m_connectionProperties.setProperty(26, 3, 1L);
        this.m_connectionProperties.setProperty(23, 3, 0L);
        this.m_connectionProperties.setProperty(24, 3, 1024L);
        this.m_connectionProperties.setProperty(25, 4, 0L);
        this.m_connectionProperties.setProperty(27, 3, 3L);
        this.m_connectionProperties.setProperty(28, 2, Character.valueOf('\u0002'));
        this.m_connectionProperties.setProperty(29, 3, 0L);
        this.m_connectionProperties.setProperty(30, 3, 0L);
        this.m_connectionProperties.setProperty(31, 3, 0L);
        this.m_connectionProperties.setProperty(32, 3, 0L);
        this.m_connectionProperties.setProperty(33, 3, 0L);
        this.m_connectionProperties.setProperty(34, 3, 0L);
        this.m_connectionProperties.setProperty(35, 3, 0L);
        this.m_connectionProperties.setProperty(36, 3, 0L);
        this.m_connectionProperties.setProperty(37, 2, Character.valueOf('\u0001'));
        this.m_connectionProperties.setProperty(38, 2, Character.valueOf('\u0001'));
        this.m_connectionProperties.setProperty(39, 3, 0L);
        this.m_connectionProperties.setProperty(40, 0, "Y");
        this.m_connectionProperties.setProperty(43, 3, 65535L);
        this.m_connectionProperties.setProperty(41, 0, "TEXT");
        this.m_connectionProperties.setProperty(42, 0, "00.00.0000");
        this.m_connectionProperties.setProperty(44, 3, 0L);
        this.m_connectionProperties.setProperty(45, 3, 1L);
        this.m_connectionProperties.setProperty(46, 0, "Y");
        this.m_connectionProperties.setProperty(47, 3, 0L);
        this.m_connectionProperties.setProperty(48, 3, 0L);
        this.m_connectionProperties.setProperty(49, 3, 0L);
        this.m_connectionProperties.setProperty(50, 3, 0L);
        this.m_connectionProperties.setProperty(51, 3, 0L);
        this.m_connectionProperties.setProperty(52, 3, 0L);
        this.m_connectionProperties.setProperty(53, 3, 0L);
        this.m_connectionProperties.setProperty(54, 3, 0L);
        this.m_connectionProperties.setProperty(55, 0, "Y");
        this.m_connectionProperties.setProperty(56, 2, Character.valueOf('\u0002'));
        this.m_connectionProperties.setProperty(57, 2, Character.valueOf('\u0004'));
        this.m_connectionProperties.setProperty(58, 0, "\"");
        this.m_connectionProperties.setProperty(59, 3, 0L);
        this.m_connectionProperties.setProperty(60, 3, 7L);
        this.m_connectionProperties.setProperty(61, 0, "N");
        this.m_connectionProperties.setProperty(62, 0, "");
        this.m_connectionProperties.setProperty(63, 0, "Y");
        this.m_connectionProperties.setProperty(64, 3, 0L);
        this.m_connectionProperties.setProperty(65, 3, 0L);
        this.m_connectionProperties.setProperty(66, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(67, 3, 0L);
        this.m_connectionProperties.setProperty(68, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(69, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(70, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(71, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(72, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(73, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(74, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(75, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(76, 2, Character.valueOf('\u00ff'));
        this.m_connectionProperties.setProperty(77, 3, 0L);
        this.m_connectionProperties.setProperty(78, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(79, 3, 0L);
        this.m_connectionProperties.setProperty(80, 0, "N");
        this.m_connectionProperties.setProperty(81, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(82, 3, 0L);
        this.m_connectionProperties.setProperty(83, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(84, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(85, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(86, 0, "N");
        this.m_connectionProperties.setProperty(87, 0, "Y");
        this.m_connectionProperties.setProperty(88, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(89, 2, Character.valueOf('\u0001'));
        this.m_connectionProperties.setProperty(90, 3, 0xFFFFFFL);
        this.m_connectionProperties.setProperty(91, 5, (short)1);
        this.m_connectionProperties.setProperty(92, 3, 127L);
        this.m_connectionProperties.setProperty(93, 0, "N");
        this.m_connectionProperties.setProperty(94, 0, "F");
        this.m_connectionProperties.setProperty(95, 3, 2L);
        this.m_connectionProperties.setProperty(96, 0, "procedure");
        this.m_connectionProperties.setProperty(97, 0, "Y");
        this.m_connectionProperties.setProperty(98, 2, Character.valueOf('\u0003'));
        this.m_connectionProperties.setProperty(99, 0, "schema");
        this.m_connectionProperties.setProperty(100, 3, 29L);
        this.m_connectionProperties.setProperty(101, 0, "");
        this.m_connectionProperties.setProperty(102, 0, "");
        this.m_connectionProperties.setProperty(103, 3, 1L);
        this.m_connectionProperties.setProperty(104, 3, 0xF77FFFL);
        this.m_connectionProperties.setProperty(105, 3, 31L);
        this.m_connectionProperties.setProperty(106, 3, 14712831L);
        this.m_connectionProperties.setProperty(107, 3, 14946049L);
        this.m_connectionProperties.setProperty(108, 3, 14974975L);
        this.m_connectionProperties.setProperty(109, 3, 31981567L);
        this.m_connectionProperties.setProperty(110, 3, 31458049L);
        this.m_connectionProperties.setProperty(111, 3, 14847745L);
        this.m_connectionProperties.setProperty(112, 3, 10510847L);
        this.m_connectionProperties.setProperty(113, 3, 14712831L);
        this.m_connectionProperties.setProperty(114, 3, 14712831L);
        this.m_connectionProperties.setProperty(115, 3, 14712831L);
        this.m_connectionProperties.setProperty(116, 3, 0L);
        this.m_connectionProperties.setProperty(117, 3, 0L);
        this.m_connectionProperties.setProperty(118, 3, 14946049L);
        this.m_connectionProperties.setProperty(119, 3, 31716351L);
        this.m_connectionProperties.setProperty(120, 3, 10510847L);
        this.m_connectionProperties.setProperty(121, 3, 14712831L);
        this.m_connectionProperties.setProperty(122, 3, 14712831L);
        this.m_connectionProperties.setProperty(123, 3, 14880513L);
        this.m_connectionProperties.setProperty(124, 3, 14913281L);
        this.m_connectionProperties.setProperty(125, 3, 14712831L);
        this.m_connectionProperties.setProperty(126, 3, 14946049L);
        this.m_connectionProperties.setProperty(127, 3, 31981567L);
        this.m_connectionProperties.setProperty(128, 3, 31981567L);
        this.m_connectionProperties.setProperty(129, 3, 31716351L);
        this.m_connectionProperties.setProperty(130, 3, 31981567L);
        this.m_connectionProperties.setProperty(131, 3, 7L);
        this.m_connectionProperties.setProperty(132, 0, "table");
        this.m_connectionProperties.setProperty(133, 3, 511L);
        this.m_connectionProperties.setProperty(134, 3, 511L);
        this.m_connectionProperties.setProperty(135, 3, 1048575L);
        this.m_connectionProperties.setProperty(136, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(137, 3, 1L);
        this.m_connectionProperties.setProperty(138, 3, 3L);
        this.m_connectionProperties.setProperty(139, 0, "");
        this.m_connectionProperties.setProperty(140, 3, 0L);
        this.m_connectionProperties.setProperty(141, 3, 0L);
        this.m_connectionProperties.setProperty(142, 3, 0L);
        this.m_connectionProperties.setProperty(143, 3, 0L);
        this.m_connectionProperties.setProperty(144, 3, 0L);
        this.m_connectionProperties.setProperty(145, 3, 0L);
        this.m_connectionProperties.setProperty(146, 3, 0L);
        this.m_connectionProperties.setProperty(147, 3, 0L);
        this.m_connectionProperties.setProperty(148, 3, 0L);
        this.m_connectionProperties.setProperty(149, 3, 3L);
        this.m_connectionProperties.setProperty(150, 0, "N");
        this.m_connectionProperties.setProperty(151, 0, "\\");
        this.m_connectionProperties.setProperty(152, 3, 0L);
        this.m_connectionProperties.setProperty(153, 3, 0L);
        this.m_connectionProperties.setProperty(154, 3, 7L);
        this.m_connectionProperties.setProperty(155, 3, 0L);
        this.m_connectionProperties.setProperty(156, 3, 0L);
        this.m_connectionProperties.setProperty(159, 3, 16L);
        this.m_connectionProperties.setProperty(157, 3, 0L);
        this.m_connectionProperties.setProperty(158, 3, 16135L);
        this.m_connectionProperties.setProperty(160, 3, 346L);
        this.m_connectionProperties.setProperty(161, 3, 16L);
        this.m_connectionProperties.setProperty(162, 3, 15L);
        this.m_connectionProperties.setProperty(163, 3, 6L);
        this.m_connectionProperties.setProperty(164, 3, 15L);
        this.m_connectionProperties.setProperty(165, 3, 0L);
        this.m_connectionProperties.setProperty(1010, 0, "N");
        this.m_connectionProperties.setProperty(1000, 5, (short)0);
        this.m_connectionProperties.setProperty(1001, 3, 0L);
        this.m_connectionProperties.setProperty(1002, new Variant(3, 0L));
        this.m_connectionProperties.setProperty(1003, 5, (short)0);
        this.m_connectionProperties.setProperty(1004, 6, 0);
        this.m_connectionProperties.setProperty(1005, 6, 0);
        this.m_connectionProperties.setProperty(1006, 0, "N");
        this.m_connectionProperties.setProperty(1007, 6, 32000);
        this.m_connectionProperties.setProperty(1008, 0, "");
        this.m_connectionProperties.setProperty(1009, 6, 0);
        this.m_connectionProperties.setProperty(166, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(167, 0, "");
        this.m_connectionProperties.setProperty(168, 5, (short)1);
        IDriver dsiDriver = DSIDriverSingleton.getInstance();
        this.m_connectionProperties.setProperty(169, 0, dsiDriver.getProperty(3).getString());
        this.m_connectionProperties.setProperty(170, 0, dsiDriver.getProperty(5).getString());
        this.m_connectionProperties.setProperty(171, 0, "");
        this.m_connectionProperties.setProperty(172, 3, 0L);
        this.m_connectionProperties.setProperty(174, 3, 0L);
        this.m_connectionProperties.setProperty(175, 3, 0L);
        this.m_connectionProperties.setProperty(176, 3, 0L);
        this.m_connectionProperties.setProperty(177, 3, this.getStopOnErrorDefaultValue());
        this.m_connectionProperties.setProperty(178, 3, 0L);
        this.m_connectionProperties.setProperty(1012, 5, this.getSupportsUpdateBatchingDefaultValue());
        this.m_connectionProperties.setProperty(1011, 3, 0L);
    }

    @Override
    public IArray createArrayOf(String typeName, Object[] elements) throws ErrorException {
        if (null == typeName || null == elements) {
            throw new NullPointerException();
        }
        ColumnMetadata componentMetadata = new ColumnMetadata(this.createTypeMetadataForSqlType(typeName));
        ColumnMetadata arrayMetadata = null;
        arrayMetadata = new ColumnMetadata(this.createTypeMetadataForSqlType("SQL_ARRAY"));
        int nesting = this.arrayNesting(elements, 0);
        ArrayList<IColumn> nestedColumnList = arrayMetadata.getTypeMetadata().getNestedColumnList();
        for (int i = 0; i < nesting; ++i) {
            nestedColumnList.add(new ColumnMetadata(this.createTypeMetadataForSqlType("SQL_ARRAY")));
            nestedColumnList = nestedColumnList.get(0).getTypeMetadata().getNestedColumnList();
        }
        nestedColumnList.add(componentMetadata);
        return new DSISimpleArray(elements, arrayMetadata);
    }

    private int arrayNesting(Object in_array, int in_previousNesting) {
        int len = Array.getLength(in_array);
        int out_nesting = in_previousNesting;
        for (int i = 0; i < len; ++i) {
            int value;
            Object val = Array.get(in_array, i);
            if (val == null || !val.getClass().isArray() || (value = this.arrayNesting(val, in_previousNesting + 1)) <= out_nesting) continue;
            out_nesting = value;
        }
        return out_nesting;
    }

    private TypeMetadata createTypeMetadataForSqlType(String sqlTypeName) throws ErrorException {
        Integer typeCode = TypeUtilities.getTypeForSqlTypeString(sqlTypeName);
        if (null == typeCode) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED.name(), sqlTypeName, ExceptionType.DATA);
        }
        return TypeMetadata.createTypeMetadata(typeCode);
    }

    private long getStopOnErrorDefaultValue() throws ErrorException, NumericOverflowException, IncorrectTypeException {
        boolean stopOnError;
        boolean bl = stopOnError = DSIDriverSingleton.getInstance().getProperty(1001).getShort() == 1;
        if (stopOnError) {
            return 3L;
        }
        return 0L;
    }

    private short getSupportsUpdateBatchingDefaultValue() throws ErrorException, NumericOverflowException, IncorrectTypeException {
        return DSIDriverSingleton.getInstance().getProperty(1002).getShort();
    }
}

