/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import com.nuodb.descriptions.ArchiveJournalDirs;
import com.nuodb.descriptions.DescriptionArchives;
import com.nuodb.descriptions.Mapper;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import java.util.Map;

public class ArchiveUtil {
    public static final String ARCHIVE_LIST_TAG_NAME = "Archives";
    public static final String ARCHIVE_TAG_NAME = "Archive";
    public static final String AGENT_ID_ATTR_NAME = "AgentId";
    public static final String ARCHIVE_INFO_TAG_NAME = "Info";
    public static final String ARCHIVE_DIR_ATTR_NAME = "ArchiveDir";
    public static final String JOURNAL_DIR_ATTR_NAME = "JournalDir";
    public static final String REGION_ATTR_NAME = "Region";
    public static final String REQUIREMENTS_NAME_ATTR_NAME = "RequirementsName";

    public static DescriptionArchives getArchives(Tag msg) {
        Tag archTag;
        DescriptionArchives archives = new DescriptionArchives();
        if (msg != null && (archTag = msg.findChild(ARCHIVE_LIST_TAG_NAME)) != null) {
            for (Tag child : archTag) {
                Tag infoTag;
                String key = child.getAttribute(AGENT_ID_ATTR_NAME, null);
                if (key == null || (infoTag = child.findChild(ARCHIVE_INFO_TAG_NAME)) == null) continue;
                String archiveDir = infoTag.getAttribute(ARCHIVE_DIR_ATTR_NAME, null);
                String journalDir = infoTag.getAttribute(JOURNAL_DIR_ATTR_NAME, null);
                String region = infoTag.getAttribute(REGION_ATTR_NAME, null);
                String requirementsName = infoTag.getAttribute(REQUIREMENTS_NAME_ATTR_NAME, null);
                archives.put(key, requirementsName, new ArchiveJournalDirsImpl(archiveDir, journalDir, region, requirementsName));
            }
        }
        return archives;
    }

    public static Tag getArchivesTag(DescriptionArchives archives, Mapper<String, String> idMapper) {
        Tag archivesTag = TagFactory.createTag(ARCHIVE_LIST_TAG_NAME);
        for (Map.Entry<DescriptionArchives.PeerAndReqKey, ArchiveJournalDirs> entry : archives.entrySet()) {
            Tag archTag = archivesTag.addChild(ARCHIVE_TAG_NAME);
            archTag.addAttribute(AGENT_ID_ATTR_NAME, idMapper.map(entry.getKey().getStableId()));
            Tag infoTag = archTag.addChild(ARCHIVE_INFO_TAG_NAME);
            if (entry.getValue().getArchiveDir() != null) {
                infoTag.addAttribute(ARCHIVE_DIR_ATTR_NAME, entry.getValue().getArchiveDir());
            }
            if (entry.getValue().getJournalDir() != null) {
                infoTag.addAttribute(JOURNAL_DIR_ATTR_NAME, entry.getValue().getJournalDir());
            }
            if (entry.getValue().getRegion() != null) {
                infoTag.addAttribute(REGION_ATTR_NAME, entry.getValue().getRegion());
            }
            if (entry.getValue().getRequirementsName() == null) continue;
            infoTag.addAttribute(REQUIREMENTS_NAME_ATTR_NAME, entry.getValue().getRequirementsName());
        }
        return archivesTag;
    }

    public static class ArchiveJournalDirsImpl
    implements ArchiveJournalDirs {
        final String archiveDir;
        final String journalDir;
        final String region;
        final String reqName;

        public ArchiveJournalDirsImpl(String archiveDir, String journalDir, String region, String reqName) {
            this.archiveDir = archiveDir;
            this.journalDir = journalDir;
            this.region = region;
            this.reqName = reqName;
        }

        @Override
        public String getArchiveDir() {
            return this.archiveDir;
        }

        @Override
        public String getJournalDir() {
            return this.journalDir;
        }

        @Override
        public String getRegion() {
            return this.region;
        }

        @Override
        public String getRequirementsName() {
            return this.reqName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArchiveJournalDirsImpl other = (ArchiveJournalDirsImpl)obj;
            if (this.archiveDir == null ? other.archiveDir != null : !this.archiveDir.equals(other.archiveDir)) {
                return false;
            }
            if (this.journalDir == null ? other.journalDir != null : !this.journalDir.equals(other.journalDir)) {
                return false;
            }
            if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
                return false;
            }
            return !(this.reqName == null ? other.reqName != null : !this.reqName.equals(other.reqName));
        }

        public String toString() {
            return String.format("SM location: RequirementsName=[%s], Region=[%s], Archive=[%s], Journal-dir=[%s]", this.reqName != null ? this.reqName : "", this.region != null ? this.region : "", this.archiveDir != null ? this.archiveDir : "", this.journalDir != null ? this.journalDir : "");
        }
    }
}

