/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.agent.plugin;

import com.nuodb.agent.PropertiesProvider;
import com.nuodb.impl.util.Preconditions;
import com.nuodb.impl.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleURLPropertiesProvider
implements PropertiesProvider {
    private static final String PROPERTIES_URL_PROP = "propertiesUrl";
    private static final Logger logger = Logger.getLogger(SimpleURLPropertiesProvider.class.getName());
    private final Properties properties = new Properties();

    public SimpleURLPropertiesProvider(Properties systemProperties) {
        URL url;
        String urlPath = systemProperties.getProperty(PROPERTIES_URL_PROP, null);
        Preconditions.checkArgument(!StringUtils.isBlank(urlPath), "property [%s] not set", PROPERTIES_URL_PROP);
        logger.log(Level.INFO, "using properties from: {0}", urlPath);
        try {
            url = new URL(urlPath);
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "Invalid URL: " + urlPath, e);
            throw new IllegalArgumentException("Invalid URL" + urlPath, e);
        }
        InputStream input = null;
        try {
            input = url.openStream();
            this.properties.load(input);
        }
        catch (Exception ioe) {
            logger.log(Level.SEVERE, "failed to resolve url", ioe);
            throw new IllegalArgumentException("Failed to load properties", ioe);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "failed to close " + urlPath, e);
                }
            }
        }
    }

    @Override
    public String getProperty(String key) {
        String val = this.properties.getProperty(key, null);
        return val != null ? val.trim() : val;
    }
}

