/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.swing.gvt.Overlay;

public class SVGUpdateOverlay
implements Overlay {
    List rects = new LinkedList();
    int size;
    int updateCount;
    int[] counts;

    public SVGUpdateOverlay(int n, int n2) {
        this.size = n;
        this.counts = new int[n2];
    }

    public void addRect(Rectangle rectangle) {
        this.rects.add(rectangle);
        if (this.rects.size() > this.size) {
            this.rects.remove(0);
        }
        ++this.updateCount;
    }

    public void endUpdate() {
        int n;
        for (n = 0; n < this.counts.length - 1; ++n) {
            this.counts[n] = this.counts[n + 1];
        }
        this.counts[n] = this.updateCount;
        this.updateCount = 0;
        int n2 = this.rects.size();
        for (n = this.counts.length - 1; n >= 0; --n) {
            if (this.counts[n] > n2) {
                this.counts[n] = n2;
            }
            n2 -= this.counts[n];
        }
        this.counts[0] = this.counts[0] + n2;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        Iterator iterator = this.rects.iterator();
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.counts.length - 1 && n3 == this.counts[n]; ++n) {
        }
        int n4 = this.counts.length - 1;
        while (iterator.hasNext()) {
            Rectangle rectangle = (Rectangle)iterator.next();
            Color color = new Color(1.0f, (float)(n4 - n) / (float)n4, 0.0f, ((float)n2 + 1.0f) / (float)this.rects.size());
            graphics.setColor(color);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n2;
            ++n3;
            while (n < this.counts.length - 1 && n3 == this.counts[n]) {
                ++n;
                n3 = 0;
            }
        }
    }
}

