/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dashboard;

import com.jidesoft.dashboard.B;
import com.jidesoft.dashboard.Gadget;
import com.jidesoft.dashboard.GadgetEvent;
import com.jidesoft.dashboard.GadgetListener;
import com.jidesoft.dashboard.GadgetManager;
import com.jidesoft.dashboard.GadgetPaletteButton;
import com.jidesoft.dashboard.GadgetPaletteInstaller;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialLineBorder;
import com.jidesoft.swing.SimpleScrollPane;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GadgetPalette
extends JPanel
implements GadgetListener,
PropertyChangeListener {
    public static final String CONTEXT_BUTTON_ADD = "GadgetPalette.add";
    public static final String CONTEXT_BUTTON_DONE = "GadgetPalette.done";
    public static final String CONTEXT_BUTTON_DESCRIPTION = "GadgetPalette.description";
    private ThemePainter \u01cc = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
    protected ButtonGroup _buttonGroup;
    private GadgetManager \u01c9;
    private GadgetPaletteInstaller \u01ca;
    protected JComponent _status;
    protected Container _gadgetList;
    private ChangeListener \u01cb;

    public GadgetPalette(GadgetManager gadgetManager, GadgetPaletteInstaller gadgetPaletteInstaller) {
        this.\u01c9 = gadgetManager;
        this.\u01c9.addGadgetListener(this);
        this.\u01c9.addPropertyChangeListener(this);
        this.\u01ca = gadgetPaletteInstaller;
        this._buttonGroup = new ButtonGroup();
        Container container = this.createGadgetButtonContainer();
        this.recreateGadgetButtons();
        this._status = this.createDescriptionLabel();
        JPanel jPanel = this.createDescriptionPanel(this._status);
        this.setLayout(new BorderLayout());
        this.add(container);
        if (jPanel != null) {
            this.add((Component)jPanel, "Last");
        }
        this.updateOpaque();
    }

    protected void updateOpaque() {
        JideSwingUtilities.setOpaqueRecursively(this, false);
    }

    protected JComponent createDescriptionLabel() {
        return new JLabel(this.getResourceString("GadgetPalette.hint"));
    }

    protected Container createGadgetButtonContainer() {
        this._gadgetList = new JPanel(new GridLayout(1, 0, 4, 4));
        JPanel jPanel = JideSwingUtilities.createCenterPanel(this._gadgetList);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SimpleScrollPane simpleScrollPane = new SimpleScrollPane(jPanel){

            @Override
            protected AbstractButton createScrollButton(int n2) {
                AbstractButton abstractButton = GadgetPalette.this.createScrollButton(n2);
                if (abstractButton != null) {
                    return abstractButton;
                }
                return super.createScrollButton(n2);
            }
        };
        simpleScrollPane.setRepeatDelay(100);
        simpleScrollPane.setBorder(BorderFactory.createEmptyBorder());
        return simpleScrollPane;
    }

    public void setButtonLayout(LayoutManager layoutManager) {
        if (layoutManager != this._gadgetList.getLayout()) {
            this._gadgetList.setLayout(layoutManager);
            this.recreateGadgetButtons();
        }
    }

    protected void recreateGadgetButtons() {
        Component[] componentArray = this._gadgetList.getComponents();
        Object[] objectArray = componentArray;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = objectArray[i2];
            if (!(component instanceof AbstractButton)) continue;
            this.uncustomizeButton((AbstractButton)component);
            this._buttonGroup.remove((AbstractButton)component);
        }
        this._gadgetList.removeAll();
        for (Object object : objectArray = this.\u01c9.getGadgets()) {
            Gadget gadget = this.\u01c9.getGadget((String)object);
            AbstractButton abstractButton = this.createButton(gadget);
            this.customizeButton(abstractButton);
            this._gadgetList.add(abstractButton);
            this._buttonGroup.add(abstractButton);
        }
        this.revalidate();
        this.repaint();
    }

    protected JPanel createDescriptionPanel(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JideBoxLayout(jPanel, 0, 6));
        jPanel.setBorder(BorderFactory.createCompoundBorder(new PartialLineBorder(this.\u01cc.getControlDk(), 1, 1), BorderFactory.createEmptyBorder(2, 10, 2, 10)));
        StyledLabel styledLabel = new StyledLabel(this.getResourceString(CONTEXT_BUTTON_DESCRIPTION));
        styledLabel.addStyleRange(new StyleRange(1));
        styledLabel.setName(CONTEXT_BUTTON_DESCRIPTION);
        jPanel.add(styledLabel);
        jPanel.add(component, "vary");
        JideButton jideButton = new JideButton(new AbstractAction(this.getResourceString(CONTEXT_BUTTON_ADD)){
            private static final long \u0102 = -6789710982445459742L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Enumeration<AbstractButton> enumeration = GadgetPalette.this._buttonGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    AbstractButton abstractButton = enumeration.nextElement();
                    if (abstractButton.getModel() != GadgetPalette.this._buttonGroup.getSelection()) continue;
                    if (!(abstractButton instanceof GadgetPaletteButton)) break;
                    GadgetPaletteButton gadgetPaletteButton = (GadgetPaletteButton)abstractButton;
                    gadgetPaletteButton.getGadget().getGadgetManager().showGadget(gadgetPaletteButton.getGadget());
                    break;
                }
            }
        });
        jideButton.setName(CONTEXT_BUTTON_ADD);
        jPanel.add(jideButton);
        JideButton jideButton2 = new JideButton(new AbstractAction(this.getResourceString(CONTEXT_BUTTON_DONE)){
            private static final long \u0102 = 4836290543086434967L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GadgetPalette.this.getInstaller().hidePalette();
            }
        });
        jideButton2.setName(CONTEXT_BUTTON_DONE);
        jPanel.add(jideButton2);
        return jPanel;
    }

    protected AbstractButton createScrollButton(int n2) {
        return null;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.\u01cc = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintBackground(graphics);
    }

    protected void paintBackground(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.\u01cc != null) {
            this.\u01cc.fillBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0, 0, this.\u01cc.getControlDk());
        }
        JideSwingUtilities.fillGradient(graphics2D, new Rectangle(0, 0, this.getWidth(), 3), new Color(255, 255, 255, 128), this.\u01cc.getControlDk(), true);
        graphics2D.dispose();
    }

    public GadgetManager getGadgetManager() {
        return this.\u01c9;
    }

    public GadgetPaletteInstaller getInstaller() {
        return this.\u01ca;
    }

    protected AbstractButton createButton(Gadget gadget) {
        return new GadgetPaletteButton(this, gadget);
    }

    protected void customizeButton(AbstractButton abstractButton) {
        abstractButton.addKeyListener(this.\u01c9.getCancelDragAndDropKeyListener());
        abstractButton.addMouseListener(this.\u01c9.getDragAndDropMouseInputListener());
        abstractButton.addMouseMotionListener(this.\u01c9.getDragAndDropMouseInputListener());
        if (this.\u01cb == null) {
            this.\u01cb = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Object object = changeEvent.getSource();
                    if (object instanceof AbstractButton) {
                        AbstractButton abstractButton = (AbstractButton)object;
                        boolean bl = abstractButton.getModel().isRollover();
                        if (bl) {
                            if (abstractButton instanceof GadgetPaletteButton && GadgetPalette.this._status instanceof JLabel) {
                                ((JLabel)GadgetPalette.this._status).setText(((GadgetPaletteButton)abstractButton).getGadget().getDescription());
                            }
                        } else if (GadgetPalette.this._status instanceof JLabel) {
                            ((JLabel)GadgetPalette.this._status).setText(GadgetPalette.this.getResourceString("GadgetPalette.hint"));
                        }
                    }
                }
            };
        }
        abstractButton.getModel().addChangeListener(this.\u01cb);
        abstractButton.setFocusable(true);
        abstractButton.setRequestFocusEnabled(true);
    }

    protected void uncustomizeButton(AbstractButton abstractButton) {
        abstractButton.removeKeyListener(this.\u01c9.getCancelDragAndDropKeyListener());
        abstractButton.removeMouseListener(this.\u01c9.getDragAndDropMouseInputListener());
        abstractButton.removeMouseMotionListener(this.\u01c9.getDragAndDropMouseInputListener());
        if (this.\u01cb != null) {
            abstractButton.getModel().removeChangeListener(this.\u01cb);
        }
    }

    protected String getResourceString(String string) {
        return B.\u0101(this.getLocale()).getString(string);
    }

    @Override
    public void eventHappened(GadgetEvent gadgetEvent) {
        if (!(this.\u01c9.\u0101() || gadgetEvent.getID() != 13199 && gadgetEvent.getID() != 13200)) {
            this.recreateGadgetButtons();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.\u01c9.\u0101() && "batchProcessing".equals(propertyChangeEvent.getPropertyName())) {
            this.recreateGadgetButtons();
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(1024)) {
            Lm.showInvalidProductMessage(GadgetPalette.class.getName(), 1024);
        }
    }
}

