/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.event.ChartSelectionEvent;
import com.jidesoft.chart.event.MouseHandler;
import com.jidesoft.chart.event.PointSelectionEvent;
import com.jidesoft.chart.event.ZoomDirection;
import com.jidesoft.chart.event.ZoomListener;
import com.jidesoft.chart.event.ZoomLocation;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MouseWheelZoomer
implements MouseHandler,
MouseWheelListener {
    public static final String PROPERTY_HORIZONTAL_ZOOM = "Horizontal Zoom";
    public static final String PROPERTY_VERTICAL_ZOOM = "Vertical Zoom";
    public static final String PROPERTY_ZOOM_LOCATION = "Zoom Location";
    public static final String PROPERTY_X_LIMITS = "X Limits";
    public static final String PROPERTY_MIN_X_RANGE_SIZE = "Min X Range Size";
    public static final String PROPERTY_MAX_X_RANGE_SIZE = "Max X Range Size";
    public static final String PROPERTY_Y_LIMITS = "Y Limits";
    public static final String PROPERTY_MIN_Y_RANGE_SIZE = "Min Y Range Size";
    public static final String PROPERTY_MAX_Y_RANGE_SIZE = "Max y Range Size";
    private List<ZoomListener> \u0116 = Collections.synchronizedList(new ArrayList());
    private Chart \u0114;
    private boolean \u0115 = true;
    private boolean \u010e = true;
    private boolean \u010d = false;
    private ZoomLocation \u010a = ZoomLocation.CHART_CENTER;
    private Point2D \u010c = null;
    private Range<?> \u010b;
    private Double \u0109;
    private Double \u0110;
    private Double \u0113;
    private Double \u010f;
    private Range<?> \u0112;
    private int \u0118 = -1;
    private int \u0117 = -1;
    private PropertyChangeSupport \u0111 = new PropertyChangeSupport(this);

    public MouseWheelZoomer(Chart chart) {
        this.\u0114 = chart;
    }

    public MouseWheelZoomer(Chart chart, boolean bl, boolean bl2) {
        this.\u0114 = chart;
        this.\u0115 = bl;
        this.\u010e = bl2;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0111.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0111.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isHorizontalZoom() {
        return this.\u0115;
    }

    public void setHorizontalZoom(boolean bl) {
        boolean bl2 = this.\u0115;
        this.\u0115 = bl;
        this.\u0111.firePropertyChange(PROPERTY_HORIZONTAL_ZOOM, bl2, bl);
    }

    public boolean isVerticalZoom() {
        return this.\u010e;
    }

    public void setVerticalZoom(boolean bl) {
        boolean bl2 = this.\u010e;
        this.\u010e = bl;
        this.\u0111.firePropertyChange(PROPERTY_VERTICAL_ZOOM, bl2, bl);
    }

    public ZoomLocation getZoomLocation() {
        return this.\u010a;
    }

    public void setZoomLocation(ZoomLocation zoomLocation) {
        ZoomLocation zoomLocation2 = this.\u010a;
        this.\u010a = zoomLocation;
        this.\u0111.firePropertyChange(PROPERTY_ZOOM_LOCATION, (Object)zoomLocation2, (Object)zoomLocation);
    }

    public Point2D getZoomFrom() {
        return this.\u010c;
    }

    public void setZoomFrom(Point2D point2D) {
        this.\u010c = point2D;
    }

    public Range<?> getXLimits() {
        return this.\u010b;
    }

    public void setXLimits(Range<?> range) {
        Range<?> range2 = this.\u010b;
        this.\u010b = range;
        this.\u0111.firePropertyChange(PROPERTY_X_LIMITS, range2, range);
    }

    public Double getMinXRangeSize() {
        return this.\u0109;
    }

    public void setMinXRangeSize(Double d2) {
        Double d3 = this.\u0109;
        this.\u0109 = d2;
        this.\u0111.firePropertyChange(PROPERTY_MIN_X_RANGE_SIZE, d3, d2);
    }

    public Range<?> getYLimits() {
        return this.\u0112;
    }

    public void setYLimits(Range<?> range) {
        Range<?> range2 = this.\u0112;
        this.\u0112 = range;
        this.\u0111.firePropertyChange(PROPERTY_Y_LIMITS, range2, range);
    }

    public Double getMinYRangeSize() {
        return this.\u0110;
    }

    public void setMinYRangeSize(Double d2) {
        Double d3 = this.\u0110;
        this.\u0110 = d2;
        this.\u0111.firePropertyChange(PROPERTY_MIN_Y_RANGE_SIZE, d3, d2);
    }

    public Double getMaxXRangeSize() {
        return this.\u0113;
    }

    public void setMaxXRangeSize(Double d2) {
        Double d3 = this.\u0113;
        this.\u0113 = d2;
        this.\u0111.firePropertyChange(PROPERTY_MAX_X_RANGE_SIZE, d3, d2);
    }

    public Double getMaxYRangeSize() {
        return this.\u010f;
    }

    public void setMaxYRangeSize(Double d2) {
        Double d3 = this.\u010f;
        this.\u010f = d2;
        this.\u0111.firePropertyChange(PROPERTY_MAX_Y_RANGE_SIZE, d3, d2);
    }

    public int getHorizontalOnlyZoomKeyMask() {
        return this.\u0118;
    }

    public void setHorizontalOnlyZoomKeyMask(int n2) {
        this.\u0118 = n2;
    }

    public int getVerticalOnlyZoomKeyMask() {
        return this.\u0117;
    }

    public void setVerticalOnlyZoomKeyMask(int n2) {
        this.\u0117 = n2;
    }

    public void addZoomListener(ZoomListener zoomListener) {
        this.\u0116.add(zoomListener);
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        this.\u0116.remove(zoomListener);
    }

    protected void fireZoom(Point point, ZoomDirection zoomDirection) {
        this.fireZoom(new PointSelectionEvent(this, point, zoomDirection));
    }

    protected void fireZoom(Point point, ZoomDirection zoomDirection, double d2) {
        this.fireZoom(new PointSelectionEvent(this, point, zoomDirection, d2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireZoom(ChartSelectionEvent chartSelectionEvent) {
        List<ZoomListener> list = this.\u0116;
        synchronized (list) {
            for (ZoomListener zoomListener : this.\u0116) {
                zoomListener.zoomChanged(chartSelectionEvent);
            }
        }
        this.\u0114.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.setHandled(!this.\u0114.isEnabled());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.setHandled(!this.\u0114.isEnabled());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        NumericRange numericRange;
        NumericRange numericRange2;
        Point point;
        if (mouseWheelEvent.getWheelRotation() == 0 || !this.\u0114.isEnabled()) {
            return;
        }
        ZoomDirection zoomDirection = mouseWheelEvent.getWheelRotation() < 0 ? ZoomDirection.IN : ZoomDirection.OUT;
        boolean bl = this.\u0118 > 0 && (mouseWheelEvent.getModifiersEx() & this.\u0118) == this.\u0118;
        boolean bl2 = this.\u0117 > 0 && (mouseWheelEvent.getModifiersEx() & this.\u0117) == this.\u0117;
        boolean bl3 = !bl && !bl2;
        boolean bl4 = this.\u0115 && (bl3 || bl);
        boolean bl5 = this.\u010e && (bl3 || bl2);
        Axis axis = this.\u0114.getXAxis();
        Axis axis2 = this.\u0114.getYAxis();
        if (this.\u010a == ZoomLocation.CHART_CENTER) {
            Point2D.Double double_ = new Point2D.Double(axis.midPoint(), axis2.midPoint());
            point = this.\u0114.calculatePixelPoint(double_);
            if (zoomDirection == ZoomDirection.IN) {
                double d2 = 0.9;
                numericRange2 = bl4 ? Axis.zoom(axis, d2) : axis.getRange();
                numericRange = bl5 ? Axis.zoom(axis2, d2) : axis2.getRange();
            } else {
                double d3 = 1.1;
                numericRange2 = bl4 ? Axis.zoom(axis, d3) : axis.getRange();
                numericRange = bl5 ? Axis.zoom(axis2, d3) : axis2.getRange();
            }
        } else if (this.\u010a == ZoomLocation.SPECIFIED_POINT) {
            point = this.\u0114.calculatePixelPoint(this.\u010c);
            if (this.\u010c != null) {
                if (zoomDirection == ZoomDirection.IN) {
                    double d4 = 0.9;
                    numericRange2 = bl4 ? Axis.zoomFromPosition(axis, d4, this.\u010c.getX()) : axis.getRange();
                    numericRange = bl5 ? Axis.zoomFromPosition(axis2, d4, this.\u010c.getY()) : axis2.getRange();
                } else {
                    double d5 = 1.1;
                    numericRange2 = bl4 ? Axis.zoomFromPosition(axis, d5, this.\u010c.getX()) : axis.getRange();
                    numericRange = bl5 ? Axis.zoomFromPosition(axis2, d5, this.\u010c.getY()) : axis2.getRange();
                }
            } else {
                numericRange2 = axis.getRange();
                numericRange = axis2.getRange();
            }
        } else {
            point = mouseWheelEvent.getPoint();
            Point2D point2D = this.\u0114.calculateUserPoint(point);
            if (zoomDirection == ZoomDirection.IN) {
                double d6 = 0.9;
                numericRange2 = bl4 ? Axis.zoomFromPosition(axis, d6, point2D.getX()) : axis.getRange();
                numericRange = bl5 ? Axis.zoomFromPosition(axis2, d6, point2D.getY()) : axis2.getRange();
            } else {
                double d7 = 1.1;
                numericRange2 = bl4 ? Axis.zoomFromPosition(axis, d7, point2D.getX()) : axis.getRange();
                NumericRange numericRange3 = numericRange = bl5 ? Axis.zoomFromPosition(axis2, d7, point2D.getY()) : axis2.getRange();
            }
        }
        if (this.\u010b != null && numericRange2 instanceof NumericRange) {
            if (numericRange2.minimum() < this.\u010b.minimum()) {
                numericRange2 = new NumericRange(this.\u010b.minimum(), numericRange2.maximum());
            }
            if (numericRange2.maximum() > this.\u010b.maximum()) {
                numericRange2 = new NumericRange(numericRange2.minimum(), this.\u010b.maximum());
            }
        }
        if ((this.\u0109 == null || numericRange2.size() >= this.\u0109) && (this.\u0113 == null || numericRange2.size() <= this.\u0113) && (this.\u010b == null || numericRange2.minimum() >= this.\u010b.minimum() && numericRange2.maximum() <= this.\u010b.maximum())) {
            axis.setRange(numericRange2, true, false);
        }
        if (this.\u0112 != null && numericRange instanceof NumericRange) {
            if (numericRange.minimum() <= this.\u0112.minimum()) {
                numericRange = new NumericRange(this.\u0112.minimum(), numericRange.maximum());
            }
            if (numericRange.maximum() >= this.\u0112.maximum()) {
                numericRange = new NumericRange(numericRange.minimum(), this.\u0112.maximum());
            }
        }
        if ((this.\u0110 == null || numericRange.size() >= this.\u0110) && (this.\u010f == null || numericRange.size() <= this.\u010f) && (this.\u0112 == null || numericRange.minimum() >= this.\u0112.minimum() && numericRange.maximum() <= this.\u0112.maximum())) {
            axis2.setRange(numericRange, true, false);
        }
        this.fireZoom(point, zoomDirection, 0.1);
        this.setHandled(true);
    }

    @Override
    public boolean isHandled() {
        return this.\u010d;
    }

    @Override
    public void setHandled(boolean bl) {
        this.\u010d = bl;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setHandled(false);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setHandled(false);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setHandled(false);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.setHandled(false);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.setHandled(false);
    }
}

