/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.ant;

import com.yworks.yguard.ObfuscatorTask;
import com.yworks.yguard.ant.AttributesSection;
import com.yworks.yguard.ant.ClassSection;
import com.yworks.yguard.ant.FieldSection;
import com.yworks.yguard.ant.LineNumberTableSection;
import com.yworks.yguard.ant.MethodSection;
import com.yworks.yguard.ant.PackageSection;
import com.yworks.yguard.ant.SourceFileSection;
import com.yworks.yguard.common.ant.Exclude;
import com.yworks.yguard.obf.YGuardRule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.ZipFileSet;

public class ExposeSection
extends Exclude {
    private List classes = new ArrayList(5);
    private List packages = new ArrayList(5);
    private List patterns = new ArrayList(5);
    private List methods = new ArrayList(5);
    private List fields = new ArrayList(5);
    private List attributes = new ArrayList(5);
    private List lineNumberTables = new ArrayList(5);
    private List sourceFiles = new ArrayList(5);

    public ExposeSection(ObfuscatorTask task) {
        super(task);
    }

    public void addPatternSet(PatternSet ps) {
        this.patterns.add(ps);
    }

    public MethodSection createMethod() {
        MethodSection ms = new MethodSection();
        this.methods.add(ms);
        return ms;
    }

    public FieldSection createField() {
        FieldSection fs = new FieldSection();
        this.fields.add(fs);
        return fs;
    }

    public ClassSection createClass() {
        ClassSection cs = new ClassSection(this.task);
        this.classes.add(cs);
        return cs;
    }

    public PackageSection createPackage() {
        PackageSection ps = new PackageSection();
        this.packages.add(ps);
        return ps;
    }

    public AttributesSection createAttribute() {
        AttributesSection as = new AttributesSection(this.task);
        this.attributes.add(as);
        return as;
    }

    public LineNumberTableSection createLineNumberTable() {
        LineNumberTableSection lns = new LineNumberTableSection(this.task);
        this.lineNumberTables.add(lns);
        return lns;
    }

    public SourceFileSection createSourceFile() {
        SourceFileSection sfs = new SourceFileSection(this.task);
        this.sourceFiles.add(sfs);
        return sfs;
    }

    public Collection createEntries(Collection srcJars) throws IOException {
        ArrayList<YGuardRule> entries = new ArrayList<YGuardRule>(20);
        if (this.source) {
            entries.add(new YGuardRule(0, "SourceFile"));
        }
        if (this.vtable) {
            entries.add(new YGuardRule(0, "LocalVariableTable"));
        }
        if (this.ltable) {
            entries.add(new YGuardRule(0, "LineNumberTable"));
        }
        if (this.lttable) {
            entries.add(new YGuardRule(0, "LocalVariableTypeTable"));
        }
        if (this.rvAnn) {
            entries.add(new YGuardRule(0, "RuntimeVisibleAnnotations"));
        }
        if (this.rvTypeAnn) {
            entries.add(new YGuardRule(0, "RuntimeVisibleTypeAnnotations"));
        }
        if (this.riAnn) {
            entries.add(new YGuardRule(0, "RuntimeInvisibleAnnotations"));
        }
        if (this.riTypeAnn) {
            entries.add(new YGuardRule(0, "RuntimeInvisibleTypeAnnotations"));
        }
        if (this.rvPann) {
            entries.add(new YGuardRule(0, "RuntimeVisibleParameterAnnotations"));
        }
        if (this.riPann) {
            entries.add(new YGuardRule(0, "RuntimeInvisibleParameterAnnotations"));
        }
        for (File file : srcJars) {
            ZipFileSet zipFile = new ZipFileSet();
            zipFile.setProject(this.task.getProject());
            zipFile.setSrc(file);
            for (ClassSection cs : this.classes) {
                if (cs.getName() != null || cs.getExtends() != null || cs.getImplements() != null) continue;
                cs.addEntries(entries, zipFile);
            }
            for (MethodSection ms : this.methods) {
                if (ms.getClassName() != null) continue;
                ms.addEntries(entries, zipFile);
            }
            for (FieldSection fs : this.fields) {
                if (fs.getClassName() != null) continue;
                fs.addEntries(entries, zipFile);
            }
            for (AttributesSection as : this.attributes) {
                if (as.getAttributes() == null) continue;
                as.addEntries(entries, zipFile);
            }
            for (LineNumberTableSection lt : this.lineNumberTables) {
                lt.addEntries(entries, zipFile);
            }
            for (SourceFileSection sfs : this.sourceFiles) {
                sfs.addEntries(entries, zipFile);
            }
            for (PackageSection ps : this.packages) {
                ps.addEntries(entries, zipFile);
            }
        }
        for (ClassSection cs : this.classes) {
            if (cs.getName() == null) continue;
            cs.addEntries(entries, cs.getName());
        }
        for (MethodSection ms : this.methods) {
            if (ms.getClassName() == null) continue;
            ms.addEntries(entries, ms.getClassName());
        }
        for (FieldSection fs : this.fields) {
            if (fs.getClassName() == null) continue;
            fs.addEntries(entries, fs.getClassName());
        }
        if (this.task instanceof ObfuscatorTask) {
            ((ObfuscatorTask)this.task).addInheritanceEntries(entries);
        }
        return entries;
    }

    public List getClasses() {
        return this.classes;
    }

    public List getPackages() {
        return this.packages;
    }

    public List getPatterns() {
        return this.patterns;
    }

    public List getMethods() {
        return this.methods;
    }

    public List getFields() {
        return this.fields;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public List getLineNumberTables() {
        return this.lineNumberTables;
    }

    public List getSourceFiles() {
        return this.sourceFiles;
    }
}

