/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphics2d.font.FontEncoder;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsbase.util.Value;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.swf.ButtonRecord;
import org.freehep.graphicsio.swf.DefineBitsJPEG3;
import org.freehep.graphicsio.swf.DefineBitsLossless2;
import org.freehep.graphicsio.swf.DefineButton;
import org.freehep.graphicsio.swf.DefineFont;
import org.freehep.graphicsio.swf.DefineShape;
import org.freehep.graphicsio.swf.DefineShape3;
import org.freehep.graphicsio.swf.DefineShape4;
import org.freehep.graphicsio.swf.DefineText;
import org.freehep.graphicsio.swf.DefineText2;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.End;
import org.freehep.graphicsio.swf.FillStyle;
import org.freehep.graphicsio.swf.FillStyleArray;
import org.freehep.graphicsio.swf.Gradient;
import org.freehep.graphicsio.swf.LineStyle;
import org.freehep.graphicsio.swf.LineStyleArray;
import org.freehep.graphicsio.swf.PlaceObject;
import org.freehep.graphicsio.swf.PlaceObject2;
import org.freehep.graphicsio.swf.SWFAction;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFGraphics2D;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFPathConstructor;
import org.freehep.graphicsio.swf.SWFShape;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.graphicsio.swf.ShowFrame;
import org.freehep.util.io.Action;

public class YSWFGraphics2D
extends AbstractVectorGraphicsIO
implements SWFConstants {
    private static final String rootKey = SWFGraphics2D.class.getName();
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
    private static final int MAX_BEFORE_TWIPS = 3275;
    private static final float frameRate = 20.0f;
    private static final boolean showBounds = false;
    private static final UserProperties defaultProperties = new UserProperties();
    private OutputStream ros;
    private SWFOutputStream os;
    private Value id;
    private Value depth;
    private boolean compress;
    private LineStyleArray lineStyles;
    private FillStyleArray fillStyles;
    private Color textColor;
    private Shape unwrittenClip;
    private AffineTransform clipTransform;
    private int clipID;
    private int clipDepthID;
    private int showClipID;
    private int showClipDepthID;
    boolean fillStroke;
    private int swfVersion;
    private static final Properties replaceFonts;
    private static final Color redZeroAlpha;
    private static final AffineTransform identity;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties properties) {
        defaultProperties.setProperties(properties);
    }

    public YSWFGraphics2D(File file, Dimension dimension) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), dimension);
    }

    public YSWFGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public YSWFGraphics2D(OutputStream outputStream, Dimension dimension) {
        super(dimension, true);
        this.init(outputStream);
    }

    public YSWFGraphics2D(OutputStream outputStream, Component component) {
        super(component, true);
        this.init(outputStream);
    }

    private void init(OutputStream outputStream) {
        this.initProperties(YSWFGraphics2D.getDefaultProperties());
        this.ros = outputStream;
        this.id = new Value().set(1);
        this.depth = new Value().set(1);
        this.compress = true;
        this.textColor = this.getColor();
        this.unwrittenClip = null;
        this.clipTransform = null;
        this.clipID = 0;
        this.clipDepthID = 0;
        this.showClipID = 0;
        this.showClipDepthID = 0;
        this.fillStroke = true;
        this.swfVersion = 7;
    }

    protected YSWFGraphics2D(YSWFGraphics2D ySWFGraphics2D, boolean bl) {
        super(ySWFGraphics2D, bl);
        this.os = ySWFGraphics2D.os;
        this.id = ySWFGraphics2D.id;
        this.depth = ySWFGraphics2D.depth;
        this.lineStyles = new LineStyleArray();
        this.lineStyles.add(ySWFGraphics2D.lineStyles.get(0));
        if (this.isProperty(CLIP)) {
            this.lineStyles.add(ySWFGraphics2D.lineStyles.get(1));
            this.lineStyles.add(ySWFGraphics2D.lineStyles.get(2));
        }
        this.fillStyles = new FillStyleArray();
        this.fillStyles.add(ySWFGraphics2D.fillStyles.get(0));
        this.textColor = ySWFGraphics2D.textColor;
        this.fillStroke = ySWFGraphics2D.fillStroke;
        this.swfVersion = ySWFGraphics2D.swfVersion;
    }

    public Dimension getSize() {
        return super.getSize();
    }

    public void writeHeader() throws IOException {
        this.os = new SWFOutputStream(new BufferedOutputStream(this.ros), this.swfVersion, this.getSize(), 20.0f, this.compress);
        String string = this.getCreator() + ":" + this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            string = string + " 1.5";
        }
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
        } else if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        this.os.writeTag(new ShowFrame());
        this.os.writeTag(new End());
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        return new YSWFGraphics2D(this, true);
    }

    public Graphics create(double d, double d2, double d3, double d4) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        YSWFGraphics2D ySWFGraphics2D = new YSWFGraphics2D(this, true);
        ((VectorGraphics)ySWFGraphics2D).translate(d, d2);
        ((VectorGraphics)ySWFGraphics2D).clipRect(0.0, 0.0, d3, d4);
        return ySWFGraphics2D;
    }

    protected void writeGraphicsSave() throws IOException {
    }

    protected void writeGraphicsRestore() throws IOException {
        this.popStreamAndWriteClip();
    }

    private AffineTransform normalizingTransform(Shape shape) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double[] dArray = new double[6];
        Object object = shape.getPathIterator(null);
        while (!object.isDone()) {
            switch (object.currentSegment(dArray)) {
                case 3: {
                    if (d > dArray[4]) {
                        d = dArray[4];
                    }
                    if (d3 < dArray[4]) {
                        d3 = dArray[4];
                    }
                    if (d2 > dArray[5]) {
                        d2 = dArray[5];
                    }
                    if (d4 < dArray[5]) {
                        d4 = dArray[5];
                    }
                }
                case 2: {
                    if (d > dArray[2]) {
                        d = dArray[2];
                    }
                    if (d3 < dArray[2]) {
                        d3 = dArray[2];
                    }
                    if (d2 > dArray[3]) {
                        d2 = dArray[3];
                    }
                    if (d4 < dArray[3]) {
                        d4 = dArray[3];
                    }
                }
                case 0: 
                case 1: {
                    if (d > dArray[0]) {
                        d = dArray[0];
                    }
                    if (d3 < dArray[0]) {
                        d3 = dArray[0];
                    }
                    if (d2 > dArray[1]) {
                        d2 = dArray[1];
                    }
                    if (!(d4 < dArray[1])) break;
                    d4 = dArray[1];
                }
            }
            object.next();
        }
        object = new AffineTransform();
        ((AffineTransform)object).translate(-d + 0.5, -d2 + 0.5);
        double d5 = Math.max(Math.ceil(d3 - d), Math.ceil(d4 - d2));
        if (d5 > 3275.0) {
            double d6 = 3275.0 / d5;
            ((AffineTransform)object).scale(d6, d6);
        }
        return object;
    }

    public void draw(Shape shape) {
        AffineTransform affineTransform = this.normalizingTransform(shape);
        try {
            AffineTransform affineTransform2 = this.getTransform();
            this.transform(affineTransform.createInverse());
            this.drawImpl(this.createTransformedShape(affineTransform, shape));
            this.setTransform(affineTransform2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.writeWarning(noninvertibleTransformException);
            this.drawImpl(shape);
        }
    }

    private Shape createTransformedShape(AffineTransform affineTransform, Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            double[] dArray = new double[]{rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()};
            affineTransform.transform(dArray, 0, dArray, 0, 2);
            return new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
        }
        if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            double[] dArray = new double[]{ellipse2D.getMinX(), ellipse2D.getMinY(), ellipse2D.getMaxX(), ellipse2D.getMaxY()};
            affineTransform.transform(dArray, 0, dArray, 0, 2);
            return new Ellipse2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
        }
        return affineTransform.createTransformedShape(shape);
    }

    private void drawImpl(Shape shape) {
        Shape shape2 = this.getStroke().createStrokedShape(shape);
        if (this.fillStroke) {
            this.fill(new Area(shape2));
            return;
        }
        try {
            Rectangle2D rectangle2D = shape2.getBounds2D();
            SWFShape sWFShape = this.createShape(shape, 1, 0, -1);
            this.os.writeTag(this.newDefineShape(this.id.getInt(), rectangle2D, this.fillStyles, this.lineStyles, sWFShape));
            this.os.writeTag(new PlaceObject2(this.id.getInt(), this.depth.getInt(), this.getTransform()));
            this.id.set(this.id.getInt() + 1);
            this.depth.set(this.depth.getInt() + 1);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void fill(Shape shape) {
        AffineTransform affineTransform = this.normalizingTransform(shape);
        try {
            AffineTransform affineTransform2 = this.getTransform();
            this.transform(affineTransform.createInverse());
            this.fillImpl(this.createTransformedShape(affineTransform, shape));
            this.setTransform(affineTransform2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.writeWarning(noninvertibleTransformException);
            this.fillImpl(shape);
        }
    }

    private void fillImpl(Shape shape) {
        try {
            Rectangle2D rectangle2D = new BasicStroke().createStrokedShape(shape).getBounds2D();
            SWFShape sWFShape = this.createShape(shape, 0, 1, -1);
            this.os.writeTag(this.newDefineShape(this.id.getInt(), rectangle2D, this.fillStyles, this.lineStyles, sWFShape));
            this.os.writeTag(new PlaceObject2(this.id.getInt(), this.depth.getInt(), this.getTransform()));
            this.id.set(this.id.getInt() + 1);
            this.depth.set(this.depth.getInt() + 1);
            boolean bl = SWFPathConstructor.isEvenOdd(shape);
            if (!bl) {
                this.writeWarning(this.getClass() + ": cannot fill using non-zero winding rule, used even-odd instead.");
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void fillAndDraw(Shape shape, Color color) {
        AffineTransform affineTransform = this.normalizingTransform(shape);
        try {
            AffineTransform affineTransform2 = this.getTransform();
            this.transform(affineTransform.createInverse());
            this.fillAndDrawImpl(this.createTransformedShape(affineTransform, shape), color);
            this.setTransform(affineTransform2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.writeWarning(noninvertibleTransformException);
            this.fillAndDrawImpl(shape, color);
        }
    }

    private void fillAndDrawImpl(Shape shape, Color color) {
        try {
            this.setFillColor(color);
            this.fill(shape);
            this.setFillColor(this.getColor());
            this.draw(shape);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage renderedImage, AffineTransform affineTransform, Color color) throws IOException {
        int n = this.id.getInt();
        this.os.writeTag(this.getImageTag(n, renderedImage, color));
        this.id.set(this.id.getInt() + 1);
        Shape shape = affineTransform.createTransformedShape(new Rectangle(0, 0, renderedImage.getWidth(), renderedImage.getHeight()));
        AffineTransform affineTransform2 = new AffineTransform(20.0f, 0.0f, 0.0f, 20.0f, 0.0f, 0.0f);
        affineTransform.concatenate(affineTransform2);
        SWFShape sWFShape = this.createShape(shape, 0, 0, 1);
        FillStyleArray fillStyleArray = new FillStyleArray();
        fillStyleArray.add(new FillStyle(n, false, affineTransform));
        LineStyleArray lineStyleArray = new LineStyleArray();
        Rectangle rectangle = shape.getBounds();
        this.os.writeTag(this.newDefineShape(this.id.getInt(), rectangle, fillStyleArray, lineStyleArray, sWFShape));
        this.os.writeTag(new PlaceObject2(this.id.getInt(), this.depth.getInt(), this.getTransform()));
        this.id.set(this.id.getInt() + 1);
        this.depth.set(this.depth.getInt() + 1);
    }

    protected void writeString(String string, double d, double d2) throws IOException {
        String string2 = this.getFont().getName();
        string = FontEncoder.getEncodedString(string, string2);
        Font font = (string2 = replaceFonts.getProperty(string2, null)) == null ? this.getFont() : new Font(string2, this.getFont().getStyle(), this.getFont().getSize());
        Font font2 = font.deriveFont(51.2f);
        GlyphVector glyphVector = font2.createGlyphVector(this.getFontRenderContext(), string);
        Rectangle2D rectangle2D = font.createGlyphVector(this.getFontRenderContext(), string).getVisualBounds();
        rectangle2D.setRect(rectangle2D.getX() + d, rectangle2D.getY() + d2, rectangle2D.getWidth(), rectangle2D.getHeight());
        int n = this.id.getInt();
        DefineFont defineFont = new DefineFont(n);
        this.id.set(this.id.getInt() + 1);
        Vector<DefineText.Record> vector = new Vector<DefineText.Record>();
        DefineText.RecordType1 recordType1 = new DefineText.RecordType1(n, this.textColor, (int)(d * 20.0), (int)(d2 * 20.0), (int)(font.getSize2D() * 20.0f));
        DefineText.RecordType0 recordType0 = new DefineText.RecordType0();
        vector.add(recordType1);
        vector.add(recordType0);
        int n2 = this.id.getInt();
        DefineText2 defineText2 = new DefineText2(n2, rectangle2D, new AffineTransform(), vector);
        this.id.set(this.id.getInt() + 1);
        for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
            defineFont.add(this.createShape(glyphVector.getGlyphOutline(i), -1, 1, -1));
            recordType0.add(new DefineText.GlyphEntry(i, 0));
        }
        this.os.writeTag(defineFont);
        this.os.writeTag(defineText2);
        this.os.writeTag(new PlaceObject2(n2, this.depth.getInt(), this.getTransform()));
        this.depth.set(this.depth.getInt() + 1);
    }

    protected void writeTransform(AffineTransform affineTransform) throws IOException {
    }

    protected void writeSetTransform(AffineTransform affineTransform) throws IOException {
    }

    protected void writeSetClip(Shape shape) throws IOException {
        this.writeClip(shape);
    }

    protected void writeClip(Shape shape) throws IOException {
        if (shape != null) {
            AffineTransform affineTransform = this.normalizingTransform(shape);
            try {
                AffineTransform affineTransform2 = this.getTransform();
                this.transform(affineTransform.createInverse());
                this.writeClipImpl(this.createTransformedShape(affineTransform, shape));
                this.setTransform(affineTransform2);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                this.writeWarning(noninvertibleTransformException);
                this.fillImpl(shape);
            }
        } else {
            this.writeClipImpl(null);
        }
    }

    private void writeClipImpl(Shape shape) throws IOException {
        this.popStreamAndWriteClip();
        this.unwrittenClip = shape;
        AffineTransform affineTransform = this.clipTransform = this.unwrittenClip != null ? new AffineTransform(this.getTransform()) : null;
        if (this.unwrittenClip != null) {
            this.clipID = this.id.getInt();
            this.id.set(this.id.getInt() + 1);
            this.clipDepthID = this.depth.getInt();
            this.depth.set(this.depth.getInt() + 1);
            if (this.isProperty(CLIP)) {
                this.showClipID = this.id.getInt();
                this.id.set(this.id.getInt() + 1);
                this.showClipDepthID = this.depth.getInt();
                this.depth.set(this.depth.getInt() + 1);
            }
            this.os.pushBuffer();
        } else {
            this.clipID = 0;
            this.clipDepthID = 0;
            if (this.isProperty(CLIP)) {
                this.showClipID = 0;
                this.showClipDepthID = 0;
            }
        }
    }

    protected void writeStroke(Stroke stroke) throws IOException {
        this.fillStroke = true;
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            this.setPen(basicStroke, this.getColor());
            if (basicStroke.getLineWidth() == 0.0f) {
                this.fillStroke = false;
            }
        }
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color color) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color color) throws IOException {
        this.setPen((BasicStroke)this.getStroke(), color);
        this.setFillColor(color);
        this.textColor = PrintColor.createPrintColor(color);
    }

    protected void writePaint(GradientPaint gradientPaint) throws IOException {
        Gradient[] gradientArray = new Gradient[]{new Gradient(0, gradientPaint.getColor1()), new Gradient(255, gradientPaint.getColor2())};
        double d = gradientPaint.getPoint1().getX();
        double d2 = gradientPaint.getPoint1().getY();
        double d3 = gradientPaint.getPoint2().getX() - d;
        double d4 = gradientPaint.getPoint2().getY() - d2;
        double d5 = gradientPaint.getPoint1().distance(gradientPaint.getPoint2()) * 20.0 / 32768.0;
        double d6 = Math.atan2(d4, d3);
        AffineTransform affineTransform = new AffineTransform(d5, 0.0, 0.0, d5, d3 / 2.0 + d, d4 / 2.0 + d2);
        affineTransform.rotate(d6);
        int n = gradientPaint.isCyclic() ? 1 : 0;
        this.fillStyles = new FillStyleArray();
        this.fillStyles.add(new FillStyle(gradientArray, 16, n, 0, 0.0f, affineTransform));
        this.textColor = PrintColor.mixColor(gradientPaint.getColor1(), gradientPaint.getColor2());
    }

    protected void writePaint(TexturePaint texturePaint) throws IOException {
        BufferedImage bufferedImage = texturePaint.getImage();
        int n = this.id.getInt();
        this.os.writeTag(this.getImageTag(n, bufferedImage, null));
        this.id.set(this.id.getInt() + 1);
        Rectangle2D rectangle2D = texturePaint.getAnchorRect();
        double d = rectangle2D.getWidth() / (double)bufferedImage.getWidth();
        double d2 = rectangle2D.getHeight() / (double)bufferedImage.getHeight();
        this.fillStyles = new FillStyleArray();
        this.fillStyles.add(new FillStyle(n, true, new AffineTransform(d * 20.0, 0.0, 0.0, d2 * 20.0, rectangle2D.getX(), rectangle2D.getY())));
        this.textColor = PrintColor.black;
    }

    protected void writePaint(Paint paint) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(Paint) not implemented for " + paint.getClass());
        this.writePaint(Color.BLACK);
    }

    protected void writeFont(Font font) throws IOException {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        this.writeWarning(this.getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String string) throws IOException {
        this.writeWarning(this.getClass() + ": writeComment(String) not implemented.");
    }

    public String toString() {
        return "YSWFGraphics2D";
    }

    SWFShape createShape(Shape shape, int n, int n2, int n3) throws IOException {
        AffineTransform affineTransform = this.getTransform();
        double d = 0.5 / (20.0 * Math.min(affineTransform.getScaleX(), affineTransform.getScaleY()));
        Vector<SWFShape.Record> vector = new Vector<SWFShape.Record>();
        SWFPathConstructor sWFPathConstructor = new SWFPathConstructor(vector, n, n2, n3, d);
        sWFPathConstructor.addPath(shape);
        return new SWFShape(vector);
    }

    private void setPen(BasicStroke basicStroke, Color color) throws IOException {
        this.lineStyles = new LineStyleArray();
        this.lineStyles.add(new LineStyle((int)(basicStroke.getLineWidth() * 20.0f), this.getPrintColor(color)));
        if (this.isProperty(CLIP)) {
            this.lineStyles.add(new LineStyle(20, Color.cyan));
            this.lineStyles.add(new LineStyle(20, Color.orange));
        }
    }

    private void setFillColor(Color color) throws IOException {
        this.fillStyles = new FillStyleArray();
        this.fillStyles.add(new FillStyle(this.getPrintColor(color)));
    }

    private void popStreamAndWriteClip() throws IOException {
        if (this.unwrittenClip == null) {
            return;
        }
        if (this.clipID == 0 || this.clipDepthID == 0) {
            System.err.println("SWFGraphics2D: internal error, invalid clipID or clipDepthID");
            return;
        }
        this.os.popBuffer();
        Rectangle2D rectangle2D = this.unwrittenClip.getBounds2D();
        SWFShape sWFShape = this.createShape(this.unwrittenClip, 0, 1, -1);
        this.os.writeTag(this.newDefineShape(this.clipID, rectangle2D, this.fillStyles, this.lineStyles, sWFShape));
        int n = this.depth.getInt() - 1;
        this.os.writeTag(new PlaceObject2(this.clipID, this.clipDepthID, this.clipTransform, n));
        if (this.isProperty(CLIP)) {
            if (this.showClipID == 0 || this.showClipDepthID == 0) {
                System.err.println("SWFGraphics2D: internal error, invalid showClipID or showClipDepthID");
                return;
            }
            SWFShape sWFShape2 = this.createShape(rectangle2D, 3, 0, -1);
            this.os.writeTag(this.newDefineShape(this.showClipID, rectangle2D, this.fillStyles, this.lineStyles, sWFShape2));
            this.os.writeTag(new PlaceObject(this.showClipID, this.showClipDepthID, this.clipTransform));
        }
        this.os.append();
    }

    private SWFTag getImageTag(int n, RenderedImage renderedImage, Color color) throws IOException {
        String string = this.getProperty(WRITE_IMAGES_AS);
        DefineBitsLossless2 defineBitsLossless2 = null;
        if (string.equals("ZLIB") || string.equals("Smallest Size")) {
            defineBitsLossless2 = new DefineBitsLossless2(n, renderedImage, color);
        }
        DefineBitsJPEG3 defineBitsJPEG3 = null;
        if (string.equals("JPG") || string.equals("Smallest Size")) {
            defineBitsJPEG3 = new DefineBitsJPEG3(n, renderedImage, color, new Properties());
        }
        DefinitionTag definitionTag = string.equals("ZLIB") ? defineBitsLossless2 : (string.equals("JPG") ? defineBitsJPEG3 : ((double)defineBitsJPEG3.getLength() < 0.5 * (double)defineBitsLossless2.getLength() ? defineBitsJPEG3 : defineBitsLossless2));
        return definitionTag;
    }

    public void writeLink(String string, String string2, Shape shape) {
        AffineTransform affineTransform = this.normalizingTransform(shape);
        try {
            AffineTransform affineTransform2 = this.getTransform();
            this.transform(affineTransform.createInverse());
            this.writeLinkImpl(string, string2, this.createTransformedShape(affineTransform, shape));
            this.setTransform(affineTransform2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.writeWarning(noninvertibleTransformException);
            this.writeLinkImpl(string, string2, shape);
        }
    }

    private void writeLinkImpl(String string, String string2, Shape shape) {
        if (null == string) {
            return;
        }
        if (null == string2 || "" == string2) {
            string2 = "_self";
        }
        Vector<SWFShape.Record> vector = new Vector<SWFShape.Record>();
        SWFPathConstructor sWFPathConstructor = new SWFPathConstructor(vector, 1, 1, -1, 0.025);
        try {
            sWFPathConstructor.addPath(shape);
            SWFShape sWFShape = new SWFShape(vector);
            int n = this.id.getInt();
            this.id.set(this.id.getInt() + 1);
            FillStyleArray fillStyleArray = new FillStyleArray();
            fillStyleArray.add(new FillStyle(redZeroAlpha));
            LineStyleArray lineStyleArray = new LineStyleArray();
            lineStyleArray.add(new LineStyle(0, redZeroAlpha));
            this.os.writeTag(new DefineShape3(n, shape.getBounds2D(), fillStyleArray, lineStyleArray, sWFShape));
            this.createLinkButton(n, string, string2);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    private void createLinkButton(int n, String string, String string2) throws IOException {
        this.createLinkButton(n, -1, -1, -1, string, string2);
    }

    private void createLinkButton(int n, int n2, int n3, int n4, String string, String string2) throws IOException {
        boolean bl;
        Vector<MyButtonRecord> vector = new Vector<MyButtonRecord>();
        boolean bl2 = n != -1;
        boolean bl3 = n2 != -1;
        boolean bl4 = n3 != -1;
        boolean bl5 = bl = n4 != -1;
        if (!(bl2 || bl3 || bl4 || bl)) {
            return;
        }
        if (bl2) {
            vector.add(new MyButtonRecord(true, !bl3, !bl4, !bl, n, 2, identity));
        }
        if (bl3) {
            vector.add(new MyButtonRecord(!bl2, true, !bl4, !bl, n2, 3, identity));
        }
        if (bl4) {
            vector.add(new MyButtonRecord(!bl2, !bl3, true, !bl, n3, 4, identity));
        }
        if (bl) {
            vector.add(new MyButtonRecord(!bl2, !bl3, !bl4, true, n4, 5, identity));
        }
        Vector<MyGetURL> vector2 = new Vector<MyGetURL>();
        vector2.add(new MyGetURL(string, string2));
        int n5 = this.id.getInt();
        this.os.writeTag(new MyDefineButton(n5, vector, vector2));
        this.os.writeTag(new PlaceObject2(n5, this.depth.getInt(), this.getTransform()));
        this.id.set(this.id.getInt() + 1);
        this.depth.set(this.depth.getInt() + 1);
    }

    private DefineShape newDefineShape(int n, Rectangle2D rectangle2D, FillStyleArray fillStyleArray, LineStyleArray lineStyleArray, SWFShape sWFShape) {
        if (this.getSWFVersion() >= 8) {
            return new DefineShape4(n, rectangle2D, fillStyleArray, lineStyleArray, sWFShape);
        }
        return new DefineShape3(n, rectangle2D, fillStyleArray, lineStyleArray, sWFShape);
    }

    public void setSWFVersion(int n) {
        this.swfVersion = n;
    }

    public int getSWFVersion() {
        return this.swfVersion;
    }

    public void setCompressionEnabled(boolean bl) {
        this.compress = bl;
    }

    public boolean isCompressionEnabled() {
        return this.compress;
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        defaultProperties.setProperty(CLIP, false);
        defaultProperties.setProperty(TEXT_AS_SHAPES, true);
        replaceFonts = new Properties();
        replaceFonts.setProperty("Symbol", "Serif");
        replaceFonts.setProperty("ZapfDingbats", "Serif");
        redZeroAlpha = new Color(255, 0, 0, 0);
        identity = new AffineTransform();
    }

    static class MyButtonRecord
    extends ButtonRecord {
        private boolean hitTest;
        private boolean down;
        private boolean over;
        private boolean up;
        private int id;
        private int depth;
        private AffineTransform matrix;

        public MyButtonRecord(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, AffineTransform affineTransform) {
            super(bl, bl2, bl3, bl4, n, n2, affineTransform);
            this.hitTest = bl;
            this.down = bl2;
            this.over = bl3;
            this.up = bl4;
            this.id = n;
            this.depth = n2;
            this.matrix = affineTransform;
        }

        public void write(SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeBitFlag(false);
            sWFOutputStream.writeBitFlag(false);
            sWFOutputStream.writeBitFlag(false);
            sWFOutputStream.writeBitFlag(false);
            sWFOutputStream.writeBitFlag(this.hitTest);
            sWFOutputStream.writeBitFlag(this.down);
            sWFOutputStream.writeBitFlag(this.over);
            sWFOutputStream.writeBitFlag(this.up);
            sWFOutputStream.writeUnsignedShort(this.id);
            sWFOutputStream.writeUnsignedShort(this.depth);
            sWFOutputStream.writeMatrix(this.matrix);
            sWFOutputStream.byteAlign();
        }
    }

    static class MyDefineButton
    extends DefineButton {
        private int id;
        private Vector buttons;
        private Vector actions;

        public MyDefineButton(int n, Vector vector, Vector vector2) {
            super(n, vector, vector2);
            this.id = n;
            this.buttons = vector;
            this.actions = vector2;
        }

        public void write(int n, SWFOutputStream sWFOutputStream) throws IOException {
            Object object;
            int n2;
            sWFOutputStream.writeUnsignedShort(this.id);
            for (n2 = 0; n2 < this.buttons.size(); ++n2) {
                object = (ButtonRecord)this.buttons.get(n2);
                ((ButtonRecord)object).write(sWFOutputStream);
            }
            sWFOutputStream.writeUnsignedByte(0);
            for (n2 = 0; n2 < this.actions.size(); ++n2) {
                object = (Action)this.actions.get(n2);
                sWFOutputStream.writeAction((Action)object);
                sWFOutputStream.byteAlign();
            }
            sWFOutputStream.byteAlign();
        }
    }

    static class MyGetURL
    extends SWFAction.GetURL {
        private String url;
        private String window;

        public MyGetURL(String string, String string2) {
            super(string, string2);
            this.url = string;
            this.window = string2;
        }

        public void write(int n, SWFOutputStream sWFOutputStream) throws IOException {
            if (sWFOutputStream.getVersion() >= 6) {
                byte[] byArray = this.url.getBytes("UTF-8");
                sWFOutputStream.write(byArray);
                sWFOutputStream.write(0);
                byArray = this.window.getBytes("UTF-8");
                sWFOutputStream.write(byArray);
                sWFOutputStream.write(0);
            } else {
                super.write(n, sWFOutputStream);
            }
        }
    }
}

