/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DirectPathBufferMarshaler;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;

class T4CTTIodpls
extends T4CTTIfun {
    private static final int DPLSDEF_IN_PARMCOUNT = 1;
    private static final int DPLSDEF_IN_FLAG = 0;
    private static final int DPLSDEF_IN_KLA_PARSE_RESET = 2;
    private static final int STREAM_VERSION = 400;
    private int dplscsr;
    private int dplsbufl;
    private DirectPathBufferMarshaler.BufferPlanner dplsbufPlan;
    private int dplsvrsn;
    private long[] dplsi4;
    private int dplsi4l;
    private long[] dplso4;
    int startErrorOffset;
    int endErrorOffset;

    T4CTTIodpls(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)129);
        this.clearState();
    }

    private void clearState() {
        this.dplscsr = 0;
        this.dplsbufPlan = null;
        this.dplsbufl = 0;
        this.dplsvrsn = 0;
        this.dplsi4 = new long[1];
        this.dplsi4l = 0;
        this.dplso4 = null;
    }

    void doODPLS(int n2, DirectPathBufferMarshaler.BufferPlanner bufferPlanner) throws IOException, SQLException {
        this.dplscsr = n2;
        this.dplsvrsn = 400;
        this.dplsbufPlan = bufferPlanner;
        do {
            this.dplsbufl = this.dplsbufPlan.preparePlan();
            this.doRPC();
        } while (!this.dplsbufPlan.isComplete());
        this.clearState();
    }

    void setI4Value(int n2, long l2) {
        this.dplsi4[n2] = l2;
        this.dplsi4l = Math.max(this.dplsi4l, n2 + 1);
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalSWORD(this.dplscsr);
        if (this.dplsbufl > 0) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.dplsbufl);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalUB4(this.dplsvrsn);
        if (this.dplsi4l > 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalUB4(this.dplsi4l);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (this.dplsbufl > 0) {
            DirectPathBufferMarshaler.marshal(this.dplsbufPlan, this.meg);
        }
        if (this.dplsi4l > 0) {
            for (int i2 = 0; i2 < this.dplsi4l; ++i2) {
                this.meg.marshalUB4(this.dplsi4[i2]);
            }
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        int n2 = this.meg.unmarshalUB2();
        this.dplso4 = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.dplso4[i2] = this.meg.unmarshalUB4();
        }
    }

    long getO4Value(int n2) {
        return this.dplso4 != null && n2 < this.dplso4.length ? this.dplso4[n2] : 0L;
    }

    @Override
    void processError() throws SQLException {
        try {
            super.processError();
        }
        catch (SQLException sQLException) {
            byte[] byArray = this.oer.oerepa;
            if (byArray != null) {
                int n2 = this.getErrorOffset(byArray, 0);
                this.getErrorOffset(byArray, n2);
            }
            throw sQLException;
        }
    }

    private int getErrorOffset(byte[] byArray, int n2) {
        int n3 = n2;
        int n4 = byArray[n2++] & 0xFF;
        int n5 = 0;
        if (n4 + n3 <= byArray.length) {
            if (n4 == 0) {
                n5 = 0;
            } else if (n4 == 1) {
                n5 = byArray[n2++] & 0xFF;
            } else if (n4 == 2) {
                n5 = (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            } else if (n4 == 4) {
                n5 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            }
        }
        if (n3 == 0) {
            this.startErrorOffset = n5;
        } else {
            this.endErrorOffset = n5;
        }
        return n2;
    }
}

