/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.Log;

public final class TcpMultiplexer {
    private static final Consumer<Throwable> NO_OP_CALLBACK = throwable -> {};
    private static volatile boolean isStarted = false;
    private final Selector selector;
    private final ConcurrentLinkedQueue<Runnable> registrationQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger pendingRegistrationCount = new AtomicInteger(0);
    private final Thread pollingThread;

    private static TcpMultiplexer soleInstance() {
        return LazyHolder.INSTANCE;
    }

    public static void registerForReadEvent(SocketChannel socketChannel, Consumer<Throwable> consumer) throws IOException {
        TcpMultiplexer.soleInstance().register(socketChannel, 1, consumer);
    }

    public static void registerForWriteEvent(SocketChannel socketChannel, Consumer<Throwable> consumer) throws IOException {
        TcpMultiplexer.soleInstance().register(socketChannel, 4, consumer);
    }

    public static void registerForConnectEvent(SocketChannel socketChannel, Consumer<Throwable> consumer) throws IOException {
        TcpMultiplexer.soleInstance().register(socketChannel, 8, consumer);
    }

    public static void cancelRegistration(SocketChannel socketChannel, Throwable throwable) {
        if (!isStarted) {
            return;
        }
        SelectionKey selectionKey = TcpMultiplexer.soleInstance().getKeyForChannel(socketChannel);
        if (selectionKey == null) {
            return;
        }
        TcpMultiplexer.onReadReady(selectionKey, throwable);
    }

    public static void stop() {
        if (!isStarted) {
            return;
        }
        isStarted = false;
        TcpMultiplexer.soleInstance().pollingThread.interrupt();
    }

    private TcpMultiplexer(Selector selector) {
        this.selector = selector;
        this.pollingThread = new Thread(this::poll, this.getClass().getName());
        this.pollingThread.setDaemon(true);
        this.pollingThread.start();
        isStarted = true;
    }

    private void register(SocketChannel socketChannel, int n2, Consumer<Throwable> consumer) throws IOException {
        this.registrationQueue.add(() -> {
            try {
                socketChannel.configureBlocking(false);
                socketChannel.register(this.selector, n2, consumer);
            }
            catch (IOException iOException) {
                try {
                    socketChannel.configureBlocking(true);
                }
                catch (IOException iOException2) {
                    iOException.addSuppressed(iOException2);
                }
                consumer.accept(iOException);
            }
        });
        if (this.pendingRegistrationCount.getAndIncrement() == 0) {
            this.selector.wakeup();
        }
    }

    private SelectionKey getKeyForChannel(SocketChannel socketChannel) {
        return socketChannel.keyFor(this.selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void poll() {
        try {
            try {
                while (true) {
                    int n2;
                    int n3 = this.selector.select();
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedIOException(Thread.currentThread().getName() + " received a thread interrupt");
                    }
                    while (n3 != 0) {
                        for (SelectionKey selectionKey2 : this.selector.selectedKeys()) {
                            TcpMultiplexer.onReadReady(selectionKey2);
                        }
                        this.selector.selectedKeys().clear();
                        n3 = this.selector.selectNow();
                    }
                    do {
                        void object;
                        n2 = 0;
                        Runnable runnable = this.registrationQueue.poll();
                        while (object != null) {
                            ++n2;
                            object.run();
                            Runnable runnable2 = this.registrationQueue.poll();
                        }
                    } while (this.pendingRegistrationCount.addAndGet(-n2) > 0);
                }
            }
            catch (IOException iOException) {
                this.invokeAllReadinessCallbacks(iOException);
                Consumer[] consumerArray = (Consumer[])this.selector.keys().stream().map(selectionKey -> (Consumer)selectionKey.attach(NO_OP_CALLBACK)).toArray(Consumer[]::new);
                IOException iOException2 = new IOException("Selector has stopped polling");
                try {
                    this.selector.close();
                }
                catch (IOException iOException3) {
                    iOException2.addSuppressed(iOException3);
                }
                for (Consumer consumer : consumerArray) {
                    consumer.accept(iOException2);
                }
            }
        }
        catch (Throwable throwable) {
            Consumer[] consumerArray = (Consumer[])this.selector.keys().stream().map(selectionKey -> (Consumer)selectionKey.attach(NO_OP_CALLBACK)).toArray(Consumer[]::new);
            IOException iOException = new IOException("Selector has stopped polling");
            try {
                this.selector.close();
            }
            catch (IOException iOException4) {
                iOException.addSuppressed(iOException4);
            }
            for (Consumer consumer : consumerArray) {
                consumer.accept(iOException);
            }
            throw throwable;
        }
    }

    private static final void onReadReady(SelectionKey selectionKey) {
        TcpMultiplexer.onReadReady(selectionKey, null);
    }

    private static final void onReadReady(SelectionKey selectionKey, Throwable throwable) {
        try {
            selectionKey.cancel();
            selectionKey.channel().configureBlocking(true);
        }
        catch (IOException iOException) {
            if (throwable == null) {
                throwable = iOException;
            }
            throwable.addSuppressed(iOException);
        }
        TcpMultiplexer.invokeReadinessCallback(selectionKey, throwable);
    }

    private static final void invokeReadinessCallback(SelectionKey selectionKey, Throwable throwable) {
        Consumer consumer = (Consumer)selectionKey.attach(NO_OP_CALLBACK);
        try {
            consumer.accept(throwable);
        }
        catch (Throwable throwable2) {
        }
    }

    private void invokeAllReadinessCallbacks(Throwable throwable) {
        for (SelectionKey selectionKey : this.selector.keys()) {
            TcpMultiplexer.invokeReadinessCallback(selectionKey, throwable);
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    private static final class LazyHolder {
        private static final TcpMultiplexer INSTANCE;

        private LazyHolder() {
        }

        static {
            Selector selector;
            try {
                selector = Selector.open();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            INSTANCE = new TcpMultiplexer(selector);
        }
    }
}

