/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.resolver.EnvVariableResolver;

public class LDAPSSLSocketFactory
extends SSLSocketFactory {
    static final ThreadLocal<Properties> connectionProperties = new ThreadLocal();
    private static SSLSocketFactory defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();

    public static SocketFactory getDefault() {
        return new LDAPSSLSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return defaultFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return defaultFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(), properties);
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n2, boolean bl) throws IOException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(socket, string, n2, bl), properties);
    }

    @Override
    public Socket createSocket(String string, int n2) throws IOException, UnknownHostException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(string, n2), properties);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2) throws IOException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(inetAddress, n2), properties);
    }

    @Override
    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(string, n2, inetAddress, n3), properties);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(inetAddress, n2, inetAddress2, n3), properties);
    }

    private SSLSocketFactory getSSLSocketFactory(@Blind(value=PropertiesBlinder.class) Properties properties) throws IOException {
        return CustomSSLSocketFactory.getSSLSocketFactory(properties, null);
    }

    @Blind(value=PropertiesBlinder.class)
    private Properties getSSLProperties(@Blind(value=PropertiesBlinder.class) Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        Properties properties2 = new Properties();
        properties2.put((Object)38, "TLS");
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (string.equalsIgnoreCase("oracle.net.ldap.ssl.walletLocation")) {
                object = properties.getProperty("oracle.net.ldap.ssl.walletLocation");
                properties2.put((Object)5, EnvVariableResolver.resolveEnvPlaceHolders((String)object, properties));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ldap.ssl.walletPassword")) {
                object = (OpaqueString)properties.get("oracle.net.ldap.ssl.walletPassword");
                properties2.put((Object)16, object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ldap.ssl.supportedVersions")) {
                object = properties.getProperty("oracle.net.ldap.ssl.supportedVersions");
                properties2.put((Object)6, object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ldap.ssl.ssl_context_protocol")) {
                object = properties.getProperty("oracle.net.ldap.ssl.ssl_context_protocol");
                properties2.put((Object)38, object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ldap.ssl.supportedCiphers")) {
                object = properties.getProperty("oracle.net.ldap.ssl.supportedCiphers");
                properties2.put((Object)7, object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ldap.ssl.keyStore")) {
                object = properties.getProperty("oracle.net.ldap.ssl.keyStore");
                properties2.put((Object)8, object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ldap.ssl.keyStoreType")) {
                object = properties.getProperty("oracle.net.ldap.ssl.keyStoreType");
                properties2.put((Object)9, object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ldap.ssl.keyStorePassword")) {
                object = (OpaqueString)properties.get("oracle.net.ldap.ssl.keyStorePassword");
                properties2.put((Object)10, object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ldap.ssl.trustStore")) {
                object = properties.getProperty("oracle.net.ldap.ssl.trustStore");
                properties2.put((Object)11, object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ldap.ssl.trustStoreType")) {
                object = properties.getProperty("oracle.net.ldap.ssl.trustStoreType");
                properties2.put((Object)12, object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ldap.ssl.trustStorePassword")) {
                object = (OpaqueString)properties.get("oracle.net.ldap.ssl.trustStorePassword");
                properties2.put((Object)13, object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ldap.ssl.keyManagerFactory.algorithm")) {
                object = properties.getProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm");
                properties2.put((Object)14, object);
                continue;
            }
            if (!string.equalsIgnoreCase("oracle.net.ldap.ssl.trustManagerFactory.algorithm")) continue;
            object = properties.getProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm");
            properties2.put((Object)15, object);
        }
        return properties2;
    }

    private Socket initializeSSLSocket(SSLSocket sSLSocket, @Blind(value=PropertiesBlinder.class) Properties properties) {
        Object object;
        String string = (String)properties.get(6);
        if (string != null && !string.trim().isEmpty()) {
            object = string.split(",");
            sSLSocket.setEnabledProtocols((String[])object);
        } else {
            sSLSocket.setEnabledProtocols(sSLSocket.getSupportedProtocols());
        }
        object = (String)properties.get(7);
        if (object != null && !((String)object).trim().isEmpty()) {
            String[] stringArray = ((String)object).split(",");
            sSLSocket.setEnabledCipherSuites(stringArray);
        } else {
            sSLSocket.setEnabledCipherSuites(sSLSocket.getSupportedCipherSuites());
        }
        return sSLSocket;
    }
}

