/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.stats.metrics;

import com.nuodb.impl.stats.metrics.MetricUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MonitorCpp {
    static Set<String> absCounters = new HashSet<String>();
    static Set<String> percentCounters = new HashSet<String>();
    static Set<String> stringIdentifiers = new HashSet<String>();
    static Set<String> msCounters = new HashSet<String>();
    static Set<String> gauges = new HashSet<String>();
    static final int MONITOR_COUNT = 1;
    static final int MONITOR_MILLISECONDS = 2;
    static final int MONITOR_STATE = 3;
    static final int MONITOR_NUMBER = 4;
    static final int MONITOR_PERCENT = 5;
    static final int MONITOR_IDENTIFIER = 6;
    static final int MONITOR_DELTA = 7;
    static final int LEFT_ALIGN = 1;
    static final int RIGHT_ALIGN = 2;
    public static Item[] items = new Item[]{MonitorCpp.SIMPLE_ITEM("Objects", "Objects", 1), MonitorCpp.SIMPLE_ITEM("PurgedObjects", "Purged Objects", 1), MonitorCpp.SIMPLE_ITEM("ObjectsCreated", "Objs Created", 7), MonitorCpp.SIMPLE_ITEM("ObjectsSaved", "Objs Saved", 7), MonitorCpp.SIMPLE_ITEM("ObjectsImported", "Objs Imported", 7), MonitorCpp.SIMPLE_ITEM("ObjectsExported", "Objs Exported", 7), MonitorCpp.SIMPLE_ITEM("ObjectsLoaded", "Objs Loaded", 7), MonitorCpp.SIMPLE_ITEM("ObjectsReloaded", "Objs Reloaded", 7), MonitorCpp.SIMPLE_ITEM("ObjectsPurged", "Objs Purged", 7), MonitorCpp.SIMPLE_ITEM("ObjectsDropped", "Objs Dropped", 7), MonitorCpp.SIMPLE_ITEM("ObjectsDroppedPurged", "Purged Objs Dropped", 7), MonitorCpp.SIMPLE_ITEM("ObjectsDeleted", "Objs Deleted", 7), MonitorCpp.SIMPLE_ITEM("ObjectsRequested", "Objs Requested", 7), MonitorCpp.SIMPLE_ITEM("ObjectsBounced", "Objs Bounced", 7), MonitorCpp.SIMPLE_ITEM("Commits", "Commits", 7), MonitorCpp.SIMPLE_ITEM("Rollbacks", "Rollbacks", 7), MonitorCpp.SIMPLE_ITEM("Inserts", "Inserts", 7), MonitorCpp.SIMPLE_ITEM("Updates", "Updates", 7), MonitorCpp.SIMPLE_ITEM("Deletes", "Deletes", 7), MonitorCpp.COMPLEX_ITEM("Stalls", "Stalls", 2, 7), MonitorCpp.SIMPLE_ITEM("SqlMsgs", "SQL Msgs", 7), MonitorCpp.SIMPLE_ITEM("SqlListenerSqlProcTime", "SQL Processing Time", 2), MonitorCpp.SIMPLE_ITEM("SqlListenerThrottleTime", "SQL Throttle Time", 2), MonitorCpp.SIMPLE_ITEM("SqlListenerIdleTime", "SQL Idle Time", 2), MonitorCpp.SIMPLE_ITEM("SqlListenerIdleTransactionTime", "SQL Idle Transaction Time", 2), MonitorCpp.SIMPLE_ITEM("SqlListenerIdleStatementTime", "SQL Idle Statement Time", 2), MonitorCpp.SIMPLE_ITEM("SqlListenerStallTime", "SQL Stall Time", 2), MonitorCpp.SIMPLE_ITEM("SqlListenerContextSwitches", "SQL Context Switches", 7), MonitorCpp.SIMPLE_ITEM("NodePingTime", "Node Ping Time", 2), MonitorCpp.SIMPLE_ITEM("NodeApplyPingTime", "Node Apply Ping Time", 2), MonitorCpp.SIMPLE_ITEM("NodePostMethodTime", "Node Post Time", 2), MonitorCpp.ST_COUNT_ITEM("IdManagerBlockingStallCount", "Id Manager Blocking Stalls", 7), MonitorCpp.ST_COUNT_ITEM("IdManagerNonBlockingStallCount", "Id Manager Non Blocking Stalls", 7), MonitorCpp.ST_COUNT_ITEM("PendingUpdateStallCount", "Pending Update Stalls", 7), MonitorCpp.ST_COUNT_ITEM("PlatformCatalogStallCount", "Platform Catalog Sync Fingerprints Stalls", 7), MonitorCpp.SIMPLE_ITEM("PlatformObjectCheckOpenTime", "Platform Object Check Open Time", 2), MonitorCpp.SIMPLE_ITEM("PlatformObjectCheckPopulatedTime", "Platform Object Check Populated Time", 2), MonitorCpp.SIMPLE_ITEM("PlatformObjectCheckCompleteTime", "Platform Object Check Complete Time", 2), MonitorCpp.SIMPLE_ITEM("PlatformObjectCheckChairmanAcknowledgedTime", "Platform Object Check Chairman Acknowledged Time", 2), MonitorCpp.SIMPLE_ITEM("TableIndexBuildManagerFailoverWaitTime", "Table Index Failover Wait Time", 2), MonitorCpp.SIMPLE_ITEM("TableIndexBuildManagerDeltaWaitTime", "Table Index Delta Request Wait Time", 2), MonitorCpp.SIMPLE_ITEM("TableIndexBuildManagerWaitTime", "Table Index Remote Build Wait Time", 2), MonitorCpp.SIMPLE_ITEM("PlatformIndexCheckAcknowledgedTime", "Platform Index Check Acknowledged Time", 2), MonitorCpp.SIMPLE_ITEM("CoordinatedBroadcastWaitTime", "Coordinated Broadcast Wait Time", 2), MonitorCpp.COMPLEX_ITEM("StallPointWaitTime", "Stall Point Wait Time", 2, 2), MonitorCpp.COMPLEX_ITEM("SyncPointWaitTime", "Sync Point Wait Time", 2, 2), MonitorCpp.SIMPLE_ITEM("TransactionBlockedTime", "Transaction Blocked Time", 2), MonitorCpp.ST_TIME_ITEM("PendingInsertWaitTime", "Pending Insert Wait Time", 2), MonitorCpp.ST_TIME_ITEM("PendingUpdateWaitTime", "Pending Update Wait Time", 2), MonitorCpp.SIMPLE_ITEM("MessagesReceived", "Msg Recvd", 7), MonitorCpp.SIMPLE_ITEM("ReplicationMessagesReceived", "Replic Msg Recvd", 7), MonitorCpp.SIMPLE_ITEM("MessagesSent", "Msg Sent", 7), MonitorCpp.SIMPLE_ITEM("PacketsReceived", "Pckt Recvd", 7), MonitorCpp.SIMPLE_ITEM("PacketsSent", "Pckets Sent", 7), MonitorCpp.SIMPLE_ITEM("AdminReceived", "Admin Recvd", 7), MonitorCpp.SIMPLE_ITEM("AdminSent", "Admin Sent", 7), MonitorCpp.SIMPLE_ITEM("ClientReceived", "Client Recvd", 7), MonitorCpp.SIMPLE_ITEM("ClientSent", "Client Sent", 7), MonitorCpp.SIMPLE_ITEM("ServerReceived", "Srvr Recvd", 7), MonitorCpp.SIMPLE_ITEM("ServerSent", "Srvr Sent", 7), MonitorCpp.SIMPLE_ITEM("BytesReceived", "Bytes Recvd", 7), MonitorCpp.SIMPLE_ITEM("BytesSent", "Bytes Sent", 7), MonitorCpp.SIMPLE_ITEM("BytesBuffered", "Bytes Buffered", 7), MonitorCpp.SIMPLE_ITEM("DiskWritten", "Dsk Writes", 1), MonitorCpp.SIMPLE_ITEM("DiskReadGeneral", "Dsk Reads (excluding HotCopy)", 1), MonitorCpp.SIMPLE_ITEM("DiskReadHotCopy", "Dsk Reads for HotCopy", 1), MonitorCpp.SIMPLE_ITEM("HeapAllocated", "Bytes allocated", 4), MonitorCpp.SIMPLE_ITEM("HeapActive", "Total charge of allocator", 4), MonitorCpp.SIMPLE_ITEM("HeapMapped", "Allocator reserve size", 4), MonitorCpp.SIMPLE_ITEM("HeapResident", "Total charge of allocator with overhead", 4), MonitorCpp.SIMPLE_ITEM("Memory", "Memory", 4), MonitorCpp.SIMPLE_ITEM("PageFaults", "Hard Page Faults", 1), MonitorCpp.SIMPLE_ITEM("PageFaultsMinor", "Soft Page Faults", 1), MonitorCpp.SIMPLE_ITEM("ArchiveQueue", "Arch Queue", 1), MonitorCpp.SIMPLE_ITEM("LogMsgs", "Log Msgs", 1), MonitorCpp.SIMPLE_ITEM("JrnlWrites", "Jrl Wrts", 1), MonitorCpp.SIMPLE_ITEM("JrnlBytes", "Jrl Bytes", 1), MonitorCpp.SIMPLE_ITEM("JournalQueue", "Journal Queue", 1), MonitorCpp.SIMPLE_ITEM("RefactorTXQueueTime", "Time spent managing tx queue", 2), MonitorCpp.SIMPLE_ITEM("NodeSocketBufferWriteTime", "Time spent in writing in inter-node socket writes", 2), MonitorCpp.SIMPLE_ITEM("BroadcastTime", "Time spent in broadcasting messages", 2), MonitorCpp.SIMPLE_ITEM("NonChairSplitTime", "Non-chair split time", 2), MonitorCpp.ST_TIME_ITEM("WaitForSplitTime", "Index insert wait for split time", 2), MonitorCpp.SIMPLE_ITEM("NumSplits", "Index splits performed", 7), MonitorCpp.SIMPLE_ITEM("ArchiveBufferedBytes", "Archive Buffered Bytes", 7), MonitorCpp.COMPLEX_ITEM("Time", "Time at end of monitor period", 2, 2), MonitorCpp.COMPLEX_ITEM("Milliseconds", "Elapsed", 2, 2), MonitorCpp.COMPLEX_ITEM("UserMilliseconds", "User Mode", 2, 2), MonitorCpp.COMPLEX_ITEM("KernelMilliseconds", "System", 2, 2), MonitorCpp.COMPLEX_ITEM("NumberCores", "Cores", 2, 4), MonitorCpp.COMPLEX_ITEM("Hostname", "Host", 1, 6), MonitorCpp.COMPLEX_ITEM("NodeType", "Node Type", 1, 6), MonitorCpp.COMPLEX_ITEM("NodeState", "State", 1, 6), MonitorCpp.COMPLEX_ITEM("ArchiveDirectory", "Archive", 1, 6), MonitorCpp.COMPLEX_ITEM("PercentUserTime", "% User", 2, 5), MonitorCpp.COMPLEX_ITEM("PercentSystemTime", "% System", 2, 5), MonitorCpp.COMPLEX_ITEM("PercentCpuTime", "% CPU", 2, 5), MonitorCpp.COMPLEX_ITEM("EffectiveVersion", "Eff Vers", 2, 4), MonitorCpp.COMPLEX_ITEM("ActualVersion", "Act Vers", 2, 4), MonitorCpp.COMPLEX_ITEM("ProcessId", "PID", 2, 4), MonitorCpp.COMPLEX_ITEM("NodeId", "Node", 2, 4), MonitorCpp.COMPLEX_ITEM("ClientCncts", "Client Cncts", 2, 4), MonitorCpp.COMPLEX_ITEM("CurrentCommittedTransactions", "Comm Trans", 2, 4), MonitorCpp.COMPLEX_ITEM("CurrentActiveTransactions", "Active Trans", 2, 4), MonitorCpp.COMPLEX_ITEM("CurrentPurgedTransactions", "Purged Trans", 2, 4), MonitorCpp.COMPLEX_ITEM("OldestActiveTransaction", "Oldest Active", 2, 4), MonitorCpp.COMPLEX_ITEM("OldestCommittedTransaction", "Oldest Committed", 2, 4), MonitorCpp.SIMPLE_ITEM("SnapshotAlbumsClosed", "Number of snapshot albums closed", 7), MonitorCpp.SIMPLE_ITEM("SnapshotAlbumsClosedForGC", "Number of snapshot albums closed to allow expunging of old record versions", 7), MonitorCpp.COMPLEX_ITEM("SnapshotAlbumTime", "Time a snapshot album was open", 2, 4), MonitorCpp.COMPLEX_ITEM("SnapshotAlbumSize", "Number of snapshots in a snapshot album", 2, 4), MonitorCpp.COMPLEX_ITEM("SendQueueSize", "Number of messages in send queue", 2, 4), MonitorCpp.COMPLEX_ITEM("SocketBufferBytes", "Size of all socket send buffers", 2, 4), MonitorCpp.COMPLEX_ITEM("ReconciliationQueueSize", "Messages in reconciliation queue", 2, 4), MonitorCpp.SIMPLE_ITEM("RemoteCommitTime", "Time spent waiting for remote commit to finish", 2), MonitorCpp.SIMPLE_ITEM("IdleTime", "Time when no threads were active", 2), MonitorCpp.SIMPLE_ITEM("ActiveTime", "Time spent in all active threads", 2), MonitorCpp.SIMPLE_ITEM("ClientThreadBacklog", "Time waiting to allocate a client thread", 2), MonitorCpp.SIMPLE_ITEM("AtomProcessingThreadBacklog", "Time waiting to allocate an atom processing thread", 2), MonitorCpp.SIMPLE_ITEM("HTTPProcessingThreadBacklog", "Time waiting to allocate an HTTP storage thread", 2), MonitorCpp.SIMPLE_ITEM("ArchiveReadTime", "Time spent in archive read", 2), MonitorCpp.SIMPLE_ITEM("ArchiveWriteTime", "Time spent in archive write", 2), MonitorCpp.SIMPLE_ITEM("ArchiveFsyncTime", "Time spent finishing archive writes", 2), MonitorCpp.SIMPLE_ITEM("ArchiveDirectoryTime", "Time spent in archive directory operations", 2), MonitorCpp.SIMPLE_ITEM("JournalReadTime", "Time spent in journal read", 2), MonitorCpp.SIMPLE_ITEM("JournalWriteTime", "Time spent in journal write", 2), MonitorCpp.SIMPLE_ITEM("JournalFsyncTime", "Time spent finishing journal writes", 2), MonitorCpp.SIMPLE_ITEM("JournalDirectoryTime", "Time spent in journal directory operations", 2), MonitorCpp.SIMPLE_ITEM("BackupReadTime", "Time spent in backup (hot copy) read", 2), MonitorCpp.SIMPLE_ITEM("BackupWriteTime", "Time spent in backup (hot copy) write", 2), MonitorCpp.SIMPLE_ITEM("BackupFsyncTime", "Time spent finishing backup (hot copy) writes", 2), MonitorCpp.SIMPLE_ITEM("BackupDirectoryTime", "Time spent in backup (hot copy) directory operations", 2), MonitorCpp.SIMPLE_ITEM("SpillFileReadTime", "Time spent in spill file read", 2), MonitorCpp.SIMPLE_ITEM("SpillFileWriteTime", "Time spent in spill file write", 2), MonitorCpp.SIMPLE_ITEM("SpillFileDirectoryTime", "Time spent in spill file directory operations", 2), MonitorCpp.SIMPLE_ITEM("MiscellaneousReadTime", "Time spent in Miscellaneous read", 2), MonitorCpp.SIMPLE_ITEM("MiscellaneousWriteTime", "Time spent in Miscellaneous write", 2), MonitorCpp.SIMPLE_ITEM("MiscellaneousDirectoryTime", "Time spent in Miscellaneous directory operations", 2), MonitorCpp.SIMPLE_ITEM("LoadObjectTime", "Time spent loading objects from archive", 2), MonitorCpp.SIMPLE_ITEM("ArchiveSyncThrottleTime", "Time in archive synchronization throttle", 2), MonitorCpp.SIMPLE_ITEM("MemoryThrottleTime", "Time in heap memory throttle", 2), MonitorCpp.SIMPLE_ITEM("PruneAtomsThrottleTime", "Time pruning throttled for sake of SM", 2), MonitorCpp.SIMPLE_ITEM("ArchiveBandwidthThrottleTime", "Time in archive I/O throttle", 2), MonitorCpp.SIMPLE_ITEM("JournalBandwidthThrottleTime", "Time in journal I/O throttle", 2), MonitorCpp.SIMPLE_ITEM("OutgoingMessageThrottleTime", "Time in outgoing message throttle", 2), MonitorCpp.COMPLEX_ITEM("OutgoingMessageActiveTime", "Time with outgoing messages to send", 2, 2), MonitorCpp.SIMPLE_ITEM("CreatePlatformRecordsTime", "Time waiting for creation of Records atom", 2), MonitorCpp.SIMPLE_ITEM("PendingEventsCommitTime", "Time waiting for commit event processing", 2), MonitorCpp.COMPLEX_ITEM("DependentCommitWaits", "Number of commits waiting for dependencies to become visible first", 2, 4), MonitorCpp.COMPLEX_ITEM("ObjectFootprint", "Estimated memory per object", 2, 4), MonitorCpp.COMPLEX_ITEM("WriteLoadLevel", "Objects per second over maximum sustainable rate", 2, 4), MonitorCpp.SIMPLE_ITEM("WriteThrottleTime", "Time writes waiting to let SM catch up", 2), MonitorCpp.SIMPLE_ITEM("LocalCommitOrderTime", "Time spent putting local commit in order", 2), MonitorCpp.SIMPLE_ITEM("CheckCompleteOptimized", "Number of times we were able to make use of an optimized check complete", 7), MonitorCpp.SIMPLE_ITEM("CheckCompleteFull", "Number of times we did a full check complete", 7), MonitorCpp.SIMPLE_ITEM("ChairmanMigration", "Number of times this node resigned as an atom chairman", 7), MonitorCpp.SIMPLE_ITEM("CycleTime", "Time spent in epoch manager", 2), MonitorCpp.SIMPLE_ITEM("RecordsGCTime", "Time spent in records GC", 2), MonitorCpp.COMPLEX_ITEM("JournalAge", "Milliseconds from journal write to journal reap", 2, 4), MonitorCpp.COMPLEX_ITEM("JournalCheckpointAge", "Milliseconds since last journal checkpoint", 2, 4), MonitorCpp.COMPLEX_ITEM("JournalSize", "Bytes of unreaped journal files", 2, 4), MonitorCpp.SIMPLE_ITEM("PendingMessages", "The number of outstanding pending messages", 1), MonitorCpp.SIMPLE_ITEM("ArchiveReadQueueLow", "The number of low priority atom load requests", 1), MonitorCpp.SIMPLE_ITEM("ArchiveReadQueueMedium", "The number of medium priority atom load requests", 1), MonitorCpp.SIMPLE_ITEM("ArchiveReadQueueHigh", "The number of high priority atom load requests", 1), MonitorCpp.SIMPLE_ITEM("MutationsArchivedMasterCatalog", "Mutations of master catalog atom archived", 1), MonitorCpp.SIMPLE_ITEM("MutationsArchivedTransactionManager", "Mutations of transaction manager atom archived", 1), MonitorCpp.SIMPLE_ITEM("MutationsArchivedTable", "Mutations of table atoms archived", 1), MonitorCpp.SIMPLE_ITEM("MutationsArchivedRecords", "Mutations of records atoms archived", 1), MonitorCpp.SIMPLE_ITEM("MutationsArchivedData", "Mutations of data atoms archived", 1), MonitorCpp.SIMPLE_ITEM("MutationsArchivedIndex", "Mutations of index atoms archived", 1), MonitorCpp.SIMPLE_ITEM("MutationsArchivedDatabase", "Mutations of database atom archived", 1), MonitorCpp.SIMPLE_ITEM("MutationsArchivedSchema", "Mutations of schema atoms archived", 1), MonitorCpp.SIMPLE_ITEM("MutationsArchivedCatalog", "Mutations of catalog atoms archived", 1), MonitorCpp.SIMPLE_ITEM("MutationsArchivedBlobs", "Mutations of blobs atoms archived", 1), MonitorCpp.SIMPLE_ITEM("MutationsArchivedSequence", "Mutations of id atoms archived", 1), MonitorCpp.COMPLEX_ITEM("MutationsArchived", "Total mutations archived", 2, 4), MonitorCpp.SIMPLE_ITEM("TransactionDependencyRemoteMin", "Time to resolve transaction dependency min us", 4), MonitorCpp.SIMPLE_ITEM("TransactionDependencyRemoteMax", "Time to resolve transaction dependency max us", 4), MonitorCpp.SIMPLE_ITEM("TransactionDependencyRemoteMean", "Time to resolve transaction dependency mean us", 4), MonitorCpp.COMPLEX_ITEM("SyncCurrentStorageGroup", "The ID of the storage group currently being synced", 2, 4), MonitorCpp.COMPLEX_ITEM("SyncCurrentTableMigration", "The Object ID of the table being synced due to table migration", 2, 4), MonitorCpp.SIMPLE_ITEM("SyncTotalCatalogs", "Total catalogs to be synced", 1), MonitorCpp.SIMPLE_ITEM("SyncCatalogsStarted", "Catalogs whose sync has been started", 1), MonitorCpp.SIMPLE_ITEM("SyncTotalAtoms", "Total atoms in catalogs whose sync has been started", 1), MonitorCpp.SIMPLE_ITEM("SyncAtomsUpToDate", "Up to date atoms in catalogs whose sync has been started", 7), MonitorCpp.SIMPLE_ITEM("SyncAtomsCopied", "Atoms copied to archive by sync", 7), MonitorCpp.SIMPLE_ITEM("SyncAtomBytesCopied", "Size of atoms copied to archive by sync", 7), MonitorCpp.SIMPLE_ITEM("FailoverMessageFlushTime", "Time to ensure message application during failover", 2), MonitorCpp.SIMPLE_ITEM("FailoverTime", "Time to run failover", 2)};
    static Map<String, MetricUtils.Type> schema = new HashMap<String, MetricUtils.Type>();

    static boolean isDeclaredAsCounter(String metric) {
        return !gauges.contains(metric);
    }

    static Item SIMPLE_ITEM(String name, String header, int units) {
        return new Item(name, header, Types.SIMPLE_BUCKET, 2, units);
    }

    static Item ST_COUNT_ITEM(String name, String header, int units) {
        return new Item(name, header, Types.SYNCTRACE_COUNT, 2, units);
    }

    static Item ST_TIME_ITEM(String name, String header, int units) {
        return new Item(name, header, Types.SYNCTRACE_TIME, 2, units);
    }

    static Item COMPLEX_ITEM(String name, String header, int alignment, int units) {
        return new Item(name, header, Types._COMPLEX, alignment, units);
    }

    static MetricUtils.Type toType(int unit) {
        if (unit == 1 || unit == 4) {
            return MetricUtils.Type.count;
        }
        if (unit == 2) {
            return MetricUtils.Type.msec;
        }
        if (unit == 3 || unit == 6) {
            return MetricUtils.Type.identifier;
        }
        if (unit == 5) {
            return MetricUtils.Type.percent;
        }
        if (unit == 7) {
            return MetricUtils.Type.delta;
        }
        throw new IllegalStateException("unknown unit type " + unit);
    }

    static {
        for (Item item : items) {
            schema.put(item.name, MonitorCpp.toType(item.units));
            if (item.units == 1 || item.units == 4) {
                absCounters.add(item.name);
                continue;
            }
            if (item.units == 5) {
                percentCounters.add(item.name);
                continue;
            }
            if (item.units == 7) {
                gauges.add(item.name);
                continue;
            }
            if (item.units == 2) {
                msCounters.add(item.name);
                continue;
            }
            if (item.units == 6) {
                stringIdentifiers.add(item.name);
                continue;
            }
            System.err.println(String.format("Stat [%s]: unknown unit type [%d]", item.name, item.units));
        }
    }

    static class Item {
        final String name;
        final String header;
        final Types type;
        final int alignment;
        final int units;

        public Item(String name, String header, Types type, int alignment, int units) {
            this.name = name;
            this.header = header;
            this.type = type;
            this.alignment = alignment;
            this.units = units;
        }
    }

    public static enum Types {
        SIMPLE_BUCKET,
        SCALED_BUCKET,
        SYNCTRACE_COUNT,
        SYNCTRACE_TIME,
        _COMPLEX;

    }
}

