/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class InnerClassesInfo {
    private int u2innerClassInfoIndex;
    private int u2outerClassInfoIndex;
    private int u2innerNameIndex;
    private int u2innerClassAccessFlags;

    public static InnerClassesInfo create(DataInput din) throws IOException {
        InnerClassesInfo ici = new InnerClassesInfo();
        ici.read(din);
        return ici;
    }

    public int getModifiers() {
        int mods = 0;
        if ((this.u2innerClassAccessFlags & 1) == 1) {
            mods |= 1;
        }
        if ((this.u2innerClassAccessFlags & 2) == 2) {
            mods |= 2;
        }
        if ((this.u2innerClassAccessFlags & 4) == 4) {
            mods |= 4;
        }
        if ((this.u2innerClassAccessFlags & 8) == 8) {
            mods |= 8;
        }
        if ((this.u2innerClassAccessFlags & 0x10) == 16) {
            mods |= 0x10;
        }
        if ((this.u2innerClassAccessFlags & 0x200) == 512) {
            mods |= 0x200;
        }
        if ((this.u2innerClassAccessFlags & 0x400) == 1024) {
            mods |= 0x400;
        }
        return mods;
    }

    private InnerClassesInfo() {
    }

    protected int getInnerClassIndex() {
        return this.u2innerClassInfoIndex;
    }

    protected int getInnerNameIndex() {
        return this.u2innerNameIndex;
    }

    protected void setInnerNameIndex(int index) {
        this.u2innerNameIndex = index;
    }

    protected void markUtf8Refs(ConstantPool pool) {
        if (this.u2innerNameIndex != 0) {
            pool.incRefCount(this.u2innerNameIndex);
        }
    }

    private void read(DataInput din) throws IOException {
        this.u2innerClassInfoIndex = din.readUnsignedShort();
        this.u2outerClassInfoIndex = din.readUnsignedShort();
        this.u2innerNameIndex = din.readUnsignedShort();
        this.u2innerClassAccessFlags = din.readUnsignedShort();
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeShort(this.u2innerClassInfoIndex);
        dout.writeShort(this.u2outerClassInfoIndex);
        dout.writeShort(this.u2innerNameIndex);
        dout.writeShort(this.u2innerClassAccessFlags);
    }
}

