/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.resultset;

import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.IStream;
import java.io.IOException;
import java.io.Reader;

public class CharacterStream
extends Reader
implements IStream {
    private IResultSet m_result = null;
    private int m_column = 0;
    private int m_resultSetOffset = 0;
    private boolean m_hasMoreData = true;
    private int m_stringOffset = 0;
    private String m_stringBuffer = "";
    private int m_bufferSize = 0;
    private DataWrapper m_data = new DataWrapper();

    public CharacterStream(IResultSet result, int column, int bufferSize) {
        this.m_result = result;
        this.m_column = column;
        this.m_bufferSize = bufferSize;
    }

    @Override
    public void close() throws IOException {
        this.m_result = null;
        this.m_stringBuffer = null;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (null == cbuf) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_INVALID_BUFFER.name());
        }
        if (0 > off || off != 0 && cbuf.length <= off) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_INVALID_OFFSET.name(), new String[]{String.valueOf(off), String.valueOf(cbuf.length)});
        }
        int numCharsRead = 0;
        int numCharsToRead = Math.min(cbuf.length - off, len);
        do {
            if (this.m_stringOffset >= this.m_stringBuffer.length() && !this.fetchMoreData()) {
                if (numCharsRead == 0) {
                    return -1;
                }
                return numCharsRead;
            }
            cbuf[numCharsRead++ + off] = this.m_stringBuffer.charAt(this.m_stringOffset++);
        } while (numCharsRead < numCharsToRead);
        return numCharsRead;
    }

    private boolean fetchMoreData() throws InputOutputException {
        if (!this.m_hasMoreData) {
            return false;
        }
        try {
            this.m_hasMoreData = this.m_result.getData(this.m_column, this.m_resultSetOffset, this.m_bufferSize, this.m_data);
            this.m_stringOffset = 0;
            this.m_stringBuffer = (String)this.m_data.getObject();
            this.m_resultSetOffset += this.m_stringBuffer.length() * 2;
        }
        catch (Exception e) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_READ_ERROR.name());
        }
        return 0 != this.m_stringBuffer.length();
    }
}

