-- Copyright (c) DbVis Software AB. All Rights Reserved.
-- NOTE: This script will not load in QueryBuilder due to the '1=1' syntax in the JOIN conditions
SELECT
    "CU"."CUSTOMER_ID"                               AS "ID",
    CONCAT("CU"."FIRST_NAME", ' ', "CU"."LAST_NAME") AS "NAME",
    "A"."ADDRESS"                                    AS "ADDRESS",
    "A"."POSTAL_CODE"                                AS "ZIP CODE",
    "A"."PHONE"                                      AS "PHONE",
    "CITY"."CITY"                                    AS "CITY",
    "COUNTRY"."COUNTRY"                              AS "COUNTRY",
    CASE "CU"."ACTIVE" 
        WHEN TRUE 
        THEN 'active' 
        ELSE '' 
    END             AS "NOTES",
    "CU"."STORE_ID" AS "SID"
FROM 
    "SAKILA"."CUSTOMER" "CU"
INNER JOIN 
    "SAKILA"."ADDRESS" "A"
ON 
    1=1
INNER JOIN 
    "SAKILA"."CITY"
ON 
    1=1
INNER JOIN 
    "SAKILA"."COUNTRY"
ON 
    1=1
WHERE 
    ( 
        "CITY"."COUNTRY_ID" = "COUNTRY"."COUNTRY_ID")
AND 
    ( 
        ( 
            "A"."CITY_ID" = "CITY"."CITY_ID")
    AND 
        ( 
            "CU"."ADDRESS_ID" = "A"."ADDRESS_ID"));