/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.filters.IFilter;
import com.vertica.dsi.dataengine.impl.DSISimpleResultSet;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IMetadataSource;
import com.vertica.dsi.dataengine.interfaces.IMetadataSourceExt;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataColumn;
import com.vertica.dsi.dataengine.utilities.MetadataColumnFactory;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.dataengine.utilities.OrderType;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.support.Pair;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DSIMetadataResultSet
extends DSISimpleResultSet {
    protected ILogger m_logger;
    private IMetadataSource m_metadataSource;
    private List<IFilter> m_filters;
    protected List<MetadataColumn> m_columns;
    protected List<MetadataSourceColumnTag> m_sortOrder;
    private boolean m_performFiltering = true;
    protected List<MetadataRow> m_rows = null;
    private int m_currentRowIndex = -1;
    protected final OrderType m_orderType;
    protected final boolean m_isODBC2;

    public DSIMetadataResultSet(IStatement statement, MetadataSourceID metadataSourceId, IMetadataSource metadataSource, List<IFilter> filters, OrderType orderType) throws ErrorException {
        this(statement, metadataSourceId, metadataSource, filters, orderType, false);
    }

    public DSIMetadataResultSet(IStatement statement, MetadataSourceID metadataSourceId, IMetadataSource metadataSource, List<IFilter> filters, OrderType orderType, boolean isODBC2) throws ErrorException {
        LogUtilities.logFunctionEntrance(statement.getLog(), new Object[]{statement, metadataSourceId, metadataSource, filters});
        assert (null != metadataSource);
        this.m_logger = statement.getLog();
        this.m_filters = filters;
        this.m_metadataSource = metadataSource;
        this.m_orderType = orderType;
        this.m_isODBC2 = isODBC2;
        this.m_columns = MetadataColumnFactory.createMetadataColumns(statement, metadataSourceId);
        this.m_sortOrder = MetadataColumnFactory.getSortOrder(statement.getLog(), metadataSourceId, filters, orderType);
        try {
            Variant filterVar = DSIDriverSingleton.getInstance().getProperty(22);
            this.m_performFiltering = 1L == filterVar.getLong();
        }
        catch (Exception e) {
            LogUtilities.logError(e, this.m_logger);
        }
        if (this.m_performFiltering && this.m_metadataSource instanceof IMetadataSourceExt) {
            ((IMetadataSourceExt)this.m_metadataSource).passdownFilters(this.m_filters);
        }
        if (OrderType.NONE != orderType) {
            try {
                this.sortData();
            }
            catch (ErrorException e) {
                throw e;
            }
            catch (Exception e) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.SORTING_ERROR.name(), (Throwable)e);
            }
        } else {
            this.initializeRows();
        }
    }

    protected DSIMetadataResultSet(IStatement statement, MetadataSourceID metadataSourceId, List<IFilter> filters, OrderType orderType) throws ErrorException {
        this(statement, metadataSourceId, filters, orderType, false);
    }

    protected DSIMetadataResultSet(IStatement statement, MetadataSourceID metadataSourceId, List<IFilter> filters, OrderType orderType, boolean isODBC2) throws ErrorException {
        LogUtilities.logFunctionEntrance(statement.getLog(), new Object[]{statement, metadataSourceId, filters});
        this.m_logger = statement.getLog();
        this.m_filters = filters;
        this.m_orderType = orderType;
        this.m_isODBC2 = isODBC2;
        this.m_columns = MetadataColumnFactory.createMetadataColumns(statement, metadataSourceId);
        this.m_sortOrder = MetadataColumnFactory.getSortOrder(statement.getLog(), metadataSourceId, filters, orderType);
        try {
            Variant filterVar = DSIDriverSingleton.getInstance().getProperty(22);
            this.m_performFiltering = 1L == filterVar.getLong();
        }
        catch (Exception e) {
            LogUtilities.logError(e, this.m_logger);
        }
    }

    @Override
    public boolean getData(int column, long offset, long maxSize, DataWrapper retrievedData) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, column, offset, maxSize, retrievedData);
        DataWrapper dw = (DataWrapper)this.m_rows.get(this.m_currentRowIndex).m_rowData.get(column);
        try {
            if (null != dw.getObject()) {
                retrievedData.setData(dw.getType(), dw.getObject());
            } else {
                retrievedData.setNull(dw.getType());
            }
        }
        catch (IncorrectTypeException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_MISMATCH.name(), new String[]{String.valueOf(dw.getType()), dw.getObject().getClass().getName()});
        }
        return false;
    }

    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return -1L;
    }

    @Override
    public ArrayList<? extends IColumn> getSelectColumns() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return (ArrayList)this.m_columns;
    }

    public List<MetadataSourceColumnTag> getSortOrder() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_sortOrder;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentRowIndex < this.m_rows.size() - 1;
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return false;
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_metadataSource) {
            this.m_metadataSource.closeCursor();
        }
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return ++this.m_currentRowIndex < this.m_rows.size();
    }

    protected boolean getUnsortedData(int column, long offset, long maxSize, DataWrapper retrievedData) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, column, offset, maxSize, retrievedData);
        if (column >= this.m_columns.size()) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), String.valueOf(column), ExceptionType.DATA);
        }
        if (this.m_columns.get(column).isNullColumn()) {
            retrievedData.setNull(this.m_columns.get(column).getTypeMetadata().getType());
            return false;
        }
        MetadataSourceColumnTag columnTag = this.m_columns.get(column).getColumnTag();
        boolean result = this.m_metadataSource.getMetadata(columnTag, offset, maxSize, retrievedData);
        if (this.m_isODBC2 && MetadataSourceColumnTag.DATA_TYPE == columnTag) {
            int type = 0;
            try {
                type = retrievedData.getSmallInt();
            }
            catch (IncorrectTypeException e) {
                // empty catch block
            }
            switch (type) {
                case 91: {
                    retrievedData.setSmallInt(9);
                    break;
                }
                case 92: {
                    retrievedData.setSmallInt(10);
                    break;
                }
                case 93: {
                    retrievedData.setSmallInt(11);
                }
            }
        }
        return result;
    }

    protected void initializeRows() throws ErrorException {
        Pair[] sortIndex = new Pair[this.m_sortOrder.size()];
        for (int i = 0; i < this.m_sortOrder.size(); ++i) {
            for (int j = 0; j < this.m_columns.size(); ++j) {
                MetadataSourceColumnTag currentColTag = this.m_columns.get(j).getColumnTag();
                if (currentColTag != this.m_sortOrder.get(i)) continue;
                sortIndex[i] = new Pair<Integer, MetadataSourceColumnTag>(j, currentColTag);
            }
        }
        if (null == this.m_rows) {
            this.m_rows = new ArrayList<MetadataRow>();
        }
        while (this.moveToNextUnsortedRow()) {
            ArrayList<DataWrapper> rowData = new ArrayList<DataWrapper>(this.m_columns.size());
            for (int i = 0; i < this.m_columns.size(); ++i) {
                DataWrapper data = new DataWrapper();
                try {
                    this.getUnsortedData(i, 0L, -1L, data);
                }
                catch (ErrorException e) {
                    if (this.m_columns.get(i).getColumnTag() == MetadataSourceColumnTag.USER_DATA_TYPE) {
                        LogUtilities.logError(e, this.m_logger);
                        data.setNull(5);
                    }
                    throw e;
                }
                rowData.add(data);
            }
            this.m_rows.add(new MetadataRow(sortIndex, rowData, this.m_orderType));
        }
    }

    protected boolean moveToNextUnsortedRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_performFiltering) {
            return this.m_metadataSource.moveToNextRow();
        }
        while (this.m_metadataSource.moveToNextRow()) {
            if (!this.checkRow()) continue;
            return true;
        }
        return false;
    }

    protected void sortData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.initializeRows();
        Collections.sort(this.m_rows);
    }

    private boolean checkRow() throws ErrorException {
        DataWrapper wrapper = new DataWrapper();
        for (IFilter filter : this.m_filters) {
            this.m_metadataSource.getMetadata(filter.getColumnTag(), 0L, -1L, wrapper);
            if (filter.filter(wrapper)) continue;
            return false;
        }
        return true;
    }

    protected static class MetadataRow
    implements Comparable<MetadataRow> {
        private final Pair<Integer, MetadataSourceColumnTag>[] m_columnsSortIndex;
        private final List<DataWrapper> m_rowData;
        private final OrderType m_orderType;

        public MetadataRow(Pair<Integer, MetadataSourceColumnTag>[] columnsSortIndex, List<DataWrapper> rowData, OrderType orderType) {
            this.m_columnsSortIndex = columnsSortIndex;
            this.m_rowData = rowData;
            this.m_orderType = orderType;
        }

        @Override
        public int compareTo(MetadataRow comp) {
            for (Pair<Integer, MetadataSourceColumnTag> currentIndex : this.m_columnsSortIndex) {
                DataWrapper otherData = comp.m_rowData.get(currentIndex.key());
                DataWrapper data = this.m_rowData.get(currentIndex.key());
                if (otherData.getType() != data.getType()) {
                    throw new ClassCastException("Unable to compare rows. Data type mismatch.");
                }
                int order = this.doCompareTo(data, otherData, currentIndex.value());
                if (0 == order) continue;
                return order;
            }
            return 0;
        }

        private int doCompareTo(DataWrapper data, DataWrapper otherData, MetadataSourceColumnTag currentSortIndex) {
            try {
                boolean isOtherDataNull;
                boolean isDataNull = null == data.getObject();
                boolean bl = isOtherDataNull = null == otherData.getObject();
                if (isDataNull || isOtherDataNull) {
                    if (isDataNull && isOtherDataNull) {
                        return 0;
                    }
                    if (isDataNull) {
                        return -1;
                    }
                    return 1;
                }
                if (currentSortIndex == MetadataSourceColumnTag.PROCEDURE_COLUMN_TYPE) {
                    return this.compareProcedureColumnType(data.getSmallInt(), otherData.getSmallInt());
                }
                if (TypeUtilities.isIntegerType(data.getType())) {
                    if (data.getType() == -5) {
                        BigInteger dataValue = data.getBigInt();
                        BigInteger otherDataValue = data.getBigInt();
                        if (currentSortIndex == MetadataSourceColumnTag.DATA_TYPE && OrderType.ODBC != this.m_orderType) {
                            dataValue = BigInteger.valueOf(TypeUtilities.mapDataTypes(dataValue.intValue()));
                            otherDataValue = BigInteger.valueOf(TypeUtilities.mapDataTypes(otherDataValue.intValue()));
                        }
                        return dataValue.compareTo(otherDataValue);
                    }
                    Long dataValue = this.getIntegerValue(data);
                    Long otherDataValue = this.getIntegerValue(otherData);
                    if (currentSortIndex == MetadataSourceColumnTag.DATA_TYPE && OrderType.ODBC != this.m_orderType) {
                        dataValue = TypeUtilities.mapDataTypes(dataValue.intValue());
                        otherDataValue = TypeUtilities.mapDataTypes(otherDataValue.intValue());
                    }
                    return dataValue.compareTo(otherDataValue);
                }
                if (TypeUtilities.isBooleanType(data.getType())) {
                    if (data.getBoolean() != otherData.getBoolean()) {
                        return data.getBoolean() != false ? 1 : -1;
                    }
                    return 0;
                }
                return this.getStringValue(data).compareTo(this.getStringValue(otherData));
            }
            catch (IncorrectTypeException e) {
                throw new ClassCastException(e.getMessage());
            }
        }

        private int compareProcedureColumnType(int data, int otherData) {
            int key1 = MetadataRow.getProcedureColumnTypeComparisonKey(data);
            int key2 = MetadataRow.getProcedureColumnTypeComparisonKey(otherData);
            return key1 - key2;
        }

        private static int getProcedureColumnTypeComparisonKey(int columnType) {
            if (5 == columnType) {
                return 0;
            }
            if (1 == columnType || 2 == columnType || 4 == columnType) {
                return 1;
            }
            if (3 == columnType) {
                return 2;
            }
            assert (0 == columnType) : "Unknown column type " + columnType;
            return 3;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (DataWrapper currentData : this.m_rowData) {
                if (null != currentData.getObject()) {
                    sb.append(currentData.getObject().toString());
                } else {
                    sb.append("null");
                }
                sb.append("-");
            }
            return sb.toString();
        }

        private Long getIntegerValue(DataWrapper data) throws IncorrectTypeException {
            int dataType = data.getType();
            if (-6 == dataType) {
                return (long)data.getTinyInt();
            }
            if (5 == dataType) {
                return (long)data.getSmallInt();
            }
            if (4 == dataType) {
                return data.getInteger();
            }
            return null;
        }

        private String getStringValue(DataWrapper data) throws IncorrectTypeException {
            switch (data.getType()) {
                case -8: 
                case 1: {
                    return data.getChar();
                }
                case -9: 
                case 12: {
                    return data.getVarChar();
                }
                case -10: 
                case -1: {
                    return data.getLongVarChar();
                }
            }
            return null;
        }
    }
}

