/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.core;

import com.google.common.graph.Network;
import com.yworks.util.graph.Edge;
import com.yworks.util.graph.Node;
import java.util.HashMap;
import java.util.Map;

public class Dfs {
    private Map<Object, Object> edgeVisit;
    private int dfsNum;
    private int compNum;
    private boolean directedMode = false;
    protected Map<Object, Object> stateMap;
    protected static Object WHITE = null;
    protected static Object GRAY = new Object();
    protected static Object BLACK = new Object();
    private byte[] nextState = new byte[1];

    public void setDirectedMode(boolean directed) {
        this.directedMode = directed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Network<Node, Edge> network, Node start) {
        if (null == start) {
            return;
        }
        this.stateMap = new HashMap<Object, Object>();
        if (!this.directedMode) {
            this.edgeVisit = new HashMap<Object, Object>();
        }
        this.dfsNum = 0;
        this.compNum = 0;
        int stackSize = Math.min(60, network.nodes().size() + 3);
        Stack stack = new Stack(stackSize);
        try {
            this.workStack(stack, start);
        }
        finally {
            this.stateMap.clear();
            if (!this.directedMode) {
                this.edgeVisit.clear();
            }
        }
    }

    private Edge nextEdge(Node currentNode, Edge currentEdge, byte[] currentMode) {
        switch (currentMode[0]) {
            case 0: {
                if (this.directedMode) {
                    currentMode[0] = 1;
                    return currentNode.firstOutEdge();
                }
                Edge edge = currentNode.firstOutEdge();
                if (edge == null) {
                    edge = currentNode.firstInEdge();
                    currentMode[0] = 3;
                } else {
                    currentMode[0] = 2;
                }
                return edge;
            }
            case 1: {
                return currentEdge.nextOutEdge();
            }
            case 2: {
                Edge edge = currentEdge.nextOutEdge();
                if (edge == null) {
                    edge = currentNode.firstInEdge();
                    currentMode[0] = 3;
                }
                return edge;
            }
            case 3: {
                return currentEdge.nextInEdge();
            }
        }
        throw new InternalError();
    }

    private Edge doNextEdge(Node currentNode, Edge currentEdge, byte[] currentMode) {
        Edge edge = this.nextEdge(currentNode, currentEdge, currentMode);
        while (edge != null && !this.doTraverse(edge)) {
            edge = this.nextEdge(currentNode, edge, currentMode);
        }
        return edge;
    }

    private void workStack(Stack stack, Node start) {
        this.nextState[0] = 0;
        Node currentNode = start;
        this.stateMap.put(currentNode, GRAY);
        this.preVisit(currentNode, ++this.dfsNum);
        Edge nextEdge = this.doNextEdge(currentNode, null, this.nextState);
        stack.pushState(currentNode, nextEdge, this.nextState[0], this.dfsNum);
        while (!stack.isEmpty()) {
            Edge edge = stack.peekCurrentEdge();
            this.nextState[0] = stack.peekIteratorState();
            while (edge != null) {
                if (this.directedMode || !((Boolean)this.edgeVisit.get(edge)).booleanValue()) {
                    Node other;
                    if (!this.directedMode) {
                        this.edgeVisit.put(edge, true);
                        other = edge.opposite(currentNode);
                    } else {
                        other = edge.target();
                    }
                    if (this.stateMap.get(other) == null) {
                        this.preTraverse(edge, other, true);
                        this.stateMap.put(other, GRAY);
                        currentNode = other;
                        this.preVisit(currentNode, ++this.dfsNum);
                        this.nextState[0] = 0;
                        edge = this.doNextEdge(currentNode, null, this.nextState);
                        stack.pushState(currentNode, edge, this.nextState[0], this.dfsNum);
                        continue;
                    }
                    this.preTraverse(edge, other, false);
                    edge = this.doNextEdge(currentNode, edge, this.nextState);
                    stack.updateTop(edge, this.nextState[0]);
                    continue;
                }
                edge = this.doNextEdge(currentNode, edge, this.nextState);
                stack.updateTop(edge, this.nextState[0]);
            }
            this.postVisit(currentNode, stack.peekLocalDfsNum(), ++this.compNum);
            this.stateMap.put(currentNode, BLACK);
            stack.pop();
            if (stack.isEmpty()) continue;
            Edge currentEdge = stack.peekCurrentEdge();
            this.postTraverse(currentEdge, currentNode);
            currentNode = stack.peekNode();
            this.nextState[0] = stack.peekIteratorState();
            Edge nextEdge2 = this.doNextEdge(currentNode, currentEdge, this.nextState);
            stack.updateTop(nextEdge2, this.nextState[0]);
        }
    }

    protected void preVisit(Node node, int dfsNumber) {
    }

    protected void postVisit(Node node, int dfsNumber, int compNumber) {
    }

    protected boolean preTraverse(Edge edge, Node node, boolean treeEdge) {
        return true;
    }

    protected void postTraverse(Edge edge, Node node) {
    }

    protected boolean doTraverse(Edge e) {
        return true;
    }

    static class Stack {
        int stackIndex = -1;
        byte[] iteratorStates;
        Edge[] currentEdges;
        int[] localDfsNums;
        Node[] nodes;

        Stack(int initialSize) {
            this.localDfsNums = new int[initialSize];
            this.currentEdges = new Edge[initialSize];
            this.iteratorStates = new byte[initialSize];
            this.nodes = new Node[initialSize];
        }

        boolean isEmpty() {
            return this.stackIndex < 0;
        }

        void pop() {
            --this.stackIndex;
        }

        Node peekNode() {
            return this.nodes[this.stackIndex];
        }

        Edge peekCurrentEdge() {
            return this.currentEdges[this.stackIndex];
        }

        byte peekIteratorState() {
            return this.iteratorStates[this.stackIndex];
        }

        int peekLocalDfsNum() {
            return this.localDfsNums[this.stackIndex];
        }

        int pushState(Node node, Edge currentEdge, byte iterastorState, int localDfsNum) {
            ++this.stackIndex;
            if (this.stackIndex == this.nodes.length) {
                int newSize = (this.stackIndex + 1) * 2;
                Node[] newStack = new Node[newSize];
                System.arraycopy(this.nodes, 0, newStack, 0, this.nodes.length);
                this.nodes = newStack;
                Edge[] newEStack = new Edge[newSize];
                System.arraycopy(this.currentEdges, 0, newEStack, 0, this.currentEdges.length);
                this.currentEdges = newEStack;
                int[] newDStack = new int[newSize];
                System.arraycopy(this.localDfsNums, 0, newDStack, 0, this.localDfsNums.length);
                this.localDfsNums = newDStack;
                byte[] newStateStack = new byte[newSize];
                System.arraycopy(this.iteratorStates, 0, newStateStack, 0, this.iteratorStates.length);
                this.iteratorStates = newStateStack;
            }
            this.nodes[this.stackIndex] = node;
            this.currentEdges[this.stackIndex] = currentEdge;
            this.iteratorStates[this.stackIndex] = iterastorState;
            this.localDfsNums[this.stackIndex] = localDfsNum;
            return this.localDfsNums[this.stackIndex];
        }

        void updateTop(Edge currentEdge, byte iteratorState) {
            this.currentEdges[this.stackIndex] = currentEdge;
            this.iteratorStates[this.stackIndex] = iteratorState;
        }
    }
}

