/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard;

import com.yworks.util.CollectionFilter;
import com.yworks.util.ant.ZipScannerTool;
import com.yworks.yguard.Conversion;
import com.yworks.yguard.ObfuscationListener;
import com.yworks.yguard.ParseException;
import com.yworks.yguard.StringReplacer;
import com.yworks.yguard.YShrinkInvoker;
import com.yworks.yguard.YShrinkModel;
import com.yworks.yguard.ant.AttributesSection;
import com.yworks.yguard.ant.ClassSection;
import com.yworks.yguard.ant.ExposeSection;
import com.yworks.yguard.ant.FieldSection;
import com.yworks.yguard.ant.MapParser;
import com.yworks.yguard.ant.Mappable;
import com.yworks.yguard.ant.MethodSection;
import com.yworks.yguard.ant.PackageSection;
import com.yworks.yguard.common.ShrinkBag;
import com.yworks.yguard.common.ant.EntryPointsSection;
import com.yworks.yguard.common.ant.Exclude;
import com.yworks.yguard.common.ant.InOutPair;
import com.yworks.yguard.common.ant.TypePatternSet;
import com.yworks.yguard.common.ant.YGuardBaseTask;
import com.yworks.yguard.obf.Cl;
import com.yworks.yguard.obf.ClassTree;
import com.yworks.yguard.obf.Filter;
import com.yworks.yguard.obf.GuardDB;
import com.yworks.yguard.obf.LineNumberTableMapper;
import com.yworks.yguard.obf.NameMaker;
import com.yworks.yguard.obf.NameMakerFactory;
import com.yworks.yguard.obf.NoSuchMappingException;
import com.yworks.yguard.obf.ResourceHandler;
import com.yworks.yguard.obf.Version;
import com.yworks.yguard.obf.YGuardRule;
import com.yworks.yguard.obf.classfile.LineNumberInfo;
import com.yworks.yguard.obf.classfile.LineNumberTableAttrInfo;
import com.yworks.yguard.obf.classfile.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ObfuscatorTask
extends YGuardBaseTask {
    private String mainClass;
    private boolean conserveManifest = false;
    private File logFile = new File("yguardlog.xml");
    private ExposeSection expose = null;
    private List adjustSections = new ArrayList();
    private MapSection map = null;
    private PatchSection patch = null;
    private boolean doShrink = false;
    private EntryPointsSection entryPoints = null;
    private File shrinkLog = null;
    private boolean useExposeAsEntryPoints = true;
    private static final String LOG_TITLE_PRE_VERSION = "  yGuard Bytecode Obfuscator, v";
    private static final String LOG_TITLE_POST_VERSION = ", a Product of yWorks GmbH - http://www.yworks.com";
    private static final String LOG_CREATED = "  Logfile created on ";
    private static final String LOG_INPUT_FILE = "  Jar file to be obfuscated:           ";
    private static final String LOG_OUTPUT_FILE = "  Target Jar file for obfuscated code: ";
    private static final String NO_SHRINKING_SUPPORT = "No shrinking support found.";
    private static final String DEPRECATED = "The obfuscate task is deprecated. Please use the new com.yworks.yguard.YGuardTask instead.";
    private boolean replaceClassNameStrings = true;
    private File[] tempJars;
    private boolean needYShrinkModel;
    private YShrinkModel yShrinkModel;
    private String annotationClass;

    public ObfuscatorTask() {
    }

    public ObfuscatorTask(boolean mode) {
        super(mode);
    }

    private static String toNativePattern(String pattern) {
        if (pattern.endsWith(".class")) {
            return pattern;
        }
        if (pattern.endsWith("**")) {
            return pattern.replace('.', '/') + "/*.class";
        }
        if (pattern.endsWith("*")) {
            return pattern.replace('.', '/') + ".class";
        }
        if (pattern.endsWith(".")) {
            return pattern.replace('.', '/') + "**/*.class";
        }
        return pattern.replace('.', '/') + ".class";
    }

    public static String[] toNativePattern(String[] patterns) {
        if (patterns == null) {
            return new String[0];
        }
        String[] res = new String[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            res[i] = ObfuscatorTask.toNativePattern(patterns[i]);
        }
        return res;
    }

    public static final String toNativeClass(String className) {
        return className.replace('.', '/');
    }

    public static final String[] toNativeMethod(String javaMethod) {
        StringTokenizer tokenizer = new StringTokenizer(javaMethod, "(,[]) ", true);
        String tmp = tokenizer.nextToken();
        while (tmp.trim().length() == 0) {
            tmp = tokenizer.nextToken();
        }
        String returnType = tmp;
        tmp = tokenizer.nextToken();
        int retarraydim = 0;
        while (tmp.equals("[")) {
            tmp = tokenizer.nextToken();
            if (!tmp.equals("]")) {
                throw new IllegalArgumentException("']' expected but found " + tmp);
            }
            ++retarraydim;
            tmp = tokenizer.nextToken();
        }
        if (tmp.trim().length() != 0) {
            throw new IllegalArgumentException("space expected but found " + tmp);
        }
        tmp = tokenizer.nextToken();
        while (tmp.trim().length() == 0) {
            tmp = tokenizer.nextToken();
        }
        String name = tmp;
        StringBuffer nativeMethod = new StringBuffer(30);
        nativeMethod.append('(');
        tmp = tokenizer.nextToken();
        while (tmp.trim().length() == 0) {
            tmp = tokenizer.nextToken();
        }
        if (!tmp.equals("(")) {
            throw new IllegalArgumentException("'(' expected but found " + tmp);
        }
        tmp = tokenizer.nextToken();
        while (!tmp.equals(")")) {
            while (tmp.trim().length() == 0) {
                tmp = tokenizer.nextToken();
            }
            String type = tmp;
            tmp = tokenizer.nextToken();
            while (tmp.trim().length() == 0) {
                tmp = tokenizer.nextToken();
            }
            int arraydim = 0;
            while (tmp.equals("[")) {
                tmp = tokenizer.nextToken();
                if (!tmp.equals("]")) {
                    throw new IllegalArgumentException("']' expected but found " + tmp);
                }
                ++arraydim;
                tmp = tokenizer.nextToken();
            }
            while (tmp.trim().length() == 0) {
                tmp = tokenizer.nextToken();
            }
            nativeMethod.append(ObfuscatorTask.toNativeType(type, arraydim));
            if (!tmp.equals(",")) continue;
            tmp = tokenizer.nextToken();
            while (tmp.trim().length() == 0) {
                tmp = tokenizer.nextToken();
            }
        }
        nativeMethod.append(')');
        nativeMethod.append(ObfuscatorTask.toNativeType(returnType, retarraydim));
        String[] result = new String[]{name, nativeMethod.toString()};
        return result;
    }

    private static final String toNativeType(String type, int arraydim) {
        StringBuffer nat = new StringBuffer(30);
        for (int i = 0; i < arraydim; ++i) {
            nat.append('[');
        }
        if ("byte".equals(type)) {
            nat.append('B');
        } else if ("char".equals(type)) {
            nat.append('C');
        } else if ("double".equals(type)) {
            nat.append('D');
        } else if ("float".equals(type)) {
            nat.append('F');
        } else if ("int".equals(type)) {
            nat.append('I');
        } else if ("long".equals(type)) {
            nat.append('J');
        } else if ("short".equals(type)) {
            nat.append('S');
        } else if ("boolean".equals(type)) {
            nat.append('Z');
        } else if ("void".equals(type)) {
            nat.append('V');
        } else {
            nat.append('L');
            nat.append(type.replace('.', '/'));
            nat.append(';');
        }
        return nat.toString();
    }

    public void setNeedYShrinkModel(boolean b) {
        this.needYShrinkModel = b;
    }

    public ExposeSection createExpose() {
        if (this.expose != null) {
            throw new IllegalArgumentException("Only one expose element allowed!");
        }
        this.expose = new ExposeSection(this);
        return this.expose;
    }

    public void addExcludes(EntryPointsSection entryPoints) {
        if (null == this.expose) {
            this.createExpose();
        }
    }

    @Override
    public Exclude createKeep() {
        return this.createExpose();
    }

    @Override
    public void addAttributesSections(List<com.yworks.yguard.common.ant.AttributesSection> attributesSections) {
        if (null != this.expose) {
            List attributes = this.expose.getAttributes();
            for (com.yworks.yguard.common.ant.AttributesSection attributesSection : attributesSections) {
                AttributesSection asYGuard = new AttributesSection(this);
                PatternSet patternSet = attributesSection.getPatternSet(TypePatternSet.Type.NAME);
                if (patternSet != null) {
                    asYGuard.addConfiguredPatternSet(patternSet);
                }
                asYGuard.setName(attributesSection.getAttributesStr());
                attributes.add(asYGuard);
            }
        }
    }

    public AdjustSection createAdjust() {
        AdjustSection adjust = new AdjustSection();
        adjust.setProject(this.getProject());
        this.adjustSections.add(adjust);
        return adjust;
    }

    public void addConfiguredExpose(ExposeSection ex) {
        if (this.expose != null) {
            throw new IllegalArgumentException("Only one expose element allowed!");
        }
        this.expose = ex;
    }

    public EntryPointsSection createEntryPoints() {
        return new EntryPointsSection(this);
    }

    public void addConfiguredEntryPoints(EntryPointsSection eps) {
        if (this.entryPoints != null) {
            throw new IllegalArgumentException("Only one entrypoints element allowed!");
        }
        this.entryPoints = eps;
    }

    public MapSection createMap() {
        if (this.map != null) {
            throw new IllegalArgumentException("Only one map element allowed!");
        }
        this.map = new MapSection();
        return this.map;
    }

    public void addConfiguredMap(MapSection map) {
        if (this.map != null) {
            throw new IllegalArgumentException("Only one map element allowed!");
        }
        this.map = map;
    }

    public PatchSection createPatch() {
        if (this.patch != null) {
            throw new IllegalArgumentException("Only one patch element allowed!");
        }
        this.patch = new PatchSection();
        return this.patch;
    }

    public void addConfiguredPatch(PatchSection patch) {
        if (this.patch != null) {
            throw new IllegalArgumentException("Only one patch element allowed!");
        }
        this.patch = patch;
    }

    public void setLogFile(File file) {
        this.logFile = file;
    }

    public void setConserveManifest(boolean c) {
        this.conserveManifest = c;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void execute() throws BuildException {
        String ed;
        this.getProject().log((Task)this, "yGuard Obfuscator v" + Version.getVersion() + " - http://www.yworks.com/products/yguard", 2);
        if (!this.mode) {
            this.getProject().log((Task)this, DEPRECATED, 1);
        }
        TaskLogger taskLogger = new TaskLogger();
        if (this.mode) {
            this.doShrink = false;
        }
        if (this.doShrink) {
            this.doShrink();
        }
        ResourceCpResolver resolver = null;
        if (this.resourceClassPath != null) {
            resolver = new ResourceCpResolver(this.resourceClassPath, this);
            Cl.setClassResolver(resolver);
        }
        YGuardNameFactory nameFactory = null;
        if (this.properties.containsKey("naming-scheme") || this.properties.containsKey("language-conformity") || this.properties.containsKey("overload-enabled")) {
            String ns = (String)this.properties.get("naming-scheme");
            String lc = (String)this.properties.get("language-conformity");
            int ilc = 0;
            int ins = 4;
            if ("compatible".equalsIgnoreCase(lc)) {
                ilc = 1;
            } else if ("illegal".equalsIgnoreCase(lc)) {
                ilc = 2;
            }
            if ("mix".equalsIgnoreCase(ns)) {
                ins = 12;
            }
            if ("best".equalsIgnoreCase(ns)) {
                ins = 8;
            }
            nameFactory = new YGuardNameFactory(ilc | ins);
            nameFactory.setPackagePrefix((String)this.properties.get("obfuscation-prefix"));
        } else {
            nameFactory = new YGuardNameFactory(4);
            nameFactory.setPackagePrefix((String)this.properties.get("obfuscation-prefix"));
        }
        if (this.properties.containsKey("overload-enabled")) {
            String overload = (String)this.properties.get("overload-enabled");
            boolean overloadEnabled = true;
            if ("false".equalsIgnoreCase(overload) || "no".equalsIgnoreCase("overload")) {
                overloadEnabled = false;
            }
            nameFactory.setOverloadEnabled(overloadEnabled);
        }
        boolean pedantic = false;
        if (this.properties.containsKey("error-checking") && "pedantic".equalsIgnoreCase(ed = (String)this.properties.get("error-checking"))) {
            pedantic = true;
        }
        this.getProject().log((Task)this, "Using NameMakerFactory: " + NameMakerFactory.getInstance(), 3);
        if (this.pairs == null) {
            throw new BuildException("No in out pairs specified!");
        }
        ArrayList<File> inFilesList = new ArrayList<File>(this.pairs.size());
        File[] inFiles = new File[this.pairs.size()];
        File[] outFiles = new File[this.pairs.size()];
        for (int i = 0; i < this.pairs.size(); ++i) {
            InOutPair pair = (InOutPair)this.pairs.get(i);
            if (pair.getIn() == null || !pair.getIn().isFile() || !pair.getIn().canRead()) {
                throw new BuildException("Cannot open inoutpair.in " + pair.getIn());
            }
            inFiles[i] = pair.getIn();
            inFilesList.add(pair.getIn());
            if (pair.getOut() == null) {
                throw new BuildException("Must specify inoutpair.out!");
            }
            outFiles[i] = pair.getOut();
        }
        PrintWriter log = null;
        if (this.logFile != null) {
            try {
                log = this.logFile.getName().endsWith(".gz") ? new PrintWriter(new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(this.logFile))))) : new PrintWriter(new BufferedWriter(new FileWriter(this.logFile)));
                taskLogger.setWriter(log);
            }
            catch (IOException ioe) {
                this.getProject().log((Task)this, "Could not create logfile: " + ioe, 0);
                log = new PrintWriter(System.out);
            }
        } else {
            log = new PrintWriter(System.out);
        }
        this.writeLogHeader(log, inFiles, outFiles);
        try {
            ArrayList<YGuardRule> rules = null;
            rules = this.expose != null ? this.expose.createEntries(inFilesList) : new ArrayList<YGuardRule>(20);
            if (this.mainClass != null) {
                String cn = ObfuscatorTask.toNativeClass(this.mainClass);
                rules.add(new YGuardRule(1, cn));
                rules.add(new YGuardRule(3, cn + "/main", "([Ljava/lang/String;)V"));
            }
            if (this.map != null) {
                Collection mapEntries = this.map.createEntries(this.getProject(), log);
                rules.addAll(mapEntries);
            }
            for (AdjustSection as : this.adjustSections) {
                as.createEntries(inFilesList);
            }
            if (this.properties.containsKey("expose-attributes")) {
                StringTokenizer st = new StringTokenizer((String)this.properties.get("expose-attributes"), ",", false);
                while (st.hasMoreTokens()) {
                    String attribute = st.nextToken().trim();
                    rules.add(new YGuardRule(0, attribute));
                    this.getProject().log((Task)this, "Exposing attribute '" + attribute + "'", 3);
                }
            }
            try {
                LogListener listener = new LogListener(this.getProject());
                ClassFileFilter filter = null;
                if (this.patch != null) {
                    this.getProject().log((Task)this, "Patching...", 2);
                    Collection patchfiles = this.patch.createEntries(inFilesList);
                    HashSet<String> names = new HashSet<String>();
                    for (YGuardRule entry : patchfiles) {
                        if (entry.type != 1) continue;
                        names.add(entry.name + ".class");
                    }
                    filter = new ClassFileFilter(new CollectionFilter(names));
                }
                GuardDB db = new GuardDB(inFiles);
                if (this.properties.containsKey("digests")) {
                    String digests = (String)this.properties.get("digests");
                    if (digests.trim().equalsIgnoreCase("none")) {
                        db.setDigests(new String[0]);
                    } else {
                        db.setDigests(digests.split("\\s*,\\s*"));
                    }
                }
                if (this.annotationClass != null) {
                    db.setAnnotationClass(ObfuscatorTask.toNativeClass(this.annotationClass));
                }
                db.setResourceHandler(new ResourceAdjuster(db));
                db.setPedantic(pedantic);
                db.setReplaceClassNameStrings(this.replaceClassNameStrings);
                db.addListener(listener);
                db.retain(rules, log);
                db.remapTo(outFiles, filter, log, this.conserveManifest);
                Iterator it = rules.iterator();
                while (it.hasNext()) {
                    ((YGuardRule)it.next()).logProperties(log);
                }
                db.close();
                Cl.setClassResolver(null);
                if (this.doShrink) {
                    for (int i = 0; i < this.tempJars.length; ++i) {
                        if (null == this.tempJars[i]) continue;
                        this.tempJars[i].delete();
                    }
                }
                if (!Logger.getInstance().isAllResolved()) {
                    Logger.getInstance().warning("Not all dependencies could be resolved. Please see the logfile for details.");
                }
            }
            catch (NoSuchMappingException nsm) {
                throw new BuildException("yGuard was unable to determine the mapped name for " + nsm.getKey() + ".\n Probably broken code. Try recompiling from source!", (Throwable)nsm);
            }
            catch (ClassNotFoundException cnfe) {
                throw new BuildException("yGuard was unable to resolve a class (" + cnfe + ").\n Probably a missing external dependency.", (Throwable)cnfe);
            }
            catch (IOException ioe) {
                if (ioe.getMessage() != null) {
                    this.getProject().log((Task)this, ioe.getMessage(), 0);
                }
                throw new BuildException("yGuard encountered an IO problem!", (Throwable)ioe);
            }
            catch (ParseException pe) {
                throw new BuildException("yGuard encountered problems during parsing!", (Throwable)pe);
            }
            catch (RuntimeException rte) {
                if (rte.getMessage() != null) {
                    this.getProject().log((Task)this, rte.getMessage(), 0);
                }
                rte.printStackTrace();
                throw new BuildException("yGuard encountered an unknown problem!", (Throwable)rte);
            }
            finally {
                this.writeLogFooter(log);
                log.flush();
                log.close();
            }
        }
        catch (IOException ioe) {
            throw new BuildException("yGuard encountered an IO problem!", (Throwable)ioe);
        }
        finally {
            try {
                if (resolver != null) {
                    resolver.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void doShrink() {
        ShrinkBag pair;
        int i;
        YShrinkInvoker yShrinkInvoker = null;
        try {
            yShrinkInvoker = (YShrinkInvoker)Class.forName("com.yworks.yguard.yshrink.YShrinkInvokerImpl").newInstance();
        }
        catch (InstantiationException e) {
            throw new BuildException(NO_SHRINKING_SUPPORT, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException(NO_SHRINKING_SUPPORT, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException(NO_SHRINKING_SUPPORT, (Throwable)e);
        }
        if (null == yShrinkInvoker) {
            return;
        }
        yShrinkInvoker.setContext(this);
        this.tempJars = new File[this.pairs.size()];
        File[] outJars = new File[this.pairs.size()];
        for (i = 0; i < this.tempJars.length; ++i) {
            try {
                this.tempJars[i] = File.createTempFile("tempJar_", "_shrinked.jar", new File(((InOutPair)this.pairs.get(i)).getOut().getParent()));
            }
            catch (IOException e) {
                this.getProject().log("Could not create tempfile for shrinking " + this.tempJars[i] + ".", 0);
                this.tempJars[i] = null;
            }
            if (null == this.tempJars[i]) continue;
            System.out.println("temp-jar: " + this.tempJars[i]);
            pair = (ShrinkBag)this.pairs.get(i);
            outJars[i] = pair.getOut();
            pair.setOut(this.tempJars[i]);
            yShrinkInvoker.addPair(pair);
        }
        yShrinkInvoker.setResourceClassPath(this.resourceClassPath);
        if (this.shrinkLog != null) {
            yShrinkInvoker.setLogFile(this.shrinkLog);
        }
        if (null != this.entryPoints) {
            yShrinkInvoker.setEntyPoints(this.entryPoints);
        }
        if (null != this.expose && this.useExposeAsEntryPoints) {
            for (ClassSection cs : this.expose.getClasses()) {
                yShrinkInvoker.addClassSection(cs);
            }
            for (MethodSection ms : this.expose.getMethods()) {
                yShrinkInvoker.addMethodSection(ms);
            }
            for (FieldSection fs : this.expose.getFields()) {
                yShrinkInvoker.addFieldSection(fs);
            }
        }
        yShrinkInvoker.execute();
        for (i = 0; i < this.tempJars.length; ++i) {
            if (null == this.tempJars[i]) continue;
            pair = (InOutPair)this.pairs.get(i);
            ((InOutPair)pair).setIn(this.tempJars[i]);
            ((InOutPair)pair).setOut(outJars[i]);
        }
    }

    public void addInheritanceEntries(Collection entries) throws IOException {
        if (!this.needYShrinkModel || this.expose == null) {
            return;
        }
        this.yShrinkModel = null;
        try {
            this.yShrinkModel = (YShrinkModel)Class.forName("com.yworks.yguard.yshrink.YShrinkModelImpl").newInstance();
        }
        catch (InstantiationException e) {
            throw new BuildException(NO_SHRINKING_SUPPORT, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException(NO_SHRINKING_SUPPORT, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException(NO_SHRINKING_SUPPORT, (Throwable)e);
        }
        if (null == this.yShrinkModel) {
            return;
        }
        if (this.resourceClassPath != null) {
            this.yShrinkModel.setResourceClassPath(this.resourceClassPath, this);
        }
        this.yShrinkModel.createSimpleModel(this.pairs);
        for (String className : this.yShrinkModel.getAllClassNames()) {
            Set<String> allAncestorClasses = this.yShrinkModel.getAllAncestorClasses(className);
            Set<String> allInterfaces = this.yShrinkModel.getAllImplementedInterfaces(className);
            for (ClassSection cs : this.expose.getClasses()) {
                if (null != cs.getExtends()) {
                    String extendsName = cs.getExtends();
                    if (extendsName.equals(className)) {
                        cs.addEntries(entries, className);
                    } else if (allAncestorClasses.contains(extendsName)) {
                        cs.addEntries(entries, className);
                    }
                }
                if (null == cs.getImplements()) continue;
                String interfaceName = cs.getImplements();
                if (interfaceName.equals(className)) {
                    cs.addEntries(entries, className);
                    continue;
                }
                if (!allInterfaces.contains(interfaceName)) continue;
                cs.addEntries(entries, className);
            }
        }
    }

    public void setShrink(boolean doShrink) {
        if (this.mode) {
            throw new BuildException("The shrink attribute is not supported when the obfuscate task is nested inside a yguard task.\n Use a separate nested shrink task instead.");
        }
        this.doShrink = doShrink;
    }

    public void setShrinkLog(File shrinkLog) {
        this.shrinkLog = shrinkLog;
    }

    public void setUseExposeAsEntryPoints(boolean useExposeAsEntryPoints) {
        this.useExposeAsEntryPoints = useExposeAsEntryPoints;
    }

    private void writeLogHeader(PrintWriter log, File[] inFile, File[] outFile) {
        log.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        log.println("<yguard version=\"1.5\">");
        log.println("<!--");
        log.println(LOG_TITLE_PRE_VERSION + Version.getVersion() + LOG_TITLE_POST_VERSION);
        log.println();
        log.println(LOG_CREATED + new Date().toString());
        log.println();
        for (int i = 0; i < inFile.length; ++i) {
            log.println(LOG_INPUT_FILE + inFile[i].getName());
            log.println(LOG_OUTPUT_FILE + outFile[i].getName());
            log.println();
        }
        log.println("-->");
    }

    private void writeLogFooter(PrintWriter log) {
        log.println("</yguard>");
    }

    public void setReplaceClassNameStrings(boolean replaceClassNameStrings) {
        this.replaceClassNameStrings = replaceClassNameStrings;
    }

    public void setScramble(boolean scramble) {
        if (scramble) {
            YGuardNameFactory.scramble();
            com.yworks.yguard.obf.KeywordNameMaker.scramble();
        }
    }

    public static void main(String[] args) {
        new LineNumberScrambler(2000, 234432L);
    }

    public String getAnnotationClass() {
        return this.annotationClass;
    }

    public void setAnnotationClass(String annotationClass) {
        this.annotationClass = annotationClass;
    }

    public static final class LineNumberScrambler {
        private int[] scrambled;
        private int[] unscrambled;

        public LineNumberScrambler(int size, long seed) {
            this.scrambled = new int[size];
            this.unscrambled = new int[size];
            for (int i = 0; i < size; ++i) {
                this.scrambled[i] = i;
                this.unscrambled[i] = i;
            }
            Random r = new Random(seed);
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < size; ++j) {
                    int p2;
                    int otherIndex = r.nextInt(size);
                    if (otherIndex == j) continue;
                    int pos1 = this.scrambled[j];
                    int pos2 = this.scrambled[otherIndex];
                    int p1 = this.unscrambled[pos1];
                    this.unscrambled[pos1] = p2 = this.unscrambled[pos2];
                    this.unscrambled[pos2] = p1;
                    this.scrambled[j] = pos2;
                    this.scrambled[otherIndex] = pos1;
                }
            }
        }

        public int scramble(int i) {
            if (i >= this.scrambled.length) {
                return this.scrambled[i % this.scrambled.length] + i / this.scrambled.length * this.scrambled.length;
            }
            return this.scrambled[i];
        }

        public int unscramble(int i) {
            if (i >= this.scrambled.length) {
                return this.unscrambled[i % this.scrambled.length] + i / this.scrambled.length * this.scrambled.length;
            }
            return this.unscrambled[i];
        }
    }

    public static final class LineNumberSqueezer
    implements LineNumberTableMapper {
        private List squeezedNumbers = new ArrayList();

        @Override
        public boolean mapLineNumberTable(String className, String methodName, String methodSignature, LineNumberTableAttrInfo lineNumberTable) {
            LineNumberInfo[] table = lineNumberTable.getLineNumberTable();
            if (table.length > 0) {
                LineNumberInfo lineNumberInfo = new LineNumberInfo(table[0].getStartPC(), table[0].getLineNumber());
                lineNumberTable.setLineNumberTable(new LineNumberInfo[]{lineNumberInfo});
                this.squeezedNumbers.add(new Object[]{className, methodName, methodSignature, lineNumberInfo});
                return true;
            }
            return false;
        }

        @Override
        public void logProperties(PrintWriter pw) {
            if (!this.squeezedNumbers.isEmpty()) {
                for (Object[] ar : this.squeezedNumbers) {
                    String className = ar[0].toString();
                    String methodName = ar[1].toString();
                    String methodSignature = ar[2].toString();
                    int line = ((LineNumberInfo)ar[3]).getLineNumber();
                    pw.println("<property owner=\"" + ClassTree.toUtf8XmlString(Conversion.toJavaClass(className)) + "#" + ClassTree.toUtf8XmlString(Conversion.toJavaMethod(methodName, methodSignature)) + "\" name=\"squeezed-linenumber\" value=\"" + line + "\"/>");
                }
                this.squeezedNumbers.clear();
            }
        }
    }

    public static final class MyLineNumberTableMapper
    implements LineNumberTableMapper {
        private long salt;
        private LineNumberScrambler last;
        private long lastSeed;
        private Set classNames = new HashSet();

        public MyLineNumberTableMapper(long salt) {
            this.salt = salt;
            this.last = new LineNumberScrambler(3584, this.lastSeed);
        }

        @Override
        public boolean mapLineNumberTable(String className, String methodName, String methodSignature, LineNumberTableAttrInfo lineNumberTable) {
            LineNumberScrambler scrambler;
            String javaClassName = className.replace('/', '.').replace('$', '.');
            this.classNames.add(className.replace('/', '.'));
            long seed = this.salt ^ (long)javaClassName.hashCode();
            if (seed == this.lastSeed) {
                scrambler = this.last;
            } else {
                scrambler = this.last = new LineNumberScrambler(3584, seed);
                this.lastSeed = seed;
            }
            for (int i = 0; i < lineNumberTable.getLineNumberTable().length; ++i) {
                LineNumberInfo lineNumberInfo = lineNumberTable.getLineNumberTable()[i];
                lineNumberInfo.setLineNumber(scrambler.scramble(lineNumberInfo.getLineNumber()));
            }
            return true;
        }

        @Override
        public void logProperties(PrintWriter pw) {
            if (!this.classNames.isEmpty()) {
                Iterator it = this.classNames.iterator();
                while (it.hasNext()) {
                    pw.println("<property owner=\"" + ClassTree.toUtf8XmlString(it.next().toString()) + "\" name=\"scrambling-salt\" value=\"" + Long.toString(this.salt) + "\"/>");
                }
                this.classNames.clear();
            }
        }
    }

    static final class ResourceCpResolver
    implements Cl.ClassResolver {
        Path resource;
        URLClassLoader urlClassLoader;

        ResourceCpResolver(Path resources, Task target) {
            this.resource = resources;
            String[] list = resources.list();
            ArrayList<URL> listUrls = new ArrayList<URL>();
            for (int i = 0; i < list.length; ++i) {
                try {
                    URL url = new File(list[i]).toURL();
                    listUrls.add(url);
                    continue;
                }
                catch (MalformedURLException mfue) {
                    target.getProject().log(target, "Could not resolve resource: " + mfue, 1);
                }
            }
            URL[] urls = new URL[listUrls.size()];
            listUrls.toArray(urls);
            this.urlClassLoader = URLClassLoader.newInstance(urls, ClassLoader.getSystemClassLoader());
        }

        @Override
        public Class resolve(String className) throws ClassNotFoundException {
            try {
                return Class.forName(className, false, this.urlClassLoader);
            }
            catch (NoClassDefFoundError ncdfe) {
                String message = ncdfe.getMessage();
                message = message == null || message.equals(className) ? className : message + "[" + className + "]";
                throw new ClassNotFoundException(message, ncdfe);
            }
            catch (LinkageError le) {
                throw new ClassNotFoundException(className, le);
            }
        }

        @Override
        public void close() throws Exception {
            this.urlClassLoader.close();
        }
    }

    static abstract class AbstractNameMaker
    implements NameMaker {
        Set reservedNames;
        Map countMap = new HashMap();
        String fillChars;
        int minLength;
        private static final String DUMMY = "(com.dummy.Dummy)";
        protected boolean overloadEnabled = true;
        private int counter = 1;

        public boolean isOverloadEnabled() {
            return this.overloadEnabled;
        }

        public void setOverloadEnabled(boolean overloadEnabled) {
            this.overloadEnabled = overloadEnabled;
        }

        AbstractNameMaker(String[] reservedNames) {
            this(reservedNames, "0o", 256);
        }

        AbstractNameMaker(String[] reservedNames, String fillChars, int minLength) {
            this.reservedNames = reservedNames != null && reservedNames.length > 0 ? new HashSet<String>(Arrays.asList(reservedNames)) : Collections.EMPTY_SET;
            this.minLength = minLength;
            this.fillChars = fillChars != null ? fillChars : "0O";
        }

        @Override
        public String nextName(String descriptor) {
            int j;
            if (descriptor == null) {
                descriptor = DUMMY;
            }
            if (this.overloadEnabled) {
                Integer i = (Integer)this.countMap.get(descriptor = descriptor.substring(0, descriptor.lastIndexOf(41)));
                if (i == null) {
                    i = new Integer(1);
                }
                j = i;
            } else {
                j = this.counter;
            }
            String result = null;
            StringBuffer sb = new StringBuffer(this.minLength > 10 ? this.minLength + 20 : 20);
            do {
                sb.setLength(0);
                String name = this.generateName(j);
                sb.append(name);
                if (sb.length() < this.minLength) {
                    while (sb.length() < this.minLength) {
                        sb.append(this.fillChars);
                    }
                    sb.setLength(this.minLength);
                }
                result = sb.toString();
                ++j;
            } while (this.reservedNames.contains(result));
            if (this.overloadEnabled) {
                this.countMap.put(descriptor, new Integer(j));
            } else {
                this.counter = j;
            }
            return result;
        }

        abstract String generateName(int var1);
    }

    static final class PrefixNameMaker
    extends AbstractNameMaker {
        private String prefix;
        private AbstractNameMaker delegate;

        PrefixNameMaker(String prefix, String[] reservedNames, AbstractNameMaker delegate) {
            super(reservedNames, "O0", 1);
            this.prefix = prefix;
            this.delegate = delegate;
        }

        @Override
        String generateName(int i) {
            return this.prefix + this.delegate.generateName(i);
        }
    }

    static final class KeywordNameMaker
    extends AbstractNameMaker {
        static final String[] KEYWORDS = new String[]{"this", "super", "new", "Object", "String", "class", "return", "void", "null", "int", "if", "float", "for", "do", "while", "public", "private", "interface"};
        static final String[] SPACER = new String[]{".", "$", " ", "_"};
        static final String[] NOSPACER = new String[]{""};
        String chars;
        String[] keyWords;
        String[] spacer;

        KeywordNameMaker(String[] reservedNames) {
            this(reservedNames, KEYWORDS, NOSPACER);
        }

        KeywordNameMaker(String[] reservedNames, String[] keyWords, String[] spacer) {
            super(reservedNames, "Oo0", 0);
            this.keyWords = keyWords;
            this.spacer = spacer;
        }

        @Override
        String generateName(int i) {
            StringBuffer sb = new StringBuffer(30);
            int tmp = i;
            int sc = 0;
            while (tmp > 0) {
                sb.append(this.keyWords[tmp % this.keyWords.length]);
                if ((tmp /= this.keyWords.length) <= 0) continue;
                sb.append(this.spacer[sc % this.spacer.length]);
                ++sc;
            }
            return sb.toString();
        }
    }

    static final class LongNameMaker
    extends AbstractNameMaker {
        String chars;
        String firstChars;

        LongNameMaker(String[] reservedNames) {
            this(reservedNames, false, 256);
        }

        LongNameMaker(String[] reservedNames, boolean ascii, int length) {
            this(reservedNames, ascii ? "Oo" : "Oo\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00f4\u00f5\u00f6\u00f8", ascii ? "Oo0" : "0Oo\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00f4\u00f5\u00f6\u00f8", length);
        }

        LongNameMaker(String[] reservedNames, String firstChars, String chars, int minLength) {
            super(reservedNames, null, minLength);
            this.chars = chars;
            if (chars == null || chars.length() < 1) {
                throw new IllegalArgumentException("must specify at least one character!");
            }
            this.firstChars = firstChars;
            if (firstChars != null && firstChars.length() < 1) {
                this.firstChars = null;
            }
        }

        @Override
        String generateName(int i) {
            StringBuffer sb = new StringBuffer(20);
            int tmp = i;
            if (this.firstChars != null) {
                sb.append(this.firstChars.charAt(tmp % this.firstChars.length()));
                tmp = this.firstChars.length() > 1 ? (tmp /= this.firstChars.length()) : --tmp;
            }
            while (tmp > 0) {
                sb.append(this.chars.charAt(tmp % this.chars.length()));
                if (this.chars.length() > 1) {
                    tmp /= this.chars.length();
                    continue;
                }
                --tmp;
            }
            if (this.chars.length() > 1) {
                while (sb.length() < this.minLength) {
                    sb.append(this.chars.charAt(0));
                }
            }
            return sb.toString();
        }
    }

    static class MixNameMaker
    extends AbstractNameMaker {
        List nameMakers = new ArrayList();
        final String prefix;

        MixNameMaker(String prefix, String[] reservedNames, AbstractNameMaker delegate, int count) {
            super(reservedNames, "O0", 1);
            this.add(delegate, count);
            this.prefix = prefix;
        }

        void add(AbstractNameMaker delegate, int count) {
            count = count < 1 ? 1 : count;
            for (int i = 0; i < count; ++i) {
                this.nameMakers.add(delegate);
            }
            Collections.shuffle(this.nameMakers);
        }

        @Override
        String generateName(int i) {
            if (this.prefix != null) {
                return this.prefix + ((AbstractNameMaker)this.nameMakers.get(i % this.nameMakers.size())).generateName(i);
            }
            return ((AbstractNameMaker)this.nameMakers.get(i % this.nameMakers.size())).generateName(i);
        }
    }

    static class CompoundNameMaker
    implements NameMaker {
        private NameMaker nm1;
        private NameMaker nm2;

        CompoundNameMaker(NameMaker nm1, NameMaker nm2) {
            this.nm1 = nm1;
            this.nm2 = nm2;
        }

        @Override
        public String nextName(String descriptor) {
            return this.nm1.nextName(descriptor) + this.nm2.nextName(descriptor);
        }
    }

    private static final class YGuardNameFactory
    extends NameMakerFactory.DefaultNameMakerFactory {
        private static String legalFirstChars;
        private static String legalChars;
        private static String crazylegalFirstChars;
        private static String crazylegalChars;
        private static String asciiFirstChars;
        private static String asciiChars;
        private static String asciiLowerChars;
        private static AtomicBoolean scrambled;
        private String packagePrefix;
        int mode;
        static final int LEGAL = 0;
        static final int COMPATIBLE = 1;
        static final int ILLEGAL = 2;
        static final int SMALL = 4;
        static final int MIX = 12;
        static final int BEST = 8;
        boolean overloadEnabled = true;

        YGuardNameFactory() {
            this(4);
        }

        YGuardNameFactory(int mode) {
            super.setInstance(this);
            this.mode = mode;
        }

        private static void scramble() {
            if (scrambled.compareAndSet(false, true)) {
                asciiChars = YGuardNameFactory.scrambleChars(asciiChars);
                asciiFirstChars = YGuardNameFactory.scrambleChars(asciiFirstChars);
                legalChars = YGuardNameFactory.scrambleChars(legalChars);
                legalFirstChars = YGuardNameFactory.scrambleChars(legalFirstChars);
                crazylegalChars = YGuardNameFactory.scrambleChars(crazylegalChars);
                crazylegalFirstChars = YGuardNameFactory.scrambleChars(crazylegalFirstChars);
            }
        }

        private static String scrambleChars(String string) {
            char[] chars = string.toCharArray();
            Random r = new Random();
            for (int c = 0; c < chars.length; ++c) {
                char random;
                int randomPosition = r.nextInt(chars.length);
                char original = chars[c];
                chars[c] = random = chars[randomPosition];
                chars[randomPosition] = original;
            }
            StringBuilder sb = new StringBuilder();
            for (char c : chars) {
                sb.append(c);
            }
            return sb.toString();
        }

        public boolean isOverloadEnabled() {
            return this.overloadEnabled;
        }

        public void setOverloadEnabled(boolean overloadEnabled) {
            this.overloadEnabled = overloadEnabled;
        }

        void setPackagePrefix(String prefix) {
            this.packagePrefix = prefix;
            if (this.packagePrefix != null) {
                this.packagePrefix = this.packagePrefix.replace('.', '/') + '/';
            }
        }

        @Override
        protected NameMaker createFieldNameMaker(String[] reservedNames, String fqClassName) {
            switch (this.mode) {
                default: {
                    LongNameMaker longNameMaker1 = new LongNameMaker(reservedNames, asciiLowerChars, asciiLowerChars, 1);
                    longNameMaker1.setOverloadEnabled(this.overloadEnabled);
                    return longNameMaker1;
                }
                case 4: {
                    LongNameMaker longNameMaker2 = new LongNameMaker(reservedNames, legalFirstChars, legalChars, 1);
                    longNameMaker2.setOverloadEnabled(this.overloadEnabled);
                    return longNameMaker2;
                }
                case 12: 
                case 13: {
                    MixNameMaker mixNameMaker1;
                    LongNameMaker nm1 = new LongNameMaker(reservedNames, false, 6);
                    KeywordNameMaker nm2 = new KeywordNameMaker(reservedNames);
                    MixNameMaker mnm = mixNameMaker1 = new MixNameMaker(null, reservedNames, nm1, 3);
                    mnm.add(nm2, 1);
                    mnm.setOverloadEnabled(this.overloadEnabled);
                    return mnm;
                }
                case 8: 
                case 9: {
                    LongNameMaker longNameMaker4 = new LongNameMaker(reservedNames, false, 256);
                    KeywordNameMaker keywordNameMaker1 = new KeywordNameMaker(reservedNames);
                    CompoundNameMaker compoundNameMaker1 = new CompoundNameMaker(longNameMaker4, keywordNameMaker1);
                    longNameMaker4.setOverloadEnabled(this.overloadEnabled);
                    keywordNameMaker1.setOverloadEnabled(this.overloadEnabled);
                    return compoundNameMaker1;
                }
                case 6: {
                    LongNameMaker longNameMaker3 = new LongNameMaker(reservedNames, crazylegalFirstChars, crazylegalChars, 1);
                    longNameMaker3.setOverloadEnabled(this.overloadEnabled);
                    return longNameMaker3;
                }
                case 14: {
                    LongNameMaker nm1 = new LongNameMaker(reservedNames, false, 6);
                    KeywordNameMaker nm2 = new KeywordNameMaker(reservedNames, KeywordNameMaker.KEYWORDS, KeywordNameMaker.SPACER);
                    MixNameMaker mixNameMaker2 = new MixNameMaker(null, reservedNames, nm1, 2);
                    mixNameMaker2.add(nm2, 1);
                    mixNameMaker2.setOverloadEnabled(this.overloadEnabled);
                    return mixNameMaker2;
                }
                case 10: 
            }
            KeywordNameMaker nm1 = new KeywordNameMaker(reservedNames, KeywordNameMaker.KEYWORDS, KeywordNameMaker.SPACER);
            LongNameMaker nm2 = new LongNameMaker(reservedNames, false, 256);
            MixNameMaker mnm = new MixNameMaker(null, reservedNames, nm1, 1);
            mnm.add(nm2, 1);
            mnm.setOverloadEnabled(this.overloadEnabled);
            return mnm;
        }

        @Override
        protected NameMaker createMethodNameMaker(String[] reservedNames, String fqClassName) {
            return this.createFieldNameMaker(reservedNames, fqClassName);
        }

        @Override
        protected NameMaker createPackageNameMaker(String[] reservedNames, String packageName) {
            boolean topLevel = packageName.length() < 1;
            switch (this.mode) {
                default: {
                    if (topLevel && this.packagePrefix != null) {
                        return new PrefixNameMaker(this.packagePrefix, reservedNames, new LongNameMaker(null, asciiLowerChars, asciiLowerChars, 1));
                    }
                    return new LongNameMaker(reservedNames, asciiLowerChars, asciiLowerChars, 1);
                }
                case 4: 
                case 6: {
                    if (topLevel && this.packagePrefix != null) {
                        return new PrefixNameMaker(this.packagePrefix, reservedNames, new LongNameMaker(null, asciiFirstChars, asciiChars, 1));
                    }
                    return new LongNameMaker(reservedNames, asciiFirstChars, asciiChars, 1);
                }
                case 12: 
                case 14: {
                    LongNameMaker nm1 = new LongNameMaker(reservedNames, asciiFirstChars, asciiChars, 1);
                    LongNameMaker nm3 = new LongNameMaker(reservedNames, true, 256);
                    LongNameMaker nm4 = new LongNameMaker(reservedNames, true, 4);
                    KeywordNameMaker nm2 = new KeywordNameMaker(reservedNames);
                    MixNameMaker mnm = new MixNameMaker(topLevel ? this.packagePrefix : null, reservedNames, nm1, 8);
                    mnm.add(nm4, 4);
                    mnm.add(nm2, 4);
                    mnm.add(nm3, 1);
                    return mnm;
                }
                case 8: 
                case 10: 
            }
            if (topLevel && this.packagePrefix != null) {
                return new PrefixNameMaker(this.packagePrefix, reservedNames, new LongNameMaker(null, true, 256));
            }
            return new LongNameMaker(reservedNames, true, 256);
        }

        @Override
        protected NameMaker createClassNameMaker(String[] reservedNames, String fqClassName) {
            return this.createPackageNameMaker(reservedNames, fqClassName);
        }

        @Override
        protected NameMaker createInnerClassNameMaker(String[] reservedNames, String fqInnerClassName) {
            switch (this.mode) {
                default: {
                    return new PrefixNameMaker("_", reservedNames, new LongNameMaker(null, asciiLowerChars, asciiLowerChars, 1));
                }
                case 4: {
                    return new PrefixNameMaker("_", reservedNames, new LongNameMaker(null, asciiFirstChars, asciiChars, 1));
                }
                case 12: {
                    return new PrefixNameMaker("_", reservedNames, new LongNameMaker(null, true, 1));
                }
                case 8: {
                    return new PrefixNameMaker("_", reservedNames, new LongNameMaker(null, true, 4));
                }
                case 6: {
                    return new LongNameMaker(reservedNames, asciiFirstChars, asciiChars, 1);
                }
                case 14: {
                    return new LongNameMaker(reservedNames, true, 1);
                }
                case 10: 
            }
            return new LongNameMaker(reservedNames, true, 10);
        }

        @Override
        public String toString() {
            switch (this.mode) {
                default: {
                    return "yGuardNameFactory [naming-scheme: default; language-conformity: default]";
                }
                case 5: {
                    return "yGuardNameFactory [naming-scheme: small; language-conformity: compatible]";
                }
                case 13: {
                    return "yGuardNameFactory [naming-scheme: mix; language-conformity: compatible]";
                }
                case 9: {
                    return "yGuardNameFactory [naming-scheme: best; language-conformity: compatible]";
                }
                case 4: {
                    return "yGuardNameFactory [naming-scheme: small; language-conformity: legal]";
                }
                case 12: {
                    return "yGuardNameFactory [naming-scheme: mix; language-conformity: legal]";
                }
                case 8: {
                    return "yGuardNameFactory [naming-scheme: best; language-conformity: legal]";
                }
                case 6: {
                    return "yGuardNameFactory [naming-scheme: small; language-conformity: illegal]";
                }
                case 14: {
                    return "yGuardNameFactory [naming-scheme: mix; language-conformity: illegal]";
                }
                case 10: 
            }
            return "yGuardNameFactory [naming-scheme: best; language-conformity: illegal]";
        }

        static {
            char i;
            scrambled = new AtomicBoolean(false);
            StringBuffer legalC = new StringBuffer(500);
            StringBuffer illegalC = new StringBuffer(500);
            StringBuffer crazyLegalC = new StringBuffer(500);
            StringBuffer asciiC = new StringBuffer(500);
            StringBuffer asciiLC = new StringBuffer(100);
            StringBuffer asciiUC = new StringBuffer(100);
            BitSet[] bs = null;
            try {
                ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(ObfuscatorTask.class.getResourceAsStream("jdks.bits")));
                bs = (BitSet[])ois.readObject();
                ois.close();
            }
            catch (IOException ioe) {
                throw new InternalError("Could not load valid character bitset!" + ioe.getMessage());
            }
            catch (ClassNotFoundException cnfe) {
                throw new InternalError("Could not load valid character bitset!" + cnfe.getMessage());
            }
            for (i = '\u0000'; i < '\uffff'; i = (char)(i + '\u0001')) {
                if (!bs[0].get(i)) {
                    illegalC.append(i);
                    continue;
                }
                legalC.append(i);
                if (i > '\u00ff') {
                    crazyLegalC.append(i);
                    continue;
                }
                if (i >= 128) continue;
                asciiC.append(i);
                if (Character.isLowerCase(i)) {
                    asciiLC.append(i);
                    continue;
                }
                asciiUC.append(i);
            }
            legalFirstChars = legalC.toString();
            crazylegalFirstChars = crazyLegalC.toString();
            asciiLowerChars = asciiLC.toString();
            asciiFirstChars = asciiC.toString();
            legalC.setLength(0);
            illegalC.setLength(0);
            crazyLegalC.setLength(0);
            for (i = '\u0000'; i < '\uffff'; i = (char)(i + '\u0001')) {
                if (!bs[1].get(i)) {
                    illegalC.append(i);
                    continue;
                }
                legalC.append(i);
                if (i > '\u00ff') {
                    crazyLegalC.append(i);
                    continue;
                }
                if (i >= 128) continue;
                asciiC.append(i);
            }
            legalChars = legalC.toString();
            crazylegalChars = crazyLegalC.toString();
            asciiChars = asciiC.toString();
        }
    }

    private static final class LogListener
    implements ObfuscationListener {
        private Project p;

        LogListener(Project p) {
            this.p = p;
        }

        @Override
        public void obfuscatingClass(String className) {
            this.p.log("Obfuscating class " + className, 3);
        }

        @Override
        public void obfuscatingJar(String inJar, String outJar) {
            this.p.log("Obfuscating Jar " + inJar + " to " + outJar);
        }

        @Override
        public void parsingClass(String className) {
            this.p.log("Parsing class " + className, 3);
        }

        @Override
        public void parsingJar(String jar) {
            this.p.log("Parsing jar " + jar);
        }
    }

    private final class TaskLogger
    extends Logger {
        private PrintWriter writer;

        TaskLogger() {
        }

        void setWriter(PrintWriter writer) {
            this.writer = writer;
        }

        @Override
        public void warning(String message) {
            ObfuscatorTask.this.getProject().log((Task)ObfuscatorTask.this, "WARNING: " + message, 1);
        }

        @Override
        public void warningToLogfile(String message) {
            if (null != this.writer) {
                this.writer.println("<!-- WARNING: " + message + " -->");
            }
        }

        @Override
        public void log(String message) {
            ObfuscatorTask.this.getProject().log((Task)ObfuscatorTask.this, message, 2);
        }

        @Override
        public void error(String message) {
            ObfuscatorTask.this.getProject().log((Task)ObfuscatorTask.this, "ERROR: " + message, 0);
        }
    }

    private static final class ClassFileFilter
    implements Filter {
        private com.yworks.util.Filter parent;

        ClassFileFilter(com.yworks.util.Filter parent) {
            this.parent = parent;
        }

        @Override
        public boolean accepts(Object o) {
            String s = (String)o;
            if (s.endsWith(".class") && s.indexOf(36) != -1) {
                s = s.substring(0, s.indexOf(36)) + ".class";
            }
            return this.parent.accepts(s);
        }
    }

    class ResourceAdjuster
    implements ResourceHandler {
        GuardDB db;
        Map map;
        StringReplacer contentReplacer = null;

        ResourceAdjuster(final GuardDB db) {
            this.db = db;
            this.map = new HashMap(){

                @Override
                public Object get(Object key) {
                    return db.translateJavaClass(key.toString());
                }
            };
        }

        @Override
        public boolean filterName(String inName, StringBuffer outName) {
            boolean rp = true;
            boolean rn = false;
            for (AdjustSection as : ObfuscatorTask.this.adjustSections) {
                if (!as.contains(inName)) continue;
                if (as.getReplaceName()) {
                    rn = true;
                }
                if (as.getReplacePath()) continue;
                rp = false;
            }
            if (rn) {
                outName.setLength(0);
                String servicesPrefix = "META-INF/services/";
                if (inName.startsWith("META-INF/services/")) {
                    String cn = inName.substring("META-INF/services/".length());
                    outName.append("META-INF/services/");
                    outName.append(this.db.translateJavaFile(cn).replace('/', '.'));
                } else {
                    int index = 0;
                    if (inName.endsWith(".properties")) {
                        index = inName.indexOf(95);
                    }
                    if (index <= 0) {
                        index = inName.indexOf(46);
                    }
                    String prefix = inName.substring(0, index);
                    prefix = this.db.translateJavaFile(prefix);
                    outName.append(prefix);
                    outName.append(inName.substring(index));
                }
            } else {
                outName.append(inName);
            }
            if (!rp) {
                String outPath = inName.substring(0, inName.lastIndexOf(47) + 1);
                String outFile = outName.toString();
                outFile = outFile.substring(outFile.lastIndexOf(47) + 1);
                outName.setLength(0);
                outName.append(outPath);
                outName.append(outFile);
            }
            return rn || !rp;
        }

        @Override
        public boolean filterContent(InputStream in, OutputStream out, String resourceName) throws IOException {
            for (AdjustSection as : ObfuscatorTask.this.adjustSections) {
                if (!as.contains(resourceName) || !as.getReplaceContent()) continue;
                OutputStreamWriter writer = new OutputStreamWriter(out);
                this.getContentReplacer().replace(new InputStreamReader(in), writer, this.map);
                ((Writer)writer).flush();
                return true;
            }
            return false;
        }

        @Override
        public String filterString(String in, String resourceName) throws IOException {
            StringBuffer result = new StringBuffer(in.length());
            this.getContentReplacer().replace(in, result, this.map);
            return result.toString();
        }

        StringReplacer getContentReplacer() {
            if (this.contentReplacer == null) {
                this.contentReplacer = new StringReplacer("(?:\\w|[$])+(\\.(?:\\w|[$])+)+");
            }
            return this.contentReplacer;
        }
    }

    public class AdjustSection
    extends ZipFileSet {
        private boolean replaceName = false;
        private boolean replaceContent = false;
        private boolean replacePath = true;
        private Set entries;

        public AdjustSection() {
            this.setProject(ObfuscatorTask.this.getProject());
        }

        public boolean contains(String name) {
            return this.entries.contains(name);
        }

        public void setReplaceContent(boolean rc) {
            this.replaceContent = rc;
        }

        public boolean getReplaceContent() {
            return this.replaceContent;
        }

        public void setReplacePath(boolean rp) {
            this.replacePath = rp;
        }

        public boolean getReplacePath() {
            return this.replacePath;
        }

        public boolean getReplaceName() {
            return this.replaceName;
        }

        public void setReplaceName(boolean rn) {
            this.replaceName = rn;
        }

        public void createEntries(Collection srcJars) throws IOException {
            this.entries = new HashSet();
            for (File file : srcJars) {
                this.setSrc(file);
                DirectoryScanner scanner = this.getDirectoryScanner(this.getProject());
                String[] includedFiles = ZipScannerTool.getMatches(this, scanner);
                for (int i = 0; i < includedFiles.length; ++i) {
                    this.entries.add(includedFiles[i]);
                }
            }
        }
    }

    public final class MapSection {
        private File logFile;
        private List mappables = new ArrayList();

        public void addConfiguredPackage(PackageSection ps) {
            this.mappables.add(ps);
        }

        public void addConfiguredClass(ClassSection ps) {
            this.mappables.add(ps);
        }

        public void addConfiguredField(FieldSection ps) {
            this.mappables.add(ps);
        }

        public void addConfiguredMethod(MethodSection ps) {
            this.mappables.add(ps);
        }

        public void setLogFile(File logFile) {
            this.logFile = logFile;
        }

        Collection createEntries(Project antproject, PrintWriter log) throws BuildException {
            Collection res;
            if (this.logFile != null) {
                try {
                    SAXParserFactory f = SAXParserFactory.newInstance();
                    f.setValidating(false);
                    SAXParser parser = f.newSAXParser();
                    XMLReader r = parser.getXMLReader();
                    MapParser mp = new MapParser(ObfuscatorTask.this);
                    r.setContentHandler(mp);
                    InputStreamReader reader = this.logFile.getName().endsWith(".gz") ? new InputStreamReader(new GZIPInputStream(new FileInputStream(this.logFile))) : new FileReader(this.logFile);
                    InputSource source = new InputSource(reader);
                    antproject.log("Parsing logfile's " + this.logFile.getName() + " map elements...", 2);
                    r.parse(source);
                    ((Reader)reader).close();
                    r = null;
                    f = null;
                    parser = null;
                    res = mp.getEntries();
                }
                catch (ParserConfigurationException pxe) {
                    throw new BuildException("Could configure xml parser!", (Throwable)pxe);
                }
                catch (SAXException pxe) {
                    throw new BuildException("Error parsing xml logfile!" + pxe, (Throwable)pxe);
                }
                catch (IOException ioe) {
                    throw new BuildException("Could not parse map from logfile!", (Throwable)ioe);
                }
            } else {
                res = new ArrayList(this.mappables.size());
            }
            for (Mappable m : this.mappables) {
                m.addMapEntries(res);
            }
            return res;
        }
    }

    public static final class Modifiers
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"public", "protected", "friendly", "private", "none"};
        }

        private int myGetIndex() {
            String[] values = this.getValues();
            for (int i = 0; i < values.length; ++i) {
                if (!this.getValue().equals(values[i])) continue;
                return i;
            }
            return -1;
        }

        public int getModifierValue() {
            switch (this.myGetIndex()) {
                default: {
                    return 0;
                }
                case 0: {
                    return 1;
                }
                case 1: {
                    return 5;
                }
                case 2: {
                    return 4101;
                }
                case 3: {
                    return 4103;
                }
                case 4: 
            }
            return 0;
        }
    }

    public final class PatchSection {
        private List patches = new ArrayList();

        public void addConfiguredClass(ClassSection cs) {
            this.patches.add(cs);
        }

        Collection createEntries(Collection srcJars) throws IOException {
            ArrayList entries = new ArrayList(20);
            for (File file : srcJars) {
                ZipFileSet zipFile = new ZipFileSet();
                zipFile.setProject(ObfuscatorTask.this.getProject());
                zipFile.setSrc(file);
                for (ClassSection cs : this.patches) {
                    if (cs.getName() == null) {
                        cs.addEntries(entries, zipFile);
                        continue;
                    }
                    cs.addEntries(entries, cs.getName());
                }
            }
            return entries;
        }
    }
}

