/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.util.artifact;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.onseven.dbvis.db.dbinfo.n;
import com.onseven.dbvis.t.l;
import com.onseven.dbvis.util.artifact.Artifact;
import com.onseven.dbvis.util.artifact.ArtifactFile;
import com.onseven.dbvis.util.artifact.DriverFile;
import com.onseven.dbvis.util.j.b;
import com.onseven.dbvis.util.x;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DriverStatus
implements n {
    private static final EnumSet<ArtifactFile._b> CLASS_SCAN_FILE_TYPES = EnumSet.of(ArtifactFile._b.d);
    @JsonProperty(value="resultCode")
    private _d downloadResultCode = _d.d;
    @JsonProperty(value="errorMessage")
    private String downloadErrorMessage;
    @JsonProperty(value="scanResultCode")
    private _c scanResultCode = _c.f;
    @JsonProperty(value="scanErrorMessage")
    private String scanErrorMessage;
    @JsonProperty(value="verifyResultCode")
    private _b verifyResultCode = _b.c;
    @JsonProperty(value="verifyErrorMessage")
    private String verifyErrorMessage;
    @JacksonXmlElementWrapper(localName="Files")
    @JacksonXmlProperty(localName="File")
    private List<DriverFile> files = new ArrayList<DriverFile>();
    @JsonProperty(value="lastDriverName")
    private String lastDriverName;
    @JsonProperty(value="lastDriverVersion")
    private String lastDriverVersion;
    @JsonProperty(value="jdbcDriverMajorMinorVersion")
    private String jdbcDriverMajorMinorVersion;
    @JsonProperty(value="currentDownloadName")
    private String currentDownloadName = null;

    public DriverStatus() {
    }

    public DriverStatus(DriverStatus driverStatus) {
        this.downloadResultCode = driverStatus.downloadResultCode;
        this.downloadErrorMessage = driverStatus.downloadErrorMessage;
        this.scanResultCode = driverStatus.scanResultCode;
        this.scanErrorMessage = driverStatus.scanErrorMessage;
        this.verifyResultCode = driverStatus.verifyResultCode;
        this.verifyErrorMessage = driverStatus.verifyErrorMessage;
        this.lastDriverName = driverStatus.lastDriverName;
        this.lastDriverVersion = driverStatus.lastDriverVersion;
        this.jdbcDriverMajorMinorVersion = driverStatus.jdbcDriverMajorMinorVersion;
        this.currentDownloadName = driverStatus.currentDownloadName;
        for (DriverFile driverFile : driverStatus.files) {
            this.add(new DriverFile(driverFile));
        }
    }

    public void clearFiles() {
        this.files.clear();
    }

    public DriverStatus(_d _d2) {
        this.downloadResultCode = _d2;
    }

    public DriverStatus(_d _d2, String string) {
        this.downloadResultCode = _d2;
        this.downloadErrorMessage = string;
    }

    public _d getDownloadResultCode() {
        return this.downloadResultCode;
    }

    public void initResults(_d _d2, _c _c2, _b _b2) {
        if (_d2 != null) {
            if (_d2 == _d.e) {
                this.downloadErrorMessage = null;
            }
            this.downloadResultCode = _d2;
        }
        if (_c2 != null) {
            if (_c2 == _c.f || _c2 == _c.e) {
                this.scanErrorMessage = null;
            }
            this.scanResultCode = _c2;
        }
        if (_b2 != null) {
            if (_b2 == _b.c || _b2 == _b.d) {
                this.verifyErrorMessage = null;
            }
            this.verifyResultCode = _b2;
        }
    }

    public String getDownloadErrorMessage() {
        return this.downloadErrorMessage;
    }

    public void setDownloadErrorMessage(String string) {
        this.downloadErrorMessage = string;
    }

    public void addToErrorMessage(String string) {
        this.downloadErrorMessage = this.downloadErrorMessage == null ? string : this.downloadErrorMessage + " " + string;
    }

    public void setNotDownloaded() {
        this.downloadResultCode = _d.d;
        this.files.clear();
    }

    public List<DriverFile> getFiles(ArtifactFile._b _b2) {
        return this.getFiles(EnumSet.of(_b2));
    }

    public List<DriverFile> getFiles(Collection<ArtifactFile._b> collection) {
        ArrayList<DriverFile> arrayList = new ArrayList<DriverFile>();
        for (DriverFile driverFile : this.files) {
            if (!collection.contains((Object)driverFile.getArtifactFileType())) continue;
            arrayList.add(driverFile);
        }
        return arrayList;
    }

    public List<DriverFile> getFilesSupportingClassScan() {
        ArrayList<DriverFile> arrayList = new ArrayList<DriverFile>();
        for (DriverFile driverFile : this.files) {
            if (!CLASS_SCAN_FILE_TYPES.contains((Object)driverFile.getArtifactFileType())) continue;
            arrayList.add(driverFile);
        }
        return arrayList;
    }

    public List<DriverFile> getFiles() {
        return this.files;
    }

    public void add(DriverFile driverFile) {
        this.files.add(driverFile);
    }

    public String toString() {
        return this.toDebugString(false);
    }

    public String toDebugString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("" + (Object)((Object)this.downloadResultCode));
        stringBuilder.append("/").append("" + (Object)((Object)this.scanResultCode));
        stringBuilder.append("/").append("" + (Object)((Object)this.verifyResultCode));
        stringBuilder.append("  ");
        String string = this.downloadErrorMessage != null ? this.downloadErrorMessage : "-";
        stringBuilder.append(string).append("/");
        string = this.scanErrorMessage != null ? this.scanErrorMessage : "-";
        stringBuilder.append(string).append("/");
        string = this.verifyErrorMessage != null ? this.verifyErrorMessage : "-";
        stringBuilder.append(string).append("\n");
        if (this.downloadResultCode == _d.e) {
            stringBuilder.append("  Files(").append(this.files.size()).append(")");
            if (bl) {
                stringBuilder.append(" ");
                stringBuilder.append(this.files.stream().map(Object::toString).collect(Collectors.joining(", ")));
            }
        }
        return stringBuilder.toString();
    }

    public void initRootDir(String string) {
        for (DriverFile driverFile : this.files) {
            if ((driverFile.artifactType == Artifact._b.e || driverFile.artifactType == Artifact._b.g) && x.j(this.currentDownloadName)) {
                File file = new File(new File(string), this.currentDownloadName);
                driverFile.setRootPath(file.getAbsolutePath());
                continue;
            }
            driverFile.setRootPath(string);
        }
    }

    public List<DriverFile> getFiles(Artifact artifact) {
        ArrayList<DriverFile> arrayList = new ArrayList<DriverFile>();
        for (DriverFile driverFile : this.files) {
            if (driverFile.artifactType != artifact.getType() || !driverFile.originArtifactId.equals(artifact.getIdString())) continue;
            arrayList.add(driverFile);
        }
        return arrayList;
    }

    @JsonIgnore
    public List<String> getDriverClassNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DriverFile driverFile : this.files) {
            List<l> list = driverFile.getClassInfos();
            for (l l2 : list) {
                arrayList.add(l2.d());
            }
        }
        return arrayList;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setFiles(List<DriverFile> list) {
        this.files = list;
    }

    public void setDownloadResultCode(_d _d2) {
        this.downloadResultCode = _d2;
    }

    public _c getScanResultCode() {
        return this.scanResultCode;
    }

    public void setScanResultCode(_c _c2) {
        this.scanResultCode = _c2;
    }

    public String getScanErrorMessage() {
        return this.scanErrorMessage;
    }

    public void setScanErrorMessage(String string) {
        this.scanErrorMessage = string;
    }

    public _b getVerifyResultCode() {
        return this.verifyResultCode;
    }

    public void setVerifyResultCode(_b _b2) {
        this.verifyResultCode = _b2;
    }

    public String getVerifyErrorMessage() {
        return this.verifyErrorMessage;
    }

    public void setVerifyErrorMessage(String string) {
        this.verifyErrorMessage = string;
    }

    public String getLastDriverName() {
        return this.lastDriverName;
    }

    public void setLastDriverName(String string) {
        this.lastDriverName = string;
    }

    public String getLastDriverVersion() {
        return this.lastDriverVersion;
    }

    public void setLastDriverVersion(String string) {
        this.lastDriverVersion = string;
    }

    public String getJdbcDriverMajorMinorVersion() {
        return this.jdbcDriverMajorMinorVersion;
    }

    public void setJdbcDriverMajorMinorVersion(String string) {
        this.jdbcDriverMajorMinorVersion = string;
    }

    @Override
    public boolean areSame(Object object) {
        if (!(object instanceof DriverStatus)) {
            return false;
        }
        DriverStatus driverStatus = (DriverStatus)object;
        if (driverStatus == null) {
            return false;
        }
        if (!(Objects.equals((Object)this.downloadResultCode, (Object)driverStatus.downloadResultCode) && Objects.equals(this.downloadErrorMessage, driverStatus.downloadErrorMessage) && Objects.equals((Object)this.verifyResultCode, (Object)driverStatus.verifyResultCode) && Objects.equals(this.verifyErrorMessage, driverStatus.verifyErrorMessage) && Objects.equals(this.jdbcDriverMajorMinorVersion, driverStatus.jdbcDriverMajorMinorVersion) && Objects.equals(this.lastDriverName, driverStatus.lastDriverName) && Objects.equals(this.lastDriverVersion, driverStatus.lastDriverVersion) && Objects.equals((Object)this.scanResultCode, (Object)driverStatus.scanResultCode) && Objects.equals(this.currentDownloadName, driverStatus.currentDownloadName) && Objects.equals(this.scanErrorMessage, driverStatus.scanErrorMessage))) {
            return false;
        }
        if (this.files.size() != driverStatus.files.size()) {
            return false;
        }
        int n2 = 0;
        for (DriverFile driverFile : this.files) {
            if (driverFile.areSame(driverStatus.files.get(n2++))) continue;
            return false;
        }
        return true;
    }

    public void mergeFrom(DriverStatus driverStatus, File file) {
        if (!this.areSame(driverStatus)) {
            this.downloadResultCode = driverStatus.downloadResultCode;
            this.downloadErrorMessage = driverStatus.downloadErrorMessage;
            this.verifyResultCode = driverStatus.verifyResultCode;
            this.verifyErrorMessage = driverStatus.verifyErrorMessage;
            this.jdbcDriverMajorMinorVersion = driverStatus.jdbcDriverMajorMinorVersion;
            this.lastDriverName = driverStatus.lastDriverName;
            this.lastDriverVersion = driverStatus.lastDriverVersion;
            this.scanResultCode = driverStatus.scanResultCode;
            this.scanErrorMessage = driverStatus.scanErrorMessage;
            this.files.clear();
            for (DriverFile driverFile : driverStatus.files) {
                DriverFile driverFile2 = new DriverFile(driverFile);
                driverFile2.setRootPath(file.getAbsolutePath());
                this.files.add(driverFile2);
            }
        }
    }

    public boolean allResultsOk() {
        return this.downloadResultCode == _d.e && this.scanResultCode == _c.e && this.verifyResultCode == _b.d;
    }

    @JsonIgnore
    public boolean isAnyError() {
        boolean bl = this.downloadResultCode == _d.f;
        boolean bl2 = this.scanResultCode == _c.h || this.scanResultCode == _c.g;
        boolean bl3 = this.verifyResultCode == _b.e;
        return bl || bl2 || bl3;
    }

    public String getDownloadResultDescription() {
        return b.b(DriverStatus.class, "DriverStatus.download." + this.downloadResultCode.name() + ".description", new Object[0]);
    }

    public String getScanResultDescription() {
        return b.b(DriverStatus.class, "DriverStatus.scan." + this.scanResultCode.name() + ".description", new Object[0]);
    }

    public String getVerifyResultDescription() {
        return b.b(DriverStatus.class, "DriverStatus.verify." + this.verifyResultCode.name() + ".description", new Object[0]);
    }

    public String getCurrentDownloadName() {
        return this.currentDownloadName;
    }

    public void setCurrentDownloadName(String string) {
        this.currentDownloadName = string;
    }

    @JsonIgnore
    public boolean hasAccessibleJarFiles() {
        List<DriverFile> list = this.getFiles(ArtifactFile._b.d);
        for (DriverFile driverFile : list) {
            if (!driverFile.getFile().isFile()) continue;
            return true;
        }
        return false;
    }

    public static enum _b {
        c,
        d,
        e;

    }

    public static enum _c {
        f,
        c,
        e,
        g,
        h,
        b;

    }

    public static enum _d {
        e,
        f,
        b,
        d;

    }
}

