/*
 * Decompiled with CFR 0.152.
 */
package com.mimer.jdbc;

import com.mimer.jdbc.Connection;
import com.mimer.jdbc.NativeConnection;
import com.mimer.jdbc.aa;
import com.mimer.jdbc.be;
import java.io.PrintStream;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public final class Driver
implements java.sql.Driver {
    static Driver a;
    private static boolean b;

    public java.sql.Connection connect(String string, Properties properties) throws SQLException {
        if (!this.acceptsURL(string)) {
            return null;
        }
        Properties properties2 = Driver.a(string, properties);
        Properties properties3 = Driver.a();
        Connection connection = new Connection(string, aa.a("protocol", properties2, properties3), aa.a("serverName", properties2, properties3), aa.a("portNumber", properties2, properties3), aa.a("databaseName", properties2, properties3), aa.a("user", properties2, properties3), aa.a("password", properties2, properties3), aa.a("VAR", properties2, properties3), aa.a("VAC", properties2, properties3), aa.a("simtim", properties2, properties3), aa.a("program", properties2, properties3), aa.a("programpwd", properties2, properties3));
        String string2 = aa.a("compatibility", properties2, properties3);
        if (string2 != null) {
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (string2.equals("sqlite")) {
                    n2 = 1;
                }
                throw numberFormatException;
            }
            connection.f(n2);
        }
        return connection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        return string.regionMatches(true, 0, "jdbc:mimer:", 0, 11);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (!this.acceptsURL(string)) {
            return null;
        }
        Properties properties2 = Driver.a(string, properties);
        Properties properties3 = Driver.a();
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("protocol", aa.a("protocol", properties2, properties3));
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Protocol to use for the connection";
        DriverPropertyInfo driverPropertyInfo2 = new DriverPropertyInfo("serverName", aa.a("serverName", properties2, properties3));
        driverPropertyInfo2.required = false;
        driverPropertyInfo2.description = "Host name of Mimer SQL server";
        DriverPropertyInfo driverPropertyInfo3 = new DriverPropertyInfo("portNumber", aa.a("portNumber", properties2, properties3));
        driverPropertyInfo3.required = false;
        driverPropertyInfo3.description = "Port number that the Mimer SQL server listens to";
        DriverPropertyInfo driverPropertyInfo4 = new DriverPropertyInfo("databaseName", aa.a("databaseName", properties2, properties3));
        driverPropertyInfo4.required = true;
        driverPropertyInfo4.description = "Name of the database";
        DriverPropertyInfo driverPropertyInfo5 = new DriverPropertyInfo("user", aa.a("user", properties2, properties3));
        driverPropertyInfo5.required = true;
        driverPropertyInfo5.description = "Database user name";
        DriverPropertyInfo driverPropertyInfo6 = new DriverPropertyInfo("password", aa.a("password", properties2, properties3));
        driverPropertyInfo6.required = true;
        driverPropertyInfo6.description = "Password for authentication";
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{driverPropertyInfo, driverPropertyInfo2, driverPropertyInfo3, driverPropertyInfo4, driverPropertyInfo5, driverPropertyInfo6};
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 42;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private static Properties a() {
        Properties properties = new Properties();
        properties.put("protocol", "");
        properties.put("serverName", "localhost");
        properties.put("portNumber", "1360");
        properties.put("user", "");
        properties.put("password", "");
        properties.put("databaseName", "");
        return properties;
    }

    private static Properties a(String string, Properties properties) {
        boolean bl2;
        Properties properties2 = new Properties(properties);
        be be2 = new be(string);
        String string2 = "";
        String string3 = "";
        be2.a(11);
        string2 = be2.b(":/?");
        boolean bl3 = bl2 = string2.length() > 0;
        if (be2.a(':')) {
            properties2.put("protocol", string2);
            if (bl2) {
                properties2.put("serverName", "");
                properties2.put("portNumber", "");
            }
            bl2 = false;
        }
        if (!bl2 && be2.a('/') && be2.a('/')) {
            string2 = be2.b(":@/?[");
            boolean bl4 = false;
            if (be2.a('[')) {
                string2 = be2.b("]");
                be2.b(":/?");
            }
            if (be2.a(':')) {
                string3 = be2.b("@/?[");
                bl4 = true;
            }
            if (be2.a('@')) {
                properties2.put("user", string2);
                if (bl4) {
                    properties2.put("password", string3);
                }
                string2 = be2.b(":/?]");
                bl4 = false;
                if (be2.a('[')) {
                    string2 = be2.b("]");
                    be2.b(":/?");
                }
                if (be2.a(':')) {
                    string3 = be2.b("/?");
                    bl4 = true;
                }
            }
            properties2.put("serverName", string2);
            if (bl4) {
                properties2.put("portNumber", string3);
            }
            be2.a('/');
        }
        if (!bl2) {
            string2 = be2.b("?");
        }
        if (string2.length() > 0) {
            properties2.put("databaseName", string2);
        }
        if (be2.a('?')) {
            do {
                string2 = be2.b("&=");
                string3 = be2.a('=') ? be2.b("&") : "";
                if (string2.length() <= 0 || properties2.containsKey(string2)) continue;
                properties2.put(string2, string3);
            } while (be2.a('&'));
        }
        return properties2;
    }

    private static void b() {
        System.out.println("Mimer SQL JDBC  Version " + aa.b());
        System.out.println("Copyright (C) Mimer Information Technology AB. All rights reserved.");
        System.out.println();
        System.out.println("Usage: com.mimer.jdbc.Driver options");
        System.out.println("options:");
        System.out.println("    --version    Display driver version");
        System.out.println("    --sysprop    Display all system properties");
        System.out.println("    --errors     List all JDBC error codes");
        System.out.println("    --ping=<url> Test the database at the specified url");
        System.out.println("    --mimcomm    Try to load the mimcomm JNI class");
        System.exit(0);
    }

    private static long c() {
        if (!b) {
            b = true;
        }
        return System.currentTimeMillis();
    }

    private static String a(long l2) {
        if (b) {
            return aa.a(String.valueOf(l2), 6);
        }
        long l3 = l2 / 1000000L;
        long l4 = l2 % 1000000L / 1000L;
        String string = String.valueOf(l4);
        return aa.a(String.valueOf(l3), 6) + "." + aa.a('0', 3 - string.length()) + l4;
    }

    static void a(String string, int n2, PrintStream printStream) {
        try {
            if (!a.acceptsURL(string)) {
                printStream.println("Unrecognized URL prefix");
            } else {
                Connection connection = (Connection)a.connect(string, null);
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                printStream.println("Database connection established.");
                printStream.println("getDatabaseProductName():    " + databaseMetaData.getDatabaseProductName());
                printStream.println("getDatabaseProductVersion(): " + databaseMetaData.getDatabaseProductVersion());
                printStream.println();
                printStream.println("Ping tests:");
                long l2 = Long.MAX_VALUE;
                long l3 = 0L;
                long l4 = 0L;
                for (int i2 = 0; i2 < n2; ++i2) {
                    long l5 = Driver.c();
                    connection.a(0, 0);
                    l5 = Driver.c() - l5;
                    if (l5 < l2) {
                        l2 = l5;
                    }
                    if (l5 > l3) {
                        l3 = l5;
                    }
                    l4 += l5;
                    printStream.println(aa.a(String.valueOf(i2), 3) + Driver.a(l5) + " ms");
                }
                printStream.println("avg" + Driver.a(l4 / 10L) + " ms      min" + Driver.a(l2) + " ms      max" + Driver.a(l3) + " ms");
                connection.close();
            }
        }
        catch (Exception exception) {
            printStream.println(exception);
        }
    }

    public static void main(String[] stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n2 = 0;
        String string = "";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equalsIgnoreCase("-version") || stringArray[i2].equalsIgnoreCase("--version")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i2].equalsIgnoreCase("-sysprop") || stringArray[i2].equalsIgnoreCase("--sysprop")) {
                bl4 = true;
                continue;
            }
            if (stringArray[i2].equalsIgnoreCase("-mimcomm") || stringArray[i2].equalsIgnoreCase("--mimcomm")) {
                bl5 = true;
                continue;
            }
            if (stringArray[i2].equalsIgnoreCase("-errors") || stringArray[i2].equalsIgnoreCase("--errors")) {
                bl3 = true;
                n2 = 0;
                continue;
            }
            if (stringArray[i2].equalsIgnoreCase("--errorshtml")) {
                bl3 = true;
                n2 = 1;
                continue;
            }
            if (stringArray[i2].equalsIgnoreCase("-ping")) {
                if (++i2 < stringArray.length) {
                    string = stringArray[i2];
                    continue;
                }
                System.out.println("-ping: missing url argument");
                Driver.b();
                continue;
            }
            if (stringArray[i2].length() > 6 && stringArray[i2].substring(0, 7).equalsIgnoreCase("--ping=")) {
                string = stringArray[i2].substring(7);
                continue;
            }
            if (stringArray[i2].equalsIgnoreCase("--help") || stringArray[i2].equalsIgnoreCase("-?") || stringArray[i2].equalsIgnoreCase("-h")) {
                Driver.b();
                continue;
            }
            System.out.println(stringArray[i2] + ": illegal argument");
            Driver.b();
        }
        if (!(bl2 || bl3 || bl4 || bl5 || string.length() != 0)) {
            Driver.b();
        }
        if (bl2) {
            aa.a(System.out);
        }
        if (bl4) {
            System.getProperties().list(System.out);
        }
        if (bl3) {
            aa.a(System.out, n2);
        }
        if (bl5) {
            NativeConnection.h();
        }
        if (string.length() > 0) {
            Driver.a(string, 10, System.out);
        }
    }

    static {
        DriverManager.println("Driver class loaded");
        a = new Driver();
        try {
            DriverManager.registerDriver(a);
        }
        catch (SQLException sQLException) {
            DriverManager.println("Unable to register driver: " + sQLException.getMessage());
        }
        b = false;
    }
}

