/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.filter.Filter;
import com.jidesoft.list.FilterableListModel;
import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.tree.DefaultTreeModelWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilterableTreeModel
extends DefaultTreeModelWrapper {
    protected List<Filter> _filters = new ArrayList<Filter>();
    protected boolean _filtersApplied = false;
    private boolean \u0104 = true;
    private boolean \u0109 = true;
    private boolean \u0105 = false;
    private boolean \u0107 = false;
    private boolean \u0106 = false;
    private boolean \u0108 = true;

    public FilterableTreeModel() {
    }

    public FilterableTreeModel(TreeModel treeModel) {
        super(treeModel);
    }

    @Override
    protected ListModelWrapper createListModelWrapper(Object object) {
        return new A();
    }

    @Override
    protected void configureListModelWrapper(ListModelWrapper listModelWrapper, Object object) {
        Object object2 = object;
        while (object2 != null) {
            if (this.isFilterEndNode(object2)) {
                return;
            }
            object2 = this.getParent(object2);
        }
        if (listModelWrapper instanceof FilterableListModel) {
            ((FilterableListModel)listModelWrapper).setAndMode(this.isAndMode());
            ((FilterableListModel)listModelWrapper).addFilters(this.\u0103());
            ((FilterableListModel)listModelWrapper).setFiltersApplied(this.isFiltersApplied());
        }
    }

    protected boolean isFilterEndNode(Object object) {
        return false;
    }

    public void addFilters(List<Filter> list) {
        for (Filter filter : list) {
            this._filters.add(filter);
        }
        if (!this.isFilterEntireTreeImmediately()) {
            this.clearAllListModelWrappers();
        }
    }

    public void addFilter(Filter filter) {
        this._filters.add(filter);
        if (!this.isFilterEntireTreeImmediately()) {
            this.clearAllListModelWrappers();
        }
    }

    public void removeFilter(Filter filter) {
        this._filters.remove(filter);
        if (!this.isFilterEntireTreeImmediately()) {
            this.clearAllListModelWrappers();
        }
    }

    public void clearFilters() {
        this._filters.clear();
        if (!this.isFilterEntireTreeImmediately()) {
            this.clearAllListModelWrappers();
        }
    }

    public Filter[] getFilters() {
        List<Filter> list = this.\u0103();
        if (list != null) {
            return list.toArray(new Filter[list.size()]);
        }
        return new Filter[0];
    }

    private List<Filter> \u0103() {
        return this._filters;
    }

    public void setFiltersApplied(boolean bl) {
        this._filtersApplied = bl;
        this.refresh();
    }

    public void refresh() {
        this.clearAllListModelWrappers();
        if (this.isFilterEntireTreeImmediately() && this.isFiltersApplied()) {
            this.\u0102();
        }
        if (this.getRoot() == null) {
            return;
        }
        this.\u0101(true);
        try {
            this.fireTreeStructureChanged(this, new TreePath(this.getRoot()));
        }
        finally {
            this.\u0101(false);
        }
    }

    private void \u0102() {
        Object object = this.getRoot();
        this.\u0105(object);
    }

    private void \u0105(Object object) {
        int n2 = this.\u0103(object);
        if (n2 > 0) {
            this.initWrapper(object);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.\u0105(this.\u0101(object, i2));
            }
        }
    }

    public boolean isFiltersApplied() {
        return this._filtersApplied;
    }

    public boolean isAndMode() {
        return this.\u0108;
    }

    public void setAndMode(boolean bl) {
        this.\u0108 = bl;
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath() != null) {
            this.clearListModelWrapper(treeModelEvent.getTreePath().getLastPathComponent());
        }
        if (this.isFiltersApplied() && this.getFilters().length > 0) {
            this.updateTreeOnNodeInserted(treeModelEvent);
        } else {
            super.treeNodesInserted(treeModelEvent);
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        super.treeNodesRemoved(treeModelEvent);
        if (this.isFiltersApplied() && this.getFilters().length > 0) {
            this.clearFiltersOnTreePath(treeModelEvent.getTreePath());
            this.\u0101(treeModelEvent.getTreePath());
            this.updateTreeOnNodeRemoved(treeModelEvent);
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.clearFiltersOnTreePath(treeModelEvent.getTreePath());
        super.treeStructureChanged(treeModelEvent);
        this.updateTreeOnStructureChanged(treeModelEvent);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath() != null) {
            this.clearListModelWrapper(treeModelEvent.getTreePath().getLastPathComponent());
        }
        super.treeNodesChanged(treeModelEvent);
        if (this.isFiltersApplied() && this.getFilters().length > 0) {
            this.updateTreeOnNodeChanged(treeModelEvent);
        }
    }

    public void clearFiltersOnTreePath(TreePath treePath) {
        if (treePath != null) {
            Object[] objectArray;
            for (Object object : objectArray = treePath.getPath()) {
                this.clearListModelWrapper(object);
            }
        }
    }

    void \u0101(TreePath treePath) {
        if (treePath != null) {
            Object[] objectArray;
            for (Object object : objectArray = treePath.getPath()) {
                this.initWrapper(object);
            }
        }
    }

    protected void updateTreeOnNodeInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath() == null) {
            return;
        }
        TreePath treePath = treeModelEvent.getTreePath();
        if (this.isFiltered(treePath.getLastPathComponent())) {
            return;
        }
        TreePath treePath2 = null;
        while (treePath != null && this.\u0104(treePath.getLastPathComponent())) {
            treePath2 = treePath;
            treePath = treePath.getParentPath();
        }
        if (treePath2 != null) {
            if (treePath != null) {
                Object object = treePath2.getLastPathComponent();
                Object object2 = treePath.getLastPathComponent();
                int n2 = this.getActualModel().getIndexOfChild(object2, object);
                ListModelWrapper listModelWrapper = this.\u0102(object2);
                int n3 = JideSwingUtilities.binarySearch(listModelWrapper.getIndexes(), n2);
                if (n3 >= 0) {
                    super.fireTreeNodesInserted(treeModelEvent.getSource(), treePath.getPath(), new int[]{n3}, new Object[]{object});
                }
            } else {
                super.fireTreeStructureChanged(treeModelEvent.getSource(), null);
            }
        } else {
            Object object = treePath.getLastPathComponent();
            ListModelWrapper listModelWrapper = this.\u0102(object);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            Object[] objectArray = treeModelEvent.getChildren();
            int objectArray2 = objectArray.length;
            for (int i2 = 0; i2 < objectArray2; ++i2) {
                Object object2 = objectArray[i2];
                int n2 = this.getActualModel().getIndexOfChild(object, object2);
                int n3 = JideSwingUtilities.binarySearch(listModelWrapper.getIndexes(), n2);
                if (n3 < 0) continue;
                arrayList.add(n3);
                arrayList2.add(object2);
            }
            if (arrayList.size() > 0) {
                int[] nArray = new int[arrayList.size()];
                for (objectArray2 = 0; objectArray2 < nArray.length; ++objectArray2) {
                    nArray[objectArray2] = (Integer)arrayList.get(objectArray2);
                }
                Object[] objectArray3 = arrayList2.toArray(new Object[arrayList2.size()]);
                super.fireTreeNodesInserted(treeModelEvent.getSource(), treePath.getPath(), nArray, objectArray3);
            }
        }
    }

    protected void updateTreeOnNodeRemoved(TreeModelEvent treeModelEvent) {
        Object object;
        TreePath treePath;
        if (treeModelEvent.getTreePath() == null) {
            return;
        }
        TreePath treePath2 = null;
        for (treePath = treeModelEvent.getTreePath(); treePath != null && this.\u0103(object = treePath.getLastPathComponent()) > 0 && this.isFiltered(object); treePath = treePath.getParentPath()) {
            treePath2 = treePath;
        }
        if (treePath2 != null) {
            if (treePath != null) {
                object = treePath2.getLastPathComponent();
                Object object2 = treePath.getLastPathComponent();
                int n2 = this.getActualModel().getIndexOfChild(object2, object);
                ListModelWrapper listModelWrapper = this.\u0102(object2);
                int n3 = JideSwingUtilities.binarySearch(listModelWrapper.getIndexes(), n2);
                if (n3 <= 0) {
                    n3 = 0 - n3;
                    super.fireTreeNodesRemoved(treeModelEvent.getSource(), treePath.getPath(), new int[]{n3}, new Object[]{object});
                }
            } else {
                super.fireTreeStructureChanged(treeModelEvent.getSource(), null);
            }
        }
    }

    protected void updateTreeOnNodeChanged(TreeModelEvent treeModelEvent) {
        this.updateTree(treeModelEvent);
    }

    protected void updateTreeOnStructureChanged(TreeModelEvent treeModelEvent) {
        this.updateTree(treeModelEvent);
    }

    private boolean \u0104(Object object) {
        ListModelWrapper listModelWrapper = this.getListModelWrapper(object);
        if (listModelWrapper == null) {
            this.initWrapper(object);
            listModelWrapper = this.getListModelWrapper(object);
        }
        if (listModelWrapper == null) {
            return false;
        }
        if (this.\u0103(object) <= 1) {
            return false;
        }
        int[] nArray = listModelWrapper.getIndexes();
        return nArray != null && nArray.length == 1;
    }

    protected boolean isFiltered(Object object) {
        ListModelWrapper listModelWrapper = this.getListModelWrapper(object);
        if (listModelWrapper == null) {
            this.initWrapper(object);
            listModelWrapper = this.getListModelWrapper(object);
        }
        if (listModelWrapper == null) {
            return false;
        }
        int[] nArray = listModelWrapper.getIndexes();
        return nArray != null && nArray.length <= 0;
    }

    protected void updateTree(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath() == null) {
            return;
        }
        TreePath treePath = treeModelEvent.getTreePath().getParentPath();
        if (treePath != null) {
            super.treeStructureChanged(new TreeModelEvent(treeModelEvent.getSource(), treePath));
        }
    }

    public boolean isFilterEntireTreeImmediately() {
        return this.\u0107;
    }

    public void setFilterEntireTreeImmediately(boolean bl) {
        this.\u0107 = bl;
    }

    public boolean isHideEmptyParentNode() {
        return this.\u0104;
    }

    public void setHideEmptyParentNode(boolean bl) {
        if (this.\u0104 != bl) {
            this.\u0104 = bl;
            if (this.\u0104) {
                this.setFilterEntireTreeImmediately(true);
            }
            Filter[] filterArray = this.getFilters();
            if (this.isFiltersApplied() && filterArray != null && filterArray.length > 0) {
                this.refresh();
            }
        }
    }

    public boolean isMatchesLeafNodeOnly() {
        return this.\u0109;
    }

    public void setMatchesLeafNodeOnly(boolean bl) {
        if (this.\u0109 != bl) {
            this.\u0109 = bl;
            if (this.isMatchesLeafNodeOnly()) {
                this.setKeepAllChildren(false);
            }
            Filter[] filterArray = this.getFilters();
            if (this.isFiltersApplied() && filterArray != null && filterArray.length > 0) {
                this.refresh();
            }
        }
    }

    public boolean isKeepAllChildren() {
        return this.\u0105;
    }

    public void setKeepAllChildren(boolean bl) {
        if (this.\u0105 != bl) {
            this.\u0105 = bl;
            if (this.isKeepAllChildren()) {
                this.setMatchesLeafNodeOnly(false);
            }
            Filter[] filterArray = this.getFilters();
            if (this.isFiltersApplied() && filterArray != null && filterArray.length > 0) {
                this.refresh();
            }
        }
    }

    boolean \u0101() {
        return this.\u0106;
    }

    void \u0101(boolean bl) {
        this.\u0106 = bl;
    }

    private Object \u0101(Object object, int n2) {
        if (object != null && object instanceof TreeNode) {
            return ((TreeNode)object).getChildAt(n2);
        }
        return null;
    }

    private int \u0103(Object object) {
        if (object != null && object instanceof TreeNode) {
            return ((TreeNode)object).getChildCount();
        }
        return 0;
    }

    protected Object getParent(Object object) {
        if (object != null && object instanceof TreeNode) {
            return ((TreeNode)object).getParent();
        }
        return null;
    }

    private class A
    extends FilterableListModel<Object> {
        private static final long \u0c15 = 6925345132111963718L;

        private A() {
        }

        private boolean \u0101(Object object, List<Filter<Object>> list) {
            return super.shouldBeFiltered(object, list);
        }

        @Override
        public boolean shouldBeFiltered(Object object, List<Filter<Object>> list) {
            if (FilterableTreeModel.this.isKeepAllChildren()) {
                boolean bl = this.\u0101(object, list);
                Object object2 = object;
                while (bl && (object2 = FilterableTreeModel.this.getParent(object2)) != null) {
                    ListModelWrapper listModelWrapper = FilterableTreeModel.this.getListModelWrapper(object2);
                    if (!(listModelWrapper instanceof A)) continue;
                    if (!((A)listModelWrapper).isFiltersApplied()) {
                        ((A)listModelWrapper).setFiltersApplied(true);
                    }
                    bl = ((A)listModelWrapper).\u0101(object2, list);
                }
                if (!bl) {
                    return bl;
                }
                return !this.\u0102(object, list);
            }
            if (FilterableTreeModel.this.isLeaf(object)) {
                return this.\u0101(object, list);
            }
            if (!FilterableTreeModel.this.isMatchesLeafNodeOnly()) {
                return !this.\u0102(object, list) && this.\u0101(object, list);
            }
            if (FilterableTreeModel.this.isHideEmptyParentNode()) {
                return !this.\u0102(object, list);
            }
            return false;
        }

        private boolean \u0102(Object object, List<Filter<Object>> list) {
            Object object2 = object;
            while (object2 != null) {
                if (FilterableTreeModel.this.isFilterEndNode(object2) && this.\u0101(object2, list)) {
                    return false;
                }
                object2 = FilterableTreeModel.this.getParent(object2);
            }
            return FilterableTreeModel.this.getChildCount(object) > 0;
        }
    }
}

