/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.paging;

import com.jidesoft.paging.PageNavigationEvent;
import com.jidesoft.paging.PageNavigationListener;
import com.jidesoft.paging.PageNavigationSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public abstract class AbstractPageNavigationSupport
implements PageNavigationSupport {
    private int \u0933 = 10;
    private int \u0935 = -1;
    private int \u0934;
    private EventListenerList \u0931;
    private static final Logger \u0930 = Logger.getLogger(PageNavigationEvent.class.getName());
    private transient int \u0932 = -1;
    private transient boolean \u092f = true;

    public AbstractPageNavigationSupport(EventListenerList eventListenerList) {
        this.\u0931 = eventListenerList;
    }

    public AbstractPageNavigationSupport(int n2, EventListenerList eventListenerList) {
        this.\u0933 = n2;
        this.\u0931 = eventListenerList;
    }

    @Override
    public int getPageSize() {
        return this.\u0933 == 0 ? 10 : this.\u0933;
    }

    @Override
    public void setPageSize(int n2) {
        int n3;
        if (n2 == 0) {
            n2 = 10;
        }
        if ((n3 = this.\u0933) != n2) {
            this.\u0933 = n2;
            this.\u0102(n3, this.\u0933);
            this.firePageNavigationEvent(this, 14100, n3, this.\u0933);
        }
    }

    @Override
    public int getCurrentPage() {
        return this.\u0935;
    }

    @Override
    public void setCurrentPage(int n2) {
        int n3 = this.\u0935;
        if (n3 != n2 && (this.getPageCount() < 0 || n2 <= this.getPageCount() - 1) && n2 >= 0) {
            this.\u0935 = n2;
            this.\u0104(n3, this.\u0935);
            this.firePageNavigationEvent(this, 14101, n3, this.\u0935);
            if (this.\u092f) {
                this.\u0194();
            }
        }
    }

    private void \u0194() {
        this.\u0932 = this.getPageSize() > 0 ? this.getCurrentPage() * this.getPageSize() : 0;
    }

    protected void setPageCount(int n2) {
        int n3 = this.\u0934;
        if (n3 != n2) {
            this.\u0934 = n2;
            this.\u0103(n3, this.\u0934);
            this.firePageNavigationEvent(this, 14099, n3, this.\u0934);
        }
    }

    @Override
    public int getPageCount() {
        return this.\u0934;
    }

    @Override
    public void nextPage() {
        int n2 = this.getCurrentPage();
        if (n2 < this.getPageCount() - 1) {
            this.setCurrentPage(n2 + 1);
        }
    }

    @Override
    public void previousPage() {
        int n2 = this.getCurrentPage();
        if (n2 > 0) {
            this.setCurrentPage(n2 - 1);
        }
    }

    @Override
    public void firstPage() {
        if (this.getCurrentPage() > 0) {
            this.setCurrentPage(0);
        }
    }

    @Override
    public void lastPage() {
        int n2 = this.getPageCount();
        if (this.getCurrentPage() < n2 - 1) {
            this.setCurrentPage(n2 - 1);
        }
    }

    @Override
    public void addPageNavigationListener(PageNavigationListener pageNavigationListener) {
        this.\u0931.add(PageNavigationListener.class, pageNavigationListener);
    }

    @Override
    public void removePageNavigationListener(PageNavigationListener pageNavigationListener) {
        this.\u0931.remove(PageNavigationListener.class, pageNavigationListener);
    }

    @Override
    public PageNavigationListener[] getPageNavigationListeners() {
        return (PageNavigationListener[])this.\u0931.getListeners(PageNavigationListener.class);
    }

    @Override
    public void firePageNavigationEvent(Object object, int n2, int n3, int n4) {
        if (object == null) {
            object = this;
        }
        if (\u0930.isLoggable(Level.FINE)) {
            switch (n2) {
                case 14099: {
                    \u0930.fine("Total page count is changed from " + n3 + " => " + n4 + ", source is " + object.getClass().getName());
                    break;
                }
                case 14100: {
                    \u0930.fine("Page size is changed from " + n3 + " => " + n4 + ", source is " + object.getClass().getName());
                    break;
                }
                case 14101: {
                    \u0930.fine("The current page index is changed from " + n3 + " => " + n4 + ", source is " + object.getClass().getName());
                    break;
                }
            }
        }
        Object[] objectArray = this.\u0931.getListenerList();
        PageNavigationEvent pageNavigationEvent = new PageNavigationEvent(object, n2, n3, n4);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PageNavigationListener.class) continue;
            ((PageNavigationListener)objectArray[i2 + 1]).pageNavigationEventFired(pageNavigationEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void \u0102(int n2, int n3) {
        int n4 = this.getCurrentPage();
        int n5 = this.getTotalRecordCount();
        if (n5 >= 0) {
            this.setPageCount(n5 / n3 + (n5 % n3 == 0 ? 0 : 1));
        } else {
            this.setPageCount(-1);
        }
        this.\u092f = false;
        try {
            if (this.\u0932 > 0) {
                this.setCurrentPage(this.\u0932 / n3);
            } else {
                this.setCurrentPage(0);
            }
        }
        finally {
            this.\u092f = true;
        }
        int n6 = this.getCurrentPage();
        if (n6 == n4) {
            this.\u0104(n4, n6);
        }
    }

    abstract void \u0103(int var1, int var2);

    abstract void \u0104(int var1, int var2);
}

