/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.applications;

import com.install4j.runtime.beans.applications.Application;
import java.io.File;
import java.util.Objects;

public abstract class ApplicationWithPath
extends Application {
    private String executableName = "";
    private boolean useCustomMacosExecutableName = false;
    private String customMacosExecutableName = "";
    private File executableDirectory;
    private String unixMode;

    protected ApplicationWithPath() {
        this.setUnixMode(this.getDefaultUnixMode());
    }

    protected abstract String getDefaultUnixMode();

    public String getExecutableName() {
        return ApplicationWithPath.replaceVariables(this.executableName);
    }

    public void setExecutableName(String executableName) {
        this.executableName = executableName;
    }

    public boolean isUseCustomMacosExecutableName() {
        return this.replaceWithTextOverride("useCustomMacosExecutableName", this.useCustomMacosExecutableName);
    }

    public void setUseCustomMacosExecutableName(boolean useCustomMacosExecutableName) {
        this.useCustomMacosExecutableName = useCustomMacosExecutableName;
    }

    public String getCustomMacosExecutableName() {
        return ApplicationWithPath.replaceVariables(ApplicationWithPath.replaceVariables(this.customMacosExecutableName));
    }

    public void setCustomMacosExecutableName(String customMacosExecutableName) {
        this.customMacosExecutableName = customMacosExecutableName;
    }

    public File getExecutableDirectory() {
        return this.replaceWithTextOverride("executableDirectory", this.executableDirectory, File.class);
    }

    public void setExecutableDirectory(File executableDirectory) {
        this.executableDirectory = executableDirectory;
    }

    public String getUnixMode() {
        return ApplicationWithPath.replaceVariables(this.unixMode);
    }

    public void setUnixMode(String unixMode) {
        this.unixMode = unixMode;
    }

    public String getUsedExecutableDirectory() {
        if (this.getExecutableDirectory() != null && this.getExecutableDirectory().getPath().trim().length() > 0) {
            return this.getExecutableDirectory().getPath();
        }
        return ".install4j";
    }

    public String getUsedExecutablePath(boolean macos) {
        StringBuilder buffer = new StringBuilder();
        String usedExecutableDirectory = this.getUsedExecutableDirectory();
        if (!Objects.equals(usedExecutableDirectory, ".")) {
            buffer.append(usedExecutableDirectory);
            buffer.append(File.separatorChar);
        }
        if (macos && this.isUseCustomMacosExecutableName()) {
            buffer.append(this.getCustomMacosExecutableName());
        } else {
            buffer.append(this.getExecutableName().replace('\\', '/'));
        }
        return buffer.toString();
    }
}

