/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.componentselection;

import com.install4j.api.UiUtil;
import com.install4j.runtime.beans.screens.componentselection.ComponentCellHandler;
import com.install4j.runtime.beans.screens.componentselection.ComponentFolderNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentTreeModel;
import com.install4j.runtime.beans.screens.componentselection.DescriptionModeProvider;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import java.awt.ComponentOrientation;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class ComponentTree
extends JTree {
    public static KeyStroke KEY_STROKE_HELP = KeyStroke.getKeyStroke(112, 0);
    public static KeyStroke KEY_STROKE_SELECT = KeyStroke.getKeyStroke(32, 0);
    private DescriptionModeProvider descriptionModeProvider;
    private ComponentCellHandler renderer;

    public ComponentTree(DescriptionModeProvider descriptionModeProvider) {
        this.descriptionModeProvider = descriptionModeProvider;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    protected abstract ComponentTreeModel createTreeModel();

    public abstract String getIconTooltip(ComponentNodeConfig var1);

    public abstract Icon getLeafIcon(ComponentNodeConfig var1);

    public abstract int getLeafIconWidth();

    public DescriptionModeProvider getDescriptionModeProvider() {
        return this.descriptionModeProvider;
    }

    protected void setupControls() {
        this.renderer = this.createComponentCellHandler();
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        this.renderer.applyComponentOrientation(o);
    }

    protected ComponentCellHandler createComponentCellHandler() {
        return new ComponentCellHandler(this);
    }

    protected void setupComponent() {
        this.setRootVisible(false);
        ComponentTreeModel model = this.createTreeModel();
        this.setVisibleRowCount(5);
        this.setModel(model);
        this.setCellRenderer(this.renderer);
        this.modelSet();
        this.setRowHeight(0);
        this.getSelectionModel().setSelectionMode(1);
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)model.getRoot();
        int childCount = rootNode.getChildCount();
        boolean topLevelOnly = true;
        for (int i = 0; i < childCount; ++i) {
            if (rootNode.getChildAt(i).getChildCount() <= 0) continue;
            topLevelOnly = false;
            break;
        }
        this.setShowsRootHandles(!topLevelOnly);
        if (this.isDisableSelectionPainting()) {
            UiUtil.getLookAndFeelEnhancer().disableExtraSelectionPainting(this);
        }
    }

    protected void modelSet() {
    }

    protected void setupEventHandlers() {
        this.addMouseListener(new ComponentTreeMouseListener());
        this.addKeyListener(new ComponentTreeKeyListener());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addComponentListener(new ComponentAdapter(){
            private boolean cellRendererUpdated;

            @Override
            public void componentResized(ComponentEvent e) {
                if (!this.cellRendererUpdated && ComponentTree.this.getWidth() > 0) {
                    this.cellRendererUpdated = true;
                    ComponentTree.this.updateCellRenderer();
                }
            }
        });
    }

    public void updateAllNodes() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        Enumeration<TreeNode> en = ((DefaultMutableTreeNode)model.getRoot()).depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            model.nodeChanged(node);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point p;
        if (event != null && (p = this.initRenderer(event)) != null) {
            return this.renderer.getToolTipText(p);
        }
        return null;
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        return null;
    }

    @Override
    public void removeSelectionRow(int row) {
    }

    private Point initRenderer(MouseEvent event) {
        TreePath path = this.getPathForLocation(event.getX(), event.getY());
        if (path == null) {
            return null;
        }
        int row = this.getRowForLocation(event.getX(), event.getY());
        Rectangle bounds = this.getRowBounds(row);
        Point point = event.getPoint();
        point.translate(-bounds.x, -bounds.y);
        this.renderer.getTreeCellRendererComponent(this, path.getLastPathComponent(), false, false, true, 0, false);
        this.renderer.setSize(this.renderer.getPreferredSize());
        this.renderer.doLayout();
        return point;
    }

    public void nodeToggled() {
    }

    public void selectionChanged(ComponentNode componentNode, boolean dependency) {
    }

    private void updateCellRenderer() {
        this.renderer = this.createComponentCellHandler();
        this.setCellRenderer(this.renderer);
    }

    public boolean isDisableSelectionPainting() {
        return false;
    }

    private void togglePathDescription(@NotNull TreePath path) {
        ComponentNode node = (ComponentNode)path.getLastPathComponent();
        ComponentNodeConfig componentNodeConfig = node.getComponentNodeConfig();
        if (componentNodeConfig.isHelpButtonVisible()) {
            node.toggleDisplayDescription();
        }
    }

    private void togglePathSelection(@NotNull TreePath path) {
        ComponentNode componentNode = (ComponentNode)path.getLastPathComponent();
        if (componentNode.isChangeable()) {
            if (componentNode instanceof ComponentFolderNode && componentNode.isSelected() && !((ComponentFolderNode)componentNode).isAllSelected()) {
                componentNode.setSelected(true, true);
            } else {
                componentNode.setSelected(!componentNode.isSelected(), true);
            }
            ((DefaultTreeModel)this.getModel()).nodeChanged(componentNode);
            this.requestFocus();
            this.nodeToggled();
            this.pathToggled(path);
        }
    }

    protected void pathToggled(TreePath path) {
    }

    public static enum ActionType {
        CHECK_BOX,
        HELP;

    }

    private static class PathWithAction {
        @NotNull
        private final TreePath path;
        @NotNull
        private final ActionType actionType;

        public PathWithAction(@NotNull TreePath path, @NotNull ActionType actionType) {
            this.path = path;
            this.actionType = actionType;
        }
    }

    private class ComponentTreeKeyListener
    extends KeyAdapter {
        private ComponentTreeKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            TreePath path;
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(event);
            if (KEY_STROKE_HELP.equals(keyStroke)) {
                TreePath path2 = ComponentTree.this.getSelectionPath();
                if (path2 != null) {
                    ComponentTree.this.togglePathDescription(path2);
                    event.consume();
                }
            } else if (KEY_STROKE_SELECT.equals(keyStroke) && (path = ComponentTree.this.getSelectionPath()) != null) {
                ComponentTree.this.togglePathSelection(path);
                event.consume();
            }
        }
    }

    private class ComponentTreeMouseListener
    extends MouseAdapter {
        private int toggleCount = -1;

        private ComponentTreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.preventToggleEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            PathWithAction pathWithAction = this.preventToggleEvent(e);
            if (pathWithAction != null) {
                JTree tree;
                switch (pathWithAction.actionType) {
                    case CHECK_BOX: {
                        ComponentTree.this.togglePathSelection(pathWithAction.path);
                        break;
                    }
                    case HELP: {
                        ComponentTree.this.togglePathDescription(pathWithAction.path);
                    }
                }
                Object source = e.getSource();
                if (source instanceof JTree && !(tree = (JTree)source).hasFocus() && tree.isFocusable() && tree.isRequestFocusEnabled()) {
                    tree.requestFocusInWindow();
                }
                e.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            PathWithAction pathWithAction = this.preventToggleEvent(e);
            if (pathWithAction != null) {
                e.consume();
            }
            if (this.toggleCount != -1) {
                ComponentTree.this.setToggleClickCount(this.toggleCount);
            }
        }

        private PathWithAction preventToggleEvent(MouseEvent e) {
            TreePath path = this.getTreePath(e);
            if (path == null) {
                return null;
            }
            Point point = ComponentTree.this.initRenderer(e);
            ActionType actionType = this.getActionType(point);
            if (actionType != null) {
                int toggleCount = ComponentTree.this.getToggleClickCount();
                if (toggleCount != -1) {
                    this.toggleCount = toggleCount;
                    ComponentTree.this.setToggleClickCount(-1);
                }
                return new PathWithAction(path, actionType);
            }
            return null;
        }

        private TreePath getTreePath(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return null;
            }
            return ComponentTree.this.getPathForLocation(e.getX(), e.getY());
        }

        public ActionType getActionType(Point point) {
            if (ComponentTree.this.renderer.isPointInCheckBox(point)) {
                return ActionType.CHECK_BOX;
            }
            if (ComponentTree.this.renderer.isPointInHelpButton(point)) {
                return ActionType.HELP;
            }
            return null;
        }
    }
}

