-- Sakila Sample Database Schema Constraints
-- Version 1.2

-- Copyright (c) 2006, 2019, Oracle and/or its affiliates.
-- All rights reserved.

-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions are
-- met:

-- * Redistributions of source code must retain the above copyright notice,
--   this list of conditions and the following disclaimer.
-- * Redistributions in binary form must reproduce the above copyright
--   notice, this list of conditions and the following disclaimer in the
--   documentation and/or other materials provided with the distribution.
-- * Neither the name of Oracle nor the names of its contributors may be used
--   to endorse or promote products derived from this software without
--   specific prior written permission.

-- THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
-- IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
-- THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
-- PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
-- CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
-- EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
-- PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
-- PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
-- LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
-- NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
-- SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

-- -------------------------------------------------
-- Modified for use with H2 database in DbVisualizer
-- (see ReadMe.DbVisualizer for details)
-- -------------------------------------------------
USE sakila;

------------------------------------
-- CREATE FOREIGN KEY CONSTRAINTS --
------------------------------------
-- after inserting data (staff <-> store has bidirectional referential constraints)

  ALTER TABLE city DROP CONSTRAINT IF EXISTS fk_city_country_id;
  ALTER TABLE city ADD CONSTRAINT fk_city_country_id FOREIGN KEY (country_id) REFERENCES country (country_id) ON DELETE RESTRICT ON UPDATE CASCADE;

  ALTER TABLE payment DROP CONSTRAINT IF EXISTS fk_payment_rental_id;
  ALTER TABLE payment DROP CONSTRAINT IF EXISTS fk_payment_customer_id;
  ALTER TABLE payment DROP CONSTRAINT IF EXISTS fk_payment_staff_id;
  ALTER TABLE payment ADD CONSTRAINT fk_payment_rental_id FOREIGN KEY (rental_id) REFERENCES rental (rental_id) ON DELETE SET NULL ON UPDATE CASCADE;
  ALTER TABLE payment ADD CONSTRAINT fk_payment_customer_id FOREIGN KEY (customer_id) REFERENCES customer (customer_id) ON DELETE RESTRICT ON UPDATE CASCADE;
  ALTER TABLE payment ADD CONSTRAINT fk_payment_staff_id FOREIGN KEY (staff_id) REFERENCES staff (staff_id) ON DELETE RESTRICT ON UPDATE CASCADE;

  ALTER TABLE rental DROP CONSTRAINT IF EXISTS fk_rental_staff_id;
  ALTER TABLE rental DROP CONSTRAINT IF EXISTS fk_rental_inventory_id;
  ALTER TABLE rental DROP CONSTRAINT IF EXISTS fk_rental_customer_id;
  ALTER TABLE rental ADD CONSTRAINT fk_rental_staff_id FOREIGN KEY (staff_id) REFERENCES staff (staff_id) ON DELETE RESTRICT ON UPDATE CASCADE;
  ALTER TABLE rental ADD CONSTRAINT fk_rental_inventory_id FOREIGN KEY (inventory_id) REFERENCES inventory (inventory_id) ON DELETE RESTRICT ON UPDATE CASCADE;
  ALTER TABLE rental ADD CONSTRAINT fk_rental_customer_id FOREIGN KEY (customer_id) REFERENCES customer (customer_id) ON DELETE RESTRICT ON UPDATE CASCADE;
  
  ALTER TABLE staff DROP CONSTRAINT IF EXISTS fk_staff_store_id;
  ALTER TABLE staff DROP CONSTRAINT IF EXISTS fk_staff_address_id;
  ALTER TABLE staff DROP CONSTRAINT IF EXISTS fk_staff_backup_id;
  ALTER TABLE staff ADD CONSTRAINT fk_staff_store_id FOREIGN KEY (store_id) REFERENCES store (store_id) ON DELETE RESTRICT ON UPDATE CASCADE;
  ALTER TABLE staff ADD CONSTRAINT fk_staff_address_id FOREIGN KEY (address_id) REFERENCES address (address_id) ON DELETE RESTRICT ON UPDATE CASCADE;
  ALTER TABLE staff ADD CONSTRAINT fk_staff_backup_id FOREIGN KEY (backup_id) REFERENCES staff(staff_id) ON DELETE RESTRICT ON UPDATE CASCADE;

  ALTER TABLE inventory DROP CONSTRAINT IF EXISTS fk_inventory_store_id;
  ALTER TABLE inventory DROP CONSTRAINT IF EXISTS fk_inventory_film_id;
  ALTER TABLE inventory ADD CONSTRAINT fk_inventory_store_id FOREIGN KEY (store_id) REFERENCES store (store_id) ON DELETE RESTRICT ON UPDATE CASCADE;
  ALTER TABLE inventory ADD CONSTRAINT fk_inventory_film_id FOREIGN KEY (film_id) REFERENCES film (film_id) ON DELETE RESTRICT ON UPDATE CASCADE;

  ALTER TABLE film_category DROP CONSTRAINT IF EXISTS fk_film_category_film;
  ALTER TABLE film_category DROP CONSTRAINT IF EXISTS fk_film_category_category;
  ALTER TABLE film_category ADD CONSTRAINT fk_film_category_film FOREIGN KEY (film_id) REFERENCES film (film_id) ON DELETE RESTRICT ON UPDATE CASCADE;
  ALTER TABLE film_category ADD CONSTRAINT fk_film_category_category FOREIGN KEY (category_id) REFERENCES category (category_id) ON DELETE RESTRICT ON UPDATE CASCADE;

  ALTER TABLE film_actor DROP CONSTRAINT IF EXISTS fk_film_actor_actor_id;
  ALTER TABLE film_actor DROP CONSTRAINT IF EXISTS fk_film_actor_film_id;
  ALTER TABLE film_actor ADD CONSTRAINT fk_film_actor_actor_id FOREIGN KEY (actor_id) REFERENCES actor (actor_id) ON DELETE RESTRICT ON UPDATE CASCADE;
  ALTER TABLE film_actor ADD CONSTRAINT fk_film_actor_film_id FOREIGN KEY (film_id) REFERENCES film (film_id) ON DELETE RESTRICT ON UPDATE CASCADE;

  ALTER TABLE film DROP CONSTRAINT IF EXISTS fk_film_language_id;
  ALTER TABLE film DROP CONSTRAINT IF EXISTS fk_film_original_language_id;
  ALTER TABLE film ADD CONSTRAINT fk_film_language_id FOREIGN KEY (language_id) REFERENCES language (language_id) ON DELETE RESTRICT ON UPDATE CASCADE;
  ALTER TABLE film ADD CONSTRAINT fk_film_original_language_id FOREIGN KEY (original_language_id) REFERENCES language (language_id) ON DELETE RESTRICT ON UPDATE CASCADE;

  ALTER TABLE customer DROP CONSTRAINT IF EXISTS fk_customer_address_id;
  ALTER TABLE customer DROP CONSTRAINT IF EXISTS fk_customer_store_id;
  ALTER TABLE customer ADD CONSTRAINT fk_customer_address_id FOREIGN KEY (address_id) REFERENCES address(address_id)  ON DELETE RESTRICT ON UPDATE CASCADE;
  ALTER TABLE customer ADD CONSTRAINT fk_customer_store_id FOREIGN KEY (store_id) REFERENCES store(store_id)   ON DELETE RESTRICT ON UPDATE CASCADE;

  ALTER TABLE store DROP CONSTRAINT IF EXISTS fk_store_manager_staff_id;
  ALTER TABLE store DROP CONSTRAINT IF EXISTS fk_store_address_id;
  ALTER TABLE store ADD CONSTRAINT fk_store_manager_staff_id FOREIGN KEY (manager_staff_id) REFERENCES staff (staff_id) ON DELETE RESTRICT ON UPDATE CASCADE;
  ALTER TABLE store ADD CONSTRAINT fk_store_address_id FOREIGN KEY (address_id) REFERENCES address (address_id) ON DELETE RESTRICT ON UPDATE CASCADE;

  ALTER TABLE address DROP CONSTRAINT IF EXISTS fk_address_city_id;
  ALTER TABLE address ADD CONSTRAINT fk_address_city_id FOREIGN KEY (city_id) REFERENCES city(city_id) ON DELETE RESTRICT ON UPDATE CASCADE;