/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.applaunch.ProgressCommunication;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.launcher.util.SingleInstance;
import com.install4j.runtime.util.StringUtil;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Application {
    public static void main(String[] args) {
        if (!HelperCommunication.executeAsHelper(args)) {
            InstallerUtil.setInProcess(false);
            if (args.length == 0) {
                System.err.println("Please provide the application id as first argument");
                System.exit(1);
            }
            String applicationId = args[0];
            String[] rest = new String[args.length - 1];
            System.arraycopy(args, 1, rest, 0, args.length - 1);
            InstallerConfig.setCurrentApplicationId(applicationId);
            CustomApplication customApplication = Application.getCustomApplication();
            if (customApplication != null && customApplication.isSingleInstance() && customApplication.isCreateExecutable()) {
                File exeFileName = System.getProperty("exe4j.moduleName") != null ? new File(System.getProperty("exe4j.moduleName")) : Application.getExeFile(customApplication);
                SingleInstance.checkForCurrentLauncher(exeFileName, false, null);
            }
            InstallerUtil.CommandLineOptions commandLineOptions = InstallerUtil.parseCommandLine(rest);
            ProgressCommunication.init();
            Application.runApplication(commandLineOptions, false, null);
        }
    }

    public static synchronized void runApplicationInProcess(String applicationId, String[] arguments, boolean dialog, Window parentWindow) {
        FileInstaller.clearFileInstaller();
        InstallerConfig.clearCurrentApplication();
        InstallerConfig.setCurrentApplicationId(applicationId);
        if (arguments == null) {
            arguments = new String[]{};
        }
        ArrayList<String> allArguments = new ArrayList<String>();
        StringUtil.splitupCommandLine(allArguments, InstallerConfig.getCurrentApplication().getArguments());
        allArguments.addAll(Arrays.asList(arguments));
        InstallerUtil.CommandLineOptions commandLineOptions = InstallerUtil.parseCommandLine(allArguments.toArray(new String[0]));
        Runnable runnable = () -> Application.runApplication(commandLineOptions, dialog, parentWindow);
        CustomApplication customApplication = Application.getCustomApplication();
        if (customApplication != null && customApplication.isSingleInstance() && customApplication.isCreateExecutable()) {
            if (!SingleInstance.checkInProcessAndRun(Application.getExeFile(customApplication), runnable)) {
                InstallerUtil.exit(0);
            }
        } else {
            runnable.run();
        }
    }

    private static void runApplication(InstallerUtil.CommandLineOptions commandLineOptions, boolean dialog, Window parentWindow) {
        try {
            ScreenExecutor screenExecutor = Installer.getScreenExecutor(commandLineOptions, dialog, parentWindow);
            Application.initInstallationDirectory();
            new Controller(screenExecutor).start();
        }
        catch (Throwable t) {
            InstallerUtil.reportException(t);
            InstallerUtil.exit(1);
        }
    }

    static void initInstallationDirectory() {
        File installationDirectory;
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        File runtimeDir = ResourceHelper.getRuntimeDir();
        if (Util.isMacOS() && config.getMacSpecificConfig().isSingleBundle()) {
            File bundleDirectory = Application.makeCanonical(new File(runtimeDir, "../../../.."));
            config.getMacSpecificConfig().setSingleBundleName(bundleDirectory.getName());
            installationDirectory = bundleDirectory.getParentFile();
        } else {
            installationDirectory = new File(runtimeDir, "..");
        }
        config.setInstallationDirectory(Application.makeCanonical(installationDirectory));
    }

    @NotNull
    private static File makeCanonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    @Nullable
    public static File getExeFile(ApplicationWithPath application) {
        if (application instanceof CustomApplication && !((CustomApplication)application).isCreateExecutable()) {
            return null;
        }
        File execDir = Application.getExecutableDir(application);
        File execFile = new File(execDir, application.getExecutableName() + (Util.isWindows() ? ".exe" : ""));
        try {
            return execFile.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return execFile;
        }
    }

    @Nullable
    private static File getExecutableDir(ApplicationWithPath application) {
        File execDir = application.getExecutableDirectory();
        if (execDir == null || execDir.getPath().trim().equals("")) {
            return ResourceHelper.getRuntimeDir();
        }
        return new File(ResourceHelper.getRuntimeDir(), "../" + execDir.getPath());
    }

    private static CustomApplication getCustomApplication() {
        com.install4j.runtime.beans.applications.Application application = InstallerConfig.getCurrentApplication();
        if (application instanceof CustomApplication) {
            return (CustomApplication)application;
        }
        return null;
    }
}

