/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.combobox.TreeComboBox;
import com.jidesoft.combobox.TreeComboBoxSearchable;
import com.jidesoft.combobox.TreeExComboBox;
import com.jidesoft.combobox.TreeExComboBoxSearchable;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.WildcardFilter;
import com.jidesoft.grid.ShrinkSearchableSupport;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.tree.FilterableTreeModel;
import com.jidesoft.tree.TreeUtils;
import com.jidesoft.utils.WildcardSupport;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class TreeComboBoxShrinkSearchableSupport
extends ShrinkSearchableSupport {
    private FilterableTreeModel _filterableTreeModel;

    public TreeComboBoxShrinkSearchableSupport(Searchable searchable) {
        super(searchable);
        if (this._searchable == null || !(this._searchable instanceof TreeExComboBoxSearchable) && !(this._searchable instanceof TreeComboBoxSearchable)) {
            throw new IllegalArgumentException("The searchable instance should be TreeExComboBoxSearchable or TreeComboBoxSearchable for TreeShrinkSearchableSupport");
        }
        if (this._searchable instanceof TreeExComboBoxSearchable) {
            ((TreeExComboBoxSearchable)this._searchable).setRecursive(false);
        } else if (this._searchable instanceof TreeComboBoxSearchable) {
            ((TreeComboBoxSearchable)this._searchable).setRecursive(false);
        }
    }

    @Override
    protected boolean needReinstallFilterableModel(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getSource() == this._searchable.getComponent() && this._filterableTreeModel != null && propertyChangeEvent.getNewValue() != this._filterableTreeModel;
    }

    @Override
    public void installFilterableModel() {
        Component component = this._searchable.getComponent();
        if (component instanceof TreeComboBox) {
            if (!this._searchable.isSearchableListenerInstalled(this)) {
                this._searchable.addSearchableListener(this);
            }
            this._filterableTreeModel = this.createFilterableTreeModel(((TreeComboBox)component).getTreeModel());
            component.removePropertyChangeListener("model", this);
            ((TreeComboBox)component).setTreeModel(this._filterableTreeModel);
            component.addPropertyChangeListener("model", this);
        } else if (component instanceof TreeExComboBox) {
            if (!this._searchable.isSearchableListenerInstalled(this)) {
                this._searchable.addSearchableListener(this);
            }
            this._filterableTreeModel = this.createFilterableTreeModel(((TreeExComboBox)component).getTreeModel());
            component.removePropertyChangeListener("model", this);
            ((TreeExComboBox)component).setTreeModel(this._filterableTreeModel);
            component.addPropertyChangeListener("model", this);
        }
    }

    protected FilterableTreeModel createFilterableTreeModel(TreeModel treeModel) {
        FilterableTreeModel filterableTreeModel = new FilterableTreeModel(treeModel);
        filterableTreeModel.setHideEmptyParentNode(true);
        filterableTreeModel.setMatchesLeafNodeOnly(true);
        return filterableTreeModel;
    }

    @Override
    public void uninstallFilterableModel() {
        this._searchable.getComponent().removePropertyChangeListener("model", this);
        if (this._filterableTreeModel != null) {
            this._searchable.removeSearchableListener(this);
            Component component = this._searchable.getComponent();
            if (component instanceof TreeComboBox) {
                ((TreeComboBox)component).setTreeModel(this._filterableTreeModel.getActualModel());
            } else if (component instanceof TreeExComboBox) {
                ((TreeExComboBox)component).setTreeModel(this._filterableTreeModel.getActualModel());
            }
            this._filterableTreeModel = null;
        }
    }

    @Override
    protected void applyFilter(String string) {
        int n;
        Enumeration<TreePath> enumeration = null;
        TreePath[] treePathArray = null;
        TreeSelectionListener[] treeSelectionListenerArray = null;
        TreeSelectionModel treeSelectionModel = null;
        JTree jTree = null;
        if (this._searchable.getComponent() instanceof TreeExComboBox) {
            jTree = ((TreeExComboBox)this._searchable.getComponent()).getTree();
        } else if (this._searchable.getComponent() instanceof TreeComboBox) {
            jTree = ((TreeComboBox)this._searchable.getComponent()).getTree();
        }
        if (jTree != null) {
            enumeration = TreeUtils.saveExpansionStateByTreePath(jTree);
            treePathArray = TreeUtils.saveSelection(jTree);
            SearchableUtils.uninstallSearchable(jTree);
            treeSelectionModel = jTree.getSelectionModel();
            if (treeSelectionModel instanceof DefaultTreeSelectionModel) {
                treeSelectionListenerArray = ((DefaultTreeSelectionModel)treeSelectionModel).getTreeSelectionListeners();
                for (n = treeSelectionListenerArray.length - 1; n >= 0; --n) {
                    TreeSelectionListener[] treeSelectionListenerArray2 = treeSelectionListenerArray[n];
                    treeSelectionModel.removeTreeSelectionListener((TreeSelectionListener)treeSelectionListenerArray2);
                }
            }
        }
        this._filterableTreeModel.clearFilters();
        if (string != null && string.length() > 0) {
            WildcardSupport wildcardSupport;
            if (this._searchable.isWildcardEnabled() && (wildcardSupport = this._searchable.getWildcardSupport()) != null) {
                string = wildcardSupport.convert(string);
            }
            WildcardFilter wildcardFilter = new WildcardFilter(string){
                private static final long serialVersionUID = -8657334053362079212L;

                @Override
                protected String convertElementToString(Object object) {
                    Object object2 = this.getObjectGrouper() == null ? object : this.getObjectGrouper().getValue(object);
                    String string = TreeComboBoxShrinkSearchableSupport.this.convertElementToString(object2);
                    if (string == null) {
                        string = super.convertElementToString(object);
                    }
                    return string != null ? string : ObjectConverterManager.toString(object2);
                }

                @Override
                protected Pattern createRegexPattern() {
                    return Pattern.compile(this.isBeginWith() ? "^" + this.getPattern() : this.getPattern(), this.isCaseSensitive() ? 0 : 2);
                }
            };
            wildcardFilter.setBeginWith(this._searchable.isFromStart());
            wildcardFilter.setEndWith(false);
            this._filterableTreeModel.addFilter(wildcardFilter);
        }
        n = this._searchable.isHideSearchPopupOnEvent();
        this._searchable.setHideSearchPopupOnEvent(false);
        this._filterableTreeModel.setFiltersApplied(true);
        this._searchable.setHideSearchPopupOnEvent(n != 0);
        if (jTree != null) {
            if (enumeration != null) {
                TreeUtils.loadExpansionStateByTreePath(jTree, enumeration);
            }
            if (treePathArray != null) {
                TreeUtils.loadSelection(jTree, treePathArray);
            }
            TreeUtils.expandAll(jTree, true);
            if (treeSelectionModel instanceof DefaultTreeSelectionModel && treeSelectionListenerArray != null && treeSelectionListenerArray.length > 0) {
                for (TreeSelectionListener treeSelectionListener : treeSelectionListenerArray) {
                    treeSelectionModel.addTreeSelectionListener(treeSelectionListener);
                }
            }
        }
    }

    @Override
    protected int getActualIndexAt(int n) {
        return n;
    }

    @Override
    protected int getVisualIndexAt(int n) {
        return n;
    }

    @Override
    protected boolean isRestoreSelection(int n, int n2) {
        return false;
    }
}

