/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.filter.Filter;
import com.jidesoft.list.FilterableListModel;
import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.tree.DefaultTreeModelWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilterableTreeModel
extends DefaultTreeModelWrapper {
    protected List<Filter> _filters = new ArrayList<Filter>();
    protected boolean _filtersApplied = false;
    private boolean _hideEmptyParentNode = true;
    private boolean _matchesLeafNodeOnly = true;
    private boolean _keepAllChildren = false;
    private boolean _filterEntireTreeImmediately = false;
    private boolean _refreshing = false;
    private boolean _andMode = true;

    public FilterableTreeModel() {
    }

    public FilterableTreeModel(TreeModel treeModel) {
        super(treeModel);
    }

    @Override
    protected ListModelWrapper createListModelWrapper(Object object) {
        return new FilterableListModelInTree();
    }

    @Override
    protected void configureListModelWrapper(ListModelWrapper listModelWrapper, Object object) {
        Object object2 = object;
        while (object2 != null) {
            if (this.isFilterEndNode(object2)) {
                return;
            }
            object2 = this.getParent(object2);
        }
        if (listModelWrapper instanceof FilterableListModel) {
            ((FilterableListModel)listModelWrapper).setAndMode(this.isAndMode());
            ((FilterableListModel)listModelWrapper).addFilters(this.internalGetFilters());
            ((FilterableListModel)listModelWrapper).setFiltersApplied(this.isFiltersApplied());
        }
    }

    protected boolean isFilterEndNode(Object object) {
        return false;
    }

    public void addFilters(List<Filter> list) {
        for (Filter filter : list) {
            this._filters.add(filter);
        }
        if (!this.isFilterEntireTreeImmediately()) {
            this.clearAllListModelWrappers();
        }
    }

    public void addFilter(Filter filter) {
        this._filters.add(filter);
        if (!this.isFilterEntireTreeImmediately()) {
            this.clearAllListModelWrappers();
        }
    }

    public void removeFilter(Filter filter) {
        this._filters.remove(filter);
        if (!this.isFilterEntireTreeImmediately()) {
            this.clearAllListModelWrappers();
        }
    }

    public void clearFilters() {
        this._filters.clear();
        if (!this.isFilterEntireTreeImmediately()) {
            this.clearAllListModelWrappers();
        }
    }

    public Filter[] getFilters() {
        List<Filter> list = this.internalGetFilters();
        if (list != null) {
            return list.toArray(new Filter[list.size()]);
        }
        return new Filter[0];
    }

    private List<Filter> internalGetFilters() {
        return this._filters;
    }

    public void setFiltersApplied(boolean bl) {
        this._filtersApplied = bl;
        this.refresh();
    }

    public void refresh() {
        this.clearAllListModelWrappers();
        if (this.isFilterEntireTreeImmediately() && this.isFiltersApplied()) {
            this.setupAllModelWrappers();
        }
        if (this.getRoot() == null) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.fireTreeStructureChanged(this, new TreePath(this.getRoot()));
        }
        finally {
            this.setRefreshing(false);
        }
    }

    private void setupAllModelWrappers() {
        Object object = this.getRoot();
        this.setupWrapperRecursively(object);
    }

    private void setupWrapperRecursively(Object object) {
        int n = this.getActualChildCount(object);
        if (n > 0) {
            this.initWrapper(object);
            for (int i = 0; i < n; ++i) {
                this.setupWrapperRecursively(this.getActualChildAt(object, i));
            }
        }
    }

    public boolean isFiltersApplied() {
        return this._filtersApplied;
    }

    public boolean isAndMode() {
        return this._andMode;
    }

    public void setAndMode(boolean bl) {
        this._andMode = bl;
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath() != null) {
            this.clearListModelWrapper(treeModelEvent.getTreePath().getLastPathComponent());
        }
        if (this.isFiltersApplied() && this.getFilters().length > 0) {
            this.updateTreeOnNodeInserted(treeModelEvent);
        } else {
            super.treeNodesInserted(treeModelEvent);
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        super.treeNodesRemoved(treeModelEvent);
        if (this.isFiltersApplied() && this.getFilters().length > 0) {
            this.clearFiltersOnTreePath(treeModelEvent.getTreePath());
            this.initWrapperOnTreePath(treeModelEvent.getTreePath());
            this.updateTreeOnNodeRemoved(treeModelEvent);
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.clearFiltersOnTreePath(treeModelEvent.getTreePath());
        super.treeStructureChanged(treeModelEvent);
        this.updateTreeOnStructureChanged(treeModelEvent);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath() != null) {
            this.clearListModelWrapper(treeModelEvent.getTreePath().getLastPathComponent());
        }
        super.treeNodesChanged(treeModelEvent);
        if (this.isFiltersApplied() && this.getFilters().length > 0) {
            this.updateTreeOnNodeChanged(treeModelEvent);
        }
    }

    public void clearFiltersOnTreePath(TreePath treePath) {
        if (treePath != null) {
            Object[] objectArray;
            for (Object object : objectArray = treePath.getPath()) {
                this.clearListModelWrapper(object);
            }
        }
    }

    void initWrapperOnTreePath(TreePath treePath) {
        if (treePath != null) {
            Object[] objectArray;
            for (Object object : objectArray = treePath.getPath()) {
                this.initWrapper(object);
            }
        }
    }

    protected void updateTreeOnNodeInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath() == null) {
            return;
        }
        TreePath treePath = treeModelEvent.getTreePath();
        if (this.isFiltered(treePath.getLastPathComponent())) {
            return;
        }
        TreePath treePath2 = null;
        while (treePath != null && this.isNewInserted(treePath.getLastPathComponent())) {
            treePath2 = treePath;
            treePath = treePath.getParentPath();
        }
        if (treePath2 != null) {
            if (treePath != null) {
                Object object = treePath2.getLastPathComponent();
                Object object2 = treePath.getLastPathComponent();
                int n = this.getActualModel().getIndexOfChild(object2, object);
                ListModelWrapper listModelWrapper = this.getListModelWrapperNotNull(object2);
                int n2 = JideSwingUtilities.binarySearch(listModelWrapper.getIndexes(), n);
                if (n2 >= 0) {
                    super.fireTreeNodesInserted(treeModelEvent.getSource(), treePath.getPath(), new int[]{n2}, new Object[]{object});
                }
            } else {
                super.fireTreeStructureChanged(treeModelEvent.getSource(), null);
            }
        } else {
            Object object = treePath.getLastPathComponent();
            ListModelWrapper listModelWrapper = this.getListModelWrapperNotNull(object);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            Object[] objectArray = treeModelEvent.getChildren();
            int objectArray2 = objectArray.length;
            for (int i = 0; i < objectArray2; ++i) {
                Object object2 = objectArray[i];
                int n = this.getActualModel().getIndexOfChild(object, object2);
                int n2 = JideSwingUtilities.binarySearch(listModelWrapper.getIndexes(), n);
                if (n2 < 0) continue;
                arrayList.add(n2);
                arrayList2.add(object2);
            }
            if (arrayList.size() > 0) {
                int[] nArray = new int[arrayList.size()];
                for (objectArray2 = 0; objectArray2 < nArray.length; ++objectArray2) {
                    nArray[objectArray2] = (Integer)arrayList.get(objectArray2);
                }
                Object[] objectArray3 = arrayList2.toArray(new Object[arrayList2.size()]);
                super.fireTreeNodesInserted(treeModelEvent.getSource(), treePath.getPath(), nArray, objectArray3);
            }
        }
    }

    protected void updateTreeOnNodeRemoved(TreeModelEvent treeModelEvent) {
        Object object;
        TreePath treePath;
        if (treeModelEvent.getTreePath() == null) {
            return;
        }
        TreePath treePath2 = null;
        for (treePath = treeModelEvent.getTreePath(); treePath != null && this.getActualChildCount(object = treePath.getLastPathComponent()) > 0 && this.isFiltered(object); treePath = treePath.getParentPath()) {
            treePath2 = treePath;
        }
        if (treePath2 != null) {
            if (treePath != null) {
                object = treePath2.getLastPathComponent();
                Object object2 = treePath.getLastPathComponent();
                int n = this.getActualModel().getIndexOfChild(object2, object);
                ListModelWrapper listModelWrapper = this.getListModelWrapperNotNull(object2);
                int n2 = JideSwingUtilities.binarySearch(listModelWrapper.getIndexes(), n);
                if (n2 <= 0) {
                    n2 = 0 - n2;
                    super.fireTreeNodesRemoved(treeModelEvent.getSource(), treePath.getPath(), new int[]{n2}, new Object[]{object});
                }
            } else {
                super.fireTreeStructureChanged(treeModelEvent.getSource(), null);
            }
        }
    }

    protected void updateTreeOnNodeChanged(TreeModelEvent treeModelEvent) {
        this.updateTree(treeModelEvent);
    }

    protected void updateTreeOnStructureChanged(TreeModelEvent treeModelEvent) {
        this.updateTree(treeModelEvent);
    }

    private boolean isNewInserted(Object object) {
        ListModelWrapper listModelWrapper = this.getListModelWrapper(object);
        if (listModelWrapper == null) {
            this.initWrapper(object);
            listModelWrapper = this.getListModelWrapper(object);
        }
        if (listModelWrapper == null) {
            return false;
        }
        if (this.getActualChildCount(object) <= 1) {
            return false;
        }
        int[] nArray = listModelWrapper.getIndexes();
        return nArray != null && nArray.length == 1;
    }

    protected boolean isFiltered(Object object) {
        ListModelWrapper listModelWrapper = this.getListModelWrapper(object);
        if (listModelWrapper == null) {
            this.initWrapper(object);
            listModelWrapper = this.getListModelWrapper(object);
        }
        if (listModelWrapper == null) {
            return false;
        }
        int[] nArray = listModelWrapper.getIndexes();
        return nArray != null && nArray.length <= 0;
    }

    protected void updateTree(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath() == null) {
            return;
        }
        TreePath treePath = treeModelEvent.getTreePath().getParentPath();
        if (treePath != null) {
            super.treeStructureChanged(new TreeModelEvent(treeModelEvent.getSource(), treePath));
        }
    }

    public boolean isFilterEntireTreeImmediately() {
        return this._filterEntireTreeImmediately;
    }

    public void setFilterEntireTreeImmediately(boolean bl) {
        this._filterEntireTreeImmediately = bl;
    }

    public boolean isHideEmptyParentNode() {
        return this._hideEmptyParentNode;
    }

    public void setHideEmptyParentNode(boolean bl) {
        if (this._hideEmptyParentNode != bl) {
            this._hideEmptyParentNode = bl;
            if (this._hideEmptyParentNode) {
                this.setFilterEntireTreeImmediately(true);
            }
            Filter[] filterArray = this.getFilters();
            if (this.isFiltersApplied() && filterArray != null && filterArray.length > 0) {
                this.refresh();
            }
        }
    }

    public boolean isMatchesLeafNodeOnly() {
        return this._matchesLeafNodeOnly;
    }

    public void setMatchesLeafNodeOnly(boolean bl) {
        if (this._matchesLeafNodeOnly != bl) {
            this._matchesLeafNodeOnly = bl;
            if (this.isMatchesLeafNodeOnly()) {
                this.setKeepAllChildren(false);
            }
            Filter[] filterArray = this.getFilters();
            if (this.isFiltersApplied() && filterArray != null && filterArray.length > 0) {
                this.refresh();
            }
        }
    }

    public boolean isKeepAllChildren() {
        return this._keepAllChildren;
    }

    public void setKeepAllChildren(boolean bl) {
        if (this._keepAllChildren != bl) {
            this._keepAllChildren = bl;
            if (this.isKeepAllChildren()) {
                this.setMatchesLeafNodeOnly(false);
            }
            Filter[] filterArray = this.getFilters();
            if (this.isFiltersApplied() && filterArray != null && filterArray.length > 0) {
                this.refresh();
            }
        }
    }

    boolean isRefreshing() {
        return this._refreshing;
    }

    void setRefreshing(boolean bl) {
        this._refreshing = bl;
    }

    private Object getActualChildAt(Object object, int n) {
        if (object != null && object instanceof TreeNode) {
            return ((TreeNode)object).getChildAt(n);
        }
        return null;
    }

    private int getActualChildCount(Object object) {
        if (object != null && object instanceof TreeNode) {
            return ((TreeNode)object).getChildCount();
        }
        return 0;
    }

    protected Object getParent(Object object) {
        if (object != null && object instanceof TreeNode) {
            return ((TreeNode)object).getParent();
        }
        return null;
    }

    private class FilterableListModelInTree
    extends FilterableListModel<Object> {
        private static final long serialVersionUID = 6925345132111963718L;

        private FilterableListModelInTree() {
        }

        private boolean superShouldBeFiltered(Object object, List<Filter<Object>> list) {
            return super.shouldBeFiltered(object, list);
        }

        @Override
        public boolean shouldBeFiltered(Object object, List<Filter<Object>> list) {
            if (FilterableTreeModel.this.isKeepAllChildren()) {
                boolean bl = this.superShouldBeFiltered(object, list);
                Object object2 = object;
                while (bl && (object2 = FilterableTreeModel.this.getParent(object2)) != null) {
                    ListModelWrapper listModelWrapper = FilterableTreeModel.this.getListModelWrapper(object2);
                    if (!(listModelWrapper instanceof FilterableListModelInTree)) continue;
                    if (!((FilterableListModelInTree)listModelWrapper).isFiltersApplied()) {
                        ((FilterableListModelInTree)listModelWrapper).setFiltersApplied(true);
                    }
                    bl = ((FilterableListModelInTree)listModelWrapper).superShouldBeFiltered(object2, list);
                }
                if (!bl) {
                    return bl;
                }
                return !this.shouldKeptForChildren(object, list);
            }
            if (FilterableTreeModel.this.isLeaf(object)) {
                return this.superShouldBeFiltered(object, list);
            }
            if (!FilterableTreeModel.this.isMatchesLeafNodeOnly()) {
                return !this.shouldKeptForChildren(object, list) && this.superShouldBeFiltered(object, list);
            }
            if (FilterableTreeModel.this.isHideEmptyParentNode()) {
                return !this.shouldKeptForChildren(object, list);
            }
            return false;
        }

        private boolean shouldKeptForChildren(Object object, List<Filter<Object>> list) {
            Object object2 = object;
            while (object2 != null) {
                if (FilterableTreeModel.this.isFilterEndNode(object2) && this.superShouldBeFiltered(object2, list)) {
                    return false;
                }
                object2 = FilterableTreeModel.this.getParent(object2);
            }
            return FilterableTreeModel.this.getChildCount(object) > 0;
        }
    }
}

