/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

class RelativePoint {
    private Component _component;
    private Point _pointOnComponent;
    private Component _originalComponent;
    private Point _originalPoint;

    public RelativePoint(MouseEvent mouseEvent) {
        this.init(mouseEvent.getComponent(), mouseEvent.getPoint());
        this._originalComponent = mouseEvent.getComponent();
        this._originalPoint = mouseEvent.getPoint();
    }

    public RelativePoint(Component component, Point point) {
        this.init(component, point);
    }

    public RelativePoint(Point point) {
        Point point2 = new Point(point.x, point.y);
        Window[] windowArray = Frame.getWindows();
        Window window = null;
        for (Window window2 : windowArray) {
            if (!window2.isActive()) continue;
            window = window2;
            break;
        }
        if (window == null) {
            window = JOptionPane.getRootFrame();
        }
        SwingUtilities.convertPointFromScreen(point2, window);
        this.init(window, point2);
    }

    private void init(Component component, Point point) {
        if (component.isShowing()) {
            this._component = SwingUtilities.getRootPane(component);
            this._pointOnComponent = SwingUtilities.convertPoint(component, point, this._component);
        } else {
            this._component = component;
            this._pointOnComponent = point;
        }
        this._originalComponent = this._component;
        this._originalPoint = this._pointOnComponent;
    }

    public Component getComponent() {
        return this._component;
    }

    public Point getPoint() {
        return this._pointOnComponent;
    }

    public Point getPoint(Component component) {
        if (component == null || component.getParent() == null || SwingUtilities.getWindowAncestor(component) == null) {
            return new Point();
        }
        return SwingUtilities.convertPoint(this.getComponent(), this.getPoint(), component);
    }

    public RelativePoint getPointOn(Component component) {
        Point point = this.getPoint(component);
        return new RelativePoint(component, point);
    }

    public Point getScreenPoint() {
        Point point = (Point)this.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, this.getComponent());
        return point;
    }

    public MouseEvent toMouseEvent() {
        return new MouseEvent(this._component, 0, 0L, 0, this._pointOnComponent.x, this._pointOnComponent.y, 1, false);
    }

    public String toString() {
        return this.getPoint() + " on " + this.getComponent().toString();
    }

    public static RelativePoint getCenterOf(JComponent jComponent) {
        Rectangle rectangle = jComponent.getVisibleRect();
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        return new RelativePoint(jComponent, point);
    }

    public static RelativePoint getSouthEastOf(JComponent jComponent) {
        Rectangle rectangle = jComponent.getVisibleRect();
        Point point = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        return new RelativePoint(jComponent, point);
    }

    public static RelativePoint getSouthWestOf(JComponent jComponent) {
        Rectangle rectangle = jComponent.getVisibleRect();
        Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
        return new RelativePoint(jComponent, point);
    }

    public static RelativePoint getNorthWestOf(JComponent jComponent) {
        Rectangle rectangle = jComponent.getVisibleRect();
        Point point = new Point(rectangle.x, rectangle.y);
        return new RelativePoint(jComponent, point);
    }

    public static RelativePoint getNorthEastOf(JComponent jComponent) {
        Rectangle rectangle = jComponent.getVisibleRect();
        Point point = new Point(rectangle.x + rectangle.width, rectangle.y);
        return new RelativePoint(jComponent, point);
    }

    public static RelativePoint fromScreen(Point point) {
        Frame frame = JOptionPane.getRootFrame();
        SwingUtilities.convertPointFromScreen(point, frame);
        return new RelativePoint(frame, point);
    }

    public Component getOriginalComponent() {
        return this._originalComponent;
    }

    public Point getOriginalPoint() {
        return this._originalPoint;
    }
}

