/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.tooltip.HeavyweightTip;
import com.jidesoft.tooltip.RelativePoint;
import com.jidesoft.tooltip.Tip;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public abstract class ExpandedTip<S extends JComponent> {
    public static final String CLIENT_PROPERTY_EXPANDED_TIP = "ExpandedTip";
    protected final S _component;
    private final TipComponent _rightTipComponent;
    private final TipComponent _leftTipComponent;
    private Tip _rightTip;
    private Tip _leftTip;
    private int _index = -1;
    private Rectangle _bounds;
    private BufferedImage _rightImage;
    private BufferedImage _leftImage;
    private Handler _handler;

    protected ExpandedTip(S s) {
        this._component = s;
        this._rightTipComponent = new TipComponent(true);
        this._leftTipComponent = new TipComponent(false);
        this._handler = new Handler();
        ((Component)this._component).addMouseListener(this._handler);
        ((Component)this._component).addMouseMotionListener(this._handler);
        ((Component)this._component).addFocusListener(this._handler);
        ((Component)this._component).addComponentListener(this._handler);
        ((Component)this._component).addHierarchyBoundsListener(this._handler);
        ((Component)this._component).addHierarchyListener(this._handler);
        this.updateClientProperty((JComponent)this._component, this);
    }

    public static ExpandedTip getExpandedTip(JComponent jComponent) {
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY_EXPANDED_TIP);
        if (object instanceof ExpandedTip) {
            return (ExpandedTip)object;
        }
        return null;
    }

    public void uninstall() {
        if (this._handler != null) {
            ((Component)this._component).removeMouseListener(this._handler);
            ((Component)this._component).removeMouseMotionListener(this._handler);
            ((Component)this._component).removeFocusListener(this._handler);
            ((Component)this._component).removeComponentListener(this._handler);
            ((Component)this._component).removeHierarchyBoundsListener(this._handler);
            ((Component)this._component).removeHierarchyListener(this._handler);
            ((JComponent)this._component).putClientProperty(CLIENT_PROPERTY_EXPANDED_TIP, null);
        }
    }

    protected void updateCurrentSelection() {
        this.handleSelectionChange(this._index, true);
    }

    private void handleMouseEvent(MouseEvent mouseEvent) {
        this.handleMouseEvent(mouseEvent, true);
    }

    private void handleMouseEvent(MouseEvent mouseEvent, boolean bl) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        if (bl || !JideSwingUtilities.equals(this._index, n)) {
            this.handleSelectionChange(n, true);
        }
    }

    protected void handleSelectionChange(int n) {
        this.handleSelectionChange(n, false);
    }

    protected void handleSelectionChange(int n, boolean bl) {
        this.doHandleSelectionChange(n, bl);
    }

    void doHandleSelectionChange(int n, boolean bl) {
        if (n == -1 || !((Component)this._component).isShowing() || !((Component)this._component).isFocusOwner() && !bl) {
            this.hideTip();
            return;
        }
        if (!JideSwingUtilities.equals(this._index, n)) {
            this.hideTip();
        }
        this._index = n;
        this.showTip();
    }

    void setIndex(int n) {
        this._index = n;
    }

    public void showTip() {
        Point point = this.createToolTipImage(this._index, true);
        Point point2 = this.createToolTipImage(this._index, false);
        if (point == null && point2 == null) {
            this.hideTip();
        } else {
            if (point != null && this._rightTip == null) {
                this.showRightTip(point);
            } else if (point != null) {
                this.repaintRightTip(point);
            }
            if (point2 != null && this._leftTip == null) {
                this.showLeftTip(point2);
            } else if (point2 != null) {
                this.repaintLeftTip(point2);
            }
        }
    }

    public void hideTip() {
        if (this._rightTip != null) {
            this._rightTip.hide();
            this._rightTip = null;
            this.repaintKeyItem();
        }
        if (this._leftTip != null) {
            this._leftTip.hide();
            this._leftTip = null;
            this.repaintKeyItem();
        }
        this._index = -1;
    }

    private void showRightTip(Point point) {
        if (this._rightImage == null) {
            this.createToolTipImage(this._index, true);
        }
        if (!((Component)this._component).isShowing()) {
            return;
        }
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (menuElementArray.length > 0) {
            return;
        }
        if (this._rightImage != null) {
            this._rightTip = new HeavyweightTip(this._rightTipComponent, false){

                @Override
                protected void setWindowShape(JWindow jWindow) {
                    ExpandedTip.this.setWindowShape(jWindow, true);
                }
            };
            this._rightTip.show((JComponent)this._component, point.x, point.y, (JComponent)this._component);
        }
        this.repaintKeyItem();
    }

    private void showLeftTip(Point point) {
        if (this._leftImage == null) {
            this.createToolTipImage(this._index, false);
        }
        if (!((Component)this._component).isShowing()) {
            return;
        }
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (menuElementArray.length > 0) {
            return;
        }
        if (this._leftImage != null) {
            this._leftTip = new HeavyweightTip(this._leftTipComponent, false){

                @Override
                protected void setWindowShape(JWindow jWindow) {
                    ExpandedTip.this.setWindowShape(jWindow, false);
                }
            };
            this._leftTip.show((JComponent)this._component, point.x, point.y, (JComponent)this._component);
        }
        this.repaintKeyItem();
    }

    protected void setWindowShape(JWindow jWindow, boolean bl) {
        if (this._component instanceof NavigationComponent) {
            try {
                GeneralPath generalPath = new GeneralPath();
                if (bl) {
                    generalPath.moveTo(0.0f, 0.0f);
                    generalPath.lineTo(jWindow.getWidth() - 2, 0.0f);
                    generalPath.quadTo(jWindow.getWidth() - 1, 1.0f, jWindow.getWidth(), 2.0f);
                    generalPath.lineTo(jWindow.getWidth(), jWindow.getHeight() - 2);
                    generalPath.quadTo(jWindow.getWidth() - 1, jWindow.getHeight() - 1, jWindow.getWidth() - 2, jWindow.getHeight());
                    generalPath.lineTo(0.0f, jWindow.getHeight());
                } else {
                    generalPath.moveTo(jWindow.getWidth(), 0.0f);
                    generalPath.lineTo(jWindow.getWidth(), jWindow.getHeight());
                    generalPath.lineTo(1.0f, jWindow.getHeight());
                    generalPath.quadTo(1.0f, jWindow.getHeight() - 1, 0.0f, jWindow.getHeight() - 2);
                    generalPath.lineTo(0.0f, 2.0f);
                    generalPath.quadTo(1.0f, 1.0f, 2.0f, 0.0f);
                    generalPath.lineTo(jWindow.getWidth(), 0.0f);
                }
                generalPath.closePath();
                JideSwingUtilities.setWindowShape(jWindow, generalPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void repaintRightTip(Point point) {
        if (this._rightTip != null && this._index != -1 && ((Component)this._component).isShowing()) {
            this._rightTip.setLocation(new RelativePoint((Component)this._component, point));
            this._rightTipComponent.repaint();
            this.repaintKeyItem();
        }
    }

    private void repaintLeftTip(Point point) {
        if (this._leftTip != null && this._index != -1 && ((Component)this._component).isShowing()) {
            this._leftTip.setLocation(new RelativePoint((Component)this._component, point));
            this._leftTipComponent.repaint();
            this.repaintKeyItem();
        }
    }

    private void repaintKeyItem() {
        if (this._bounds != null) {
            ((JComponent)this._component).repaint(this._bounds);
        }
    }

    protected Point createToolTipImage(int n, boolean bl) {
        Component component = this.getComponent(n);
        if (!(component instanceof JComponent)) {
            return null;
        }
        this._bounds = this.getRowBounds(n);
        if (this._bounds == null) {
            return null;
        }
        Rectangle rectangle = this._bounds;
        Rectangle rectangle2 = this.getVisibleRect(n);
        int n2 = bl ? rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width) : rectangle2.x - rectangle.x;
        int n3 = rectangle.height;
        if (n2 <= 0 || n3 <= 0) {
            return null;
        }
        if (rectangle.y < rectangle2.y) {
            return null;
        }
        if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            return null;
        }
        int n4 = SystemInfo.getDisplayScale();
        BufferedImage bufferedImage = this.createImage(n2 * n4, n3 * n4);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.scale(n4, n4);
        graphics2D.setClip(null);
        this.fillBackground(graphics2D, n2, n3);
        if (bl) {
            graphics2D.translate(-(rectangle2.x + rectangle2.width - rectangle.x), 0);
        }
        this.paintTipImage(graphics2D, component, rectangle, n, n4);
        if (this.shouldDrawBorder()) {
            int n5;
            graphics2D.setColor(Color.GRAY);
            int n6 = n4 == 1 ? n2 - 1 : n2;
            int n7 = n5 = n4 == 1 ? n3 - 1 : n3;
            if (bl) {
                graphics2D.translate(rectangle2.x + rectangle2.width - rectangle.x, 0);
                graphics2D.drawLine(0, 0, n6, 0);
                graphics2D.drawLine(n6, 0, n6, n5);
                graphics2D.drawLine(0, n5, n6, n5);
            } else {
                graphics2D.drawLine(0, 0, n6, 0);
                graphics2D.drawLine(0, 0, 0, n5);
                graphics2D.drawLine(0, n5, n2, n5);
            }
        }
        if (bl) {
            this._rightImage = bufferedImage;
        } else {
            this._leftImage = bufferedImage;
        }
        graphics2D.dispose();
        return bl ? new Point(rectangle2.x + rectangle2.width, rectangle.y) : new Point(rectangle.x, rectangle.y);
    }

    protected boolean shouldDrawBorder() {
        return !(this._component instanceof NavigationComponent);
    }

    protected BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 1);
    }

    protected void fillBackground(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(((Component)this._component).getBackground());
        graphics2D.fillRect(0, 0, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTipImage(Graphics2D graphics2D, Component component, Rectangle rectangle, int n, int n2) {
        BufferedImage bufferedImage = IconsFactory.createImage(component, rectangle, 1, n2);
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(0, 0, rectangle.width, rectangle.height);
        try {
            graphics2D2.scale(1.0 / (double)n2, 1.0 / (double)n2);
            graphics2D2.drawImage((Image)bufferedImage, 0, 0, (ImageObserver)this._component);
        }
        finally {
            graphics2D2.dispose();
        }
    }

    protected Rectangle getVisibleRect(int n) {
        return ((JComponent)this._component).getVisibleRect();
    }

    public S getComponent() {
        return this._component;
    }

    protected Component getComponent(int n) {
        return this._component;
    }

    protected abstract Rectangle getRowBounds(int var1);

    protected abstract int rowAtPoint(Point var1);

    private void updateClientProperty(JComponent jComponent, ExpandedTip expandedTip) {
        if (jComponent != null) {
            Object object = ((JComponent)this._component).getClientProperty(CLIENT_PROPERTY_EXPANDED_TIP);
            if (object instanceof ExpandedTip) {
                ((ExpandedTip)object).uninstall();
            }
            jComponent.putClientProperty(CLIENT_PROPERTY_EXPANDED_TIP, expandedTip);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(ExpandedTip.class.getName(), 2);
        }
    }

    private class TipComponent
    extends JComponent {
        final boolean _rightOrLeft;

        private TipComponent(boolean bl) {
            this._rightOrLeft = bl;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            int n = SystemInfo.getDisplayScale();
            return this._rightOrLeft ? new Dimension(ExpandedTip.this._rightImage.getWidth() / n, ExpandedTip.this._rightImage.getHeight() / n) : new Dimension(ExpandedTip.this._leftImage.getWidth() / n, ExpandedTip.this._leftImage.getHeight() / n);
        }

        @Override
        public void paint(Graphics graphics) {
            int n = SystemInfo.getDisplayScale();
            ((Graphics2D)graphics).scale(1.0 / (double)n, 1.0 / (double)n);
            graphics.drawImage(this._rightOrLeft ? ExpandedTip.this._rightImage : ExpandedTip.this._leftImage, 0, 0, null);
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener,
    FocusListener,
    ComponentListener,
    HierarchyBoundsListener,
    HierarchyListener {
        private Handler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ExpandedTip.this.hideTip();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ExpandedTip.this.handleMouseEvent(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ExpandedTip.this.handleMouseEvent(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 0) {
                ExpandedTip.this.handleMouseEvent(mouseEvent, false);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            ExpandedTip.this.hideTip();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            ExpandedTip.this.updateCurrentSelection();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            ExpandedTip.this.hideTip();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            ExpandedTip.this.updateCurrentSelection();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            ExpandedTip.this.updateCurrentSelection();
        }

        @Override
        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
            ExpandedTip.this.updateCurrentSelection();
        }

        @Override
        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            ExpandedTip.this.updateCurrentSelection();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            ExpandedTip.this.hideTip();
        }
    }
}

