/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.tuple;

import com.jidesoft.thirdparty.prefuse.data.Schema;
import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.event.TupleSetListener;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import com.jidesoft.thirdparty.prefuse.data.tuple.TupleSet;
import com.jidesoft.thirdparty.prefuse.data.util.FilterIteratorFactory;
import com.jidesoft.thirdparty.prefuse.util.collections.CopyOnWriteArrayList;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class AbstractTupleSet
implements TupleSet {
    private CopyOnWriteArrayList m_tupleListeners;
    private HashMap m_props;
    private SwingPropertyChangeSupport m_propSupport;

    @Override
    public Iterator tuples(Predicate predicate) {
        if (predicate == null) {
            return this.tuples();
        }
        return FilterIteratorFactory.tuples(this, predicate);
    }

    @Override
    public void addTupleSetListener(TupleSetListener tupleSetListener) {
        if (this.m_tupleListeners == null) {
            this.m_tupleListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_tupleListeners.contains(tupleSetListener)) {
            this.m_tupleListeners.add(tupleSetListener);
        }
    }

    @Override
    public void removeTupleSetListener(TupleSetListener tupleSetListener) {
        if (this.m_tupleListeners != null) {
            this.m_tupleListeners.remove(tupleSetListener);
        }
    }

    protected void fireTupleEvent(Table table, int n, int n2, int n3) {
        if (this.m_tupleListeners != null && this.m_tupleListeners.size() > 0) {
            Object[] objectArray = this.m_tupleListeners.getArray();
            Tuple[] tupleArray = new Tuple[n2 - n + 1];
            int n4 = 0;
            int n5 = n;
            while (n5 <= n2) {
                tupleArray[n4] = table.getTuple(n5);
                ++n5;
                ++n4;
            }
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                TupleSetListener tupleSetListener = (TupleSetListener)objectArray[n4];
                if (n3 == 1) {
                    tupleSetListener.tupleSetChanged(this, tupleArray, EMPTY_ARRAY);
                    continue;
                }
                tupleSetListener.tupleSetChanged(this, EMPTY_ARRAY, tupleArray);
            }
        }
    }

    protected void fireTupleEvent(Tuple tuple, int n) {
        if (this.m_tupleListeners != null && this.m_tupleListeners.size() > 0) {
            Object[] objectArray = this.m_tupleListeners.getArray();
            Tuple[] tupleArray = new Tuple[]{tuple};
            for (int i = 0; i < objectArray.length; ++i) {
                TupleSetListener tupleSetListener = (TupleSetListener)objectArray[i];
                if (n == 1) {
                    tupleSetListener.tupleSetChanged(this, tupleArray, EMPTY_ARRAY);
                    continue;
                }
                tupleSetListener.tupleSetChanged(this, EMPTY_ARRAY, tupleArray);
            }
        }
    }

    protected void fireTupleEvent(Tuple[] tupleArray, Tuple[] tupleArray2) {
        if (this.m_tupleListeners != null && this.m_tupleListeners.size() > 0) {
            Object[] objectArray = this.m_tupleListeners.getArray();
            tupleArray = tupleArray == null ? EMPTY_ARRAY : tupleArray;
            tupleArray2 = tupleArray2 == null ? EMPTY_ARRAY : tupleArray2;
            for (int i = 0; i < objectArray.length; ++i) {
                TupleSetListener tupleSetListener = (TupleSetListener)objectArray[i];
                tupleSetListener.tupleSetChanged(this, tupleArray, tupleArray2);
            }
        }
    }

    @Override
    public boolean isAddColumnSupported() {
        return false;
    }

    @Override
    public void addColumns(Schema schema) {
        if (this.isAddColumnSupported()) {
            for (int i = 0; i < schema.getColumnCount(); ++i) {
                try {
                    this.addColumn(schema.getColumnName(i), schema.getColumnType(i), schema.getDefault(i));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void addColumn(String string, Class clazz, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumn(String string, Class clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumn(String string, Expression expression) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumn(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.m_propSupport == null) {
            this.m_propSupport = new SwingPropertyChangeSupport(this);
        }
        this.m_propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.m_propSupport == null) {
            this.m_propSupport = new SwingPropertyChangeSupport(this);
        }
        this.m_propSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.m_propSupport == null) {
            return;
        }
        this.m_propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.m_propSupport == null) {
            return;
        }
        this.m_propSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void putClientProperty(String string, Object object) {
        Object object2 = null;
        if (this.m_props == null && object == null) {
            return;
        }
        if (object == null) {
            object2 = this.m_props.remove(string);
        } else {
            if (this.m_props == null) {
                this.m_props = new HashMap(2);
            }
            object2 = this.m_props.put(string, object);
        }
        if (this.m_propSupport != null) {
            this.m_propSupport.firePropertyChange(string, object2, object);
        }
    }

    @Override
    public Object getClientProperty(String string) {
        return this.m_props == null ? null : this.m_props.get(string);
    }
}

