/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.expression;

import com.jidesoft.thirdparty.prefuse.data.Schema;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.expression.BinaryExpression;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.ExpressionVisitor;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import com.jidesoft.thirdparty.prefuse.util.TypeLib;
import com.jidesoft.thirdparty.prefuse.util.collections.DefaultLiteralComparator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralComparator;
import java.util.Comparator;

public class RangePredicate
extends BinaryExpression
implements Predicate {
    public static final int IN_IN = 0;
    public static final int IN_EX = 1;
    public static final int EX_IN = 2;
    public static final int EX_EX = 3;
    private Expression m_middle;
    private Comparator m_cmp;

    public RangePredicate(Expression expression, Expression expression2, Expression expression3) {
        this(0, expression, expression2, expression3, DefaultLiteralComparator.getInstance());
    }

    public RangePredicate(Expression expression, Expression expression2, Expression expression3, Comparator comparator) {
        this(0, expression, expression2, expression3, comparator);
    }

    public RangePredicate(int n, Expression expression, Expression expression2, Expression expression3) {
        this(n, expression, expression2, expression3, DefaultLiteralComparator.getInstance());
    }

    public RangePredicate(int n, Expression expression, Expression expression2, Expression expression3, Comparator comparator) {
        super(n, 0, 3, expression2, expression3);
        this.m_middle = expression;
        this.m_cmp = comparator;
    }

    public Expression getMiddleExpression() {
        return this.m_middle;
    }

    public Comparator getComparator() {
        return this.m_cmp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getBoolean(Tuple tuple) {
        int n;
        Class clazz = this.m_left.getType(tuple.getSchema());
        Class clazz2 = this.m_right.getType(tuple.getSchema());
        Class clazz3 = this.m_middle.getType(tuple.getSchema());
        Class clazz4 = null;
        if (clazz.isAssignableFrom(clazz2)) {
            clazz4 = clazz;
        } else if (clazz2.isAssignableFrom(clazz)) {
            clazz4 = clazz2;
        }
        int n2 = 0;
        if (clazz4 != null && TypeLib.isNumericType(clazz4) && TypeLib.isNumericType(clazz3)) {
            Class clazz5 = TypeLib.getNumericType(clazz4, clazz3);
            if (clazz5 == Integer.TYPE) {
                int n3 = this.m_left.getInt(tuple);
                int n4 = this.m_right.getInt(tuple);
                int n5 = this.m_middle.getInt(tuple);
                n = ((LiteralComparator)this.m_cmp).compare(n5, n3);
                n2 = ((LiteralComparator)this.m_cmp).compare(n5, n4);
            } else if (clazz5 == Long.TYPE) {
                long l = this.m_left.getLong(tuple);
                long l2 = this.m_right.getLong(tuple);
                long l3 = this.m_middle.getLong(tuple);
                n = ((LiteralComparator)this.m_cmp).compare(l3, l);
                n2 = ((LiteralComparator)this.m_cmp).compare(l3, l2);
            } else if (clazz5 == Float.TYPE) {
                float f = this.m_left.getFloat(tuple);
                float f2 = this.m_right.getFloat(tuple);
                float f3 = this.m_middle.getFloat(tuple);
                n = ((LiteralComparator)this.m_cmp).compare(f3, f);
                n2 = ((LiteralComparator)this.m_cmp).compare(f3, f2);
            } else {
                if (clazz5 != Double.TYPE) throw new IllegalStateException();
                double d = this.m_left.getDouble(tuple);
                double d2 = this.m_right.getDouble(tuple);
                double d3 = this.m_middle.getDouble(tuple);
                n = ((LiteralComparator)this.m_cmp).compare(d3, d);
                n2 = ((LiteralComparator)this.m_cmp).compare(d3, d2);
            }
        } else {
            Object object = this.m_left.get(tuple);
            Object object2 = this.m_right.get(tuple);
            Object object3 = this.m_middle.get(tuple);
            n = this.m_cmp.compare(object3, object);
            n2 = this.m_cmp.compare(object3, object2);
        }
        switch (this.m_op) {
            case 0: {
                if (n < 0) return false;
                if (n2 > 0) return false;
                return true;
            }
            case 1: {
                if (n < 0) return false;
                if (n2 >= 0) return false;
                return true;
            }
            case 2: {
                if (n <= 0) return false;
                if (n2 > 0) return false;
                return true;
            }
            case 3: {
                if (n <= 0) return false;
                if (n2 >= 0) return false;
                return true;
            }
        }
        throw new IllegalStateException("Unknown operation.");
    }

    @Override
    public Class getType(Schema schema) {
        return Boolean.TYPE;
    }

    @Override
    public Object get(Tuple tuple) {
        return this.getBoolean(tuple) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void visit(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visitExpression(this);
        expressionVisitor.down();
        this.m_left.visit(expressionVisitor);
        expressionVisitor.up();
        expressionVisitor.down();
        this.m_middle.visit(expressionVisitor);
        expressionVisitor.up();
        expressionVisitor.down();
        this.m_right.visit(expressionVisitor);
        expressionVisitor.up();
    }

    @Override
    protected void addChildListeners() {
        super.addChildListeners();
        this.m_middle.addExpressionListener(this);
    }

    @Override
    protected void removeChildListeners() {
        super.removeChildListeners();
        this.m_middle.removeExpressionListener(this);
    }

    public String toString() {
        String string = "?";
        String string2 = "?";
        switch (this.m_op) {
            case 0: {
                string2 = "<=";
                string = "<=";
                break;
            }
            case 1: {
                string = "<=";
                string2 = "<";
                break;
            }
            case 2: {
                string = "<";
                string2 = "<=";
                break;
            }
            case 3: {
                string2 = "<";
                string = "<";
            }
        }
        return '(' + this.m_left.toString() + ' ' + string + ' ' + this.m_middle.toString() + " AND " + this.m_middle.toString() + ' ' + string2 + ' ' + this.m_right.toString() + ')';
    }
}

