/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.status;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.utils.SystemInfo;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ResizeStatusBarItem
extends LabelStatusBarItem {
    private boolean _resizeTopLevelAncestor;
    private boolean _stopRepaintDuringResizing = !SystemInfo.isJdk6Above();
    private StopEventQueue _eventQueue;

    public ResizeStatusBarItem() {
        this("RESIZE");
    }

    public ResizeStatusBarItem(String string) {
        this(string, true);
    }

    public ResizeStatusBarItem(boolean bl) {
        this("RESIZE", bl);
    }

    public ResizeStatusBarItem(String string, boolean bl) {
        super(string);
        this.setPreferredWidth(18);
        this._resizeTopLevelAncestor = bl;
        this.configureListener(this.getComponent());
    }

    @Override
    protected JLabel createLabel() {
        return new NullLabel(new ResizeIcon());
    }

    private void configureListener(Component component) {
        if (this._resizeTopLevelAncestor) {
            ResizableMouseInputAdapter resizableMouseInputAdapter = new ResizableMouseInputAdapter();
            component.addMouseListener(resizableMouseInputAdapter);
            component.addMouseMotionListener(resizableMouseInputAdapter);
        }
    }

    @Override
    protected void configureLabel(JLabel jLabel) {
        jLabel.setHorizontalTextPosition(0);
        jLabel.setVerticalTextPosition(0);
    }

    protected boolean isResizable() {
        Container container = this.getTopLevelAncestor();
        boolean bl = true;
        if (container instanceof Frame) {
            bl = ((Frame)container).isResizable() && ((Frame)container).getExtendedState() == 0;
        }
        return bl;
    }

    public void setStopRepaintDuringResizing(boolean bl) {
        this._stopRepaintDuringResizing = bl;
    }

    class StopEventQueue
    extends EventQueue {
        boolean _stop;

        StopEventQueue() {
        }

        public synchronized void setStop(boolean bl) {
            this._stop = bl;
        }

        @Override
        public void dispatchEvent(AWTEvent aWTEvent) {
            if (!(this._stop && aWTEvent.getID() == 800 || this._stop && aWTEvent.getID() == 101)) {
                super.dispatchEvent(aWTEvent);
            }
        }
    }

    public class ResizableMouseInputAdapter
    extends MouseInputAdapter {
        private Rectangle _startingBounds;
        private int _eventMouseScreenX;
        private int _eventMouseScreenY;
        private int _resizeCorner;
        protected static final int RESIZE_NONE = 0;
        private boolean _discardRelease = false;
        private Container _container;

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!ResizeStatusBarItem.this.isResizable()) {
                return;
            }
            if (!(mouseEvent.getSource() instanceof JComponent)) {
                return;
            }
            this._container = ((JComponent)mouseEvent.getSource()).getTopLevelAncestor();
            this._startingBounds = new Rectangle(this._container.getLocationOnScreen(), this._container.getSize());
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            this._eventMouseScreenX = point.x;
            this._eventMouseScreenY = point.y;
            this._resizeCorner = 16;
            Cursor cursor = Cursor.getDefaultCursor();
            switch (this._resizeCorner) {
                case 32: {
                    cursor = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 2: {
                    cursor = Cursor.getPredefinedCursor(8);
                    break;
                }
                case 128: {
                    cursor = Cursor.getPredefinedCursor(10);
                    break;
                }
                case 8: {
                    cursor = Cursor.getPredefinedCursor(11);
                    break;
                }
                case 16: {
                    cursor = Cursor.getPredefinedCursor(5);
                    break;
                }
                case 64: {
                    cursor = Cursor.getPredefinedCursor(4);
                    break;
                }
                case 1: {
                    cursor = Cursor.getPredefinedCursor(6);
                    break;
                }
                case 4: {
                    cursor = Cursor.getPredefinedCursor(7);
                }
            }
            Container container = this._container;
            if (container instanceof JFrame) {
                ((JFrame)container).getGlassPane().setVisible(true);
                ((JFrame)container).getGlassPane().setCursor(cursor);
            } else if (container instanceof JApplet) {
                ((JApplet)container).getGlassPane().setVisible(true);
                ((JApplet)container).getGlassPane().setCursor(cursor);
            } else if (container instanceof JWindow) {
                ((JWindow)container).getGlassPane().setVisible(true);
                ((JWindow)container).getGlassPane().setCursor(cursor);
            } else if (container instanceof JDialog) {
                ((JDialog)container).getGlassPane().setVisible(true);
                ((JDialog)container).getGlassPane().setCursor(cursor);
            }
            if (ResizeStatusBarItem.this._stopRepaintDuringResizing) {
                if (ResizeStatusBarItem.this._eventQueue == null) {
                    ResizeStatusBarItem.this._eventQueue = new StopEventQueue();
                    Toolkit.getDefaultToolkit().getSystemEventQueue().push(ResizeStatusBarItem.this._eventQueue);
                }
                ResizeStatusBarItem.this._eventQueue.setStop(true);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            int n2;
            if (this._startingBounds == null) {
                return;
            }
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            Component component = (Component)mouseEvent.getSource();
            SwingUtilities.convertPointToScreen(point, component);
            int n3 = this._eventMouseScreenX - point.x;
            int n4 = this._eventMouseScreenY - point.y;
            Dimension dimension = this._container.getMinimumSize();
            Dimension dimension2 = this._container.getMaximumSize();
            Rectangle rectangle = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            switch (this._resizeCorner) {
                case 0: {
                    return;
                }
                case 16: {
                    if (this._startingBounds.width - n3 < dimension.width) {
                        n3 = this._startingBounds.width - dimension.width;
                    } else if (this._startingBounds.width - n3 > dimension2.width) {
                        n3 = -(dimension2.width - this._startingBounds.width);
                    }
                    if (this._startingBounds.x + this._startingBounds.width - n3 > rectangle.width) {
                        n3 = this._startingBounds.x + this._startingBounds.width - rectangle.width;
                    }
                    if (this._startingBounds.height - n4 < dimension.height) {
                        n4 = this._startingBounds.height - dimension.height;
                    } else if (this._startingBounds.height - n4 > dimension2.height) {
                        n4 = -(dimension2.height - this._startingBounds.height);
                    }
                    if (this._startingBounds.y + this._startingBounds.height - n4 > rectangle.height) {
                        n4 = this._startingBounds.y + this._startingBounds.height - rectangle.height;
                    }
                    n2 = this._startingBounds.width - n3;
                    n = this._startingBounds.height - n4;
                    break;
                }
                default: {
                    return;
                }
            }
            Dimension dimension3 = new Dimension(n2, n);
            this._container.setSize(dimension3);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!ResizeStatusBarItem.this.isResizable()) {
                return;
            }
            if (ResizeStatusBarItem.this._stopRepaintDuringResizing) {
                ResizeStatusBarItem.this._eventQueue.setStop(false);
            }
            this._startingBounds = null;
            if (this._discardRelease) {
                this._discardRelease = false;
                return;
            }
            if (this._resizeCorner != 0) {
                Container container = this._container;
                if (container instanceof JFrame) {
                    ((JFrame)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JFrame)container).getGlassPane().setVisible(false);
                } else if (container instanceof JApplet) {
                    ((JApplet)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JApplet)container).getGlassPane().setVisible(false);
                } else if (container instanceof JWindow) {
                    ((JWindow)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JWindow)container).getGlassPane().setVisible(false);
                } else if (container instanceof JDialog) {
                    ((JDialog)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JDialog)container).getGlassPane().setVisible(false);
                }
                if (ResizeStatusBarItem.this._stopRepaintDuringResizing) {
                    Dimension dimension = this._container.getSize();
                    --dimension.width;
                    --dimension.height;
                    this._container.setSize(dimension);
                }
                this._eventMouseScreenX = 0;
                this._eventMouseScreenY = 0;
                this._startingBounds = null;
                this._resizeCorner = 0;
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (ResizeStatusBarItem.this.isResizable()) {
                ((Component)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(5));
            } else {
                ((Component)mouseEvent.getSource()).setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ((Component)mouseEvent.getSource()).setCursor(Cursor.getDefaultCursor());
        }
    }

    private class ResizeIcon
    implements Icon {
        private static final int WIDTH = 12;
        private static final int HEIGHT = 12;

        @Override
        public int getIconHeight() {
            return 12;
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Object object = UIDefaultsLookup.get("StatusBar.paintResizableIcon");
            boolean bl = ResizeStatusBarItem.this.isResizable();
            if (bl && (!(object instanceof Boolean) || ((Boolean)object).booleanValue())) {
                int n3 = 6;
                int n4 = 6;
                int n5 = 4;
                int n6 = 4;
                int n7 = n3 + n5;
                int n8 = n4 + n6;
                int n9 = n7 + n5;
                int n10 = n8 + n6;
                Color color = graphics.getColor();
                graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                this.drawSquare(graphics, n4 + 1, n9 + 1);
                this.drawSquare(graphics, n8 + 1, n7 + 1);
                this.drawSquare(graphics, n8 + 1, n9 + 1);
                this.drawSquare(graphics, n10 + 1, n3 + 1);
                this.drawSquare(graphics, n10 + 1, n7 + 1);
                this.drawSquare(graphics, n10 + 1, n9 + 1);
                graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
                this.drawSquare(graphics, n4, n9);
                this.drawSquare(graphics, n8, n7);
                this.drawSquare(graphics, n8, n9);
                this.drawSquare(graphics, n10, n3);
                this.drawSquare(graphics, n10, n7);
                this.drawSquare(graphics, n10, n9);
                graphics.setColor(color);
            }
        }

        private void drawSquare(Graphics graphics, int n, int n2) {
            graphics.fillRect(n, n2, 2, 2);
        }
    }
}

