/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.status;

import com.jidesoft.status.StatusBarItem;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;

public class LabelStatusBarItem
extends StatusBarItem {
    private JLabel _label;
    private String _name;

    public LabelStatusBarItem() {
        this("");
    }

    public LabelStatusBarItem(String string) {
        this._name = string;
        this.setLayout(new BorderLayout());
        this._label = this.createLabel();
        this.add(this._label);
        this.configureLabel(this._label);
    }

    protected JLabel createLabel() {
        return new NullLabel(){

            @Override
            public Point getToolTipLocation(MouseEvent mouseEvent) {
                if (SystemInfo.isJdk6Above()) {
                    return super.getToolTipLocation(mouseEvent);
                }
                Point point = this.getLocation();
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                point.y += this.getHeight() - fontMetrics.getHeight();
                return point;
            }
        };
    }

    protected void configureLabel(JLabel jLabel) {
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
    }

    public void setText(String string) {
        if (this._label != null) {
            this._label.setText(string);
        }
    }

    public String getText() {
        if (this._label != null) {
            return this._label.getText();
        }
        return null;
    }

    @Deprecated
    public void setToolTip(String string) {
        this.setToolTipText(string);
    }

    @Override
    public void setToolTipText(String string) {
        if (this._label != null) {
            this._label.setToolTipText(string);
        }
    }

    @Override
    public String getToolTipText() {
        if (this._label != null) {
            return this._label.getToolTipText();
        }
        return null;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        if (SystemInfo.isJdk6Above()) {
            return super.getToolTipLocation(mouseEvent);
        }
        Point point = this.getLocation();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        point.y += this.getHeight() - fontMetrics.getHeight();
        return point;
    }

    public void setIcon(Icon icon) {
        if (this._label != null) {
            this._label.setIcon(icon);
        }
    }

    public void setHorizontalAlignment(int n) {
        if (this._label != null) {
            this._label.setHorizontalAlignment(n);
        }
    }

    public int getHorizontalAlignment() {
        if (this._label != null) {
            return this._label.getHorizontalAlignment();
        }
        return 10;
    }

    public Icon getIcon() {
        if (this._label != null) {
            return this._label.getIcon();
        }
        return null;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this._label != null) {
            this._label.setEnabled(bl);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (this._label != null) {
            this._label.addMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (this._label != null) {
            this._label.removeMouseListener(mouseListener);
        }
    }

    @Override
    public synchronized MouseListener[] getMouseListeners() {
        if (this._label != null) {
            return this._label.getMouseListeners();
        }
        return null;
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this._label != null) {
            this._label.addMouseMotionListener(mouseMotionListener);
        }
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this._label != null) {
            this._label.removeMouseMotionListener(mouseMotionListener);
        }
    }

    @Override
    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        if (this._label != null) {
            return this._label.getMouseMotionListeners();
        }
        return null;
    }

    public void setAlignment(int n) {
        if (this._label != null) {
            this._label.setHorizontalAlignment(n);
        }
    }

    public Component getComponent() {
        return this._label;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getPreferredWidth() == 0) {
            return new Dimension(this._label.getPreferredSize().width + this.getInsets().left + this.getInsets().right, super.getPreferredSize().height);
        }
        return super.getPreferredSize();
    }

    @Override
    public String getItemName() {
        return this._name;
    }
}

