/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.search;

import com.jidesoft.search.FindAndReplaceEvent;
import com.jidesoft.search.FindAndReplaceListener;
import com.jidesoft.search.FindAndReplaceTarget;
import com.jidesoft.search.FindResult;
import com.jidesoft.search.FindResults;
import com.jidesoft.search.PromptDialog;
import com.jidesoft.utils.DefaultWildcardSupport;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.StringUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;

public class FindAndReplace {
    private static Logger LOGGER;
    public static final int SCOPE_GLOBAL = 0;
    public static final int SCOPE_SELECTION = 1;
    public static final int ORIGIN_ENTIRE = 0;
    public static final int ORIGIN_FROM_CURSOR = 1;
    private List<FindAndReplaceTarget> _targets;
    private FindAndReplaceTarget _selectedTarget;
    private String _findText;
    private String _replaceText;
    private Vector<String> _findHistory = new Vector();
    private Vector<String> _replaceHistory = new Vector();
    private boolean _useRegexOrWildcards;
    private boolean _useRegex = true;
    private boolean _useWildcards = false;
    private boolean _matchCase = false;
    private boolean _matchWholeWord = false;
    private int _scope = 0;
    private int _origin = 1;
    private Matcher _lastSearch;
    private boolean _forward = true;
    private boolean _reversed = false;
    private boolean _replace;
    private boolean _showFindAll = true;
    private int _textLength = 0;
    private StringBuilder _text = null;
    private EventListenerList _listenerList = null;
    protected Pattern _pattern;
    private Rectangle _promptDialogBounds;
    private boolean _targetChanged;
    private boolean _searchFromStart = false;
    public static FindResult EMPTY_RESULT;

    public FindAndReplaceTarget getTarget() {
        return this._selectedTarget == null && this._targets != null && this._targets.size() == 1 ? this._targets.get(0) : this._selectedTarget;
    }

    public void setTarget(FindAndReplaceTarget findAndReplaceTarget) {
        if (this._selectedTarget != findAndReplaceTarget) {
            this._selectedTarget = findAndReplaceTarget;
            this._targetChanged = true;
        }
    }

    public void addTarget(FindAndReplaceTarget findAndReplaceTarget) {
        if (this._targets == null) {
            this._targets = new ArrayList<FindAndReplaceTarget>();
        }
        this._targets.add(findAndReplaceTarget);
    }

    public void removeTarget(FindAndReplaceTarget findAndReplaceTarget) {
        this._targets.remove(findAndReplaceTarget);
    }

    public FindAndReplaceTarget[] getTargets() {
        return this._targets.toArray(new FindAndReplaceTarget[this._targets.size()]);
    }

    public String getFindText() {
        return this._findText;
    }

    public void setFindText(String string) {
        this._findText = string;
    }

    public String getReplaceText() {
        return this._replaceText;
    }

    public void setReplaceText(String string) {
        this._replaceText = string;
    }

    public Vector<String> getFindHistory() {
        return this._findHistory;
    }

    public void setFindHistory(Vector<String> vector) {
        this._findHistory = vector;
    }

    public Vector<String> getReplaceHistory() {
        return this._replaceHistory;
    }

    public void setReplaceHistory(Vector<String> vector) {
        this._replaceHistory = vector;
    }

    public boolean isUseRegexOrWildcards() {
        return this._useRegexOrWildcards;
    }

    public void setUseRegexOrWildcards(boolean bl) {
        this._useRegexOrWildcards = bl;
    }

    public boolean isUseWildcards() {
        return this._useWildcards;
    }

    public void setUseWildcards(boolean bl) {
        this._useWildcards = bl;
    }

    public boolean isUseRegex() {
        return this._useRegex;
    }

    public void setUseRegex(boolean bl) {
        this._useRegex = bl;
    }

    public boolean isMatchWholeWord() {
        return this._matchWholeWord;
    }

    public void setMatchWholeWord(boolean bl) {
        this._matchWholeWord = bl;
    }

    public boolean isMatchCase() {
        return this._matchCase;
    }

    public void setMatchCase(boolean bl) {
        this._matchCase = bl;
    }

    public int getScope() {
        return this._scope;
    }

    public void setScope(int n) {
        this._scope = n;
    }

    public int getOrigin() {
        return this._origin;
    }

    public void setOrigin(int n) {
        this._origin = n;
    }

    public void searchAgain() {
        if (this._lastSearch != null) {
            this.initialCharSequence();
            this.search(this._lastSearch);
        }
    }

    protected int getFlags() {
        int n = 0;
        if (!this.isMatchCase()) {
            n |= 2;
        }
        return n |= 8;
    }

    protected Matcher getMatcher() {
        String string = this.getFindText();
        if (this.isUseRegexOrWildcards()) {
            if (!this.isUseRegex() && this.isUseWildcards()) {
                DefaultWildcardSupport defaultWildcardSupport = new DefaultWildcardSupport();
                string = defaultWildcardSupport.convert(string);
                string = string.replaceAll("\\[\\!", "[^");
                string = string.replaceAll("#", "\\\\d");
                string = string.replaceAll("\\#", "#");
            }
        } else {
            string = string.replaceAll("([\\{\\}\\[\\]\\(\\)\\$\\^\\.\\*\\\\\\+\\?\\|])", "\\\\$1");
        }
        this._pattern = Pattern.compile(this.isMatchWholeWord() ? "\\b" + string + "\\b" : string, this.getFlags());
        this.initialCharSequence();
        return this._pattern.matcher(this._text);
    }

    protected void initialCharSequence() {
        if (this._text == null || this._targetChanged || this.getTarget().isTargetChanged()) {
            this._text = new StringBuilder(this.getTarget().getCurrentText());
            this._targetChanged = false;
            int n = this._textLength = this._text != null ? this._text.length() : 0;
            if (this._lastSearch != null) {
                this._lastSearch = this._pattern.matcher(this._text);
            }
        }
    }

    public void search() {
        if (this.getFindText() == null || this.getFindText().length() == 0) {
            return;
        }
        this.fireFindAndReplaceEvent(0);
        this.setForward(!this.isReversed());
        this._searchFromStart = this.getOrigin() == 0;
        Matcher matcher = null;
        try {
            matcher = this.getMatcher();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.fireFindAndReplaceEvent(3, this.getTarget().getCurrentName());
            this.getTarget().showMessage(MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.notFound"), this.getFindText()));
            this.fireFindAndReplaceEvent(2);
            return;
        }
        this.getTarget().adjustCurrentPosition(this.getFindText(), this.isForward());
        this.search(matcher);
    }

    public FindResults searchAll() {
        if (this.getFindText() == null || this.getFindText().length() == 0) {
            return null;
        }
        this.setForward(true);
        int n = 0;
        this.fireFindAndReplaceEvent(0);
        FindResults findResults = new FindResults(this.getTarget().getResourceString("FindAndReplace.foundUsages"), this.getTarget().getIntepreter());
        FindResults findResults2 = new FindResults(this.getTarget().getCurrentName(), this.getTarget().getIntepreter());
        this.fireFindAndReplaceEvent(1, this.getTarget().getCurrentName());
        try {
            while (true) {
                Matcher matcher;
                this._lastSearch = matcher = this.getMatcher();
                FindResult findResult = this.findNext(matcher, n);
                if (EMPTY_RESULT == findResult) {
                    findResults.addFindResults(findResults2);
                    this.fireFindAndReplaceEvent(3, this.getTarget().getCurrentName(), findResults2);
                    if (!this.getTarget().hasNext()) break;
                    this.getTarget().next();
                    findResults2 = new FindResults(this.getTarget().getCurrentName(), this.getTarget().getIntepreter());
                    n = 0;
                    this.textChanged();
                    this.fireFindAndReplaceEvent(1, this.getTarget().getCurrentName());
                    continue;
                }
                findResults2.addFindResult(findResult);
                n = findResult.getEnd();
                this.fireFindAndReplaceEvent(4, findResult);
            }
            this.fireFindAndReplaceEvent(2, findResults);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.fireFindAndReplaceEvent(3, this.getTarget().getCurrentName());
            this.getTarget().showMessage(MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.notFound"), this.getFindText()));
            this.fireFindAndReplaceEvent(2);
        }
        return findResults;
    }

    public void search(Matcher matcher) {
        int n;
        boolean bl;
        boolean bl2;
        boolean bl3;
        block19: {
            block20: {
                int n2;
                bl3 = false;
                int n3 = this._searchFromStart ? (this.isForward() ? 0 : this._textLength) : (n2 = this.getTarget().getCurrentPosition(this.isForward()));
                if (this._searchFromStart) {
                    this._searchFromStart = false;
                }
                bl2 = false;
                bl = false;
                n = 0;
                while (true) {
                    int n4;
                    ++n;
                    FindResult findResult = this.findNext(matcher, n2);
                    if (findResult == EMPTY_RESULT) {
                        this.fireFindAndReplaceEvent(3, this.getTarget().getCurrentName());
                        if (this.getTarget().hasNext()) {
                            this.getTarget().next();
                            n2 = 0;
                            bl = false;
                            matcher = this.getMatcher();
                            this.fireFindAndReplaceEvent(1, this.getTarget().getCurrentName());
                            continue;
                        }
                        break block19;
                    }
                    if (!bl2 && !bl) {
                        this.getTarget().highlight(findResult.getStart(), findResult.getEnd());
                    }
                    this.fireFindAndReplaceEvent(4, findResult);
                    if (!this.isReplace()) break block20;
                    String string = this.getReplaceText();
                    if (this.isUseRegexOrWildcards() && this.isUseRegex()) {
                        try {
                            string = this.getTarget().getCurrentText().subSequence(findResult.getStart(), findResult.getEnd()).toString().replaceAll(this.getFindText(), FindAndReplace.unescapeReplaceString(this.getReplaceText()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bl2 || bl) {
                        n4 = this.replace(findResult, string);
                        this._textLength += n4;
                        int n5 = n2 = this.isReversed() ? findResult.getStart() - 1 : findResult.getStart() + n4 + 1;
                        if (this.getTarget().isTargetChanged()) {
                            this.textChanged();
                        } else {
                            this._text.replace(findResult.getStart(), findResult.getEnd(), string);
                        }
                        matcher = this.getMatcher();
                        continue;
                    }
                    n4 = this.promptForReplace();
                    switch (n4) {
                        case 0: {
                            int n6 = this.replace(findResult, string);
                            n2 = this.isReversed() ? findResult.getStart() - 1 : findResult.getStart() + n6 + 1;
                            matcher = this.getMatcher();
                            break;
                        }
                        case 1: {
                            n2 = this.isReversed() ? findResult.getStart() - 1 : findResult.getStart() + 1;
                            break;
                        }
                        case 2: {
                            this.getTarget().replaceAllStarts();
                            n = 0;
                            int n6 = this.replace(findResult, string);
                            n2 = this.isReversed() ? findResult.getStart() - 1 : findResult.getStart() + n6 + 1;
                            this.textChanged();
                            matcher = this.getMatcher();
                            bl2 = true;
                            break;
                        }
                        case 3: {
                            this.getTarget().replaceAllStarts();
                            bl = true;
                            break;
                        }
                    }
                    if (n4 == -1) break;
                }
                bl3 = true;
                break block19;
            }
            bl3 = true;
        }
        if (!(bl2 || bl || bl3)) {
            this.searchFinished();
        }
        if (bl2 || bl) {
            this.getTarget().replaceAllEnds();
            this.getTarget().showMessage(MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.replacedAll"), n));
        }
        this._lastSearch = matcher;
    }

    private static String unescapeReplaceString(String string) {
        return StringUtils.unescapeJava(string.replace("\\$", "\\\\$"));
    }

    protected int promptForReplace() {
        Window window = this.getTarget().getPromptDialogParent();
        boolean bl = this.getTarget().hasNext();
        PromptDialog promptDialog = window instanceof Frame ? new PromptDialog((Frame)window, this.getTarget().getResourceString("FindAndReplace.replaceTitle"), MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.replaceMessage"), this.getReplaceText()), bl, this.getTarget()) : new PromptDialog((Dialog)window, this.getTarget().getResourceString("FindAndReplace.replaceTitle"), MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.replaceMessage"), this.getReplaceText()), bl, this.getTarget());
        promptDialog.pack();
        Point point = this.getTarget().getPromptDialogLocation(promptDialog.getBounds());
        if (point != null) {
            promptDialog.setLocation(point);
        } else {
            if (this._promptDialogBounds != null) {
                promptDialog.setBounds(this._promptDialogBounds);
            } else {
                promptDialog.setLocation(this.getTarget().getPromptDialogLocation());
            }
            this.getTarget().scrollToShowCaret(promptDialog.getBounds());
            promptDialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (componentEvent.getSource() instanceof PromptDialog) {
                        FindAndReplace.this._promptDialogBounds = ((PromptDialog)componentEvent.getSource()).getBounds();
                    }
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    if (componentEvent.getSource() instanceof PromptDialog) {
                        FindAndReplace.this._promptDialogBounds = ((PromptDialog)componentEvent.getSource()).getBounds();
                    }
                }
            });
        }
        promptDialog.setVisible(true);
        return promptDialog.getDialogResult();
    }

    protected FindResult findNext(Matcher matcher, int n) {
        boolean bl = this.isForward();
        if (n >= this._textLength && bl) {
            return EMPTY_RESULT;
        }
        if (n <= 0 && !bl) {
            return EMPTY_RESULT;
        }
        if (bl) {
            if (n < 0) {
                n = 0;
            }
            if (matcher.find(n) && matcher.end() <= this._textLength) {
                return new FindResult(matcher.start(), matcher.end(), this.getTarget().getIntepreter());
            }
            return EMPTY_RESULT;
        }
        int n2 = -1;
        matcher.reset();
        int n3 = -1;
        while (matcher.find() && matcher.end() <= n) {
            n2 = matcher.start();
            n3 = matcher.end();
        }
        if (n2 < 0) {
            return EMPTY_RESULT;
        }
        return new FindResult(n2, n3, this.getTarget().getIntepreter());
    }

    public int replace(FindResult findResult, String string) {
        try {
            this.getTarget().replace(findResult.getStart(), findResult.getEnd() - findResult.getStart(), string);
            this.fireFindAndReplaceEvent(5, findResult, string);
            return string.length() - (findResult.getEnd() - findResult.getStart());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public void textChanged() {
        this._text = null;
        this._textLength = 0;
    }

    protected void searchFinished() {
        boolean bl;
        boolean bl2 = this.isForward();
        try {
            this.setForward(true);
            bl = this.findNext(this.getMatcher(), 0) != EMPTY_RESULT;
        }
        finally {
            this.setForward(bl2);
        }
        if (!bl) {
            this.getTarget().showMessage(MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.notFound"), this.getFindText()));
        } else if (this.isForward()) {
            this.getTarget().showMessage(MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.notFoundFromTop"), this.getFindText(), this.isReversed() ? this.getTarget().getResourceString("FindAndReplace.backwardSearchKeyStroke") : this.getTarget().getResourceString("FindAndReplace.forwardSearchKeyStroke")));
            this._searchFromStart = true;
        } else {
            this.getTarget().showMessage(MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.notFoundFromBottom"), this.getFindText(), this.isReversed() ? this.getTarget().getResourceString("FindAndReplace.forwardSearchKeyStroke") : this.getTarget().getResourceString("FindAndReplace.backwardSearchKeyStroke")));
            this._searchFromStart = true;
        }
        this.fireFindAndReplaceEvent(2);
    }

    public boolean isForward() {
        return this._forward;
    }

    public void setForward(boolean bl) {
        boolean bl2 = this._forward;
        if (bl2 != bl) {
            this._forward = bl;
        }
    }

    public boolean isReversed() {
        return this._reversed;
    }

    public void setReversed(boolean bl) {
        boolean bl2 = this._reversed;
        if (bl2 != bl) {
            this._reversed = bl;
        }
    }

    public boolean isReplace() {
        return this._replace;
    }

    public void setReplace(boolean bl) {
        this._replace = bl;
    }

    public boolean isShowFindAll() {
        return this._showFindAll;
    }

    public void setShowFindAll(boolean bl) {
        this._showFindAll = bl;
    }

    public synchronized void addFindAndReplaceListener(FindAndReplaceListener findAndReplaceListener) {
        if (this._listenerList == null) {
            this._listenerList = new EventListenerList();
        }
        this._listenerList.add(FindAndReplaceListener.class, findAndReplaceListener);
    }

    public synchronized void removeFindAndReplaceListener(FindAndReplaceListener findAndReplaceListener) {
        this._listenerList.remove(FindAndReplaceListener.class, findAndReplaceListener);
    }

    public FindAndReplaceListener[] getFindAndReplaceListeners() {
        return (FindAndReplaceListener[])this._listenerList.getListeners(FindAndReplaceListener.class);
    }

    protected void fireFindAndReplaceEvent(int n) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new FindAndReplaceEvent(this, n).toString());
        }
        if (this._listenerList == null) {
            return;
        }
        Object[] objectArray = this._listenerList.getListenerList();
        FindAndReplaceEvent findAndReplaceEvent = new FindAndReplaceEvent(this, n);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FindAndReplaceListener.class) continue;
            ((FindAndReplaceListener)objectArray[i + 1]).statusChanged(findAndReplaceEvent);
        }
    }

    protected void fireFindAndReplaceEvent(int n, FindResults findResults) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new FindAndReplaceEvent((Object)this, n, findResults).toString());
        }
        if (this._listenerList == null) {
            return;
        }
        Object[] objectArray = this._listenerList.getListenerList();
        FindAndReplaceEvent findAndReplaceEvent = new FindAndReplaceEvent((Object)this, n, findResults);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FindAndReplaceListener.class) continue;
            ((FindAndReplaceListener)objectArray[i + 1]).statusChanged(findAndReplaceEvent);
        }
    }

    protected void fireFindAndReplaceEvent(int n, FindResult findResult) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new FindAndReplaceEvent((Object)this, n, findResult).toString());
        }
        if (this._listenerList == null) {
            return;
        }
        Object[] objectArray = this._listenerList.getListenerList();
        FindAndReplaceEvent findAndReplaceEvent = new FindAndReplaceEvent((Object)this, n, findResult);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FindAndReplaceListener.class) continue;
            ((FindAndReplaceListener)objectArray[i + 1]).statusChanged(findAndReplaceEvent);
        }
    }

    protected void fireFindAndReplaceEvent(int n, FindResult findResult, String string) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new FindAndReplaceEvent((Object)this, n, findResult, string).toString());
        }
        if (this._listenerList == null) {
            return;
        }
        Object[] objectArray = this._listenerList.getListenerList();
        FindAndReplaceEvent findAndReplaceEvent = new FindAndReplaceEvent((Object)this, n, findResult, string);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FindAndReplaceListener.class) continue;
            ((FindAndReplaceListener)objectArray[i + 1]).statusChanged(findAndReplaceEvent);
        }
    }

    protected void fireFindAndReplaceEvent(int n, String string, FindResults findResults) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new FindAndReplaceEvent((Object)this, n, string, findResults).toString());
        }
        if (this._listenerList == null) {
            return;
        }
        Object[] objectArray = this._listenerList.getListenerList();
        FindAndReplaceEvent findAndReplaceEvent = new FindAndReplaceEvent((Object)this, n, string, findResults);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FindAndReplaceListener.class) continue;
            ((FindAndReplaceListener)objectArray[i + 1]).statusChanged(findAndReplaceEvent);
        }
    }

    protected void fireFindAndReplaceEvent(int n, String string) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new FindAndReplaceEvent((Object)this, n, string).toString());
        }
        if (this._listenerList == null) {
            return;
        }
        Object[] objectArray = this._listenerList.getListenerList();
        FindAndReplaceEvent findAndReplaceEvent = new FindAndReplaceEvent((Object)this, n, string);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FindAndReplaceListener.class) continue;
            ((FindAndReplaceListener)objectArray[i + 1]).statusChanged(findAndReplaceEvent);
        }
    }

    public boolean isTargetChanged() {
        return this._targetChanged;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(128)) {
            Lm.showInvalidProductMessage(FindAndReplace.class.getName(), 128);
        }
        LOGGER = Logger.getLogger(FindAndReplace.class.getName());
        EMPTY_RESULT = new FindResult(-1, -1, null);
    }
}

