/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.scale;

import com.jidesoft.gantt.GanttChart;
import com.jidesoft.scale.Period;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.scale.ScaleAreaPopupMenuCustomizer;
import com.jidesoft.scale.ScaleModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ResizePeriodsPopupMenuCustomizer<T>
implements ScaleAreaPopupMenuCustomizer<T>,
ActionListener {
    public static final String RESOURCE_PREFIX = "ScaleArea.MenuItem.";
    public static final String AUTO_RESIZE_PERIODS = "autoResizePeriods";
    public static final String AUTO_RESIZE_PERIODS_VISIBLE_ENTRIES = "autoResizePeriodsVisibleEntries";
    public static final String RESIZE_PERIOD_TO_FIT = "resizePeriodToFit";
    public static final String ZOOM_IN = "zoomIn";
    public static final String ZOOM_OUT = "zoomOut";
    private final GanttChart<T, ?> _chart;
    private ScaleArea<T> _scaleArea;
    private Period _clickedPeriod;
    private T _clickedInstant;

    public ResizePeriodsPopupMenuCustomizer(GanttChart<T, ?> ganttChart) {
        this._chart = ganttChart;
    }

    @Override
    public void customizePopup(JPopupMenu jPopupMenu, ScaleArea<T> scaleArea, Period period, T t) {
        this._scaleArea = scaleArea;
        this._clickedPeriod = period;
        this._clickedInstant = t;
        jPopupMenu.add(this.createMenuItem(AUTO_RESIZE_PERIODS));
        jPopupMenu.add(this.createMenuItem(AUTO_RESIZE_PERIODS_VISIBLE_ENTRIES));
        if (period != null) {
            jPopupMenu.add(this.createMenuItem(RESIZE_PERIOD_TO_FIT));
        }
        jPopupMenu.add(this.createMenuItem(ZOOM_IN));
        jPopupMenu.add(this.createMenuItem(ZOOM_OUT));
    }

    private JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(this.getResourceString(string));
        jMenuItem.setName(string);
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(this._scaleArea.getScaleModel() != null);
        return jMenuItem;
    }

    protected String getResourceString(String string) {
        return this._scaleArea.getResourceString(RESOURCE_PREFIX + string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (AUTO_RESIZE_PERIODS.equals(string)) {
            this._chart.autoResizePeriods(false);
        } else if (AUTO_RESIZE_PERIODS_VISIBLE_ENTRIES.equals(string)) {
            this._chart.autoResizePeriods(true);
        } else if (RESIZE_PERIOD_TO_FIT.equals(string)) {
            ScaleArea<T> scaleArea = this._chart.getScaleArea();
            ScaleModel<T> scaleModel = scaleArea.getScaleModel();
            T t = scaleModel.getPeriodStart(this._clickedPeriod, this._clickedInstant);
            T t2 = scaleModel.getPeriodEnd(this._clickedPeriod, this._clickedInstant);
            this._chart.zoomPeriods(t, t2);
        } else if (ZOOM_IN.equals(string)) {
            this._chart.zoomInPeriods();
        } else if (ZOOM_OUT.equals(string)) {
            this._chart.zoomOutPeriods();
        }
    }
}

