/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.rss.FeedConstants;
import com.jidesoft.rss.FeedPreference;
import com.jidesoft.rss.FeedReader;
import com.jidesoft.rss.PreferencePanel;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;

class PreferenceDialog
extends StandardDialog {
    private PreferencePanel _preferencePanel;
    private FeedReader _rss = null;

    public PreferenceDialog(Frame frame, FeedReader feedReader) {
        super(frame);
        this.initDialog(feedReader);
    }

    public PreferenceDialog(Dialog dialog, FeedReader feedReader) {
        super(dialog, true);
        this.initDialog(feedReader);
    }

    private void initDialog(FeedReader feedReader) {
        this.setResizable(false);
        this._rss = feedReader;
        this.setTitle(this._rss.getResourceString("RssFeeds.preferenceDialogTitle"));
        this.setDefaultAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.okButtonText", this.getLocale())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.save();
                PreferenceDialog.this.setVisible(false);
                PreferenceDialog.this.dispose();
            }
        });
        this.setDefaultCancelAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.cancelButtonText", this.getLocale())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.setVisible(false);
                PreferenceDialog.this.dispose();
            }
        });
    }

    @Override
    public JComponent createBannerPanel() {
        return null;
    }

    @Override
    public JComponent createContentPanel() {
        this._preferencePanel = new PreferencePanel(this._rss);
        try {
            this._preferencePanel.load(this._rss.getFeedPreference());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this._preferencePanel;
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        buttonPanel.addButton((AbstractButton)jButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)jButton2, "CANCEL");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jButton.setAction(this.getDefaultAction());
        jButton2.setAction(this.getDefaultCancelAction());
        return buttonPanel;
    }

    private void save() {
        block2: {
            try {
                FeedPreference feedPreference = this._rss.getFeedPreference();
                this._preferencePanel.save(feedPreference);
                this._rss.firePreferenceChangedEvent(feedPreference);
                this._rss.setRefreshDelay(feedPreference.getRefreshTime() * FeedConstants.MS_IN_MINUTE);
                this._rss.setMaxCacheItems(feedPreference.getMaxCacheItems());
            }
            catch (Exception exception) {
                if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block2;
                FeedReader.getLogger().warning(exception.getLocalizedMessage());
            }
        }
    }
}

