/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.rss.FeedReader;
import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.utils.manager.PersistenceManagerException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class FeedTreeModel
extends DefaultTreeModel {
    private FeedReader _feedReader;

    public FeedTreeModel(FeedReader feedReader, TreeNode treeNode) {
        super(treeNode);
        this._feedReader = feedReader;
    }

    @Override
    public void insertNodeInto(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2, int n) {
        super.insertNodeInto(mutableTreeNode, mutableTreeNode2, n);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)mutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)mutableTreeNode2;
        try {
            if (defaultMutableTreeNode.getUserObject() instanceof ChannelGroupIF) {
                ChannelGroupIF channelGroupIF = (ChannelGroupIF)defaultMutableTreeNode.getUserObject();
                channelGroupIF = this._feedReader.getFeedPersistenceManager().createGroup(channelGroupIF.getTitle());
                defaultMutableTreeNode.setUserObject(channelGroupIF);
                return;
            }
            if (defaultMutableTreeNode.getUserObject() instanceof ChannelIF) {
                ChannelIF channelIF = (ChannelIF)defaultMutableTreeNode.getUserObject();
                ChannelGroupIF channelGroupIF = (ChannelGroupIF)defaultMutableTreeNode2.getUserObject();
                long l = this._feedReader.getFeedPersistenceManager().createChannel(channelIF.getTitle(), channelIF.getLocation()).getId();
                channelIF.setId(l);
                this._feedReader.getFeedPersistenceManager().updateChannel(channelIF);
                this._feedReader.getFeedPersistenceManager().addChannelToGroup(channelIF, channelGroupIF);
                defaultMutableTreeNode.setUserObject(channelIF);
            }
        }
        catch (PersistenceManagerException persistenceManagerException) {
            this._feedReader.fireStatusChangedEvent(persistenceManagerException.getLocalizedMessage());
        }
    }

    @Override
    public void removeNodeFromParent(MutableTreeNode mutableTreeNode) {
        Object object;
        ChannelIF channelIF;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)mutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (defaultMutableTreeNode != null) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        }
        if (defaultMutableTreeNode.getUserObject() instanceof ChannelIF) {
            channelIF = (ChannelIF)defaultMutableTreeNode.getUserObject();
            object = (ChannelGroupIF)defaultMutableTreeNode2.getUserObject();
            try {
                this._feedReader.getFeedPersistenceManager().removeChannelFromGroup(channelIF, (ChannelGroupIF)object);
                this._feedReader.getFeedPersistenceManager().deleteChannel(channelIF);
            }
            catch (PersistenceManagerException persistenceManagerException) {
                this._feedReader.fireStatusChangedEvent(persistenceManagerException.getLocalizedMessage());
            }
        }
        if (defaultMutableTreeNode.getUserObject() instanceof ChannelGroupIF) {
            channelIF = (ChannelGroupIF)defaultMutableTreeNode.getUserObject();
            object = channelIF.getAll();
            try {
                if (object != null) {
                    ArrayList<ChannelIF> arrayList = new ArrayList<ChannelIF>();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        ChannelIF channelIF2 = (ChannelIF)iterator.next();
                        arrayList.add(channelIF2);
                    }
                    for (ChannelIF channelIF2 : arrayList) {
                        this._feedReader.getFeedPersistenceManager().removeChannelFromGroup(channelIF2, (ChannelGroupIF)channelIF);
                        this._feedReader.getFeedPersistenceManager().deleteChannel(channelIF2);
                    }
                }
                this._feedReader.getFeedPersistenceManager().deleteGroup((ChannelGroupIF)channelIF);
            }
            catch (PersistenceManagerException persistenceManagerException) {
                this._feedReader.fireStatusChangedEvent(persistenceManagerException.getLocalizedMessage());
            }
        }
        super.removeNodeFromParent(mutableTreeNode);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        try {
            String string;
            ChannelIF channelIF;
            if (defaultMutableTreeNode.getUserObject() instanceof ChannelIF) {
                channelIF = (ChannelIF)defaultMutableTreeNode.getUserObject();
                if (object != null) {
                    if (object instanceof String) {
                        string = (String)object;
                        channelIF.setTitle((String)object);
                    }
                    if (object instanceof ChannelIF) {
                        channelIF = (ChannelIF)object;
                    }
                }
                this._feedReader.getFeedPersistenceManager().updateChannel(channelIF);
            }
            if (defaultMutableTreeNode.getUserObject() instanceof ChannelGroupIF) {
                channelIF = (ChannelGroupIF)defaultMutableTreeNode.getUserObject();
                if (object != null) {
                    if (object instanceof String) {
                        string = (String)object;
                        channelIF.setTitle((String)object);
                    }
                    if (object instanceof ChannelIF) {
                        channelIF = (ChannelGroupIF)object;
                    }
                }
                this._feedReader.getFeedPersistenceManager().updateGroup((ChannelGroupIF)channelIF);
            }
        }
        catch (PersistenceManagerException persistenceManagerException) {
            this._feedReader.fireStatusChangedEvent(persistenceManagerException.getLocalizedMessage());
        }
        this.nodeChanged(defaultMutableTreeNode);
    }
}

