/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;

class CompositeIcon
implements Icon,
SwingConstants {
    Icon fIcon1;
    Icon fIcon2;
    int fPosition;
    int fHorizontalOrientation;
    int fVerticalOrientation;

    public CompositeIcon(Icon icon, Icon icon2) {
        this(icon, icon2, 1);
    }

    public CompositeIcon(Icon icon, Icon icon2, int n) {
        this(icon, icon2, n, 0, 0);
    }

    public CompositeIcon(Icon icon, Icon icon2, int n, int n2, int n3) {
        this.fIcon1 = icon;
        this.fIcon2 = icon2;
        this.fPosition = n;
        this.fHorizontalOrientation = n2;
        this.fVerticalOrientation = n3;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3 = this.getIconWidth();
        int n4 = this.getIconHeight();
        if (this.fPosition == 2 || this.fPosition == 4) {
            Icon icon;
            Icon icon2;
            if (this.fPosition == 2) {
                icon2 = this.fIcon1;
                icon = this.fIcon2;
            } else {
                icon2 = this.fIcon2;
                icon = this.fIcon1;
            }
            this.paintIcon(component, graphics, icon2, n, n2, n3, n4, 2, this.fVerticalOrientation);
            this.paintIcon(component, graphics, icon, n + icon2.getIconWidth(), n2, n3, n4, 2, this.fVerticalOrientation);
        } else if (this.fPosition == 1 || this.fPosition == 3) {
            Icon icon;
            Icon icon3;
            if (this.fPosition == 1) {
                icon3 = this.fIcon1;
                icon = this.fIcon2;
            } else {
                icon3 = this.fIcon2;
                icon = this.fIcon1;
            }
            this.paintIcon(component, graphics, icon3, n, n2, n3, n4, this.fHorizontalOrientation, 1);
            this.paintIcon(component, graphics, icon, n, n2 + icon3.getIconHeight(), n3, n4, this.fHorizontalOrientation, 1);
        } else {
            this.paintIcon(component, graphics, this.fIcon1, n, n2, n3, n4, this.fHorizontalOrientation, this.fVerticalOrientation);
            this.paintIcon(component, graphics, this.fIcon2, n, n2, n3, n4, this.fHorizontalOrientation, this.fVerticalOrientation);
        }
    }

    void paintIcon(Component component, Graphics graphics, Icon icon, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        switch (n5) {
            case 2: {
                n8 = n;
                break;
            }
            case 4: {
                n8 = n + n3 - icon.getIconWidth();
                break;
            }
            default: {
                n8 = n + (n3 - icon.getIconWidth()) / 2;
            }
        }
        switch (n6) {
            case 1: {
                n7 = n2;
                break;
            }
            case 3: {
                n7 = n2 + n4 - icon.getIconHeight();
                break;
            }
            default: {
                n7 = n2 + (n4 - icon.getIconHeight()) / 2;
            }
        }
        icon.paintIcon(component, graphics, n8, n7);
    }

    @Override
    public int getIconWidth() {
        if (this.fPosition == 2 || this.fPosition == 4) {
            return this.fIcon1.getIconWidth() + this.fIcon2.getIconWidth();
        }
        return Math.max(this.fIcon1.getIconWidth(), this.fIcon2.getIconWidth());
    }

    @Override
    public int getIconHeight() {
        if (this.fPosition == 1 || this.fPosition == 3) {
            return this.fIcon1.getIconHeight() + this.fIcon2.getIconHeight();
        }
        return Math.max(this.fIcon1.getIconHeight(), this.fIcon2.getIconHeight());
    }
}

