/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.PeriodHeaderPainter;
import com.jidesoft.plaf.ScaleAreaUI;
import com.jidesoft.plaf.basic.BasicPeriodHeaderPainter;
import com.jidesoft.scale.Period;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.scale.ScaleAreaPopupMenuCustomizer;
import com.jidesoft.scale.ScaleModel;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;

public class BasicScaleAreaUI
extends ScaleAreaUI {
    public static final String UI_PERIOD_HEADER_PAINTER = "ScaleArea.periodHeaderPainter";
    public static final String UI_MOUSE_DRAG_RESIZABLE = "ScaleAreaUI.mouseDragResizable";
    private ScaleArea<Object> _scaleArea;
    private Handler _handler;
    private int _periodWidth = 27;
    private int _periodHeight = 21;
    private long _positionOffset = 0L;
    private double _positionScaleFactor = 1.0;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScaleAreaUI();
    }

    protected ScaleArea<Object> getScaleArea() {
        return this._scaleArea;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this._scaleArea = (ScaleArea)jComponent;
        this.installDefaults(this._scaleArea);
        this.installListeners(this._scaleArea);
        this.recalculateScale(this._scaleArea);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(this._scaleArea);
        this.uninstallDefaults(this._scaleArea);
        this._scaleArea = null;
    }

    protected void installDefaults(ScaleArea<Object> scaleArea) {
        PeriodHeaderPainter periodHeaderPainter = (PeriodHeaderPainter)UIManager.get(UI_PERIOD_HEADER_PAINTER);
        if (periodHeaderPainter == null) {
            periodHeaderPainter = this.createDefaultPeriodHeaderPainter(scaleArea);
        }
        scaleArea.setPeriodHeaderPainter(periodHeaderPainter);
    }

    protected PeriodHeaderPainter createDefaultPeriodHeaderPainter(ScaleArea<Object> scaleArea) {
        return new BasicPeriodHeaderPainter();
    }

    protected void uninstallDefaults(ScaleArea<Object> scaleArea) {
    }

    protected void installListeners(ScaleArea<Object> scaleArea) {
        this._handler = this.createHandler();
        scaleArea.addPropertyChangeListener(this._handler);
        scaleArea.addMouseListener(this._handler);
        scaleArea.addMouseMotionListener(this._handler);
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    protected void uninstallListeners(ScaleArea<Object> scaleArea) {
        scaleArea.removeMouseMotionListener(this._handler);
        scaleArea.removeMouseListener(this._handler);
        scaleArea.removePropertyChangeListener(this._handler);
        this._handler = null;
    }

    protected void paintBackground(Graphics graphics, ScaleArea<Object> scaleArea) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(scaleArea.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        ScaleArea scaleArea = (ScaleArea)jComponent;
        this.paintBackground(graphics, scaleArea);
        scaleArea.getPeriodHeaderPainter().paintPeriodHeaders(scaleArea, graphics);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        int n;
        ScaleArea scaleArea = (ScaleArea)jComponent;
        ScaleModel scaleModel = scaleArea.getScaleModel();
        Dimension dimension = scaleArea.getPreferredPeriodSize();
        int n2 = scaleArea.getVisiblePeriods().size();
        int n3 = n2 * dimension.height;
        if (scaleModel != null) {
            n = this.getLeftToRightX(scaleModel.getPosition(scaleArea.getEnd())) - this.getLeftToRightX(scaleModel.getPosition(scaleArea.getStart()));
        } else {
            n3 = dimension.height;
            n = dimension.width;
        }
        if (n == Integer.MAX_VALUE) {
            n = 2147482647;
        }
        return new DimensionUIResource(n += scaleArea.getPeriodMargin() * 2, n3);
    }

    protected void recalculateScale(ScaleArea<Object> scaleArea) {
        ScaleModel<Object> scaleModel = scaleArea.getScaleModel();
        if (scaleModel != null) {
            Object object = scaleArea.getStart();
            this._positionOffset = scaleModel.getPosition(object);
            Period period = scaleArea.getSmallestVisiblePeriod();
            Object object2 = scaleModel.getPeriodStart(period, object);
            Object object3 = scaleModel.getPeriodEnd(period, object);
            long l = scaleModel.getPosition(object3) - scaleModel.getPosition(object2);
            this._positionScaleFactor = (double)scaleArea.getPreferredPeriodSize().width / (double)l;
        } else {
            this._positionOffset = 0L;
            this._positionScaleFactor = 1.0;
        }
    }

    @Override
    public long getPositionAt(int n) {
        if (!this._scaleArea.getComponentOrientation().isLeftToRight()) {
            n = this._scaleArea.getWidth() - n;
        }
        int n2 = this._scaleArea.getPeriodMargin();
        long l = (long)Math.floor((double)(n - n2) / this._positionScaleFactor);
        return l + this._positionOffset;
    }

    @Override
    public int getX(long l) {
        int n = this.getLeftToRightX(l);
        if (this._scaleArea.getComponentOrientation().isLeftToRight()) {
            return n;
        }
        return this._scaleArea.getWidth() - n;
    }

    protected int getLeftToRightX(long l) {
        int n = this._scaleArea.getPeriodMargin();
        return n + (int)Math.round((double)(l - this._positionOffset) * this._positionScaleFactor);
    }

    protected void setPreferredPeriodSize(Dimension dimension) {
        this._periodWidth = dimension.width;
        this._periodHeight = dimension.height;
        this._scaleArea.revalidate();
    }

    @Override
    public Dimension getPreferredPeriodSize(Period period) {
        return new DimensionUIResource(this._periodWidth, this._periodHeight);
    }

    @Override
    public Period getPeriodAt(int n) {
        if (n < 0 || n >= this._scaleArea.getHeight()) {
            return null;
        }
        int n2 = (this._scaleArea.getHeight() - n) / this._scaleArea.getPreferredPeriodSize().height;
        List<Period> list = this._scaleArea.getVisiblePeriods();
        if (n2 >= 0 && n2 < list.size()) {
            return list.get(n2);
        }
        return null;
    }

    protected static class Handler
    implements PropertyChangeListener,
    MouseListener,
    MouseMotionListener {
        protected static final Set<String> SCALE_PROPERTIES = new HashSet<String>(Arrays.asList("scaleModel", "scaleStart", "scaleEnd", "visiblePeriods", "preferredPeriodSize", "periodMargin"));
        protected static final int MINIMUM_PERIOD_WIDTH = 10;
        protected static final int AREA_SIZE_RESIZE = 2;
        protected static final int NONE = 0;
        protected static final int RESIZE_PERIOD = 1;
        protected final BasicScaleAreaUI _ui;
        protected final boolean _resizable;
        private int _action = 0;
        private Point _pressedPoint;
        private int _pressedWidth;

        public Handler(BasicScaleAreaUI basicScaleAreaUI) {
            this._ui = basicScaleAreaUI;
            this._resizable = UIManager.getBoolean(BasicScaleAreaUI.UI_MOUSE_DRAG_RESIZABLE);
        }

        protected int getCurrentAction() {
            return this._action;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (SCALE_PROPERTIES.contains(propertyChangeEvent.getPropertyName())) {
                this._ui.recalculateScale((ScaleArea)propertyChangeEvent.getSource());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                this._pressedPoint = mouseEvent.getPoint();
                this._pressedWidth = this._ui.getScaleArea().getPreferredPeriodSize().width;
            }
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                this._pressedPoint = null;
            }
            this.maybeShowPopup(mouseEvent);
        }

        protected void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JidePopupMenu jidePopupMenu = new JidePopupMenu();
                ScaleArea scaleArea = (ScaleArea)mouseEvent.getComponent();
                Period period = scaleArea.getUI().getPeriodAt(mouseEvent.getY());
                Object t = scaleArea.getInstantAt(mouseEvent.getX());
                for (ScaleAreaPopupMenuCustomizer scaleAreaPopupMenuCustomizer : scaleArea.getPopupMenuCustomizers()) {
                    JideSwingUtilities.addSeparatorIfNecessary(jidePopupMenu);
                    scaleAreaPopupMenuCustomizer.customizePopup(jidePopupMenu, scaleArea, period, t);
                }
                if (jidePopupMenu.getComponentCount() > 0) {
                    Object object = scaleArea.getPopupLocation(mouseEvent);
                    if (object == null) {
                        object = mouseEvent.getPoint();
                    }
                    jidePopupMenu.show(scaleArea, ((Point)object).x, ((Point)object).y);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this._resizable) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Period period = this._ui.getPeriodAt(point.y);
            ScaleArea<Object> scaleArea = this._ui.getScaleArea();
            Period period2 = scaleArea.getSmallestVisiblePeriod();
            if (period2 == period) {
                ScaleModel<Object> scaleModel = scaleArea.getScaleModel();
                long l = this._ui.getPositionAt(point.x);
                Object object = scaleModel.getInstantAt(l);
                long l2 = scaleModel.getPosition(scaleModel.getPeriodStart(period, object));
                int n = this._ui.getX(l2);
                long l3 = scaleModel.getPosition(scaleModel.getPeriodEnd(period, object));
                int n2 = this._ui.getX(l3);
                if (Math.abs(point.x - n) - 1 <= 2 || Math.abs(point.x - n2) - 1 <= 2) {
                    this._action = 1;
                    scaleArea.setCursor(Cursor.getPredefinedCursor(10));
                } else {
                    this._action = 0;
                    scaleArea.setCursor(Cursor.getDefaultCursor());
                }
            } else {
                this._action = 0;
                scaleArea.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this._action == 1 && this._pressedPoint != null) {
                ScaleArea<Object> scaleArea = this._ui.getScaleArea();
                int n = scaleArea.getComponentOrientation().isLeftToRight() ? 1 : -1;
                int n2 = Math.max(10, this._pressedWidth + n * (mouseEvent.getX() - this._pressedPoint.x));
                Dimension dimension = scaleArea.getPreferredPeriodSize();
                scaleArea.setPreferredPeriodSize(new Dimension(n2, dimension.height));
            }
        }
    }
}

