/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.gantt.GanttChart;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.GanttEntryRelation;
import com.jidesoft.gantt.GanttEntryRelationModel;
import com.jidesoft.gantt.GanttEntryRenderer;
import com.jidesoft.gantt.GanttLabelRenderer;
import com.jidesoft.gantt.GanttModel;
import com.jidesoft.gantt.MutableGanttEntry;
import com.jidesoft.gantt.PeriodBackgroundPainter;
import com.jidesoft.gantt.SubEntryGanttEntry;
import com.jidesoft.grid.Expandable;
import com.jidesoft.plaf.GanttChartUI;
import com.jidesoft.plaf.GanttEntryRelationPainter;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicGanttEntryRelationPainter;
import com.jidesoft.plaf.basic.BasicScaleAreaUI;
import com.jidesoft.plaf.basic.GanttChartBackgroundPainter;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.range.Range;
import com.jidesoft.scale.Period;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.tree.ExpandVetoException;

public class BasicGanttChartUI
extends GanttChartUI {
    public static final String UI_GANTT_CHART_FONT = "GanttChart.font";
    public static final String UI_GANTT_CHART_FOREGROUND = "GanttChart.foreground";
    public static final String UI_GANTT_CHART_BACKGROUND = "GanttChart.background";
    public static final String UI_GANTT_CHART_BACKGROUND_PAINTER = "GanttChart.backgroundPainter";
    public static final String UI_VISIBLE_RELATIONS_THRESHOLD = "GanttChart.visibleRelationsThreshold";
    public static final int DEFAULT_VISIBLE_RELATIONS_THRESHOLD = 25;
    protected GanttChart<Object, GanttEntry<Object>> _chart;
    protected CellRendererPane _rendererPane;
    private Handler<Object> _listener;
    private GanttChartBackgroundPainter _backgroundPainter;
    private Border _cellFocusBorder;
    private Border _selectedCellFocusBorder;
    private int _relationThreshold;
    private static final Insets _ganttEntryPadding = UIDefaultsLookup.getInsets("TaskBar.padding");
    private static final int AREA_SIZE_MOVE = 2;
    private static final int AREA_SIZE_CHANGE_COMPLETION = 4;
    private static final int CHANGE_LEAD = 0;
    private static final int CHANGE_SELECTION = 1;
    private static final int EXTEND_SELECTION = 2;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicGanttChartUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this._chart = (GanttChart)jComponent;
        Object object = UIManager.get(UI_GANTT_CHART_BACKGROUND_PAINTER);
        this._backgroundPainter = object instanceof GanttChartBackgroundPainter ? (GanttChartBackgroundPainter)object : new GanttChartBackgroundPainter();
        Object object2 = UIManager.get(UI_VISIBLE_RELATIONS_THRESHOLD);
        this._relationThreshold = object2 instanceof Integer ? (Integer)object2 : 25;
        this.installDefaults(this._chart);
        this.installListeners(this._chart);
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        GanttChart ganttChart = (GanttChart)jComponent;
        this._backgroundPainter = null;
        this._relationThreshold = 25;
        this.uninstallDefaults(ganttChart);
        this.uninstallListeners(ganttChart);
        this.uninstallKeyboardActions();
    }

    protected void installDefaults(GanttChart<Object, GanttEntry<Object>> ganttChart) {
        Color color;
        Color color2;
        LookAndFeel.installColorsAndFont(ganttChart, UI_GANTT_CHART_BACKGROUND, UI_GANTT_CHART_FOREGROUND, UI_GANTT_CHART_FONT);
        Color color3 = ganttChart.getSelectionBackground();
        if (color3 == null || color3 instanceof UIResource) {
            color3 = UIManager.getColor("GanttChart.selectionBackground");
            ganttChart.setSelectionBackground(color3 != null ? color3 : UIManager.getColor("textHighlight"));
        }
        if ((color2 = ganttChart.getSelectionForeground()) == null || color2 instanceof UIResource) {
            color2 = UIManager.getColor("GanttChart.selectionForeground");
            ganttChart.setSelectionForeground(color2 != null ? color2 : UIManager.getColor("textHighlightText"));
        }
        if ((color = ganttChart.getGridColor()) == null || color instanceof UIResource) {
            color = UIManager.getColor("GanttChart.gridLine");
            ganttChart.setGridColor(color != null ? color : Color.GRAY);
        }
        ganttChart.setShowGrid(true);
        ganttChart.setRowMargin(1);
        this._cellFocusBorder = UIDefaultsLookup.getBorder("GanttChart.focusCellHighlightBorder");
        this._selectedCellFocusBorder = UIDefaultsLookup.getBorder("GanttChart.focusSelectedCellHighlightBorder");
        this._rendererPane = new CellRendererPane();
        ganttChart.add(this._rendererPane);
        this.initializePainters(ganttChart);
    }

    protected void initializePainters(GanttChart<?, ?> ganttChart) {
        this.setPainterIfResource(ganttChart, 1, new BasicRelationPainter(10, null, BasicRelationPainter.ARROW, _ganttEntryPadding));
        this.setPainterIfResource(ganttChart, 4, new BasicRelationPainter(10, null, BasicRelationPainter.ARROW, _ganttEntryPadding));
        this.setPainterIfResource(ganttChart, 2, new BasicRelationPainter(10, null, BasicRelationPainter.ARROW, _ganttEntryPadding));
        this.setPainterIfResource(ganttChart, 3, new BasicRelationPainter(10, null, BasicRelationPainter.ARROW, _ganttEntryPadding));
    }

    protected void setPainterIfResource(GanttChart<?, ?> ganttChart, int n, GanttEntryRelationPainter ganttEntryRelationPainter) {
        GanttEntryRelationPainter ganttEntryRelationPainter2 = ganttChart.getRelationPainter(n);
        if (ganttEntryRelationPainter2 == null || ganttEntryRelationPainter2 instanceof UIResource) {
            ganttChart.setRelationPainter(n, ganttEntryRelationPainter);
        }
    }

    protected void uninstallDefaults(GanttChart<Object, GanttEntry<Object>> ganttChart) {
        ganttChart.remove(this._rendererPane);
        this._cellFocusBorder = null;
        this._selectedCellFocusBorder = null;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this._chart, 0, inputMap);
        LazyActionMap.installLazyActionMap(this._chart, BasicGanttChartUI.class, "GanttChart.actionMap");
    }

    public static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("selectPreviousRow"));
        lazyActionMap.put(new Actions("selectPreviousRowExtendSelection"));
        lazyActionMap.put(new Actions("selectPreviousRowChangeLead"));
        lazyActionMap.put(new Actions("selectNextRow"));
        lazyActionMap.put(new Actions("selectNextRowExtendSelection"));
        lazyActionMap.put(new Actions("selectNextRowChangeLead"));
        lazyActionMap.put(new Actions("selectFirstRow"));
        lazyActionMap.put(new Actions("selectFirstRowExtendSelection"));
        lazyActionMap.put(new Actions("selectFirstRowChangeLead"));
        lazyActionMap.put(new Actions("selectLastRow"));
        lazyActionMap.put(new Actions("selectLastRowExtendSelection"));
        lazyActionMap.put(new Actions("selectLastRowChangeLead"));
        lazyActionMap.put(new Actions("scrollUp"));
        lazyActionMap.put(new Actions("scrollUpExtendSelection"));
        lazyActionMap.put(new Actions("scrollUpChangeLead"));
        lazyActionMap.put(new Actions("scrollDown"));
        lazyActionMap.put(new Actions("scrollDownExtendSelection"));
        lazyActionMap.put(new Actions("scrollDownChangeLead"));
        lazyActionMap.put(new Actions("selectAll"));
        lazyActionMap.put(new Actions("clearSelection"));
        lazyActionMap.put(new Actions("addToSelection"));
        lazyActionMap.put(new Actions("toggleAndAnchor"));
        lazyActionMap.put(new Actions("extendTo"));
        lazyActionMap.put(new Actions("moveSelectionTo"));
        lazyActionMap.put(new Actions("zoomInPeriods"));
        lazyActionMap.put(new Actions("zoomOutPeriods"));
    }

    InputMap getInputMap(int n) {
        if (n == 0) {
            return (InputMap)UIDefaultsLookup.get("GanttChart.focusInputMap");
        }
        return null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this._chart, null);
        SwingUtilities.replaceUIInputMap(this._chart, 0, null);
    }

    protected void installListeners(GanttChart<Object, GanttEntry<Object>> ganttChart) {
        this._listener = new Handler(ganttChart);
        ganttChart.addKeyListener(this._listener);
        ganttChart.addFocusListener(this._listener);
        ganttChart.addMouseListener(this._listener);
        ganttChart.addMouseMotionListener(this._listener);
        ganttChart.addMouseWheelListener(this._listener);
        ganttChart.addPropertyChangeListener(this._listener);
        ganttChart.getSelectionModel().addListSelectionListener(this._listener);
        if (ganttChart.getScaleArea() != null && ganttChart.getScaleArea().getTreeTable() != null) {
            ganttChart.getScaleArea().getTreeTable().addTreeWillExpandListener(this._listener);
            ganttChart.getScaleArea().getTreeTable().addTreeExpansionListener(this._listener);
        }
    }

    protected void uninstallListeners(GanttChart<?, ?> ganttChart) {
        ganttChart.removeKeyListener(this._listener);
        ganttChart.removeFocusListener(this._listener);
        ganttChart.removeMouseListener(this._listener);
        ganttChart.removeMouseMotionListener(this._listener);
        ganttChart.removeMouseWheelListener(this._listener);
        ganttChart.removePropertyChangeListener(this._listener);
        ganttChart.getSelectionModel().removeListSelectionListener(this._listener);
        if (ganttChart.getScaleArea() != null && ganttChart.getScaleArea().getTreeTable() != null) {
            ganttChart.getScaleArea().getTreeTable().removeTreeWillExpandListener(this._listener);
            ganttChart.getScaleArea().getTreeTable().removeTreeExpansionListener(this._listener);
        }
        this._listener = null;
    }

    protected void paintBackground(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(ganttChart.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void paintEntries(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart, int n, int n2) {
        Rectangle rectangle = graphics.getClipBounds();
        for (int i = n; i <= n2; ++i) {
            Rectangle rectangle2 = ganttChart.getEntryRect(i);
            GanttEntry<Object> ganttEntry = ganttChart.getEntryAt(i);
            List list = null;
            if (ganttEntry instanceof SubEntryGanttEntry) {
                list = ((SubEntryGanttEntry)ganttEntry).getSubEntries();
            }
            if (rectangle2 == null) continue;
            if (list == null || list.size() <= 0) {
                rectangle2.x -= BasicGanttChartUI._ganttEntryPadding.left;
                rectangle2.y -= BasicGanttChartUI._ganttEntryPadding.top;
                rectangle2.width += BasicGanttChartUI._ganttEntryPadding.left + BasicGanttChartUI._ganttEntryPadding.right;
                rectangle2.height += BasicGanttChartUI._ganttEntryPadding.top + BasicGanttChartUI._ganttEntryPadding.bottom;
                if (!rectangle.intersects(rectangle2)) continue;
                this.paintGanttEntry(graphics, ganttChart, i, rectangle2, _ganttEntryPadding);
                this.paintGanttLabel(graphics, ganttChart, i, rectangle2);
                continue;
            }
            for (int j = 0; j < list.size(); ++j) {
                GanttEntry ganttEntry2 = list.get(j);
                Rectangle rectangle3 = ganttChart.getEntryRect(ganttEntry2, i);
                if (rectangle3 == null) continue;
                rectangle2 = (Rectangle)rectangle3.clone();
                rectangle2.x -= BasicGanttChartUI._ganttEntryPadding.left;
                rectangle2.y -= BasicGanttChartUI._ganttEntryPadding.top;
                rectangle2.width += BasicGanttChartUI._ganttEntryPadding.left + BasicGanttChartUI._ganttEntryPadding.right;
                rectangle2.height += BasicGanttChartUI._ganttEntryPadding.top + BasicGanttChartUI._ganttEntryPadding.bottom;
                if (!rectangle.intersects(rectangle2)) continue;
                this.paintGanttEntry(graphics, ganttChart, i, j, rectangle2, _ganttEntryPadding);
                this.paintGanttLabel(graphics, ganttChart, i, j, rectangle2);
            }
        }
    }

    protected void paintGanttEntry(Graphics graphics, GanttChart<?, ?> ganttChart, int n, Rectangle rectangle, Insets insets) {
        this.paintGanttEntry(graphics, ganttChart, n, -1, rectangle, insets);
    }

    protected void paintGanttEntry(Graphics graphics, GanttChart<?, ?> ganttChart, int n, int n2, Rectangle rectangle, Insets insets) {
        GanttEntryRenderer ganttEntryRenderer = ganttChart.getEntryRenderer(n, n2);
        Component component = ganttChart.prepareRenderer(ganttEntryRenderer, n, n2, insets);
        this._rendererPane.paintComponent(graphics, component, ganttChart, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    protected void paintGanttLabel(Graphics graphics, GanttChart<?, ?> ganttChart, int n, Rectangle rectangle) {
        this.paintGanttLabel(graphics, ganttChart, n, -1, rectangle);
    }

    protected void paintGanttLabel(Graphics graphics, GanttChart<?, ?> ganttChart, int n, int n2, Rectangle rectangle) {
        GanttLabelRenderer ganttLabelRenderer = ganttChart.getLabelRenderer(n, n2);
        if (ganttLabelRenderer != null) {
            Component component = ganttChart.prepareLabelRenderer(ganttLabelRenderer, n, n2);
            int n3 = ganttChart.getLabelPosition();
            int n4 = ganttChart.getLabelEntryGap();
            boolean bl = ganttChart.getComponentOrientation().isLeftToRight();
            if (n3 == 11) {
                n3 = bl ? 3 : 7;
            } else if (n3 == 10) {
                n3 = bl ? 7 : 3;
            }
            if (n3 == 3) {
                rectangle.x += rectangle.width + n4;
                rectangle.width = component.getPreferredSize().width;
            } else if (n3 == 7) {
                rectangle.width = component.getPreferredSize().width;
                rectangle.x -= rectangle.width + n4;
            }
            this._rendererPane.paintComponent(graphics, component, ganttChart, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        GanttChart ganttChart = (GanttChart)jComponent;
        this.paintBackground(graphics, ganttChart);
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = ganttChart.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (ganttChart.getEntryCount() <= 0 || !rectangle2.intersects(rectangle)) {
            // empty if block
        }
        boolean bl = ganttChart.getComponentOrientation().isLeftToRight();
        Point point = rectangle.getLocation();
        if (!bl) {
            ++point.x;
        }
        Point point2 = new Point(rectangle.x + rectangle.width - (bl ? 1 : 0), rectangle.y + rectangle.height);
        int n = ganttChart.rowAtPoint(point);
        int n2 = ganttChart.rowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = ganttChart.getEntryCount() - 1;
        }
        this.paintGrid(graphics, ganttChart, n, n2);
        if (ganttChart.getModel() != null) {
            this.paintPeriodBackgrounds(graphics, ganttChart);
            this.paintSelection(graphics, ganttChart, n, n2);
            this.paintEntries(graphics, ganttChart, n, n2);
            this._rendererPane.removeAll();
            Rectangle rectangle3 = ganttChart.getVisibleRect();
            Point point3 = rectangle3.getLocation();
            int n3 = ganttChart.rowAtPoint(point3);
            point3.x += rectangle3.width;
            point3.y += rectangle3.height;
            int n4 = ganttChart.rowAtPoint(rectangle3.getLocation());
            this.paintGanttEntryRelations(graphics, ganttChart, Math.min(n3, n), Math.max(n4, n2));
        }
    }

    protected void paintPeriodBackgrounds(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart) {
        List<PeriodBackgroundPainter<Object>> list = ganttChart.getPeriodBackgroundPainters();
        this._backgroundPainter.paintPeriodBackgrounds(ganttChart, graphics, list);
    }

    protected void paintGrid(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart, int n, int n2) {
        if (ganttChart.isShowGrid()) {
            graphics.setColor(ganttChart.getGridColor());
            Rectangle rectangle = ganttChart.getRowRect(n, true);
            Rectangle rectangle2 = ganttChart.getRowRect(n2, true);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            int n3 = rectangle3.x + rectangle3.width;
            int n4 = rectangle3.y;
            for (int i = n; i <= n2; ++i) {
                graphics.drawLine(rectangle3.x, (n4 += ganttChart.getRowHeight(i)) - 1, n3 - 1, n4 - 1);
            }
        }
    }

    protected void paintSelection(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart, int n, int n2) {
        if (ganttChart.getSelectedRow() == -1) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n3 = ganttChart.getSelectionModel().getLeadSelectionIndex();
        for (int i = n; i <= n2; ++i) {
            Border border;
            Rectangle rectangle;
            boolean bl = ganttChart.isRowSelected(i);
            boolean bl2 = ganttChart.isFocusOwner();
            if (bl) {
                rectangle = ganttChart.getRowRect(i, !ganttChart.isShowGrid());
                graphics2D.setColor(ganttChart.getSelectionBackground());
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (n3 != i || !bl2) continue;
            rectangle = ganttChart.getRowRect(i, !ganttChart.isShowGrid());
            Border border2 = border = bl && this._selectedCellFocusBorder != null ? this._selectedCellFocusBorder : this._cellFocusBorder;
            if (border == null) continue;
            Rectangle rectangle2 = graphics.getClipBounds();
            Rectangle rectangle3 = rectangle.intersection(rectangle2);
            border.paintBorder(ganttChart, graphics2D, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
        graphics2D.dispose();
    }

    protected void paintGanttEntryRelations(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart, int n, int n2) {
        int n3;
        HashSet<GanttEntryRelation<GanttEntry<Object>>> hashSet = new HashSet<GanttEntryRelation<GanttEntry<Object>>>();
        GanttModel<Object, GanttEntry<Object>> ganttModel = ganttChart.getModel();
        HashSet<GanttEntry<Object>> hashSet2 = new HashSet<GanttEntry<Object>>();
        GanttEntryRelationModel<GanttEntry<Object>> ganttEntryRelationModel = ganttModel.getGanttEntryRelationModel();
        if (ganttEntryRelationModel != null) {
            for (n3 = n; n3 <= n2; ++n3) {
                GanttEntry<Object> ganttEntry = ganttChart.getEntryAt(n3);
                if (!hashSet2.add(ganttEntry)) continue;
                hashSet.addAll(ganttEntryRelationModel.getEntryRelations(ganttEntry));
            }
        }
        if (this._relationThreshold != 0) {
            GanttEntry<Object> ganttEntry;
            int n4;
            int ganttEntryRelation;
            n3 = 0;
            int n5 = ganttModel.getEntryCount();
            if (this._relationThreshold > 0) {
                n3 = Math.max(n3, n - this._relationThreshold);
                ganttEntryRelation = Math.min(n5, n2 + this._relationThreshold);
            }
            for (n4 = n3; n4 < n; ++n4) {
                ganttEntry = ganttChart.getEntryAt(n4);
                if (!hashSet2.add(ganttEntry)) continue;
                hashSet.addAll(this.getVisibleRelations(ganttModel, ganttEntry, n, n2));
            }
            for (n4 = n2 + 1; n4 < ganttEntryRelation; ++n4) {
                ganttEntry = ganttChart.getEntryAt(n4);
                if (!hashSet2.add(ganttEntry)) continue;
                hashSet.addAll(this.getVisibleRelations(ganttModel, ganttEntry, n, n2));
            }
        }
        for (GanttEntryRelation ganttEntryRelation : hashSet) {
            this.paintGanttEntryRelation(graphics, ganttChart, ganttEntryRelation);
        }
    }

    private Set<GanttEntryRelation<GanttEntry<Object>>> getVisibleRelations(GanttModel<Object, GanttEntry<Object>> ganttModel, GanttEntry<Object> ganttEntry, int n, int n2) {
        HashSet<GanttEntryRelation<GanttEntry<Object>>> hashSet = new HashSet<GanttEntryRelation<GanttEntry<Object>>>();
        GanttEntryRelationModel<GanttEntry<Object>> ganttEntryRelationModel = ganttModel.getGanttEntryRelationModel();
        if (ganttEntryRelationModel != null) {
            for (GanttEntryRelation<GanttEntry<Object>> ganttEntryRelation : ganttEntryRelationModel.getEntryRelations(ganttEntry)) {
                int n3;
                GanttEntry ganttEntry2;
                GanttEntry<Object> ganttEntry3 = ganttEntryRelation.getPredecessorEntry();
                int n4 = ganttModel.getIndexOf(ganttEntry3);
                if (n4 == -1) {
                    while ((ganttEntry2 = ganttEntry3.getParent()) != null && ganttEntry2 instanceof GanttEntry && (n4 = ganttModel.getIndexOf(ganttEntry3 = ganttEntry2)) == -1) {
                    }
                }
                if ((n3 = ganttModel.getIndexOf(ganttEntry2 = ganttEntryRelation.getSuccessorEntry())) == -1) {
                    Expandable expandable;
                    while ((expandable = ganttEntry2.getParent()) != null && expandable instanceof GanttEntry && (n3 = ganttModel.getIndexOf(ganttEntry2 = (GanttEntry)expandable)) == -1) {
                    }
                }
                if ((n4 > n2 || n3 < n) && (n4 < n || n3 > n2)) continue;
                hashSet.add(ganttEntryRelation);
            }
        }
        return hashSet;
    }

    protected void paintGanttEntryRelation(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart, GanttEntryRelation<GanttEntry<Object>> ganttEntryRelation) {
        GanttEntryRelationPainter ganttEntryRelationPainter = ganttChart.getRelationPainter(ganttEntryRelation.getRelationType());
        if (ganttEntryRelationPainter != null) {
            ganttEntryRelationPainter.paintRelation(graphics, ganttChart, ganttEntryRelation, false, false);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        GanttChart ganttChart = (GanttChart)jComponent;
        ScaleArea scaleArea = ganttChart.getScaleArea();
        Dimension dimension = scaleArea.getPreferredSize();
        dimension.height = scaleArea.getTreeTable() != null ? scaleArea.getTreeTable().getPreferredSize().height : ganttChart.getTotalRowHeight();
        return dimension;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize(GanttChart<?, ?> ganttChart) {
        ScaleArea<?> scaleArea = ganttChart.getScaleArea();
        int n = 400;
        int n2 = 400;
        if (scaleArea != null) {
            n = scaleArea.getPreferredPeriodSize().width * scaleArea.getVisiblePeriodCount();
            n2 = scaleArea.getTreeTable() != null ? scaleArea.getTreeTable().getPreferredScrollableViewportSize().height : Math.min(400, this.getPreferredSize(ganttChart).height);
        }
        return new Dimension(n, n2);
    }

    public int getSubEntryIndex(int n, Point point) {
        List list;
        GanttEntry<Object> ganttEntry;
        GanttModel<Object, GanttEntry<Object>> ganttModel = this._chart.getModel();
        if (ganttModel != null && (ganttEntry = ganttModel.getEntryAt(n)) instanceof SubEntryGanttEntry && (list = ((SubEntryGanttEntry)ganttEntry).getSubEntries()) != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Rectangle rectangle;
                GanttEntry ganttEntry2 = list.get(i);
                if (!(ganttEntry2 instanceof GanttEntry) || (rectangle = this._chart.getEntryRect(ganttEntry2, n)) == null) continue;
                Rectangle rectangle2 = (Rectangle)rectangle.clone();
                rectangle2.x -= this._chart.getResizeAreaWidth() / 2;
                rectangle2.width += this._chart.getResizeAreaWidth();
                rectangle2.y -= 2;
                rectangle2.height += 4;
                if (!rectangle2.contains(point)) continue;
                return i;
            }
        }
        return -1;
    }

    public GanttEntry getEntryAt(int n, Point point) {
        GanttModel<Object, GanttEntry<Object>> ganttModel = this._chart.getModel();
        if (ganttModel != null) {
            List list;
            GanttEntry<Object> ganttEntry = ganttModel.getEntryAt(n);
            if (ganttEntry instanceof SubEntryGanttEntry && (list = ((SubEntryGanttEntry)ganttEntry).getSubEntries()) != null) {
                GanttEntry ganttEntry2 = null;
                for (int i = list.size() - 1; i >= 0; --i) {
                    Rectangle rectangle;
                    GanttEntry ganttEntry3 = list.get(i);
                    if (!(ganttEntry3 instanceof GanttEntry) || (rectangle = this._chart.getEntryRect(ganttEntry3, n)) == null) continue;
                    if (rectangle.contains(point)) {
                        return ganttEntry3;
                    }
                    if (ganttEntry2 != null) continue;
                    Rectangle rectangle2 = (Rectangle)rectangle.clone();
                    rectangle2.x -= this._chart.getResizeAreaWidth() / 2;
                    rectangle2.width += this._chart.getResizeAreaWidth();
                    rectangle2.y -= 2;
                    rectangle2.height += 4;
                    if (!rectangle2.contains(point)) continue;
                    ganttEntry2 = ganttEntry3;
                }
                return ganttEntry2;
            }
            return ganttEntry;
        }
        return null;
    }

    private static int getAdjustedLead(GanttChart<?, ?> ganttChart, boolean bl, ListSelectionModel listSelectionModel) {
        int n;
        int n2 = listSelectionModel.getLeadSelectionIndex();
        return n2 < (n = ganttChart.getEntryCount()) ? n2 : -1;
    }

    private static int adjustIndex(int n, GanttChart<?, ?> ganttChart) {
        return n < ganttChart.getEntryCount() ? n : -1;
    }

    private static class Actions
    extends UIAction {
        private static final String SELECT_PREVIOUS_ROW = "selectPreviousRow";
        private static final String SELECT_PREVIOUS_ROW_EXTEND = "selectPreviousRowExtendSelection";
        private static final String SELECT_PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        private static final String SELECT_NEXT_ROW = "selectNextRow";
        private static final String SELECT_NEXT_ROW_EXTEND = "selectNextRowExtendSelection";
        private static final String SELECT_NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        private static final String SELECT_FIRST_ROW = "selectFirstRow";
        private static final String SELECT_FIRST_ROW_EXTEND = "selectFirstRowExtendSelection";
        private static final String SELECT_FIRST_ROW_CHANGE_LEAD = "selectFirstRowChangeLead";
        private static final String SELECT_LAST_ROW = "selectLastRow";
        private static final String SELECT_LAST_ROW_EXTEND = "selectLastRowExtendSelection";
        private static final String SELECT_LAST_ROW_CHANGE_LEAD = "selectLastRowChangeLead";
        private static final String SCROLL_UP = "scrollUp";
        private static final String SCROLL_UP_EXTEND = "scrollUpExtendSelection";
        private static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        private static final String SCROLL_DOWN = "scrollDown";
        private static final String SCROLL_DOWN_EXTEND = "scrollDownExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";
        private static final String ZOOM_IN_PERIODS = "zoomInPeriods";
        private static final String ZOOM_OUT_PERIODS = "zoomOutPeriods";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            GanttChart ganttChart = (GanttChart)actionEvent.getSource();
            BasicGanttChartUI basicGanttChartUI = (BasicGanttChartUI)ganttChart.getUI();
            if (SELECT_PREVIOUS_ROW.equals(string)) {
                this.changeSelection(ganttChart, 1, this.getNextIndex(ganttChart, basicGanttChartUI, -1), -1);
            } else if (SELECT_PREVIOUS_ROW_EXTEND.equals(string)) {
                this.changeSelection(ganttChart, 2, this.getNextIndex(ganttChart, basicGanttChartUI, -1), -1);
            } else if (SELECT_PREVIOUS_ROW_CHANGE_LEAD.equals(string)) {
                this.changeSelection(ganttChart, 0, this.getNextIndex(ganttChart, basicGanttChartUI, -1), -1);
            } else if (SELECT_NEXT_ROW.equals(string)) {
                this.changeSelection(ganttChart, 1, this.getNextIndex(ganttChart, basicGanttChartUI, 1), 1);
            } else if (SELECT_NEXT_ROW_EXTEND.equals(string)) {
                this.changeSelection(ganttChart, 2, this.getNextIndex(ganttChart, basicGanttChartUI, 1), 1);
            } else if (SELECT_NEXT_ROW_CHANGE_LEAD.equals(string)) {
                this.changeSelection(ganttChart, 0, this.getNextIndex(ganttChart, basicGanttChartUI, 1), 1);
            } else if (SELECT_FIRST_ROW.equals(string)) {
                this.changeSelection(ganttChart, 1, 0, -1);
            } else if (SELECT_FIRST_ROW_EXTEND.equals(string)) {
                this.changeSelection(ganttChart, 2, 0, -1);
            } else if (SELECT_FIRST_ROW_CHANGE_LEAD.equals(string)) {
                this.changeSelection(ganttChart, 0, 0, -1);
            } else if (SELECT_LAST_ROW.equals(string)) {
                this.changeSelection(ganttChart, 1, ganttChart.getEntryCount() - 1, 1);
            } else if (SELECT_LAST_ROW_EXTEND.equals(string)) {
                this.changeSelection(ganttChart, 2, ganttChart.getEntryCount() - 1, 1);
            } else if (SELECT_LAST_ROW_CHANGE_LEAD.equals(string)) {
                this.changeSelection(ganttChart, 0, ganttChart.getEntryCount() - 1, 1);
            } else if (SCROLL_UP.equals(string)) {
                this.changeSelection(ganttChart, 1, this.getNextPageIndex(ganttChart, -1), -1);
            } else if (SCROLL_UP_EXTEND.equals(string)) {
                this.changeSelection(ganttChart, 2, this.getNextPageIndex(ganttChart, -1), -1);
            } else if (SCROLL_UP_CHANGE_LEAD.equals(string)) {
                this.changeSelection(ganttChart, 0, this.getNextPageIndex(ganttChart, -1), -1);
            } else if (SCROLL_DOWN.equals(string)) {
                this.changeSelection(ganttChart, 1, this.getNextPageIndex(ganttChart, 1), 1);
            } else if (SCROLL_DOWN_EXTEND.equals(string)) {
                this.changeSelection(ganttChart, 2, this.getNextPageIndex(ganttChart, 1), 1);
            } else if (SCROLL_DOWN_CHANGE_LEAD.equals(string)) {
                this.changeSelection(ganttChart, 0, this.getNextPageIndex(ganttChart, 1), 1);
            } else if (SELECT_ALL.equals(string)) {
                this.selectAll(ganttChart);
            } else if (CLEAR_SELECTION.equals(string)) {
                this.clearSelection(ganttChart);
            } else if (ADD_TO_SELECTION.equals(string)) {
                int n = BasicGanttChartUI.adjustIndex(ganttChart.getSelectionModel().getLeadSelectionIndex(), ganttChart);
                if (n >= 0 && !ganttChart.isRowSelected(n)) {
                    int n2 = ganttChart.getSelectionModel().getAnchorSelectionIndex();
                    ganttChart.setValueIsAdjusting(true);
                    ganttChart.addSelectionInterval(n, n);
                    ganttChart.getSelectionModel().setAnchorSelectionIndex(n2);
                    ganttChart.setValueIsAdjusting(false);
                }
            } else if (TOGGLE_AND_ANCHOR.equals(string)) {
                int n = BasicGanttChartUI.adjustIndex(ganttChart.getSelectionModel().getLeadSelectionIndex(), ganttChart);
                if (ganttChart.isRowSelected(n)) {
                    ganttChart.removeSelectionInterval(n, n);
                } else {
                    ganttChart.addSelectionInterval(n, n);
                }
            } else if (EXTEND_TO.equals(string)) {
                this.changeSelection(ganttChart, 2, BasicGanttChartUI.adjustIndex(ganttChart.getSelectionModel().getLeadSelectionIndex(), ganttChart), 0);
            } else if (MOVE_SELECTION_TO.equals(string)) {
                this.changeSelection(ganttChart, 1, BasicGanttChartUI.adjustIndex(ganttChart.getSelectionModel().getLeadSelectionIndex(), ganttChart), 0);
            } else if (ZOOM_IN_PERIODS.equals(string)) {
                ganttChart.zoomInPeriods();
            } else if (ZOOM_OUT_PERIODS.equals(string)) {
                ganttChart.zoomOutPeriods();
            }
        }

        @Override
        public boolean isEnabled(Object object) {
            String string = this.getName();
            if (string == SELECT_PREVIOUS_ROW_CHANGE_LEAD || string == SELECT_NEXT_ROW_CHANGE_LEAD || string == SELECT_FIRST_ROW_CHANGE_LEAD || string == SELECT_LAST_ROW_CHANGE_LEAD || string == SCROLL_UP_CHANGE_LEAD || string == SCROLL_DOWN_CHANGE_LEAD) {
                return object != null && ((GanttChart)object).getSelectionModel() instanceof DefaultListSelectionModel;
            }
            return true;
        }

        private void clearSelection(GanttChart<?, ?> ganttChart) {
            ganttChart.clearSelection();
        }

        private void selectAll(GanttChart<?, ?> ganttChart) {
            int n = ganttChart.getEntryCount();
            if (n > 0) {
                ListSelectionModel listSelectionModel = ganttChart.getSelectionModel();
                int n2 = BasicGanttChartUI.adjustIndex(listSelectionModel.getLeadSelectionIndex(), ganttChart);
                if (listSelectionModel.getSelectionMode() == 0) {
                    if (n2 == -1) {
                        int n3 = BasicGanttChartUI.adjustIndex(ganttChart.getMinSelectionIndex(), ganttChart);
                        n2 = n3 == -1 ? 0 : n3;
                    }
                    ganttChart.setSelectionInterval(n2, n2);
                    ganttChart.ensureRowIsVisible(n2);
                } else {
                    ganttChart.setValueIsAdjusting(true);
                    ganttChart.setSelectionInterval(0, n - 1);
                    ganttChart.setValueIsAdjusting(false);
                }
            }
        }

        private int getNextPageIndex(GanttChart<?, ?> ganttChart, int n) {
            int n2;
            Rectangle rectangle;
            if (ganttChart.getEntryCount() == 0) {
                return -1;
            }
            Rectangle rectangle2 = ganttChart.getVisibleRect();
            ListSelectionModel listSelectionModel = ganttChart.getSelectionModel();
            int n3 = BasicGanttChartUI.adjustIndex(listSelectionModel.getLeadSelectionIndex(), ganttChart);
            Rectangle rectangle3 = rectangle = n3 == -1 ? new Rectangle() : ganttChart.getRowRect(n3, true);
            if (n < 0) {
                Point point = new Point(rectangle.x, rectangle2.y);
                n2 = ganttChart.rowAtPoint(point);
                if (n3 <= n2) {
                    point.y = rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
                    n2 = ganttChart.rowAtPoint(point);
                    Rectangle rectangle4 = ganttChart.getRowRect(n2, true);
                    if (rectangle4.y < rectangle2.y) {
                        point.y = rectangle4.y + rectangle4.height;
                        n2 = ganttChart.rowAtPoint(point);
                        rectangle4 = ganttChart.getRowRect(n2, true);
                    }
                    if (rectangle4.y >= rectangle.y) {
                        point.y = rectangle.y - 1;
                        n2 = ganttChart.rowAtPoint(point);
                    }
                }
            } else {
                Point point = new Point(rectangle.x, rectangle2.y + rectangle2.height - 1);
                n2 = ganttChart.rowAtPoint(point);
                Rectangle rectangle5 = ganttChart.getRowRect(n2, true);
                if (rectangle5.y + rectangle5.height > rectangle2.y + rectangle2.height) {
                    point.y = rectangle5.y - 1;
                    n2 = ganttChart.rowAtPoint(point);
                    n2 = Math.max(n2, n3);
                }
                if (n3 >= n2) {
                    rectangle2.y = rectangle.y;
                    point.y = rectangle2.y + rectangle2.height - 1;
                    n2 = ganttChart.rowAtPoint(point);
                    rectangle5 = ganttChart.getRowRect(n2, true);
                    if (rectangle5.y + rectangle5.height > rectangle2.y + rectangle2.height) {
                        point.y = rectangle5.y - 1;
                        n2 = ganttChart.rowAtPoint(point);
                        rectangle5 = ganttChart.getRowRect(n2, true);
                    }
                    if (rectangle5.y <= rectangle.y) {
                        point.y = rectangle.y + rectangle.height;
                        n2 = ganttChart.rowAtPoint(point);
                    }
                }
            }
            return n2;
        }

        private void changeSelection(GanttChart<?, ?> ganttChart, int n, int n2, int n3) {
            if (n2 >= 0 && n2 < ganttChart.getEntryCount()) {
                ListSelectionModel listSelectionModel = ganttChart.getSelectionModel();
                if (n == 0 && ganttChart.getSelectionMode() != 2) {
                    n = 1;
                }
                this.adjustScrollPositionIfNecessary(ganttChart, n2, n3);
                if (n == 2) {
                    int n4 = BasicGanttChartUI.adjustIndex(listSelectionModel.getAnchorSelectionIndex(), ganttChart);
                    if (n4 == -1) {
                        n4 = 0;
                    }
                    ganttChart.setSelectionInterval(n4, n2);
                } else if (n == 1) {
                    ganttChart.setSelectedIndex(n2);
                } else {
                    ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(n2);
                }
            }
        }

        private void adjustScrollPositionIfNecessary(GanttChart<?, ?> ganttChart, int n, int n2) {
            if (n2 == 0) {
                return;
            }
            Rectangle rectangle = ganttChart.getRowRect(n, true);
            Rectangle rectangle2 = ganttChart.getVisibleRect();
            if (rectangle != null && !rectangle2.contains(rectangle)) {
                if (n2 > 0 && (rectangle.y < rectangle2.y || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height)) {
                    int n3 = Math.max(0, rectangle.y + rectangle.height - rectangle2.height);
                    int n4 = ganttChart.rowAtPoint(new Point(rectangle.x, n3));
                    Rectangle rectangle3 = ganttChart.getRowRect(n4, true);
                    if (rectangle3.y < n3 && rectangle3.y < rectangle.y) {
                        rectangle3.y += rectangle3.height;
                        n4 = ganttChart.rowAtPoint(rectangle3.getLocation());
                        rectangle3 = ganttChart.getRowRect(n4, true);
                    }
                    rectangle = rectangle3;
                    rectangle.height = rectangle2.height;
                } else {
                    rectangle.height = Math.min(rectangle.height, rectangle2.height);
                }
                ganttChart.scrollRectToVisible(rectangle);
            }
        }

        private int getNextIndex(GanttChart<?, ?> ganttChart, BasicGanttChartUI basicGanttChartUI, int n) {
            int n2 = BasicGanttChartUI.adjustIndex(ganttChart.getLeadSelectionIndex(), ganttChart);
            int n3 = ganttChart.getEntryCount();
            if (n2 == -1) {
                if (n3 > 0) {
                    n2 = n > 0 ? 0 : n3 - 1;
                }
            } else {
                n2 = n3 == 1 ? 0 : (n2 += n);
            }
            return n2;
        }
    }

    public static class BasicRelationPainter
    extends BasicGanttEntryRelationPainter
    implements UIResource {
        public static final Shape BLOCK = new Rectangle2D.Double(0.0, -2.0, 3.0, 4.0);
        public static final Shape ARROW = new Polygon(new int[]{0, 4, 4}, new int[]{0, -4, 4}, 3);
        public static final int DEFAULT_EXTEND_WIDTH = 10;

        public BasicRelationPainter(int n, Shape shape, Shape shape2, Insets insets) {
            super(n, shape, shape2, insets);
        }
    }

    private class Handler<T>
    implements MouseInputListener,
    MouseWheelListener,
    KeyListener,
    FocusListener,
    ListSelectionListener,
    PropertyChangeListener,
    TreeWillExpandListener,
    TreeExpansionListener,
    UIResource {
        private static final int NONE = 0;
        private static final int MOVE = 1;
        private static final int RESIZE_WEST = 2;
        private static final int RESIZE_EAST = 3;
        private static final int CHANGE_COMPLETION = 4;
        private static final int SELECTION = 5;
        private final GanttChart<T, GanttEntry<T>> _chart;
        private Point _pressedPoint;
        private Point _pressedViewPortPoint;
        private Rectangle _pressedVisibleRect;
        private int _pressedRow;
        private int _action;
        private MutableGanttEntry<T> _draggedEntry;
        private int _originalStartX;
        private int _originalEndX;
        private boolean _treeExpanding;

        private Handler(GanttChart<T, GanttEntry<T>> ganttChart) {
            this._chart = ganttChart;
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this._treeExpanding = false;
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            this._treeExpanding = true;
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this._treeExpanding = false;
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            this._treeExpanding = true;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                if (listSelectionModel != null) {
                    listSelectionModel.removeListSelectionListener(this);
                }
                if ((listSelectionModel = (ListSelectionModel)propertyChangeEvent.getNewValue()) != null) {
                    listSelectionModel.addListSelectionListener(this);
                }
            } else if (BasicScaleAreaUI.Handler.SCALE_PROPERTIES.contains(propertyChangeEvent.getPropertyName())) {
                this._chart.revalidate();
                this._chart.repaint();
            }
        }

        protected void repaintCellFocus() {
            Rectangle rectangle;
            int n = BasicGanttChartUI.adjustIndex(this._chart.getLeadSelectionIndex(), this._chart);
            if (n != -1 && (rectangle = this._chart.getRowRect(n, true)) != null) {
                rectangle.grow(2, 2);
                this._chart.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (this._chart.getViewMode() == 1) {
                    Rectangle rectangle = new Rectangle(mouseEvent.getPoint());
                    Rectangle rectangle2 = this._chart.getVisibleRect();
                    rectangle.grow((rectangle2.width - rectangle.width) / 2, (rectangle2.height - rectangle.height) / 2);
                    this._chart.scrollRectToVisible(rectangle);
                } else if (this._draggedEntry != null) {
                    this._chart.scrollRowToVisible(this._chart.getIndexOf(this._draggedEntry));
                }
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.adjustSelection(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                Object object;
                GanttEntry ganttEntry;
                this._pressedPoint = mouseEvent.getPoint();
                this._pressedViewPortPoint = SwingUtilities.convertPoint(this._chart, this._pressedPoint, this._chart.getParent());
                this._pressedVisibleRect = this._chart.getVisibleRect();
                int n = this._chart.rowAtPoint(this._pressedPoint);
                if (n >= 0 && (ganttEntry = BasicGanttChartUI.this.getEntryAt(n, this._pressedPoint)) != null && (object = ganttEntry.getRange()) != null) {
                    ScaleArea scaleArea = this._chart.getScaleArea();
                    this._originalStartX = scaleArea.getX(object.lower());
                    this._originalEndX = scaleArea.getX(object.upper());
                }
                this._pressedRow = this._chart.rowAtPoint(this._pressedPoint);
                this._chart.requestFocusInWindow();
                ganttEntry = BasicGanttChartUI.this.getEntryAt(this._pressedRow, mouseEvent.getPoint());
                if (this._action == 4 && ganttEntry instanceof MutableGanttEntry) {
                    object = this._chart.getEntryRect(ganttEntry, this._pressedRow);
                    if (object == null) {
                        return;
                    }
                    double d = Math.max(0.0, Math.min(1.0, (double)(this._pressedPoint.x - ((Rectangle)object).x) / (double)((Rectangle)object).width));
                    ((MutableGanttEntry)ganttEntry).setCompletion(d);
                    return;
                }
                if (this._chart.getViewMode() == 1 && !JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent) && !mouseEvent.isShiftDown()) {
                    object = this._chart.getEntryRect(ganttEntry, this._pressedRow);
                    if (object == null) {
                        return;
                    }
                    ((Rectangle)object).grow(this._chart.getResizeAreaWidth(), this._chart.getResizeAreaWidth());
                    if (!((Rectangle)object).contains(this._pressedPoint)) {
                        return;
                    }
                }
            }
        }

        private void adjustSelection(MouseEvent mouseEvent) {
            if (this._pressedRow == -1) {
                return;
            }
            this._chart.changeSelection(this._pressedRow, JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent), mouseEvent.isShiftDown());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this._draggedEntry != null) {
                    this._draggedEntry.setAdjusting(false);
                    Expandable expandable = this._draggedEntry.getParent();
                    while (expandable instanceof MutableGanttEntry) {
                        ((MutableGanttEntry)expandable).setAdjusting(false);
                        expandable = expandable.getParent();
                    }
                    expandable = this._draggedEntry.getParent();
                    if (expandable != null) {
                        expandable.notifyChildUpdated(this._draggedEntry);
                    }
                    this._draggedEntry = null;
                }
                this._pressedVisibleRect = null;
                this._pressedViewPortPoint = null;
                this._pressedPoint = null;
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            block24: {
                Point point;
                block25: {
                    block23: {
                        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                            return;
                        }
                        point = mouseEvent.getPoint();
                        if (this._action != 5) break block23;
                        int n = this._chart.rowAtPoint(point);
                        if (n == -1) {
                            return;
                        }
                        this._chart.changeSelection(n, JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent), true);
                        break block24;
                    }
                    if (this._action != 0) break block25;
                    if (this._pressedVisibleRect == null || !this.canPan()) break block24;
                    Point point2 = SwingUtilities.convertPoint(this._chart, point, this._chart.getParent());
                    Rectangle rectangle = new Rectangle(this._pressedVisibleRect);
                    rectangle.x = (int)((double)rectangle.x + (this._pressedViewPortPoint.getX() - point2.getX()));
                    rectangle.y = (int)((double)rectangle.y + (this._pressedViewPortPoint.getY() - point2.getY()));
                    this._chart.scrollRectToVisible(rectangle);
                    break block24;
                }
                if (this._pressedPoint != null) {
                    boolean bl = mouseEvent.isShiftDown();
                    boolean bl2 = this._chart.getComponentOrientation().isLeftToRight();
                    ScaleArea<T> scaleArea = this._chart.getScaleArea();
                    switch (this._action) {
                        case 1: {
                            Rectangle rectangle;
                            Object object;
                            if (this._draggedEntry == null) {
                                return;
                            }
                            int n = point.x - this._pressedPoint.x;
                            T t = scaleArea.getInstantAt(this._originalStartX + n);
                            if (bl) {
                                object = scaleArea.getSmallestVisiblePeriod();
                                t = scaleArea.getScaleModel().getPeriodStart((Period)object, t);
                            }
                            this._draggedEntry.setAdjusting(true);
                            object = this._draggedEntry.getParent();
                            while (object instanceof MutableGanttEntry) {
                                ((MutableGanttEntry)object).setAdjusting(true);
                                object = object.getParent();
                            }
                            Range<Object> range = this._draggedEntry.setRange(t, null);
                            Object t2 = range.upper();
                            if (t2 instanceof Comparable && ((Comparable)t2).compareTo(scaleArea.getEnd()) > 0) {
                                scaleArea.setEnd(t2);
                            }
                            if (t instanceof Comparable && ((Comparable)t).compareTo(scaleArea.getStart()) < 0) {
                                scaleArea.setStart(t);
                            }
                            this.resizeAndRepaint();
                            int n2 = this._chart.rowAtPoint(point);
                            if (n2 < 0 || (rectangle = this._chart.getEntryRect(this._draggedEntry, n2)) == null) break;
                            Rectangle rectangle2 = (Rectangle)rectangle.clone();
                            rectangle2.x = mouseEvent.getX();
                            rectangle2.width = 1;
                            this._chart.scrollRectToVisible(rectangle2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            Rectangle rectangle;
                            Object t;
                            Period period;
                            if (this._draggedEntry == null) {
                                return;
                            }
                            boolean bl3 = bl2 && this._action == 2 || !bl2 && this._action == 3;
                            Range range = this._draggedEntry.getRange();
                            if (range == null) {
                                return;
                            }
                            T t3 = scaleArea.getInstantAt(point.x);
                            if (bl) {
                                period = scaleArea.getSmallestVisiblePeriod();
                                t3 = scaleArea.getScaleModel().getPeriodStart(period, t3);
                            }
                            if (bl3) {
                                if (bl2 && point.x > this._originalEndX || !bl2 && point.x < this._originalEndX) {
                                    period = range.lower();
                                    t = t3;
                                } else {
                                    period = t3;
                                    t = range.upper();
                                }
                            } else if (bl2 && point.x < this._originalStartX || !bl2 && point.x > this._originalStartX) {
                                period = t3;
                                t = range.upper();
                            } else {
                                period = range.lower();
                                t = t3;
                            }
                            this.resizeAndRepaint();
                            if (!this._chart.isAllowResizeEntry((GanttEntry<Period>)this._draggedEntry, period, (Period)t)) break;
                            this._draggedEntry.setAdjusting(true);
                            this._draggedEntry.setRange(period, (Period)t);
                            int n = this._chart.rowAtPoint(point);
                            if (n < 0 || (rectangle = this._chart.getEntryRect(this._draggedEntry, n)) == null) break;
                            this._chart.scrollRectToVisible(rectangle);
                            break;
                        }
                        case 4: {
                            Rectangle rectangle;
                            GanttEntry ganttEntry = BasicGanttChartUI.this.getEntryAt(this._pressedRow, mouseEvent.getPoint());
                            if (!(ganttEntry instanceof MutableGanttEntry) || (rectangle = this._chart.getEntryRect(ganttEntry, this._pressedRow)) == null) break;
                            double d = (double)(point.x - rectangle.x) / (double)rectangle.width;
                            ((MutableGanttEntry)ganttEntry).setAdjusting(true);
                            ((MutableGanttEntry)ganttEntry).setCompletion(d);
                            break;
                        }
                        default: {
                            assert (false) : "Unknown drag action: " + this._action;
                            break;
                        }
                    }
                }
            }
        }

        protected void resizeAndRepaint() {
            Container container;
            for (container = this._chart.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
            }
            if (container != null) {
                container = container.getParent();
            }
            if (container != null) {
                container.invalidate();
                container.repaint();
                container.doLayout();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Rectangle rectangle;
            Point point = mouseEvent.getPoint();
            int n = this._chart.rowAtPoint(point);
            if (n == -1) {
                this._chart.setCursor(Cursor.getDefaultCursor());
                this._action = 0;
                this._draggedEntry = null;
                this._originalStartX = 0;
                this._originalEndX = 0;
                return;
            }
            GanttEntry ganttEntry = BasicGanttChartUI.this.getEntryAt(n, mouseEvent.getPoint());
            if (ganttEntry != null && (rectangle = this._chart.getEntryRect(ganttEntry, n)) != null) {
                boolean bl;
                Rectangle rectangle2 = (Rectangle)rectangle.clone();
                rectangle2.x -= this._chart.getResizeAreaWidth() / 2;
                rectangle2.width += this._chart.getResizeAreaWidth();
                rectangle2.y -= 2;
                rectangle2.height += 4;
                Range range = ganttEntry.getRange();
                if (range == null) {
                    return;
                }
                boolean bl2 = bl = range.maximum() == range.minimum();
                if (bl) {
                    rectangle2.x -= this._chart.getResizeAreaWidth() / 2;
                    rectangle2.width += this._chart.getResizeAreaWidth();
                }
                if (rectangle2.contains(point) && this._chart.isEditable() && this._chart.getViewMode() != 1 && ganttEntry instanceof MutableGanttEntry) {
                    this._draggedEntry = (MutableGanttEntry)ganttEntry;
                    boolean bl3 = this._draggedEntry.isRangeEditable();
                    boolean bl4 = this._draggedEntry.isCompletionEditable();
                    if (bl3 && this._chart.isResizeWestArea(point, rectangle)) {
                        this._chart.setCursor(JideCursors.getPredefinedCursor(37));
                        this._action = 2;
                    } else if (bl3 && this._chart.isResizeEastArea(point, rectangle)) {
                        this._chart.setCursor(JideCursors.getPredefinedCursor(36));
                        this._action = 3;
                    } else if (bl4 && !bl && point.y >= rectangle2.y + rectangle2.height / 2 - 2 && point.y <= rectangle2.y + rectangle2.height / 2 + 2) {
                        this._chart.setCursor(JideCursors.getPredefinedCursor(35));
                        this._action = 4;
                    } else if (bl3 && this._chart.isAllowMoveEntry() && (rectangle.contains(point) || rectangle.isEmpty() && new Rectangle(rectangle.x - this._chart.getResizeAreaWidth() / 2, rectangle.y, rectangle.width + this._chart.getResizeAreaWidth(), rectangle.height).contains(point))) {
                        this._chart.setCursor(Cursor.getPredefinedCursor(13));
                        this._action = 1;
                    } else {
                        this._chart.setCursor(Cursor.getDefaultCursor());
                        this._action = 0;
                        this._draggedEntry = null;
                        this._originalStartX = 0;
                        this._originalEndX = 0;
                        return;
                    }
                    ScaleArea scaleArea = this._chart.getScaleArea();
                    this._originalStartX = scaleArea.getX(range.lower());
                    this._originalEndX = scaleArea.getX(range.upper());
                    return;
                }
            }
            if (this._chart.getViewMode() == 1 && !JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent) && !mouseEvent.isShiftDown()) {
                if (this.canPan()) {
                    this._chart.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    this._chart.setCursor(Cursor.getDefaultCursor());
                }
                this._action = 0;
            } else {
                this._chart.setCursor(Cursor.getDefaultCursor());
                this._action = 5;
            }
            this._draggedEntry = null;
            this._originalStartX = 0;
            this._originalEndX = 0;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (this._chart.getViewMode() == 1 && (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 16)) {
                this._chart.setCursor(Cursor.getDefaultCursor());
                this._action = 5;
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this._chart.getViewMode() == 1 && (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 16)) {
                if (this.canPan()) {
                    this._chart.setCursor(Cursor.getPredefinedCursor(13));
                }
                this._action = 0;
            }
        }

        private boolean canPan() {
            return !this._chart.getVisibleRect().contains(this._chart.getBounds());
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (JideSwingUtilities.isMenuShortcutKeyDown(mouseWheelEvent) && this._chart.isAllowMouseWheelZoom()) {
                if (mouseWheelEvent.getWheelRotation() > 0) {
                    this._chart.zoomOutPeriods();
                } else {
                    this._chart.zoomInPeriods();
                }
                mouseWheelEvent.consume();
            } else if (this._chart.getParent() != null) {
                this._chart.getParent().dispatchEvent(SwingUtilities.convertMouseEvent(this._chart, mouseWheelEvent, this._chart.getParent()));
            }
        }
    }
}

