/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.gantt.GanttChart;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.scale.Period;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.scale.ScaleModel;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

abstract class AbstractPeriodPainter
implements Serializable {
    private static final long serialVersionUID = -7494681359197722718L;
    private final int _minimumDistance;
    private boolean _chartPrinting;

    public AbstractPeriodPainter(int n) {
        this._minimumDistance = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintAllPeriodIntervals(GanttChart<Object, GanttEntry<Object>> ganttChart, Graphics2D graphics2D, List<Period> list) {
        try {
            this._chartPrinting = ganttChart.isPaintingForPrint();
            this.paintAllPeriodIntervals(ganttChart.getScaleArea(), graphics2D, list);
        }
        finally {
            this._chartPrinting = false;
        }
    }

    protected void paintAllPeriodIntervals(ScaleArea<Object> scaleArea, Graphics2D graphics2D, List<Period> list) {
        boolean bl = scaleArea.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics2D.getClipBounds();
        int n = scaleArea.getPreferredPeriodSize().height;
        int n2 = scaleArea.getHeight();
        int n3 = rectangle.x;
        int n4 = rectangle.x + rectangle.width;
        ScaleModel<Object> scaleModel = scaleArea.getScaleModel();
        if (scaleModel == null) {
            this.paintPeriodInterval(scaleArea, graphics2D, null, null, null, n3, n2 - n, n4, n2);
            return;
        }
        for (Period period : list) {
            int n5;
            int n6 = bl ? n3 : n4;
            int n7 = bl ? n4 : n3;
            Object object = scaleArea.getInstantAt(n6);
            Object object2 = scaleArea.getInstantAt(n7);
            if (this.isBelowMinimumDistance(graphics2D, scaleArea, scaleModel, period, object)) continue;
            List<Object> list2 = scaleModel.getPeriodBoundaries(period, object, object2);
            if (!bl) {
                Collections.reverse(list2);
            }
            if ((n5 = list2.size()) < 1) continue;
            object = list2.get(0);
            n6 = scaleArea.getX(object);
            for (int i = 1; i < n5; ++i) {
                object2 = list2.get(i);
                n7 = scaleArea.getX(object2);
                this.paintPeriodInterval(scaleArea, graphics2D, period, bl ? object : object2, bl ? object2 : object, n6, n2 - n, n7, n2);
                n6 = n7;
                object = object2;
            }
            n2 -= n;
        }
    }

    protected boolean isBelowMinimumDistance(Graphics2D graphics2D, ScaleArea<Object> scaleArea, ScaleModel<Object> scaleModel, Period period, Object object) {
        if (scaleArea.isPaintingForPrint() || this._chartPrinting) {
            return false;
        }
        double d = 1.0;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (affineTransform != null) {
            d = affineTransform.getScaleX();
        }
        Object object2 = scaleModel.getPeriodStart(period, object);
        Object object3 = scaleModel.getPeriodEnd(period, object);
        return Math.abs(d * (double)scaleArea.getX(object3) - d * (double)scaleArea.getX(object2)) < (double)this._minimumDistance;
    }

    protected abstract void paintPeriodInterval(ScaleArea<Object> var1, Graphics2D var2, Period var3, Object var4, Object var5, int var6, int var7, int var8, int var9);
}

