/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.pivot.PivotField;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ResourceProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

class SubtotalSettingPanel
extends JPanel {
    private ResourceProvider _resourceProvider;
    private JRadioButton _automaticRadio;
    private JRadioButton _customRadio;
    private JRadioButton _noneRadio;
    private CheckBoxList _subtotalList;
    private int[] _availableSummaries;

    public SubtotalSettingPanel(ResourceProvider resourceProvider) {
        this._resourceProvider = resourceProvider;
        this.installComponents();
        this.installListeners();
    }

    protected void installComponents() {
        this._automaticRadio = new JRadioButton(this._resourceProvider.getResourceString("FieldSettings.automatic"));
        this._customRadio = new JRadioButton(this._resourceProvider.getResourceString("FieldSettings.custom"));
        this._noneRadio = new JRadioButton(this._resourceProvider.getResourceString("FieldSettings.none"));
        this._automaticRadio.setMnemonic(this._resourceProvider.getResourceString("FieldSettings.automatic.mnemonic").charAt(0));
        this._customRadio.setMnemonic(this._resourceProvider.getResourceString("FieldSettings.custom.mnemonic").charAt(0));
        this._noneRadio.setMnemonic(this._resourceProvider.getResourceString("FieldSettings.none.mnemonic").charAt(0));
        this._subtotalList = new CheckBoxList(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                dimension.width = 150;
                return dimension;
            }

            @Override
            public boolean isCheckBoxEnabled(int n) {
                int[] nArray = SubtotalSettingPanel.this.getAvailableSummaries();
                if (nArray != null) {
                    for (int n2 : nArray) {
                        if (n != n2) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        };
        this._subtotalList.setVisibleRowCount(7);
        this.setLayout(new BorderLayout(10, 6));
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
        jPanel.add(this._automaticRadio);
        jPanel.add(this._customRadio);
        jPanel.add(this._noneRadio);
        this.add((Component)JideSwingUtilities.createTopPanel(jPanel), "Before");
        this.add(new JScrollPane(this._subtotalList));
    }

    protected void installListeners() {
        ButtonGroup buttonGroup = new ButtonGroup();
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SubtotalSettingPanel.this._subtotalList.setEnabled(false);
                }
            }
        };
        ItemListener itemListener2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SubtotalSettingPanel.this._subtotalList.setEnabled(true);
                }
            }
        };
        buttonGroup.add(this._automaticRadio);
        this._automaticRadio.addItemListener(itemListener);
        buttonGroup.add(this._customRadio);
        this._customRadio.addItemListener(itemListener2);
        buttonGroup.add(this._noneRadio);
        this._noneRadio.addItemListener(itemListener);
    }

    public void setListModel(ListModel listModel) {
        this._subtotalList.setModel(listModel);
    }

    public void loadData(int n, int[] nArray) {
        switch (n) {
            case 1: {
                this._automaticRadio.setSelected(true);
                this._subtotalList.setEnabled(false);
                break;
            }
            case 2: {
                this._customRadio.setSelected(true);
                this._subtotalList.setEnabled(true);
                break;
            }
            case 0: {
                this._noneRadio.setSelected(true);
                this._subtotalList.setEnabled(false);
            }
        }
        this._subtotalList.getCheckBoxListSelectionModel().clearSelection();
        if (nArray != null) {
            for (int n2 : nArray) {
                this._subtotalList.getCheckBoxListSelectionModel().addSelectionInterval(n2, n2);
            }
        }
    }

    public void saveData(PivotField pivotField, int n) {
        int n2 = 1;
        if (this._automaticRadio.isSelected()) {
            n2 = 1;
        } else if (this._customRadio.isSelected()) {
            n2 = 2;
        } else if (this._noneRadio.isSelected()) {
            n2 = 0;
        }
        int[] nArray = this._subtotalList.getCheckBoxListSelectedIndices();
        switch (n) {
            case 0: {
                pivotField.setSubtotalType(n2);
                pivotField.setCustomSubtotals(nArray);
                break;
            }
            case 1: {
                pivotField.setSubtotalTypeForRow(n2);
                pivotField.setCustomSubtotalsForRow(nArray);
                break;
            }
            case 2: {
                pivotField.setSubtotalTypeForColumn(n2);
                pivotField.setCustomSubtotalsForColumn(nArray);
            }
        }
    }

    public int[] getAvailableSummaries() {
        return this._availableSummaries;
    }

    public void setAvailableSummaries(int[] nArray) {
        this._availableSummaries = nArray;
        if (this._subtotalList != null) {
            this._subtotalList.repaint();
        }
    }
}

