/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.EnumConverter;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.filter.CustomFilterEditor;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.CellEditorFactory;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.ContextSensitiveCellRenderer;
import com.jidesoft.grid.CustomFilterEditorDialog;
import com.jidesoft.grid.DynamicTableFilter;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.EnumCellEditor;
import com.jidesoft.grid.GridIconsFactory;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.IndexChangeEvent;
import com.jidesoft.grid.IndexChangeListener;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.ListComboBoxCellEditor;
import com.jidesoft.grid.QuickFilterField;
import com.jidesoft.grid.SummaryCalculator;
import com.jidesoft.grid.TableColumnAutoResizer;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableSelectionModel;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.pivot.CalculatedHeaderTableModel;
import com.jidesoft.pivot.CompareToConverter;
import com.jidesoft.pivot.CopiedExpandableValue;
import com.jidesoft.pivot.DataTable;
import com.jidesoft.pivot.DataTableModel;
import com.jidesoft.pivot.DefaultExpandableValue;
import com.jidesoft.pivot.DefaultValues;
import com.jidesoft.pivot.DummyValue;
import com.jidesoft.pivot.FieldArea;
import com.jidesoft.pivot.FieldBox;
import com.jidesoft.pivot.FieldBoxInputListener;
import com.jidesoft.pivot.FieldSettingsDialog;
import com.jidesoft.pivot.FieldSettingsPanel;
import com.jidesoft.pivot.FixScrollPaneUI;
import com.jidesoft.pivot.GrandTotalValues;
import com.jidesoft.pivot.HeaderTable;
import com.jidesoft.pivot.HeaderTableModel;
import com.jidesoft.pivot.HideColumnPropertyListener;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotConstants;
import com.jidesoft.pivot.PivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotResources;
import com.jidesoft.pivot.PivotValueProvider;
import com.jidesoft.pivot.PivotValueProviderEvent;
import com.jidesoft.pivot.PivotValueProviderListener;
import com.jidesoft.pivot.PopupMenuMouseListener;
import com.jidesoft.pivot.QuickUnassignedFieldsAreaFilterField;
import com.jidesoft.pivot.RunningSummary;
import com.jidesoft.pivot.SummaryValues;
import com.jidesoft.pivot.UnassignedFieldsArea;
import com.jidesoft.pivot.Value;
import com.jidesoft.pivot.Values;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.CornerScroller;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialLineBorder;
import com.jidesoft.swing.Searchable;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.ResourceProvider;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.CellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PivotTablePane
extends JPanel
implements PivotConstants,
ResourceProvider,
IndexChangeListener,
PropertyChangeListener,
PivotValueProviderListener {
    private IPivotDataModel _pivotDataModel;
    protected FieldArea _filterFieldsArea;
    protected FieldArea _dataFieldsArea;
    protected FieldArea _rowFieldsArea;
    protected FieldArea _columnFieldsArea;
    private boolean _fieldChooserAreaVisible = true;
    private boolean _filterFieldAreaVisible = true;
    private boolean _dataFieldAreaVisible = true;
    private boolean _rowFieldAreaVisible = true;
    private boolean _columnFieldAreaVisible = true;
    private boolean _flatLayout = false;
    private boolean _allowSortByRow = false;
    protected Map<PivotField, FieldBox> _fieldBoxMap;
    protected JTable _rowHeaderTable;
    protected JTable _columnHeaderTable;
    protected JTable _dataTable;
    protected JTable _cornerTable;
    public static final int FIELD_GAP = 2;
    private int _rowHeight = 20;
    private FieldBoxInputListener _listener;
    private Container _fieldsPanel;
    protected UnassignedFieldsArea _unassignedFieldsArea;
    private ButtonGroup _unassignedButtonGroup;
    private boolean _fieldChooserEnabled = true;
    private String _version;
    private ThemePainter _painter;
    private JPanel _fieldChooserComboBoxPanel;
    private Searchable _unassignedFieldsAreaSearchable;
    private QuickUnassignedFieldsAreaFilterField _filterField;
    private PropertyChangeListener _panePropertyChangeListener;
    private PopupMenuMouseListener _popupMenuMouseListener;
    PropertyChangeListener _columnProertyChangeListener;
    private boolean _rearrangable = true;
    private Color _gridColor;
    private boolean _plainHeaderTables = false;
    private int _headerSelectionMode = 1;
    private boolean _dataFieldFilterable = false;
    private boolean _rowFieldFilterable = true;
    private boolean _columnFieldFilterable = true;
    private boolean _hideExpandIconOnSingleRow = true;
    private boolean _scrollSelectionToVisible = true;
    private boolean _showFilterButtonsOnMouseOver = false;
    private boolean _dataFieldsDuplicationEnabled = false;
    private Map<PivotField, Integer> _hiddenHeaderField;
    public static final String PROPERTY_PLAIN_HEADER_TABLES = "plainHeaderTables";
    public static final String PROPERTY_HEADER_SELECTION_MODEL = "headerSelectionModel";
    public static final String PROPERTY_GRID_COLOR = "gridColor";
    public static final String PROPERTY_FILTER_FIELD_AREA_VISIBLE = "filterFieldAreaVisible";
    public static final String PROPERTY_DATA_FIELD_AREA_VISIBLE = "dataFieldAreaVisible";
    public static final String PROPERTY_ROW_FIELD_AREA_VISIBLE = "rowFieldAreaVisible";
    public static final String PROPERTY_COLUMN_FIELD_AREA_VISIBLE = "columnFieldAreaVisible";
    public static final String PROPERTY_FIELD_CHOOSER_AREA_VISIBLE = "fieldChooserAreaVisible";
    public static final String PROPERTY_DATA_FIELD_FILTERABLE = "dataFieldFilterable";
    public static final String PROPERTY_COLUMN_FIELD_FILTERABLE = "columnFieldFilterable";
    public static final String PROPERTY_ROW_FIELD_FILTERABLE = "rowFieldFilterable";
    public static final String PROPERTY_HIDE_EXPAND_ICON_ON_SINGLE_ROW = "hideExpandIconOnSignleRow";
    public static final String PROPERTY_SCROLL_SELECTION_TO_VISIBLE = "scrollSelectionToVisible";
    public static final String PROPERTY_FLAT_LAYOUT = "flatLayout";
    public static final String PROPERTY_SHOW_FILTER_BUTTONS_ON_MOUSE_OVER = "showFilterButtonsOnMouseOver";
    public static final String PROPERTY_DATA_FIELDS_DUPLICATION_ENABLED = "dataFieldsDuplicationEnabled";
    protected JPanel _separator;
    protected Container _contentPanel;
    private int _visibleRowCount = 20;
    protected JScrollPane _scrollPane;
    protected JComboBox _addToComboBox;
    protected JButton _addToButton;
    protected PivotField _addToComboBoxField;
    private boolean _shrinkDataFieldArea = true;
    private boolean _hideFieldOnDraggingOut = true;
    private boolean _keepFieldAreaFit = false;
    private boolean _showFilterIcon = false;
    private Icon _filterIcon = null;
    protected TableColumnAutoResizer[] _columnAutoResizer = null;
    private boolean _considerRowFieldWidth = true;
    private boolean _restoreColumnWidthNeeded = true;
    private Cursor _dragNoDropCursor = null;
    private Cursor _dragRemoveCursor = JideCursors.getPredefinedCursor(32);
    private boolean _respectFieldPreferredWidth = false;
    protected static final String CLIENT_PROPERTY_COLUMN_MODEL_LISTENER = "PivotTablePane.columnModelListener";
    protected static final String CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER = "PivotTablePane.propertyChangeListener";
    protected static final String CLIENT_PROPERTY_COMPONENT_LISTENER = "PivotTablePane.componentListener";
    public static final String FIELD_SETTING_DIALOG_OK_BUTTON = "OptionPane.okButtonText";
    public static final String FIELD_SETTING_DIALOG_CANCEL_BUTTON = "OptionPane.cancelButtonText";
    public static final String FIELD_SETTING_DIALOG_HIDE_BUTTON = "PivotTablePane.hide";
    private PopupMenuCustomizer _popupMenuCustomizer;
    private PopupMenuCustomizer _headerTablePopupMenuCustomizer;
    private PopupMenuCustomizer _dataTablePopupMenuCustomizer;
    public static final ConverterContext CONVERTER_CONTEXT_RUNNING_TYPE;
    public static final EditorContext EDITOR_CONTEXT_RUNNING_TYPE;
    public static final ConverterContext CONVERTER_CONTEXT_PIVOT_FIELD;
    public static final EditorContext EDITOR_CONTEXT_PIVOT_FIELD;
    public static final EditorContext EDITOR_CONTEXT_COMPARE_TO;
    private EnumConverter _runningTypeConverter;
    private ObjectConverter _pivotFieldConverter;
    private ObjectConverter _compareToConverter;
    Map<Integer, Integer>[] _columnHeaderWidths;
    Map<Integer, Integer>[] _rowHeaderWidths;
    private Object[] _savedSelections;
    private PivotField[] _previousRowFields;
    private PivotField[] _previousColumnFields;

    public PivotTablePane() {
        this.installListeners();
    }

    public PivotTablePane(IPivotDataModel iPivotDataModel) {
        this.installListeners();
        this.setPivotDataModel(iPivotDataModel);
    }

    private void installListeners() {
        if (this._panePropertyChangeListener == null) {
            this._panePropertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (PivotTablePane.PROPERTY_ROW_FIELD_AREA_VISIBLE.equals(propertyChangeEvent.getPropertyName()) || PivotTablePane.PROPERTY_COLUMN_FIELD_AREA_VISIBLE.equals(propertyChangeEvent.getPropertyName()) || PivotTablePane.PROPERTY_DATA_FIELD_AREA_VISIBLE.equals(propertyChangeEvent.getPropertyName()) || PivotTablePane.PROPERTY_FILTER_FIELD_AREA_VISIBLE.equals(propertyChangeEvent.getPropertyName())) {
                        PivotTablePane.this.refreshAddToComboBox(null);
                    }
                }
            };
        }
        this.addPropertyChangeListener(this._panePropertyChangeListener);
    }

    public void setPivotDataModel(IPivotDataModel iPivotDataModel) {
        if (this._pivotDataModel instanceof PivotValueProvider) {
            ((PivotValueProvider)((Object)this._pivotDataModel)).removePivotValueProviderListener(this);
        }
        this._pivotDataModel = iPivotDataModel;
        this.init();
        this.updateUI();
        if (this._pivotDataModel instanceof PivotValueProvider) {
            ((PivotValueProvider)((Object)this._pivotDataModel)).addPivotValueProviderListener(this);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
    }

    private void init() {
        PivotField[] pivotFieldArray;
        if (!this.getPivotDataModel().isCalculated()) {
            this.getPivotDataModel().calculate();
        }
        if ((pivotFieldArray = this.getPivotDataModel().getDataFields()) != null && this.getPivotDataModel() instanceof PivotDataModel && this.isDataFieldsDuplicationEnabled()) {
            for (PivotField pivotField : pivotFieldArray) {
                PivotField pivotField2 = ((PivotDataModel)this.getPivotDataModel()).duplicateField(pivotField);
                pivotField2.setAreaType(-1);
            }
            this.getPivotDataModel().updateFields();
        }
        this._contentPanel = this.createContentPanel();
        if (this._contentPanel instanceof JPanel) {
            ((JPanel)this._contentPanel).setOpaque(false);
            ((JPanel)this._contentPanel).setBorder(UIDefaultsLookup.getBorder("TextArea.border"));
        }
        if (this._popupMenuMouseListener != null) {
            this._contentPanel.addMouseListener(this._popupMenuMouseListener);
        }
        this._fieldsPanel = this.createFieldPanel();
        this.initConvertersAndEditors();
        this.initComponents();
        this.customizeFieldsPanel(this._fieldsPanel);
        this.setupLayout(this._contentPanel, this._fieldsPanel);
        if (this._fieldsPanel != null) {
            this._fieldsPanel.setVisible(this.isFieldChooserVisible());
        }
        if (this._filterFieldsArea != null) {
            this._filterFieldsArea.setVisible(this.isFilterFieldAreaVisible());
        }
        if (this._separator != null) {
            this._separator.setVisible(this.isFilterFieldAreaVisible());
        }
        if (this._rowFieldsArea != null) {
            this._rowFieldsArea.setVisible(this.isRowFieldAreaVisible());
        }
        if (this._columnFieldsArea != null) {
            this._columnFieldsArea.setVisible(this.isColumnFieldAreaVisible());
        }
        if (this._dataFieldsArea != null) {
            this._dataFieldsArea.setVisible(this.isDataFieldAreaVisible());
        }
    }

    protected Container createFieldPanel() {
        return new JPanel();
    }

    protected Container createContentPanel() {
        return new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                if (PivotTablePane.this._painter == null) {
                    PivotTablePane.this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
                }
                if (PivotTablePane.this._painter != null) {
                    PivotTablePane.this._painter.paintContentBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0, 0);
                }
                super.paintComponent(graphics);
            }
        };
    }

    protected void initComponents() {
        Object object;
        PivotConstants pivotConstants2;
        if (this._listener == null) {
            this._listener = this.createFieldBoxInputListener();
        }
        if (this._popupMenuMouseListener == null) {
            this._popupMenuMouseListener = new PopupMenuMouseListener(this);
            this.addMouseListener(this._popupMenuMouseListener);
        }
        this._columnProertyChangeListener = new HideColumnPropertyListener();
        this._unassignedButtonGroup = new ButtonGroup();
        this._separator = new JPanel();
        this._separator.setOpaque(false);
        this._separator.setPreferredSize(new Dimension(3, 3));
        this._separator.setMinimumSize(new Dimension(3, 3));
        this._separator.setBorder(new PartialLineBorder(Color.GRAY, 1, 2));
        if (this._fieldBoxMap != null) {
            for (PivotConstants pivotConstants2 : this._fieldBoxMap.keySet()) {
                object = this._fieldBoxMap.get(pivotConstants2);
                this.uninitializeFieldBox((FieldBox)object);
            }
        }
        this._fieldBoxMap = new WeakHashMap<PivotField, FieldBox>();
        this._filterFieldsArea = this.createFieldArea(2);
        this._rowFieldsArea = this.createFieldArea(0);
        this._columnFieldsArea = this.createFieldArea(1);
        this._dataFieldsArea = this.createFieldArea(3);
        this.fillFilterFieldArea();
        this.fillRowFieldArea();
        this.fillColumnFieldArea();
        this.fillDataFieldArea();
        HeaderTableModel headerTableModel = this._pivotDataModel.getRowHeaderTableModel();
        pivotConstants2 = this._pivotDataModel.getColumnHeaderTableModel();
        if (this._rowHeaderTable != null) {
            object = this._rowHeaderTable.getClientProperty(CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER);
            if (object instanceof PropertyChangeListener) {
                this._rowHeaderTable.removePropertyChangeListener((PropertyChangeListener)object);
            }
            if ((object = this._rowHeaderTable.getClientProperty(CLIENT_PROPERTY_COMPONENT_LISTENER)) instanceof ComponentListener) {
                this._rowHeaderTable.removeComponentListener((ComponentListener)object);
            }
            this.removePropertyChangeListener((HeaderTable)this._rowHeaderTable);
            TableModel tableModel = this._rowHeaderTable.getModel();
            tableModel.removeTableModelListener(this._rowHeaderTable);
            tableModel.removeTableModelListener(((JideTable)this._rowHeaderTable).getTableSelectionModel());
            if (tableModel instanceof HeaderTableModel) {
                ((HeaderTableModel)tableModel).removeIndexChangeListener(this);
            }
        }
        if (this._columnHeaderTable != null) {
            this.removePropertyChangeListener((HeaderTable)this._columnHeaderTable);
            object = this._columnHeaderTable.getModel();
            object.removeTableModelListener(this._columnHeaderTable);
            object.removeTableModelListener(((JideTable)this._columnHeaderTable).getTableSelectionModel());
            if (object instanceof HeaderTableModel) {
                ((HeaderTableModel)object).removeIndexChangeListener(this);
            }
        }
        if (this._dataTable != null) {
            this._dataTable.getModel().removeTableModelListener(this._dataTable);
            this._dataTable.getModel().removeTableModelListener(((JideTable)this._dataTable).getTableSelectionModel());
        }
        this._dataTable = this.createDataTable();
        this.setDataTableModel(this._dataTable, this._pivotDataModel.getDataTableModel());
        this._dataTable.setGridColor(this.getGridColor());
        this._dataTable.setPreferredScrollableViewportSize(new Dimension(this._dataTable.getPreferredScrollableViewportSize().width, this.getRowHeight() * this._visibleRowCount));
        this._rowHeaderTable = this.createHeaderTable();
        this.setHeaderTableModel(this._rowHeaderTable, headerTableModel);
        this.adjustRowHeight();
        this._rowHeaderTable.putClientProperty("AutoResize.highPerformance", Boolean.FALSE);
        this._columnHeaderTable = this.createHeaderTable();
        this.setHeaderTableModel(this._columnHeaderTable, (TableModel)((Object)pivotConstants2));
        this._columnHeaderTable.setRowHeight(this.getRowHeight());
        this._columnHeaderTable.putClientProperty("AutoResize.highPerformance", Boolean.FALSE);
        this._dataTable.addPropertyChangeListener(this);
        this._rowHeaderTable.addPropertyChangeListener(this);
        this._columnHeaderTable.addPropertyChangeListener(this);
        ((DataTable)this._dataTable).getTableSelectionModel().addTableSelectionListener((HeaderTable)this._rowHeaderTable);
        ((DataTable)this._dataTable).getTableSelectionModel().addTableSelectionListener((HeaderTable)this._columnHeaderTable);
        TableUtils.unifyTableCellSelection(new JTable[]{this._dataTable, this._rowHeaderTable, this._columnHeaderTable});
    }

    protected void initConvertersAndEditors() {
        if (!(CellRendererManager.getRenderer(PivotField.class, EDITOR_CONTEXT_PIVOT_FIELD) instanceof ContextSensitiveCellRenderer)) {
            CellRendererManager.registerRenderer(PivotField.class, new ContextSensitiveCellRenderer(), EDITOR_CONTEXT_PIVOT_FIELD);
            CellRendererManager.registerRenderer(Object.class, new ContextSensitiveCellRenderer(), EDITOR_CONTEXT_COMPARE_TO);
        }
        this._runningTypeConverter = new EnumConverter("RunningType", new Integer[]{0, 1, 2, 3, 4}, new String[]{this.getResourceString("RunningType.Difference"), this.getResourceString("RunningType.PercentageOfItem"), this.getResourceString("RunningType.PercentageFromItem"), this.getResourceString("RunningType.Total"), this.getResourceString("RunningType.PercentageOfTotal")});
        this._compareToConverter = new CompareToConverter(this);
        this._pivotFieldConverter = new ObjectConverter(){

            @Override
            public String toString(Object object, ConverterContext converterContext) {
                if (object instanceof RunningSummary.RangeTotalField) {
                    return PivotTablePane.this.getResourceString("FieldSettings.total");
                }
                if (object instanceof PivotField) {
                    return ((PivotField)object).getTitle();
                }
                return null;
            }

            @Override
            public boolean supportToString(Object object, ConverterContext converterContext) {
                return true;
            }

            @Override
            public Object fromString(String string, ConverterContext converterContext) {
                PivotField[] pivotFieldArray;
                if (string == null) {
                    return null;
                }
                if (string.equals(PivotTablePane.this.getResourceString("FieldSettings.total"))) {
                    return RunningSummary.RangeTotalField.INSTANCE;
                }
                for (PivotField pivotField : pivotFieldArray = PivotTablePane.this._pivotDataModel.getColumnFields()) {
                    if (!string.equals(pivotField.getTitle())) continue;
                    return pivotField;
                }
                return null;
            }

            @Override
            public boolean supportFromString(String string, ConverterContext converterContext) {
                return true;
            }
        };
        ObjectConverterManager.registerConverter(Integer.class, this._runningTypeConverter, CONVERTER_CONTEXT_RUNNING_TYPE);
        CellEditorManager.registerEditor(Integer.class, new CellEditorFactory(){

            @Override
            public CellEditor create() {
                return new EnumCellEditor(PivotTablePane.this._runningTypeConverter);
            }
        }, EDITOR_CONTEXT_RUNNING_TYPE);
        ObjectConverterManager.registerConverter(PivotField.class, this._pivotFieldConverter, CONVERTER_CONTEXT_PIVOT_FIELD);
        CellEditorManager.registerEditor(PivotField.class, new CellEditorFactory(){

            @Override
            public CellEditor create() {
                return new ListComboBoxCellEditor();
            }
        }, EDITOR_CONTEXT_PIVOT_FIELD);
        ObjectConverterManager.registerConverter(RunningSummary.CompareToObject.class, this._compareToConverter, CompareToConverter.CONTEXT);
        CellEditorManager.registerEditor(RunningSummary.CompareToObject.class, new CellEditorFactory(){

            @Override
            public CellEditor create() {
                return new ListComboBoxCellEditor();
            }
        }, EDITOR_CONTEXT_COMPARE_TO);
    }

    public void unregisterConvertersAndEditors() {
        CellRendererManager.unregisterRenderer(PivotField.class, EDITOR_CONTEXT_PIVOT_FIELD);
        CellRendererManager.unregisterRenderer(Object.class, EDITOR_CONTEXT_COMPARE_TO);
        ObjectConverterManager.unregisterConverter(Integer.class, CONVERTER_CONTEXT_RUNNING_TYPE);
        CellEditorManager.unregisterEditor(Integer.class, EDITOR_CONTEXT_RUNNING_TYPE);
        ObjectConverterManager.unregisterConverter(PivotField.class, CONVERTER_CONTEXT_PIVOT_FIELD);
        CellEditorManager.unregisterEditor(PivotField.class, EDITOR_CONTEXT_PIVOT_FIELD);
        ObjectConverterManager.unregisterConverter(RunningSummary.CompareToObject.class, CompareToConverter.CONTEXT);
        CellEditorManager.unregisterEditor(RunningSummary.CompareToObject.class, EDITOR_CONTEXT_COMPARE_TO);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("nonContiguousCellSelection".equals(propertyChangeEvent.getPropertyName()) || "rowSelectionAllowed".equals(propertyChangeEvent.getPropertyName()) || "columnSelectionAllowed".equals(propertyChangeEvent.getPropertyName())) {
            TableUtils.ununifyTableCellSelection(new JTable[]{this._dataTable, this._rowHeaderTable, this._columnHeaderTable});
            TableUtils.unifyTableCellSelection(new JTable[]{this._dataTable, this._rowHeaderTable, this._columnHeaderTable});
        }
    }

    protected FieldBoxInputListener createFieldBoxInputListener() {
        return new FieldBoxInputListener(this);
    }

    protected boolean validateFieldBoxDragging(FieldBox fieldBox, Component component, boolean bl) {
        return true;
    }

    @Override
    public void indexChanged(IndexChangeEvent indexChangeEvent) {
        if (!(indexChangeEvent.getSource() instanceof HeaderTableModel) || !this.isRestoreColumnWidthNeeded()) {
            return;
        }
        switch (indexChangeEvent.getType()) {
            case 0: {
                if (this.getPivotDataModel().getRowHeaderTableModel().equals(indexChangeEvent.getSource())) {
                    if (this._rowHeaderWidths != null) break;
                    this._rowHeaderWidths = PivotTablePane.getTableColumnWidth((HeaderTable)this.getRowHeaderTable());
                    break;
                }
                if (this._columnHeaderWidths != null) break;
                this._columnHeaderWidths = PivotTablePane.getTableColumnWidth((HeaderTable)this.getColumnHeaderTable());
                break;
            }
            case 1: {
                if (this.getPivotDataModel().getRowHeaderTableModel().equals(indexChangeEvent.getSource())) {
                    if (this._rowHeaderWidths != null) {
                        PivotTablePane.setTableColumnWidth((HeaderTable)this.getRowHeaderTable(), this._rowHeaderWidths);
                        this.hideRowHeaderTableColumns();
                    }
                    this._rowHeaderWidths = null;
                    break;
                }
                if (this._columnHeaderWidths != null) {
                    PivotTablePane.setTableColumnWidth((HeaderTable)this.getColumnHeaderTable(), this._columnHeaderWidths);
                    if (!this.isKeepFieldAreaFit()) {
                        TableUtils.synchronizeTableColumnWidthNow(this._columnHeaderTable, this._dataTable);
                    }
                }
                this._columnHeaderWidths = null;
            }
        }
    }

    @Override
    public void pivotValueProviderEventHandler(final PivotValueProviderEvent pivotValueProviderEvent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                switch (pivotValueProviderEvent.getType()) {
                    case 0: 
                    case 1: {
                        PivotTablePane.access$402(PivotTablePane.this, PivotTablePane.this.saveSelection());
                        PivotTablePane.this.saveFieldsInformation();
                        break;
                    }
                    case 2: {
                        if (pivotValueProviderEvent.getObject() == null) {
                            PivotTablePane.this._filterFieldsArea.removeAll();
                            PivotTablePane.this._rowFieldsArea.removeAll();
                            PivotTablePane.this._columnFieldsArea.removeAll();
                            PivotTablePane.this._dataFieldsArea.removeAll();
                            PivotTablePane.this._unassignedFieldsArea.removeAll();
                            PivotTablePane.this.fillFilterFieldArea();
                            PivotTablePane.this.fillDataFieldArea();
                            PivotTablePane.this.fillRowFieldArea();
                            PivotTablePane.this.fillColumnFieldArea();
                            PivotTablePane.this.fillUnassignedFieldArea();
                        } else if (PivotTablePane.this.getPivotDataModel() instanceof PivotDataModel) {
                            ((PivotDataModel)PivotTablePane.this.getPivotDataModel()).setOriginalDataUpdate(pivotValueProviderEvent.getObject());
                        }
                        if (PivotTablePane.this.getPivotDataModel().isHighPerformanceMode() || PivotTablePane.this.rowColumnFieldsChanged()) {
                            PivotTablePane.this.getPivotDataModel().clearHiddenValues();
                            PivotTablePane.this.getPivotDataModel().clearHiddenColumns();
                            PivotTablePane.this.getPivotDataModel().clearHiddenRows();
                        }
                        PivotTablePane.this.clearFieldsInformation();
                        PivotTablePane.this.bothHeadersUpdated();
                        if (PivotTablePane.this.getPivotDataModel() instanceof PivotDataModel) {
                            ((PivotDataModel)PivotTablePane.this.getPivotDataModel()).setOriginalDataUpdate(null);
                        }
                        PivotTablePane.this.loadSelection(PivotTablePane.this._savedSelections, PivotTablePane.this.isScrollSelectionToVisible());
                        PivotTablePane.this.hideRowHeaderTableColumns();
                        PivotTablePane.this.revalidate();
                        PivotTablePane.this.repaint();
                        break;
                    }
                    case 3: {
                        PivotTablePane.this.clearFieldsInformation();
                        if (PivotTablePane.this.getRowHeaderTable() != null) {
                            PivotTablePane.this.getRowHeaderTable().invalidate();
                            PivotTablePane.this.getRowHeaderTable().repaint();
                        }
                        if (PivotTablePane.this.getColumnHeaderTable() != null) {
                            PivotTablePane.this.getColumnHeaderTable().invalidate();
                            PivotTablePane.this.getColumnHeaderTable().repaint();
                        }
                        if (PivotTablePane.this.getDataTable() == null) break;
                        PivotTablePane.this.getDataTable().invalidate();
                        PivotTablePane.this.getDataTable().repaint();
                        break;
                    }
                    case 4: {
                        PivotTablePane.access$402(PivotTablePane.this, PivotTablePane.this.saveSelection());
                        if (!PivotTablePane.this.isRestoreColumnWidthNeeded()) break;
                        if (pivotValueProviderEvent.getSource() instanceof HeaderTableModel) {
                            if (((HeaderTableModel)pivotValueProviderEvent.getSource()).isRowHeader()) {
                                PivotTablePane.this._rowHeaderWidths = PivotTablePane.getTableColumnWidth((HeaderTable)PivotTablePane.this.getRowHeaderTable());
                                break;
                            }
                            PivotTablePane.this._columnHeaderWidths = PivotTablePane.getTableColumnWidth((HeaderTable)PivotTablePane.this.getColumnHeaderTable());
                            break;
                        }
                        PivotTablePane.this._rowHeaderWidths = PivotTablePane.getTableColumnWidth((HeaderTable)PivotTablePane.this.getRowHeaderTable());
                        PivotTablePane.this._columnHeaderWidths = PivotTablePane.getTableColumnWidth((HeaderTable)PivotTablePane.this.getColumnHeaderTable());
                        break;
                    }
                    case 5: {
                        if (pivotValueProviderEvent.getObject() != null) break;
                        PivotTablePane.this.rowHeaderUpdated();
                        PivotTablePane.this.loadSelection(PivotTablePane.this._savedSelections, PivotTablePane.this.isScrollSelectionToVisible());
                        PivotTablePane.this.hideRowHeaderTableColumns();
                        if (PivotTablePane.this.isRestoreColumnWidthNeeded() && PivotTablePane.this._rowHeaderWidths != null) {
                            PivotTablePane.setTableColumnWidth((HeaderTable)PivotTablePane.this.getRowHeaderTable(), PivotTablePane.this._rowHeaderWidths);
                            PivotTablePane.this.hideRowHeaderTableColumns();
                        }
                        PivotTablePane.this._rowHeaderWidths = null;
                        break;
                    }
                    case 6: {
                        if (pivotValueProviderEvent.getObject() != null) break;
                        PivotTablePane.this.columnHeaderUpdated();
                        PivotTablePane.this.loadSelection(PivotTablePane.this._savedSelections, PivotTablePane.this.isScrollSelectionToVisible());
                        if (PivotTablePane.this.isRestoreColumnWidthNeeded() && PivotTablePane.this._columnHeaderWidths != null) {
                            PivotTablePane.setTableColumnWidth((HeaderTable)PivotTablePane.this.getColumnHeaderTable(), PivotTablePane.this._columnHeaderWidths);
                            if (!PivotTablePane.this.isKeepFieldAreaFit()) {
                                TableUtils.synchronizeTableColumnWidthNow(PivotTablePane.this._columnHeaderTable, PivotTablePane.this._dataTable);
                            }
                        }
                        PivotTablePane.this._columnHeaderWidths = null;
                        break;
                    }
                    case 7: {
                        PivotTablePane.this.bothHeadersUpdated();
                        PivotTablePane.this.loadSelection(PivotTablePane.this._savedSelections, PivotTablePane.this.isScrollSelectionToVisible());
                        if (PivotTablePane.this.isRestoreColumnWidthNeeded() && PivotTablePane.this._rowHeaderWidths != null) {
                            PivotTablePane.setTableColumnWidth((HeaderTable)PivotTablePane.this.getRowHeaderTable(), PivotTablePane.this._rowHeaderWidths);
                        }
                        PivotTablePane.this._rowHeaderWidths = null;
                        PivotTablePane.this.hideRowHeaderTableColumns();
                        if (PivotTablePane.this.isRestoreColumnWidthNeeded() && PivotTablePane.this._columnHeaderWidths != null) {
                            PivotTablePane.setTableColumnWidth((HeaderTable)PivotTablePane.this.getColumnHeaderTable(), PivotTablePane.this._columnHeaderWidths);
                            if (!PivotTablePane.this.isKeepFieldAreaFit()) {
                                TableUtils.synchronizeTableColumnWidthNow(PivotTablePane.this._columnHeaderTable, PivotTablePane.this._dataTable);
                            }
                        }
                        PivotTablePane.this._columnHeaderWidths = null;
                        break;
                    }
                    case 8: {
                        PivotField[] pivotFieldArray = PivotTablePane.this._pivotDataModel.getDataFields();
                        HashSet<Integer> hashSet = new HashSet<Integer>();
                        for (int i = 0; i < pivotFieldArray.length; ++i) {
                            PivotField pivotField = pivotFieldArray[i];
                            boolean bl = false;
                            int n = pivotField.getModelIndex();
                            if (!hashSet.contains(n)) {
                                for (int j = i + 1; j < pivotFieldArray.length; ++j) {
                                    PivotField pivotField2 = pivotFieldArray[j];
                                    if (pivotField2.getModelIndex() != n) continue;
                                    bl = true;
                                    pivotField2.replaceTitleWith(PivotTablePane.this.getDuplicatedTitle(pivotField2));
                                }
                                if (bl) {
                                    hashSet.add(n);
                                    pivotField.replaceTitleWith(PivotTablePane.this.getDuplicatedTitle(pivotField));
                                }
                            } else {
                                bl = true;
                            }
                            if (bl || pivotField.getOldTitle() == null) continue;
                            pivotField.setTitle(pivotField.getOldTitle());
                        }
                        if ("layoutDataFieldsFirstFlagChanged".equals(pivotValueProviderEvent.getObject())) {
                            ((HeaderTable)PivotTablePane.this.getRowHeaderTable()).invalidateCellSpanCache();
                            ((HeaderTable)PivotTablePane.this.getColumnHeaderTable()).invalidateCellSpanCache();
                            PivotTablePane.this.fillRowFieldArea(true);
                        }
                        PivotTablePane.this.invalidate();
                        PivotTablePane.this.repaint();
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected FieldArea createFieldArea(int n) {
        return new FieldArea(this, n);
    }

    protected void configureEnclosingScrollPaneForDataTable(JTable jTable) {
        Container container;
        Container container2 = jTable.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            Border border;
            Border border2;
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != jTable) {
                return;
            }
            if (this.getColumnHeaderTable() != null) {
                if (this.isFlatLayout()) {
                    if (jScrollPane instanceof JideScrollPane) {
                        ((JideScrollPane)jScrollPane).setSubColumnHeaderView(this.getColumnHeaderTable());
                    }
                } else {
                    jScrollPane.setColumnHeaderView(this.getColumnHeaderTable());
                }
            }
            if (((border2 = jScrollPane.getBorder()) == null || border2 instanceof UIResource) && (border = UIDefaultsLookup.getBorder("Table.scrollPaneBorder")) != null) {
                jScrollPane.setBorder(border);
            }
        }
    }

    protected DataTable createDataTable() {
        return new DataTable(this);
    }

    protected HeaderTable createHeaderTable() {
        return new HeaderTable(this);
    }

    private void adjustRowHeight() {
        int n = this.getRowHeight() * this.getAdjustedRowHeights();
        if (this._dataTable != null) {
            this._dataTable.setRowHeight(n);
        }
        if (this._rowHeaderTable != null) {
            this._rowHeaderTable.setRowHeight(n);
        }
    }

    protected int getAdjustedRowHeights() {
        return 1;
    }

    protected void setupLayout(Container container, Container container2) {
        EventListener[] eventListenerArray;
        this.removeAll();
        container.removeAll();
        this.setOpaque(false);
        this.setLayout(new BorderLayout(6, 6));
        this.add(container);
        this.add((Component)container2, "After");
        container.setLayout(new JideBoxLayout(container, 1));
        container.add((Component)this._filterFieldsArea, "fix");
        container.add((Component)this._separator, "fix");
        container.add(Box.createVerticalStrut(3), "fix");
        if (this.isFlatLayout()) {
            this._scrollPane = new FlatJideScrollPane();
            ((JideScrollPane)this._scrollPane).setFlatLayout(this.isFlatLayout());
            eventListenerArray = this._scrollPane.getMouseWheelListeners();
            for (MouseWheelListener mouseWheelListener : eventListenerArray) {
                this._scrollPane.removeMouseWheelListener(mouseWheelListener);
            }
            this._scrollPane.setOpaque(false);
        } else {
            eventListenerArray = new JPanel(new BorderLayout(0, 0));
            eventListenerArray.setOpaque(false);
            eventListenerArray.add((Component)this._dataFieldsArea, "Before");
            eventListenerArray.add((Component)this._columnFieldsArea, "Center");
            container.add((Component)eventListenerArray, "fix");
            this._scrollPane = this.createScrollPane();
            this.customizeScrollPane(this._scrollPane);
        }
        if (this._popupMenuMouseListener != null) {
            this._scrollPane.addMouseListener(this._popupMenuMouseListener);
        }
        if (this.isFlatLayout()) {
            if (SystemInfo.isJdk15Above()) {
                this._scrollPane.setCorner("UPPER_LEADING_CORNER", this._dataFieldsArea);
            } else {
                this._scrollPane.setCorner("UPPER_LEFT_CORNER", this._dataFieldsArea);
            }
            this._scrollPane.setColumnHeaderView(this._columnFieldsArea);
            this._scrollPane.getColumnHeader().setOpaque(false);
            this._scrollPane.setCorner("SUB_UPPER_LEFT", this._rowFieldsArea);
            ((JideScrollPane)this._scrollPane).setSubColumnHeaderView(this._columnHeaderTable);
        } else {
            if (SystemInfo.isJdk15Above()) {
                this._scrollPane.setCorner("UPPER_LEADING_CORNER", this._rowFieldsArea);
            } else {
                this._scrollPane.setCorner("UPPER_LEFT_CORNER", this._rowFieldsArea);
            }
            this._scrollPane.setColumnHeaderView(this._columnHeaderTable);
        }
        this._scrollPane.setViewportView(this._dataTable);
        this._scrollPane.getViewport().setBackground(this._dataTable.getBackground());
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._scrollPane.setRowHeaderView(this._rowHeaderTable);
        this._scrollPane.getRowHeader().setBackground(this._dataTable.getBackground());
        this._scrollPane.getColumnHeader().setBackground(this._dataTable.getBackground());
        ((HeaderTable)this._rowHeaderTable).setAutoScrolls();
        ((HeaderTable)this._columnHeaderTable).setAutoScrolls();
        this.synchronizeFieldAreaWithColumnWidth(this._rowHeaderTable, this._rowFieldsArea);
        this.synchronizeFieldAreaTableWidth(this._rowHeaderTable, this._dataFieldsArea, this._rowFieldsArea);
        TableUtils.synchronizeTableColumnWidth(this._columnHeaderTable, this._dataTable);
        TableUtils.synchronizeTableColumnWidth(this._dataTable, this._columnHeaderTable);
        eventListenerArray = new JTable[]{null, this._columnHeaderTable};
        EventListener[] eventListenerArray2 = new JTable[]{this._rowHeaderTable, this._dataTable};
        JTable[][] jTableArray = new JTable[][]{eventListenerArray, eventListenerArray2};
        if (this.getHeaderSelectionMode() != 1) {
            TableUtils.synchronizeNavigationKeys(jTableArray);
        } else {
            TableUtils.unsynchronizeNavigationKeys(jTableArray);
        }
        if (this.isFlatLayout()) {
            JScrollPane jScrollPane = this.createScrollPane();
            this.customizeScrollPane(jScrollPane);
            jScrollPane.setViewportView(this._scrollPane);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this._scrollPane = jScrollPane;
            if (this._popupMenuMouseListener != null) {
                this._scrollPane.addMouseListener(this._popupMenuMouseListener);
            }
        }
        container.add((Component)this._scrollPane, "vary");
        this.configureDataTableForFlatLayout();
    }

    protected JScrollPane createScrollPane() {
        return new JideScrollPaneEx();
    }

    protected void customizeScrollPane(JScrollPane jScrollPane) {
        if (jScrollPane instanceof JideScrollPane) {
            ((JideScrollPane)jScrollPane).setHorizontalScrollBarCoversWholeWidth(true);
            ((JideScrollPane)jScrollPane).setVerticalScrollBarCoversWholeHeight(true);
            CornerScroller cornerScroller = new CornerScroller(jScrollPane);
            cornerScroller.setSelectionBorderColor(Color.GRAY);
            ((JideScrollPane)jScrollPane).setScrollBarCorner("VERTICAL_BOTTOM", cornerScroller);
        }
        jScrollPane.getViewport().setOpaque(!this.isFlatLayout());
        jScrollPane.setOpaque(false);
    }

    protected void customizeFieldsPanel(Container container) {
        container.removeAll();
        container.setLayout(new BorderLayout(6, 6));
        this._addToComboBox = new JComboBox();
        JComponent jComponent = this.createFieldList();
        container.add(jComponent);
        this._fieldChooserComboBoxPanel = new JPanel(new BorderLayout(6, 6));
        this._addToButton = new JButton(this.getResourceString("PivotTablePane.addTo"));
        this._fieldChooserComboBoxPanel.add((Component)this._addToButton, "Before");
        this._fieldChooserComboBoxPanel.add(this._addToComboBox);
        container.add((Component)this._fieldChooserComboBoxPanel, "Last");
        this._addToButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 844022190426028416L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component[] componentArray;
                for (Component component : componentArray = PivotTablePane.this._unassignedFieldsArea.getComponents()) {
                    if (!(component instanceof FieldBox) || !((FieldBox)component).isSelected()) continue;
                    String string = (String)PivotTablePane.this._addToComboBox.getSelectedItem();
                    int n = PivotTablePane.this.getFieldAreaType(string);
                    if (!((FieldBox)component).getField().isAllowedAsField(n)) break;
                    PivotTablePane.this.addFieldBox((FieldBox)component, n);
                    break;
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        jPanel.add((Component)new JLabel(this.getResourceString("PivotTablePane.fieldList")), "First");
        this._filterField = new QuickUnassignedFieldsAreaFilterField(this._unassignedFieldsArea, new JComponent[]{this._addToButton, this._addToComboBox});
        jPanel.add((Component)this._filterField, "Center");
        container.add((Component)jPanel, "First");
    }

    private JComponent createFieldList() {
        if (this._unassignedFieldsArea != null && this._unassignedFieldsAreaSearchable != null) {
            this._unassignedFieldsAreaSearchable.uninstallListeners();
        }
        this._unassignedFieldsArea = new UnassignedFieldsArea();
        this._unassignedFieldsAreaSearchable = new UnassignedFieldsAreaSearchable(this._unassignedFieldsArea);
        this.fillUnassignedFieldArea();
        JScrollPane jScrollPane = new JScrollPane(this._unassignedFieldsArea, 20, 31);
        if (this._popupMenuMouseListener != null) {
            jScrollPane.addMouseListener(this._popupMenuMouseListener);
        }
        return jScrollPane;
    }

    public void updatePossibleValues() {
        Set<PivotField> set = this._fieldBoxMap.keySet();
        for (PivotField pivotField : set) {
            FieldBox fieldBox = this._fieldBoxMap.get(pivotField);
            fieldBox.setPossibleValues(this._pivotDataModel.getPossibleValues(pivotField));
        }
    }

    public void updatePossibleValues(FieldBox fieldBox) {
        PivotField pivotField = fieldBox.getField();
        fieldBox.setPossibleValues(this._pivotDataModel.getPossibleValues(pivotField));
    }

    protected String getDuplicatedTitle(PivotField pivotField) {
        String string = pivotField.getOldTitle() == null ? pivotField.getTitle() : pivotField.getOldTitle();
        SummaryCalculator summaryCalculator = this._pivotDataModel.getSummaryCalculator();
        if (summaryCalculator == null) {
            return string;
        }
        String string2 = summaryCalculator.getSummaryName(this.getLocale(), pivotField.getSummaryType());
        return string + " (" + string2 + ")";
    }

    private void fillDataFieldArea() {
        int n;
        PivotField pivotField;
        int n2;
        PivotField[] pivotFieldArray = this._pivotDataModel.getDataFields();
        this._dataFieldsArea.removeAll();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (n2 = 0; n2 < pivotFieldArray.length; ++n2) {
            pivotField = pivotFieldArray[n2];
            boolean bl = false;
            n = pivotField.getModelIndex();
            if (!hashSet.contains(n)) {
                for (int i = n2 + 1; i < pivotFieldArray.length; ++i) {
                    PivotField pivotField2 = pivotFieldArray[i];
                    if (pivotField2.getModelIndex() != n) continue;
                    bl = true;
                    pivotField2.replaceTitleWith(this.getDuplicatedTitle(pivotField2));
                }
                if (bl) {
                    hashSet.add(n);
                    pivotField.replaceTitleWith(this.getDuplicatedTitle(pivotField));
                }
            } else {
                bl = true;
            }
            if (bl || pivotField.getOldTitle() == null) continue;
            pivotField.setTitle(pivotField.getOldTitle());
        }
        for (n2 = 0; n2 < pivotFieldArray.length; ++n2) {
            pivotField = pivotFieldArray[n2];
            pivotField.setAreaIndex(n2 * 2 + 1);
            FieldBox fieldBox = this._fieldBoxMap.get(pivotField);
            int n3 = n = this.isDataFieldFilterable() && pivotField.isFilterable() ? 1 : 0;
            if (fieldBox != null) {
                fieldBox.setSortArrowVisible(false);
                fieldBox.setFilterButtonVisible(n != 0);
            } else {
                fieldBox = this.createFieldBox(pivotField, false, n != 0);
                this._fieldBoxMap.put(pivotField, fieldBox);
                this.initializeFieldBox(fieldBox);
            }
            fieldBox.setSelected(false);
            fieldBox.setFirst(n2 == 0);
            fieldBox.setLast(n2 == pivotFieldArray.length - 1);
            this.customizeFieldBox(fieldBox);
            this._dataFieldsArea.add(fieldBox);
        }
        if (this.isKeepFieldAreaFit()) {
            this._dataFieldsArea.doLayout();
        } else if (this._rowHeaderTable != null && this._rowFieldsArea != null) {
            this.updateDataFieldAreaWidth(this._rowHeaderTable, this._dataFieldsArea, this._rowFieldsArea);
        }
        this.adjustRowHeight();
    }

    private void fillColumnFieldArea() {
        PivotField[] pivotFieldArray = this._pivotDataModel.getColumnFields();
        boolean bl = false;
        this._columnFieldsArea.removeAll();
        for (int i = 0; i < pivotFieldArray.length; ++i) {
            boolean bl2;
            PivotField pivotField = pivotFieldArray[i];
            if (pivotField.getOldTitle() != null) {
                pivotField.setTitle(pivotField.getOldTitle());
            }
            pivotField.setAreaIndex(i * 2 + 1);
            FieldBox fieldBox = this._fieldBoxMap.get(pivotField);
            boolean bl3 = bl2 = this.isColumnFieldFilterable() && pivotField.isFilterable();
            if (fieldBox != null) {
                fieldBox.setSortArrowVisible(true);
                fieldBox.setFilterButtonVisible(bl2);
            } else {
                fieldBox = this.createFieldBox(pivotField, true, bl2);
                this._fieldBoxMap.put(pivotField, fieldBox);
                if (this.isShowFilterButtonsOnMouseOver()) {
                    fieldBox.showFilterButtonVisible(false);
                }
                bl = true;
            }
            fieldBox.setSelected(false);
            fieldBox.setFirst(i == 0);
            fieldBox.setLast(i == pivotFieldArray.length - 1);
            this.setFieldBoxPreferredSize(fieldBox);
            if (bl) {
                this.initializeFieldBox(fieldBox);
            }
            this.customizeFieldBox(fieldBox);
            this._columnFieldsArea.add(fieldBox);
        }
        this._columnFieldsArea.doLayout();
        this.configureDataTableForFlatLayout();
    }

    private void configureDataTableForFlatLayout() {
        PivotField[] pivotFieldArray = this._pivotDataModel.getColumnFields();
        JTable jTable = this.getDataTable();
        if (jTable != null) {
            if (this.isFlatLayout() && pivotFieldArray.length == 0) {
                jTable.setPreferredSize(this._columnFieldsArea.getPreferredSize());
                jTable.setOpaque(false);
                if (jTable.getParent() instanceof JComponent) {
                    ((JComponent)jTable.getParent()).setOpaque(false);
                }
                if (this.getColumnHeaderTable() != null && this.getColumnHeaderTable().getParent() instanceof JComponent) {
                    ((JComponent)this.getColumnHeaderTable().getParent()).setOpaque(false);
                }
                if (this.getRowHeaderTable() != null && this.getRowHeaderTable().getParent() instanceof JComponent) {
                    ((JComponent)this.getRowHeaderTable().getParent()).setOpaque(false);
                }
            } else {
                jTable.setPreferredSize(null);
                jTable.setOpaque(true);
                if (jTable.getParent() instanceof JComponent) {
                    ((JComponent)jTable.getParent()).setOpaque(true);
                }
                if (this.getColumnHeaderTable() != null && this.getColumnHeaderTable().getParent() instanceof JComponent) {
                    ((JComponent)this.getColumnHeaderTable().getParent()).setOpaque(true);
                }
                if (this.getRowHeaderTable() != null && this.getRowHeaderTable().getParent() instanceof JComponent) {
                    ((JComponent)this.getRowHeaderTable().getParent()).setOpaque(true);
                }
            }
        }
    }

    private void setFieldBoxPreferredSize(FieldBox fieldBox) {
    }

    private void fillRowFieldArea() {
        this.fillRowFieldArea(false);
    }

    private void fillRowFieldArea(boolean bl) {
        PivotField[] pivotFieldArray = this._pivotDataModel.getRowFields();
        this._rowFieldsArea.removeAll();
        if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isAlwaysRowDataFields() && this._pivotDataModel.getDataFields().length > 1) {
            Object object;
            if (this._pivotDataModel.isLayoutDataFieldsFirst()) {
                object = Box.createGlue();
                ((Component)object).setPreferredSize(new Dimension(75, 1));
                this._rowFieldsArea.add((Component)object);
            }
            if (bl && this._pivotDataModel.getRowHeaderTableModel().isDataFieldAdded()) {
                int n;
                int n2;
                if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isLayoutDataFieldsFirst()) {
                    object = this._rowHeaderTable.getColumnModel();
                    n2 = object.getColumn(object.getColumnCount() - 1).getPreferredWidth();
                    for (n = object.getColumnCount() - 1; n > 0; --n) {
                        object.getColumn(n).setPreferredWidth(object.getColumn(n - 1).getPreferredWidth());
                    }
                    object.getColumn(0).setPreferredWidth(n2);
                } else {
                    object = this._rowHeaderTable.getColumnModel();
                    n2 = object.getColumn(0).getPreferredWidth();
                    for (n = 0; n < object.getColumnCount() - 1; ++n) {
                        object.getColumn(n).setPreferredWidth(object.getColumn(n + 1).getPreferredWidth());
                    }
                    object.getColumn(object.getColumnCount() - 1).setPreferredWidth(n2);
                }
            }
        }
        for (int i = 0; i < pivotFieldArray.length; ++i) {
            boolean bl2;
            PivotField pivotField = pivotFieldArray[i];
            if (pivotField.getOldTitle() != null) {
                pivotField.setTitle(pivotField.getOldTitle());
            }
            pivotField.setAreaIndex(i * 2 + 1);
            FieldBox fieldBox = this._fieldBoxMap.get(pivotField);
            boolean bl3 = bl2 = this.isRowFieldFilterable() && pivotField.isFilterable();
            if (fieldBox != null) {
                fieldBox.setSortArrowVisible(true);
                fieldBox.setFilterButtonVisible(bl2);
            } else {
                fieldBox = this.createFieldBox(pivotField, true, bl2);
                this._fieldBoxMap.put(pivotField, fieldBox);
                this.initializeFieldBox(fieldBox);
            }
            fieldBox.setSelected(false);
            fieldBox.setFirst(i == 0);
            fieldBox.setLast(i == pivotFieldArray.length - 1);
            if (this.isKeepFieldAreaFit() && pivotField.getPreferredWidth() > 0) {
                fieldBox.setPreferredSize(new Dimension(pivotField.getPreferredWidth(), fieldBox.getPreferredSize().height));
            }
            this.customizeFieldBox(fieldBox);
            this._rowFieldsArea.add(fieldBox);
        }
        this._rowFieldsArea.doLayout();
    }

    private void fillUnassignedFieldArea() {
        PivotField[] pivotFieldArray = this._pivotDataModel.getUnassignedFields();
        Arrays.sort(pivotFieldArray, new Comparator<PivotField>(){

            @Override
            public int compare(PivotField pivotField, PivotField pivotField2) {
                if (pivotField.getTitle() != null) {
                    return pivotField.getTitle().compareTo(pivotField2.getTitle());
                }
                if (pivotField2.getTitle() != null) {
                    return -pivotField2.getTitle().compareTo(pivotField.getTitle());
                }
                return 0;
            }
        });
        ArrayList<FieldBox> arrayList = new ArrayList<FieldBox>();
        for (int i = 0; i < pivotFieldArray.length; ++i) {
            PivotField pivotField = pivotFieldArray[i];
            if (pivotField.getOldTitle() != null) {
                pivotField.setTitle(pivotField.getOldTitle());
            }
            if (!pivotField.isVisible()) continue;
            pivotField.setAreaIndex(i * 2 + 1);
            FieldBox fieldBox = this._fieldBoxMap.get(pivotField);
            if (fieldBox != null) {
                fieldBox.setSortArrowVisible(false);
                fieldBox.setFilterButtonVisible(false);
                fieldBox.setPreferredSize(null);
            } else {
                fieldBox = this.createFieldBox(pivotField, false, false);
                this._fieldBoxMap.put(pivotField, fieldBox);
                this.initializeFieldBox(fieldBox);
            }
            fieldBox.setFirst(i == 0);
            fieldBox.setLast(i == pivotFieldArray.length - 1);
            if (i == 0) {
                this.selectFieldBox(fieldBox);
            }
            this.customizeFieldBox(fieldBox);
            arrayList.add(fieldBox);
        }
        this.fillUnassignedFieldArea(this._unassignedFieldsArea, arrayList, this._filterField);
    }

    protected void fillUnassignedFieldArea(UnassignedFieldsArea unassignedFieldsArea, List<FieldBox> list, QuickFilterField quickFilterField) {
        unassignedFieldsArea.removeAll();
        unassignedFieldsArea.clearFieldBoxes();
        unassignedFieldsArea.setLayout(new JideBoxLayout(unassignedFieldsArea, 1));
        boolean bl = false;
        for (FieldBox fieldBox : list) {
            unassignedFieldsArea.addFieldBox(fieldBox);
            if (this.isFieldChooserFilterFieldVisible() && !quickFilterField.matches(fieldBox.getField(), quickFilterField.getSearchingText())) continue;
            unassignedFieldsArea.add(fieldBox);
            bl = true;
        }
        if (this._addToButton != null) {
            this._addToButton.setEnabled(bl);
        }
        if (this._addToComboBox != null) {
            this._addToComboBox.setEnabled(bl);
        }
        unassignedFieldsArea.add(Box.createGlue(), "vary");
        unassignedFieldsArea.revalidate();
    }

    private void fillFilterFieldArea() {
        PivotField[] pivotFieldArray = this._pivotDataModel.getFilterFields();
        this._filterFieldsArea.removeAll();
        boolean bl = false;
        for (int i = 0; i < pivotFieldArray.length; ++i) {
            PivotField pivotField = pivotFieldArray[i];
            if (pivotField.getOldTitle() != null) {
                pivotField.setTitle(pivotField.getOldTitle());
            }
            pivotField.setAreaIndex(i * 2 + 1);
            FieldBox fieldBox = this._fieldBoxMap.get(pivotField);
            if (fieldBox != null) {
                fieldBox.setSortArrowVisible(false);
                fieldBox.setFilterButtonVisible(pivotField.isFilterable());
            } else {
                fieldBox = this.createFieldBox(pivotField, false, pivotField.isFilterable());
                this._fieldBoxMap.put(pivotField, fieldBox);
                bl = true;
            }
            fieldBox.setFirst(i == 0);
            fieldBox.setLast(i == pivotFieldArray.length - 1);
            this.setFieldBoxPreferredSize(fieldBox);
            if (bl) {
                this.initializeFieldBox(fieldBox);
                this.synchronizeFieldAreaWithField(fieldBox);
            }
            this.customizeFieldBox(fieldBox);
            this._filterFieldsArea.add(fieldBox);
        }
        this._filterFieldsArea.doLayout();
    }

    protected FieldBox createFieldBox(PivotField pivotField, boolean bl, boolean bl2) {
        return new FieldBox(pivotField, bl, bl2);
    }

    protected void initializeFieldBox(FieldBox fieldBox) {
        fieldBox.setPivotTablePane(this);
        fieldBox.addMouseListener(this._listener);
        fieldBox.addMouseMotionListener(this._listener);
        fieldBox.addKeyListener(this._listener);
        fieldBox.addActionListener(this._listener);
        this.synchronizeFieldAreaWithField(fieldBox);
        this._unassignedButtonGroup.add(fieldBox);
    }

    protected void customizeFieldBox(FieldBox fieldBox) {
    }

    protected void uninitializeFieldBox(FieldBox fieldBox) {
        fieldBox.uninstallListeners();
        fieldBox.setPivotTablePane(null);
        fieldBox.removeMouseListener(this._listener);
        fieldBox.removeMouseMotionListener(this._listener);
        fieldBox.removeKeyListener(this._listener);
        fieldBox.removeActionListener(this._listener);
        this._unassignedButtonGroup.remove(fieldBox);
    }

    public void selectFieldBox(FieldBox fieldBox) {
        this._unassignedButtonGroup.setSelected(fieldBox.getModel(), true);
        fieldBox.setSelected(true);
        PivotField pivotField = fieldBox.getField();
        this.refreshAddToComboBox(pivotField);
    }

    private void refreshAddToComboBox(PivotField pivotField) {
        if (pivotField == null && this._addToComboBoxField == null) {
            return;
        }
        if (pivotField == null) {
            pivotField = this._addToComboBoxField;
        } else {
            this._addToComboBoxField = pivotField;
        }
        if (this._addToComboBox != null && pivotField.getAreaType() == -1) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            if (this.isRowFieldAreaVisible() && pivotField.isAllowedAsRowField()) {
                defaultComboBoxModel.addElement(this.getFieldAreaName(0));
            }
            if (this.isColumnFieldAreaVisible() && pivotField.isAllowedAsColumnField()) {
                defaultComboBoxModel.addElement(this.getFieldAreaName(1));
            }
            if (this.isFilterFieldAreaVisible() && pivotField.isAllowedAsFilterField()) {
                defaultComboBoxModel.addElement(this.getFieldAreaName(2));
            }
            if (this.isDataFieldAreaVisible() && pivotField.isAllowedAsDataField()) {
                defaultComboBoxModel.addElement(this.getFieldAreaName(3));
            }
            Object object = this._addToComboBox.getSelectedItem();
            this._addToComboBox.setModel(defaultComboBoxModel);
            if (object != null) {
                this._addToComboBox.setSelectedItem(object);
            }
        }
    }

    public void rowHeaderUpdated() {
        this.setRestoreColumnWidthNeeded(false);
        this._pivotDataModel.invalidateRowHeaderTableModel();
        if (this._cornerTable != null) {
            this._pivotDataModel.invalidateCornerTableModel();
            TableModel tableModel = this._pivotDataModel.getCornerTableModel();
            this.setCornerTableModel(this._cornerTable, tableModel);
            TableUtils.synchronizeTableColumnWidthNow(this._rowHeaderTable, this._cornerTable);
        }
        this.setDataTableModel(this._dataTable, this._pivotDataModel.getDataTableModel());
        PivotTablePane.updateTableColumnWidth(this._rowHeaderTable, this._rowFieldsArea);
        if (!this.isKeepFieldAreaFit()) {
            TableUtils.synchronizeTableColumnWidthNow(this._columnHeaderTable, this._dataTable);
        }
        this.setRestoreColumnWidthNeeded(true);
    }

    public void columnHeaderUpdated() {
        Object object;
        if (this._cornerTable != null) {
            this._pivotDataModel.invalidateCornerTableModel();
            object = this._pivotDataModel.getCornerTableModel();
            this.setCornerTableModel(this._cornerTable, (TableModel)object);
            TableUtils.synchronizeTableColumnWidthNow(this._rowHeaderTable, this._cornerTable);
        }
        object = this.getAndClearDataFieldFilter();
        Map<Integer, Integer>[] mapArray = PivotTablePane.getTableColumnWidth((HeaderTable)this._columnHeaderTable);
        this._pivotDataModel.invalidateColumnHeaderTableModel();
        this.setDataTableModel(this._dataTable, this._pivotDataModel.getDataTableModel());
        PivotTablePane.setTableColumnWidth((HeaderTable)this._columnHeaderTable, mapArray);
        if (!this.isKeepFieldAreaFit()) {
            TableUtils.synchronizeTableColumnWidthNow(this._columnHeaderTable, this._dataTable);
        }
        this.setDataFieldFilter((Map<PivotField, Object>)object);
    }

    protected void setDataTableModel(JTable jTable, TableModel tableModel) {
        jTable.setModel(tableModel);
    }

    protected void setHeaderTableModel(JTable jTable, TableModel tableModel) {
        jTable.setModel(tableModel);
        if (tableModel instanceof HeaderTableModel) {
            ((HeaderTableModel)tableModel).addIndexChangeListener(this);
        }
    }

    void adjustColumnWidth(HeaderTable headerTable) {
        if (!this.isRespectFieldPreferredWidth()) {
            return;
        }
        boolean bl = ((HeaderTableModel)headerTable.getModel()).isRowHeader();
        if (!bl) {
            PivotField[] pivotFieldArray = this.getPivotDataModel().getDataFields();
            if (pivotFieldArray.length == 1) {
                int n = pivotFieldArray[0].getPreferredWidth();
                for (int i = 0; i < headerTable.getColumnCount(); ++i) {
                    headerTable.getColumnModel().getColumn(i).setWidth(n);
                    headerTable.getColumnModel().getColumn(i).setPreferredWidth(n);
                }
            } else if (pivotFieldArray.length > 0) {
                int n = this.getPivotDataModel().getColumnFields().length;
                if (n == 0 && this.getPivotDataModel().isShowGrandTotalForColumn()) {
                    ++n;
                }
                for (int i = 0; i < headerTable.getColumnCount(); ++i) {
                    PivotField pivotField = ((HeaderTableModel)headerTable.getModel()).getFieldAt(n, i);
                    if (pivotField == null) continue;
                    int n2 = pivotField.getPreferredWidth();
                    headerTable.getColumnModel().getColumn(i).setWidth(n2);
                    headerTable.getColumnModel().getColumn(i).setPreferredWidth(n2);
                }
            }
            TableUtils.synchronizeTableColumnWidthNow(headerTable, this._dataTable);
        }
    }

    protected void setCornerTableModel(JTable jTable, TableModel tableModel) {
        if (jTable != null) {
            jTable.setModel(tableModel);
        }
    }

    Map<PivotField, Object> getAndClearDataFieldFilter() {
        HashMap<PivotField, Object> hashMap = new HashMap<PivotField, Object>();
        for (PivotField pivotField : this.getPivotDataModel().getDataFields()) {
            ArrayList<Object> arrayList;
            if (!pivotField.isDataFieldFilterOnSummary() || pivotField.getFilter() == null && pivotField.getSelectedPossibleValues() == null && pivotField.getFilteredPossibleValues() == null) continue;
            if (pivotField.getFilter() != null) {
                hashMap.put(pivotField, pivotField.getFilter());
            } else if (pivotField.getSelectedPossibleValues() != null) {
                arrayList = new ArrayList<Object>();
                arrayList.add(Boolean.TRUE);
                arrayList.add(pivotField.getSelectedPossibleValues());
                hashMap.put(pivotField, arrayList);
            } else if (pivotField.getFilteredPossibleValues() != null) {
                arrayList = new ArrayList();
                arrayList.add(Boolean.FALSE);
                arrayList.add(pivotField.getFilteredPossibleValues());
                hashMap.put(pivotField, arrayList);
            }
            pivotField.setFilter(null);
            pivotField.setSelectedPossibleValues(null);
            pivotField.setFilteredPossibleValues(null);
        }
        return hashMap;
    }

    void setDataFieldFilter(Map<PivotField, Object> map) {
        if (map == null || map.size() <= 0) {
            return;
        }
        for (PivotField pivotField : map.keySet()) {
            Object object = map.get(pivotField);
            if (object instanceof Filter) {
                pivotField.setFilter((Filter)object);
                continue;
            }
            if (!(object instanceof List) || !(((List)object).get(0) instanceof Boolean)) continue;
            if (((Boolean)((List)object).get(0)).booleanValue()) {
                pivotField.setSelectedPossibleValues((Object[])((List)object).get(1));
                continue;
            }
            pivotField.setFilteredPossibleValues((Object[])((List)object).get(1));
        }
    }

    public static Map<Integer, Integer>[] getTableColumnWidth(HeaderTable headerTable) {
        if (headerTable.getPivotTablePane().getPivotDataModel().isHighPerformanceMode()) {
            return null;
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap3 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap4 = new HashMap<Integer, Integer>();
        TableColumnModel tableColumnModel = headerTable.getColumnModel();
        boolean bl = ((HeaderTableModel)headerTable.getModel()).isRowHeader();
        for (int i = 0; i < headerTable.getColumnCount(); ++i) {
            Values values = ((HeaderTableModel)headerTable.getModel()).getValuesAt(i);
            if (!bl && values == null) continue;
            PivotField pivotField = ((HeaderTableModel)headerTable.getModel()).getFieldAt(headerTable.getRowCount() - 1, i);
            Integer n = !bl ? Integer.valueOf(values.hashCode() * 29 + (pivotField == null ? 1 : pivotField.hashCode())) : Integer.valueOf(pivotField == null ? 1 : pivotField.hashCode());
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            hashMap.put(n, tableColumn.getWidth());
            hashMap2.put(n, tableColumn.getPreferredWidth());
            hashMap3.put(n, tableColumn.getMinWidth());
            hashMap4.put(n, tableColumn.getMaxWidth());
        }
        return new Map[]{hashMap, hashMap2, hashMap3, hashMap4};
    }

    public static void setTableColumnWidth(HeaderTable headerTable, Map<Integer, Integer>[] mapArray) {
        int n;
        if (headerTable.getPivotTablePane().getPivotDataModel().isHighPerformanceMode()) {
            return;
        }
        TableColumnModel tableColumnModel = headerTable.getColumnModel();
        int[] nArray = null;
        if (((HeaderTableModel)headerTable.getModel()).isRowHeader()) {
            Component[] componentArray = headerTable.getPivotTablePane().getRowFieldsArea().getFieldBoxes();
            nArray = new int[componentArray.length];
            for (n = 0; n < componentArray.length; ++n) {
                nArray[n] = componentArray[n].getWidth() + 4;
            }
        }
        boolean bl = ((HeaderTableModel)headerTable.getModel()).isRowHeader();
        for (n = 0; n < headerTable.getColumnCount(); ++n) {
            Values values = ((HeaderTableModel)headerTable.getModel()).getValuesAt(n);
            if (!bl && values == null) continue;
            PivotField pivotField = ((HeaderTableModel)headerTable.getModel()).getFieldAt(headerTable.getRowCount() - 1, n);
            Integer n2 = !bl ? Integer.valueOf(values.hashCode() * 29 + (pivotField == null ? 1 : pivotField.hashCode())) : Integer.valueOf(pivotField == null ? 1 : pivotField.hashCode());
            Integer n3 = mapArray[0].get(n2);
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            if (n3 != null) {
                if (nArray != null && nArray.length > n) {
                    n3 = Math.max(n3, nArray[n]);
                }
                tableColumn.setWidth(n3);
                n3 = mapArray[1].get(n2);
                if (nArray != null && nArray.length > n) {
                    n3 = Math.max(n3, nArray[n]);
                }
                tableColumn.setPreferredWidth(n3);
                n3 = mapArray[2].get(n2);
                tableColumn.setMinWidth(n3);
                n3 = mapArray[3].get(n2);
                tableColumn.setMaxWidth(n3);
                continue;
            }
            if (!headerTable.getPivotTablePane().isRespectFieldPreferredWidth() || ((HeaderTableModel)headerTable.getModel()).isRowHeader() || pivotField == null) continue;
            int n4 = pivotField.getPreferredWidth();
            tableColumn.setWidth(n4);
            tableColumn.setPreferredWidth(n4);
        }
    }

    public void bothHeadersUpdated() {
        Map<PivotField, Object> map = this.getAndClearDataFieldFilter();
        this.setRestoreColumnWidthNeeded(false);
        Map<Integer, Integer>[] mapArray = PivotTablePane.getTableColumnWidth((HeaderTable)this._columnHeaderTable);
        this._pivotDataModel.invalidateRowHeaderTableModel();
        if (!this.isKeepFieldAreaFit()) {
            PivotTablePane.updateTableColumnWidth(this._rowHeaderTable, this._rowFieldsArea);
        }
        this._pivotDataModel.invalidateColumnHeaderTableModel();
        if (this._cornerTable != null) {
            this._pivotDataModel.invalidateCornerTableModel();
            TableModel tableModel = this._pivotDataModel.getCornerTableModel();
            this.setCornerTableModel(this._cornerTable, tableModel);
            TableUtils.synchronizeTableColumnWidthNow(this._rowHeaderTable, this._cornerTable);
        }
        this.setDataTableModel(this._dataTable, this._pivotDataModel.getDataTableModel());
        PivotTablePane.setTableColumnWidth((HeaderTable)this._columnHeaderTable, mapArray);
        if (!this.isKeepFieldAreaFit()) {
            TableUtils.synchronizeTableColumnWidthNow(this._columnHeaderTable, this._dataTable);
        }
        this.setRestoreColumnWidthNeeded(true);
        this.setDataFieldFilter(map);
    }

    public void dataTableUpdated() {
        TableModel tableModel = this._pivotDataModel.getDataTableModel();
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableDataChanged();
        }
    }

    public void fieldsUpdated() {
        for (PivotField pivotField : this._fieldBoxMap.keySet()) {
            FieldBox fieldBox = this._fieldBoxMap.get(pivotField);
            this.uninitializeFieldBox(fieldBox);
        }
        this._fieldBoxMap.clear();
        this.getPivotDataModel().calculate();
    }

    public void rowFieldsUpdated() {
        Enumeration<AbstractButton> enumeration = this._unassignedButtonGroup.getElements();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (!(abstractButton instanceof FieldBox) || ((FieldBox)abstractButton).getField().getAreaType() != 0) continue;
            arrayList.add(abstractButton);
        }
        for (AbstractButton abstractButton : arrayList) {
            this._unassignedButtonGroup.remove(abstractButton);
            this._fieldBoxMap.get(((FieldBox)abstractButton).getField());
        }
        this.getPivotDataModel().calculate();
    }

    public void columnFieldsUpdated() {
        Enumeration<AbstractButton> enumeration = this._unassignedButtonGroup.getElements();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (!(abstractButton instanceof FieldBox) || ((FieldBox)abstractButton).getField().getAreaType() != 1) continue;
            arrayList.add(abstractButton);
        }
        for (AbstractButton abstractButton : arrayList) {
            this._unassignedButtonGroup.remove(abstractButton);
            this._fieldBoxMap.get(((FieldBox)abstractButton).getField());
        }
        this.getPivotDataModel().calculate();
    }

    public void synchronizeFieldAreaWithColumnWidth(JTable jTable, FieldArea fieldArea) {
        this.synchronizeFieldAreaWithColumnWidth(jTable, fieldArea, true);
    }

    private void synchronizeFieldAreaWithColumnWidth(final JTable jTable, final FieldArea fieldArea, boolean bl) {
        if (bl) {
            fieldArea.setTable(jTable, 0);
            for (int i = 0; i < fieldArea.getComponentCount(); ++i) {
                jTable.getColumnModel().getColumn(i).setPreferredWidth(fieldArea.getComponent((int)i).getPreferredSize().width + 4);
            }
        }
        final TableColumnModelListener tableColumnModelListener = new TableColumnModelListener(){

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                if (PivotTablePane.this.isRestoreColumnWidthNeeded()) {
                    fieldArea.invalidate();
                    fieldArea.doLayout();
                    if (!PivotTablePane.this.isKeepFieldAreaFit()) {
                        if (fieldArea.getAreaType() == 0 && fieldArea.getWidth() > 0) {
                            fieldArea.savePreferredWidth();
                        }
                    } else {
                        fieldArea.savePreferredWidth();
                    }
                }
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }
        };
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("columnModel".equals(propertyChangeEvent.getPropertyName())) {
                    TableColumnModel tableColumnModel = (TableColumnModel)propertyChangeEvent.getOldValue();
                    if (tableColumnModel != null) {
                        tableColumnModel.removeColumnModelListener(tableColumnModelListener);
                    }
                    if ((tableColumnModel = (TableColumnModel)propertyChangeEvent.getNewValue()) != null) {
                        tableColumnModel.addColumnModelListener(tableColumnModelListener);
                    }
                } else if ("model".equals(propertyChangeEvent.getPropertyName())) {
                    PivotTablePane.updateTableColumnWidth(jTable, fieldArea);
                }
            }
        };
        jTable.addPropertyChangeListener(propertyChangeListener);
        jTable.putClientProperty(CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER, propertyChangeListener);
        jTable.getColumnModel().addColumnModelListener(tableColumnModelListener);
        jTable.putClientProperty(CLIENT_PROPERTY_COLUMN_MODEL_LISTENER, tableColumnModelListener);
    }

    private void unsynchronizeFieldAreaWithColumnWidth(JTable jTable, FieldArea fieldArea) {
        Object object;
        Object object2 = jTable.getClientProperty(CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER);
        if (object2 instanceof PropertyChangeListener) {
            jTable.removePropertyChangeListener((PropertyChangeListener)object2);
        }
        if ((object = jTable.getClientProperty(CLIENT_PROPERTY_COLUMN_MODEL_LISTENER)) instanceof TableColumnModelListener) {
            jTable.getColumnModel().removeColumnModelListener((TableColumnModelListener)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateTableColumnWidth(JTable jTable, FieldArea fieldArea) {
        Object object = jTable.getClientProperty(CLIENT_PROPERTY_COLUMN_MODEL_LISTENER);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        if (object != null && object instanceof TableColumnModelListener) {
            tableColumnModel.removeColumnModelListener((TableColumnModelListener)object);
        }
        try {
            if (fieldArea.getComponentCount() == 0) {
                if (tableColumnModel.getColumnCount() != 0) {
                    tableColumnModel.getColumn(0).setPreferredWidth(fieldArea.getMinimumSize().width);
                }
            } else {
                int n;
                for (int i = 0; i < fieldArea.getComponentCount(); ++i) {
                    if (!(fieldArea.getComponent(i) instanceof FieldBox)) continue;
                    n = ((FieldBox)fieldArea.getComponent(i)).getField().getPreferredWidth();
                    if (n == 0 && fieldArea.isShowing() && (n = fieldArea.getComponent(i).getWidth()) > 0) {
                        ((FieldBox)fieldArea.getComponent(i)).getField().setPreferredWidth(n);
                    }
                    int n2 = fieldArea.getComponent((int)i).getPreferredSize().width;
                    if (i < 0 || i >= tableColumnModel.getColumnCount()) continue;
                    tableColumnModel.getColumn(i).setPreferredWidth(Math.max(n, n2) + 4);
                }
                TableModel tableModel = TableModelWrapperUtils.getActualTableModel(jTable.getModel(), HeaderTableModel.class);
                if (jTable instanceof HeaderTable && ((HeaderTable)jTable).getPivotTablePane().isRespectFieldPreferredWidth() && tableModel instanceof HeaderTableModel && ((HeaderTableModel)tableModel).isRowHeader() && tableColumnModel.getColumnCount() == fieldArea.getComponentCount() + 1) {
                    n = tableColumnModel.getColumn(tableColumnModel.getColumnCount() - 1).getMinWidth();
                    for (PivotField pivotField : ((HeaderTableModel)tableModel).getPivotDataModel().getDataFields()) {
                        n = Math.max(n, pivotField.getPreferredWidth());
                    }
                    tableColumnModel.getColumn(tableColumnModel.getColumnCount() - 1).setPreferredWidth(n);
                }
            }
        }
        finally {
            if (object != null && object instanceof TableColumnModelListener) {
                tableColumnModel.addColumnModelListener((TableColumnModelListener)object);
            }
        }
    }

    public void synchronizeFieldAreaTableWidth(final JTable jTable, final FieldArea fieldArea, final FieldArea fieldArea2) {
        TableColumnModelListener tableColumnModelListener = new TableColumnModelListener(){

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                fieldArea.invalidate();
                fieldArea.doLayout();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }
        };
        jTable.getColumnModel().addColumnModelListener(tableColumnModelListener);
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (PivotTablePane.this.isKeepFieldAreaFit()) {
                    Dimension dimension = fieldArea.getPreferredSize();
                    Dimension dimension2 = fieldArea.getMinimumSize();
                    dimension.width = jTable.getColumnCount() == 0 ? Math.max(dimension2.width, fieldArea2.getMinimumSize().width) : Math.max(dimension2.width, jTable.getWidth());
                    fieldArea.setPreferredSize(dimension);
                    fieldArea.getParent().doLayout();
                    fieldArea.doLayout();
                } else {
                    PivotTablePane.this.updateDataFieldAreaWidth(jTable, fieldArea, fieldArea2);
                }
            }
        };
        jTable.addComponentListener(componentAdapter);
        jTable.putClientProperty(CLIENT_PROPERTY_COMPONENT_LISTENER, componentAdapter);
    }

    private void updateDataFieldAreaWidth(JTable jTable, FieldArea fieldArea, FieldArea fieldArea2) {
        Dimension dimension = fieldArea.getPreferredSize();
        Dimension dimension2 = fieldArea.getMinimumSize();
        dimension.width = jTable.getColumnCount() == 0 ? Math.max(dimension2.width, fieldArea2.getMinimumSize().width) : Math.max(dimension2.width, jTable.getWidth());
        if (!this.isShrinkDataFieldArea()) {
            fieldArea.setPreferredSize(null);
            fieldArea.doLayout();
            int n = fieldArea.getPreferredSize().width;
            if (dimension.width < n) {
                dimension.width = n;
            }
        } else if (this.isKeepFieldAreaFit()) {
            fieldArea.setPreferredSize(dimension);
        }
        if (!this.isKeepFieldAreaFit()) {
            fieldArea.setPreferredSize(dimension);
        }
        if (fieldArea.getParent() != null) {
            fieldArea.getParent().doLayout();
        }
        fieldArea.doLayout();
    }

    public void synchronizeFieldAreaWithField(FieldBox fieldBox) {
    }

    public int getRowHeight() {
        return this._rowHeight;
    }

    public void setRowHeight(int n) {
        if (this._rowHeight != n) {
            this._rowHeight = n;
            if (this._dataTable != null) {
                this._dataTable.setRowHeight(this._rowHeight);
            }
            if (this._rowHeaderTable != null) {
                this._rowHeaderTable.setRowHeight(this._rowHeight);
            }
        }
    }

    public void setVisibleRowCount(int n) {
        int n2 = this._visibleRowCount;
        this._visibleRowCount = Math.max(0, n);
        this.firePropertyChange("visibleRowCount", n2, n);
        if (this._dataTable != null) {
            this._dataTable.setPreferredScrollableViewportSize(new Dimension(this._dataTable.getPreferredScrollableViewportSize().width, this.getRowHeight() * this._visibleRowCount));
        }
    }

    public int getVisibleRowCount() {
        return this._visibleRowCount;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._listener != null && this._listener.isDragging()) {
            this._listener.drawItem(graphics);
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        if (this._rowHeaderTable != null) {
            this._rowHeaderTable.setCursor(cursor);
        }
        if (this._columnHeaderTable != null) {
            this._columnHeaderTable.setCursor(cursor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void hideFieldBox(FieldBox fieldBox) {
        if (!fieldBox.getField().isAllowedAsUnassignedField()) return;
        this.getPivotDataModel().setAdjusting(true);
        try {
            int n = fieldBox.getField().getAreaType();
            fieldBox.getField().setAreaType(-1);
            switch (n) {
                case 0: {
                    this.rowFieldsUpdated();
                    return;
                }
                case 1: {
                    this.columnFieldsUpdated();
                    return;
                }
                case 2: 
                case 3: {
                    this.fieldsUpdated();
                    return;
                }
            }
            return;
        }
        finally {
            this.getPivotDataModel().setAdjusting(false);
        }
    }

    protected void moveFieldBox(FieldBox fieldBox, boolean bl) {
        this.getPivotDataModel().setAdjusting(true);
        try {
            fieldBox.getField().setAreaIndex(bl ? fieldBox.getField().getAreaIndex() - 3 : fieldBox.getField().getAreaIndex() + 3);
            this.fieldsUpdated();
        }
        finally {
            this.getPivotDataModel().setAdjusting(false);
        }
    }

    protected void moveFieldBoxToBeginning(FieldBox fieldBox) {
        this.getPivotDataModel().setAdjusting(true);
        try {
            fieldBox.getField().setAreaIndex(0);
            this.fieldsUpdated();
        }
        finally {
            this.getPivotDataModel().setAdjusting(false);
        }
    }

    protected void moveFieldBoxToEnd(FieldBox fieldBox) {
        this.getPivotDataModel().setAdjusting(true);
        try {
            fieldBox.getField().setAreaIndex(Integer.MAX_VALUE);
            this.fieldsUpdated();
        }
        finally {
            this.getPivotDataModel().setAdjusting(false);
        }
    }

    protected void addFieldBox(FieldBox fieldBox, int n) {
        try {
            PivotField[] pivotFieldArray = this.getPivotDataModel().getFields();
            int n2 = -1;
            for (PivotField pivotField : pivotFieldArray) {
                if (pivotField.getAreaType() != n || pivotField.getAreaIndex() <= n2) continue;
                n2 = pivotField.getAreaIndex();
            }
            fieldBox.getField().setAreaType(n);
            if (++n2 % 2 == 0) {
                fieldBox.getField().setAreaIndex(n2);
            } else {
                fieldBox.getField().setAreaIndex(Integer.MAX_VALUE);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(this.getResourceString("PivotTablePane.incompatibleType.message"), fieldBox.getField().getName()), this.getResourceString("PivotTablePane.incompatibleType.title"), 0);
        }
        this.fieldsUpdated();
    }

    protected void moveFieldBox(FieldBox fieldBox, FieldBox fieldBox2, boolean bl) {
        try {
            int n = fieldBox2.getField().getAreaType();
            int n2 = fieldBox.getField().getAreaType();
            if (!this.isDataFieldsDuplicationEnabled()) {
                fieldBox.getField().setAreaType(n);
                fieldBox.getField().setAreaIndex(bl ? fieldBox2.getField().getAreaIndex() - 1 : fieldBox2.getField().getAreaIndex() + 1);
            } else if (n2 != 3 && n == 3 && this.getPivotDataModel() instanceof PivotDataModel) {
                PivotField pivotField = fieldBox.getField();
                PivotField pivotField2 = ((PivotDataModel)this.getPivotDataModel()).duplicateField(pivotField);
                pivotField2.setAreaType(n);
                pivotField2.setAreaIndex(bl ? fieldBox2.getField().getAreaIndex() - 1 : fieldBox2.getField().getAreaIndex() + 1);
                pivotField.setAreaType(-1);
            } else {
                if (this.getPivotDataModel() instanceof PivotDataModel) {
                    if (n2 == 3 && n == -1) {
                        PivotField pivotField = fieldBox.getField();
                        int n3 = pivotField.getModelIndex();
                        ((PivotDataModel)this.getPivotDataModel()).removeDuplicatedField(pivotField);
                        pivotField = this.getPivotDataModel().getField(n3);
                        fieldBox = this._fieldBoxMap.get(pivotField);
                    } else if (n != -1) {
                        PivotField pivotField = fieldBox.getField();
                        int n4 = pivotField.getModelIndex();
                        while (((PivotDataModel)this.getPivotDataModel()).removeDuplicatedField(pivotField)) {
                            pivotField = this.getPivotDataModel().getField(n4);
                        }
                        fieldBox = this._fieldBoxMap.get(pivotField);
                    }
                }
                fieldBox.getField().setAreaType(n);
                fieldBox.getField().setAreaIndex(bl ? fieldBox2.getField().getAreaIndex() - 1 : fieldBox2.getField().getAreaIndex() + 1);
            }
            if (n == n2 || n2 == -1 || n == -1) {
                if (n == 0 || n2 == 0) {
                    this.rowFieldsUpdated();
                } else if (n == 1 || n2 == 1) {
                    this.columnFieldsUpdated();
                } else if (n == 3 || n == 2 || n2 == 3 || n2 == 2) {
                    this.fieldsUpdated();
                }
            } else {
                this.fieldsUpdated();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(this.getResourceString("PivotTablePane.incompatibleType.message"), fieldBox.getField().getName()), this.getResourceString("PivotTablePane.incompatibleType.title"), 0);
            this.fieldsUpdated();
        }
    }

    public void setFieldChooserVisible(boolean bl) {
        boolean bl2 = this._fieldChooserAreaVisible;
        if (bl2 != bl) {
            this._fieldChooserAreaVisible = bl;
            this.firePropertyChange(PROPERTY_FIELD_CHOOSER_AREA_VISIBLE, bl2, this._fieldChooserAreaVisible);
        }
        if (this._fieldsPanel != null) {
            this._fieldsPanel.setVisible(this.isFieldChooserVisible());
        }
    }

    public boolean isFieldChooserVisible() {
        return this._fieldChooserAreaVisible;
    }

    public JTable getRowHeaderTable() {
        return this._rowHeaderTable;
    }

    public JTable getColumnHeaderTable() {
        return this._columnHeaderTable;
    }

    public JTable getDataTable() {
        return this._dataTable;
    }

    public JTable getCornerTable() {
        return this._cornerTable;
    }

    public IPivotDataModel getPivotDataModel() {
        return this._pivotDataModel;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String string) {
        this._version = string;
    }

    protected void showPopup(Point point) {
        Object object;
        Component component = this.findComponentAt(point);
        Container container = PivotTablePane.getValidParentOf(null, component);
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        if (container instanceof FieldBox) {
            JMenuItem jMenuItem;
            object = (FieldBox)container;
            if (this.isRearrangable() && ((FieldBox)object).getField().getAreaType() != -1) {
                if (((FieldBox)object).getField().isAllowedAsUnassignedField()) {
                    jMenuItem = new JMenuItem(new AbstractAction(this.getResourceString(FIELD_SETTING_DIALOG_HIDE_BUTTON), (FieldBox)object){
                        private static final long serialVersionUID = -7197710989465411756L;
                        final /* synthetic */ FieldBox val$fieldBox;
                        {
                            this.val$fieldBox = fieldBox;
                            super(string);
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            PivotTablePane.this.hideFieldBox(this.val$fieldBox);
                        }
                    });
                    jMenuItem.setName(FIELD_SETTING_DIALOG_HIDE_BUTTON);
                    jMenuItem.setMnemonic(this.getResourceString("PivotTablePane.hide.mnemonic").charAt(0));
                    jidePopupMenu.add(jMenuItem);
                }
                JMenu jMenu = new JMenu(this.getResourceString("PivotTablePane.move"));
                jMenu.setName("PivotTablePane.move");
                jMenu.setMnemonic(this.getResourceString("PivotTablePane.move.mnemonic").charAt(0));
                jMenuItem = new JMenuItem(new AbstractAction(this.getResourceString("PivotTablePane.moveBeginning"), (FieldBox)object){
                    private static final long serialVersionUID = -5574451744126677463L;
                    final /* synthetic */ FieldBox val$fieldBox;
                    {
                        this.val$fieldBox = fieldBox;
                        super(string);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PivotTablePane.this.moveFieldBoxToBeginning(this.val$fieldBox);
                    }
                });
                jMenu.setName("PivotTablePane.moveBeginning");
                jMenuItem.setMnemonic(this.getResourceString("PivotTablePane.moveBeginning.mnemonic").charAt(0));
                jMenuItem.setEnabled(!((FieldBox)object).isFirst());
                jMenu.add(jMenuItem);
                jMenuItem = new JMenuItem(new AbstractAction(this.getResourceString("PivotTablePane.moveLeft"), (FieldBox)object){
                    private static final long serialVersionUID = -2297645520537207300L;
                    final /* synthetic */ FieldBox val$fieldBox;
                    {
                        this.val$fieldBox = fieldBox;
                        super(string);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PivotTablePane.this.moveFieldBox(this.val$fieldBox, true);
                    }
                });
                jMenu.setName("PivotTablePane.moveLeft");
                jMenuItem.setMnemonic(this.getResourceString("PivotTablePane.moveLeft.mnemonic").charAt(0));
                jMenuItem.setEnabled(!((FieldBox)object).isFirst());
                jMenu.add(jMenuItem);
                jMenuItem = new JMenuItem(new AbstractAction(this.getResourceString("PivotTablePane.moveRight"), (FieldBox)object){
                    private static final long serialVersionUID = 142467024186108231L;
                    final /* synthetic */ FieldBox val$fieldBox;
                    {
                        this.val$fieldBox = fieldBox;
                        super(string);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PivotTablePane.this.moveFieldBox(this.val$fieldBox, false);
                    }
                });
                jMenu.setName("PivotTablePane.moveRight");
                jMenuItem.setMnemonic(this.getResourceString("PivotTablePane.moveRight.mnemonic").charAt(0));
                jMenuItem.setEnabled(!((FieldBox)object).isLast());
                jMenu.add(jMenuItem);
                jMenuItem = new JMenuItem(new AbstractAction(this.getResourceString("PivotTablePane.moveEnd"), (FieldBox)object){
                    private static final long serialVersionUID = 490229878402108571L;
                    final /* synthetic */ FieldBox val$fieldBox;
                    {
                        this.val$fieldBox = fieldBox;
                        super(string);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PivotTablePane.this.moveFieldBoxToEnd(this.val$fieldBox);
                    }
                });
                jMenu.setName("PivotTablePane.moveEnd");
                jMenuItem.setMnemonic(this.getResourceString("PivotTablePane.moveEnd.mnemonic").charAt(0));
                jMenuItem.setEnabled(!((FieldBox)object).isLast());
                jMenu.add(jMenuItem);
                jidePopupMenu.add(jMenu);
            }
            if (((FieldBox)object).getField().isCustomizable()) {
                if (jidePopupMenu.getComponentCount() > 0) {
                    jidePopupMenu.addSeparator();
                }
                jMenuItem = new JMenuItem(new AbstractAction(this.getResourceString("PivotTablePane.fieldSettings"), (FieldBox)object){
                    private static final long serialVersionUID = 2896069689906651621L;
                    final /* synthetic */ FieldBox val$fieldBox;
                    {
                        this.val$fieldBox = fieldBox;
                        super(string);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PivotTablePane.this.showFieldSettingsDialog(this.val$fieldBox);
                    }
                });
                jMenuItem.setName("PivotTablePane.fieldSettings");
                jMenuItem.setMnemonic(this.getResourceString("PivotTablePane.fieldSettings.mnemonic").charAt(0));
                jidePopupMenu.add(jMenuItem);
            }
        }
        if (this.isFieldChooserEnabled()) {
            if (jidePopupMenu.getComponentCount() > 0) {
                jidePopupMenu.addSeparator();
            }
            object = new JMenuItem(this.isFieldChooserVisible() ? this.getResourceString("PivotTablePane.hideFieldList") : this.getResourceString("PivotTablePane.showFieldList"));
            ((Component)object).setName("PivotTablePane.showFieldList");
            ((AbstractButton)object).setMnemonic(this.getResourceString("PivotTablePane.showFieldList.mnemonic").charAt(0));
            ((AbstractButton)object).addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 6377703420510625880L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PivotTablePane.this.setFieldChooserVisible(!PivotTablePane.this.isFieldChooserVisible());
                }
            });
            jidePopupMenu.add((JMenuItem)object);
        }
        if (this.getPivotDataModel().hasHiddenColumns() || this.getPivotDataModel().hasHiddenValues() || this.hasHiddenRowField() || this.getPivotDataModel().hasHiddenRows()) {
            if (jidePopupMenu.getComponentCount() > 0) {
                jidePopupMenu.addSeparator();
            }
            object = new JMenuItem(this.getResourceString("PivotTablePane.showAll"));
            ((Component)object).setName("PivotTablePane.showAll");
            ((AbstractButton)object).setMnemonic(this.getResourceString("PivotTablePane.showAll.mnemonic").charAt(0));
            ((AbstractButton)object).addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 490229878402108571L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PivotTablePane.this.clearHiddenRowFields();
                    PivotTablePane.this.showAllColumns();
                    PivotTablePane.this.showAllRows();
                    PivotTablePane.this.clearHiddenValues();
                }
            });
            jidePopupMenu.add((JMenuItem)object);
        }
        if ((object = this.getPopupMenuCustomizer()) != null) {
            object.customize(jidePopupMenu, container);
        }
        if (jidePopupMenu.getComponentCount() > 0) {
            JideSwingUtilities.showPopupMenu(jidePopupMenu, this, point.x, point.y);
        }
    }

    private void showHiddenOriginalValues() {
        Map<PivotField, Set<Values>> map;
        HeaderTableModel headerTableModel = this.getPivotDataModel().getColumnHeaderTableModel();
        if (headerTableModel instanceof CalculatedHeaderTableModel && (map = ((CalculatedHeaderTableModel)headerTableModel).getHiddenOriginalValues()) != null && !map.isEmpty()) {
            for (PivotField pivotField : map.keySet()) {
                Set<Values> set;
                if (pivotField == null || (set = map.get(pivotField)) == null) continue;
                for (Values values : set) {
                    int n;
                    if (!(values instanceof DefaultValues) || (n = headerTableModel.getInsertIndexInFlatData((DefaultValues)values, headerTableModel.getFlatData())) >= 0) continue;
                    this.showColumn(-1 - n, values, pivotField);
                }
            }
        }
    }

    protected void showFieldSettingsDialog(FieldBox fieldBox) {
        Window window = JideSwingUtilities.getWindowForComponent(this);
        FieldSettingsDialog fieldSettingsDialog = window instanceof Frame ? new FieldSettingsDialog((Frame)window, this, this.getResourceString("PivotTablePane.fieldSettings.title")) : new FieldSettingsDialog((Dialog)window, this, this.getResourceString("PivotTablePane.fieldSettings.title"));
        fieldSettingsDialog.setDefaultCloseOperation(2);
        fieldSettingsDialog.pack();
        fieldSettingsDialog.setLocationRelativeTo(this);
        fieldSettingsDialog.getFieldSettingsPanel().setField(fieldBox.getField());
        fieldSettingsDialog.getFieldSettingsPanel().loadData();
        fieldSettingsDialog.setVisible(true);
        if (fieldSettingsDialog.getDialogResult() == 0) {
            fieldSettingsDialog.getFieldSettingsPanel().saveData();
            Object[] objectArray = this.saveSelection();
            this.showHiddenOriginalValues();
            this.bothHeadersUpdated();
            this.loadSelection(objectArray);
            this.hideRowHeaderTableColumns();
        } else if (fieldSettingsDialog.getDialogResult() == FieldSettingsDialog.RESULT_HIDE) {
            this.hideFieldBox(fieldBox);
        }
    }

    protected CustomFilterEditorDialog createCustomFilterEditorDialog(Container container, String string, CustomFilterEditor customFilterEditor) {
        if (container instanceof Frame) {
            return new CustomFilterEditorDialog((Frame)container, string, (JComponent)customFilterEditor);
        }
        if (container instanceof Dialog) {
            return new CustomFilterEditorDialog((Dialog)container, string, (JComponent)customFilterEditor);
        }
        return new CustomFilterEditorDialog((Frame)null, string, (JComponent)customFilterEditor);
    }

    protected FieldSettingsPanel createFieldSettingsPanel() {
        return new FieldSettingsPanel(this);
    }

    protected ButtonPanel createFieldSettingsDialogButtonPanel(final StandardDialog standardDialog) {
        ButtonPanel buttonPanel = new ButtonPanel(1);
        JButton jButton = new JButton(new AbstractAction(JideSwingUtilities.getOKString(this.getLocale())){
            private static final long serialVersionUID = 8834800451061035928L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                standardDialog.setDialogResult(0);
                standardDialog.setVisible(false);
            }
        });
        jButton.setName(FIELD_SETTING_DIALOG_OK_BUTTON);
        buttonPanel.addButton((AbstractButton)jButton, "AFFIRMATIVE");
        JButton jButton2 = new JButton(new AbstractAction(JideSwingUtilities.getCancelString(this.getLocale())){
            private static final long serialVersionUID = -4067081832260858892L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                standardDialog.setDialogResult(-1);
                standardDialog.setVisible(false);
            }
        });
        jButton2.setName(FIELD_SETTING_DIALOG_CANCEL_BUTTON);
        buttonPanel.addButton((AbstractButton)jButton2, "CANCEL");
        JButton jButton3 = new JButton(new AbstractAction(this.getResourceString(FIELD_SETTING_DIALOG_HIDE_BUTTON)){
            private static final long serialVersionUID = 3273783807560168556L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                standardDialog.setDialogResult(FieldSettingsDialog.RESULT_HIDE);
                standardDialog.setVisible(false);
            }
        });
        jButton3.setName(FIELD_SETTING_DIALOG_HIDE_BUTTON);
        jButton3.setMnemonic(this.getResourceString("PivotTablePane.hide.mnemonic").charAt(0));
        buttonPanel.addButton((AbstractButton)jButton3, "ALTERNATIVE");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        standardDialog.setDefaultAction(jButton.getAction());
        standardDialog.setDefaultCancelAction(jButton2.getAction());
        standardDialog.getRootPane().setDefaultButton(jButton);
        return buttonPanel;
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this._popupMenuCustomizer;
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this._popupMenuCustomizer = popupMenuCustomizer;
    }

    public PopupMenuCustomizer getHeaderTablePopupMenuCustomizer() {
        return this._headerTablePopupMenuCustomizer;
    }

    public void setHeaderTablePopupMenuCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this._headerTablePopupMenuCustomizer = popupMenuCustomizer;
    }

    public PopupMenuCustomizer getDataTablePopupMenuCustomizer() {
        return this._dataTablePopupMenuCustomizer;
    }

    public void setDataTablePopupMenuCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this._dataTablePopupMenuCustomizer = popupMenuCustomizer;
    }

    static Container getValidParentOf(Component component, Component component2) {
        Component component3 = component2;
        if (component3 == null) {
            return null;
        }
        if (PivotTablePane.isValidComponent(component, component3)) {
            return (Container)component3;
        }
        do {
            if ((component3 = component3.getParent()) != null) continue;
            return null;
        } while (!PivotTablePane.isValidComponent(component, component3));
        return (Container)component3;
    }

    private static boolean isValidComponent(Component component, Component component2) {
        return component2 instanceof FieldBox || component2 instanceof FieldArea || component2 instanceof DataTable || component2 instanceof HeaderTable || component2 instanceof JViewport && ((JViewport)component2).getView() instanceof UnassignedFieldsArea;
    }

    public static String getAreaName(Locale locale, int n) {
        switch (n) {
            case 0: {
                return PivotResources.getResourceBundle(locale).getString("AreaType.row");
            }
            case 1: {
                return PivotResources.getResourceBundle(locale).getString("AreaType.column");
            }
            case 2: {
                return PivotResources.getResourceBundle(locale).getString("AreaType.filter");
            }
            case 3: {
                return PivotResources.getResourceBundle(locale).getString("AreaType.data");
            }
            case -1: {
                return PivotResources.getResourceBundle(locale).getString("AreaType.available");
            }
        }
        return "";
    }

    @Deprecated
    public static int getSummaryCount() {
        return 7;
    }

    @Deprecated
    public static String getSummaryName(Locale locale, int n) {
        switch (n) {
            case 0: {
                return PivotResources.getResourceBundle(locale).getString("SummaryType.Sum");
            }
            case 1: {
                return PivotResources.getResourceBundle(locale).getString("SummaryType.Max");
            }
            case 2: {
                return PivotResources.getResourceBundle(locale).getString("SummaryType.Min");
            }
            case 3: {
                return PivotResources.getResourceBundle(locale).getString("SummaryType.Mean");
            }
            case 4: {
                return PivotResources.getResourceBundle(locale).getString("SummaryType.Var");
            }
            case 5: {
                return PivotResources.getResourceBundle(locale).getString("SummaryType.StdDev");
            }
            case 6: {
                return PivotResources.getResourceBundle(locale).getString("SummaryType.Count");
            }
            case 7: {
                return PivotResources.getResourceBundle(locale).getString("SummaryType.Constant");
            }
            case -2: {
                return PivotResources.getResourceBundle(locale).getString("SummaryType.None");
            }
        }
        return "";
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._rowFieldsArea.setLocale(locale);
        this._columnFieldsArea.setLocale(locale);
        this._dataFieldsArea.setLocale(locale);
        this._filterFieldsArea.setLocale(locale);
        this._unassignedFieldsArea.setLocale(locale);
        this.customizeFieldsPanel(this._fieldsPanel);
        this._rowHeaderTable.setLocale(locale);
        this._columnHeaderTable.setLocale(locale);
        this._dataTable.setLocale(locale);
    }

    public boolean isFieldChooserEnabled() {
        return this._fieldChooserEnabled;
    }

    public void setFieldChooserEnabled(boolean bl) {
        this._fieldChooserEnabled = bl;
        if (!this.isFieldChooserEnabled()) {
            this.setFieldChooserVisible(false);
        }
    }

    public boolean isRearrangable() {
        return this._rearrangable;
    }

    public void setRearrangable(boolean bl) {
        this._rearrangable = bl;
        if (this._fieldChooserComboBoxPanel != null) {
            this._fieldChooserComboBoxPanel.setVisible(this.isRearrangable());
        }
    }

    public JPanel getFieldChooserComboBoxPanel() {
        return this._fieldChooserComboBoxPanel;
    }

    public void setFieldChooserFilterFieldVisible(boolean bl) {
        if (this._filterField != null) {
            this._filterField.setVisible(bl);
        }
    }

    QuickUnassignedFieldsAreaFilterField getFilterField() {
        return this._filterField;
    }

    public boolean isFieldChooserFilterFieldVisible() {
        return this._filterField != null && this._filterField.isVisible();
    }

    public int[] getRowFieldsWidth() {
        Component[] componentArray = this._rowFieldsArea.getFieldBoxes();
        int[] nArray = new int[componentArray.length];
        for (int i = 0; i < componentArray.length; ++i) {
            nArray[i] = this.isKeepFieldAreaFit() ? componentArray[i].getPreferredSize().width : (componentArray[i] instanceof FieldBox ? ((FieldBox)componentArray[i]).getActualPreferredSize().width : componentArray[i].getPreferredSize().width);
        }
        return nArray;
    }

    public void autoResizeAllColumns() {
        this.autoResizeAllColumns(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoResizeAllColumns(boolean bl) {
        int[] nArray;
        Object object = this.getColumnHeaderTable().getClientProperty("AutoResize.highPerformance");
        if (this.getPivotDataModel().getCellStyleProvider() != null) {
            this.getColumnHeaderTable().putClientProperty("AutoResize.highPerformance", false);
        }
        try {
            nArray = TableUtils.autoResizeAllColumns(this.getColumnHeaderTable(), null, false, bl);
        }
        finally {
            this.getColumnHeaderTable().putClientProperty("AutoResize.highPerformance", object);
        }
        object = this.getDataTable().getClientProperty("AutoResize.highPerformance");
        if (this.getPivotDataModel().getCellStyleProvider() != null) {
            this.getDataTable().putClientProperty("AutoResize.highPerformance", false);
        }
        try {
            TableUtils.autoResizeAllColumns(this.getDataTable(), nArray, false, bl);
        }
        finally {
            this.getDataTable().putClientProperty("AutoResize.highPerformance", object);
        }
        final JTable jTable = this.getRowHeaderTable();
        object = jTable.getClientProperty("AutoResize.highPerformance");
        if (this.getPivotDataModel().getCellStyleProvider() != null) {
            jTable.putClientProperty("AutoResize.highPerformance", false);
        }
        try {
            if (this.isConsiderRowFieldWidth()) {
                TableUtils.autoResizeAllColumns(jTable, this.getRowFieldsWidth(), false, bl);
            } else {
                TableUtils.autoResizeAllColumns(jTable, null, false, bl);
            }
        }
        finally {
            jTable.putClientProperty("AutoResize.highPerformance", object);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PivotField[] pivotFieldArray = PivotTablePane.this.getPivotDataModel().getRowFields();
                if (pivotFieldArray != null && pivotFieldArray.length > 0) {
                    for (int i = 0; i < pivotFieldArray.length; ++i) {
                        pivotFieldArray[i].setPreferredWidth(jTable.getColumnModel().getColumn(i).getPreferredWidth() - 4);
                    }
                } else {
                    Dimension dimension = PivotTablePane.this.getRowFieldsArea().getSize();
                    int n = jTable.getColumnCount();
                    if (dimension != null && dimension.width > jTable.getWidth() && n >= 1) {
                        int n2 = 0;
                        for (int i = 0; i < n - 1; ++i) {
                            n2 += jTable.getColumnModel().getColumn(i).getWidth();
                        }
                        TableColumn tableColumn = jTable.getColumnModel().getColumn(n - 1);
                        tableColumn.setPreferredWidth(dimension.width - n2);
                        tableColumn.setWidth(dimension.width - n2);
                    }
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public Container getFieldChooser() {
        return this._fieldsPanel;
    }

    public Color getGridColor() {
        if (this._gridColor == null) {
            this._gridColor = UIDefaultsLookup.getColor("control");
        }
        return this._gridColor;
    }

    public void setGridColor(Color color) {
        Color color2 = this._gridColor;
        if (color2 != color) {
            this._gridColor = color;
            if (this._dataTable != null) {
                this._dataTable.setGridColor(this.getGridColor());
            }
            this.firePropertyChange(PROPERTY_GRID_COLOR, color2, this._gridColor);
        }
    }

    public boolean isPlainHeaderTables() {
        return this._plainHeaderTables;
    }

    public void setPlainHeaderTables(boolean bl) {
        boolean bl2 = this._plainHeaderTables;
        if (bl2 != bl) {
            this._plainHeaderTables = bl;
            this.firePropertyChange(PROPERTY_PLAIN_HEADER_TABLES, bl2, bl);
            this.repaint();
        }
    }

    public boolean isFilterFieldAreaVisible() {
        return this._filterFieldAreaVisible;
    }

    public void setFilterFieldAreaVisible(boolean bl) {
        boolean bl2 = this._filterFieldAreaVisible;
        if (bl2 != bl) {
            this._filterFieldAreaVisible = bl;
            this.firePropertyChange(PROPERTY_FILTER_FIELD_AREA_VISIBLE, bl2, bl);
        }
        this._filterFieldsArea.setVisible(this.isFilterFieldAreaVisible());
        this._separator.setVisible(this.isFilterFieldAreaVisible());
    }

    public boolean isColumnFieldAreaVisible() {
        return this._columnFieldAreaVisible;
    }

    public void setColumnFieldAreaVisible(boolean bl) {
        boolean bl2 = this._columnFieldAreaVisible;
        if (bl2 != bl) {
            this._columnFieldAreaVisible = bl;
            this.firePropertyChange(PROPERTY_COLUMN_FIELD_AREA_VISIBLE, bl2, bl);
        }
        this._columnFieldsArea.setVisible(this.isColumnFieldAreaVisible());
    }

    public boolean isRowFieldAreaVisible() {
        return this._rowFieldAreaVisible;
    }

    public void setRowFieldAreaVisible(boolean bl) {
        boolean bl2 = this._rowFieldAreaVisible;
        if (bl2 != bl) {
            this._rowFieldAreaVisible = bl;
            this.firePropertyChange(PROPERTY_ROW_FIELD_AREA_VISIBLE, bl2, bl);
        }
        this._rowFieldsArea.setVisible(this.isRowFieldAreaVisible());
    }

    public boolean isDataFieldAreaVisible() {
        return this._dataFieldAreaVisible;
    }

    public void setDataFieldAreaVisible(boolean bl) {
        boolean bl2 = this._dataFieldAreaVisible;
        if (bl2 != bl) {
            this._dataFieldAreaVisible = bl;
            this.firePropertyChange(PROPERTY_DATA_FIELD_AREA_VISIBLE, bl2, bl);
        }
        this._dataFieldsArea.setVisible(this.isDataFieldAreaVisible());
    }

    public String getFieldAreaMessage(int n) {
        String string;
        switch (n) {
            case 0: {
                string = this.getResourceString("FieldArea.row.message");
                break;
            }
            case 1: {
                string = this.getResourceString("FieldArea.column.message");
                break;
            }
            case 3: {
                string = this.getResourceString("FieldArea.data.message");
                break;
            }
            case 2: {
                string = this.getResourceString("FieldArea.filter.message");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public String getFieldAreaName(int n) {
        String string;
        switch (n) {
            case 0: {
                string = this.getResourceString("PivotTablePane.rowArea");
                break;
            }
            case 1: {
                string = this.getResourceString("PivotTablePane.columnArea");
                break;
            }
            case 3: {
                string = this.getResourceString("PivotTablePane.dataArea");
                break;
            }
            case 2: {
                string = this.getResourceString("PivotTablePane.filterArea");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public int getFieldAreaType(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equals(this.getFieldAreaName(0))) {
            return 0;
        }
        if (string.equals(this.getFieldAreaName(1))) {
            return 1;
        }
        if (string.equals(this.getFieldAreaName(3))) {
            return 3;
        }
        if (string.equals(this.getFieldAreaName(2))) {
            return 2;
        }
        return 0;
    }

    public boolean isDataFieldFilterable() {
        return this._dataFieldFilterable;
    }

    public void setDataFieldFilterable(boolean bl) {
        boolean bl2 = this._dataFieldFilterable;
        if (bl2 != bl) {
            this._dataFieldFilterable = bl;
            this.firePropertyChange(PROPERTY_DATA_FIELD_FILTERABLE, bl2, bl);
            this.fillDataFieldArea();
        }
    }

    public boolean isRowFieldFilterable() {
        return this._rowFieldFilterable;
    }

    public void setRowFieldFilterable(boolean bl) {
        boolean bl2 = this._rowFieldFilterable;
        if (bl2 != bl) {
            this._rowFieldFilterable = bl;
            this.firePropertyChange(PROPERTY_ROW_FIELD_FILTERABLE, bl2, bl);
            this.fillRowFieldArea();
        }
    }

    public boolean isColumnFieldFilterable() {
        return this._columnFieldFilterable;
    }

    public void setColumnFieldFilterable(boolean bl) {
        boolean bl2 = this._columnFieldFilterable;
        if (bl2 != bl) {
            this._columnFieldFilterable = bl;
            this.firePropertyChange(PROPERTY_COLUMN_FIELD_FILTERABLE, bl2, bl);
            this.fillColumnFieldArea();
        }
    }

    public boolean isSelectedHeaderFilterable(boolean bl, int n, int n2, int n3, int n4) {
        PivotField pivotField;
        int n5;
        if (bl && !this.isRowFieldFilterable() || !bl && !this.isColumnFieldFilterable() || !(this._pivotDataModel instanceof PivotDataModel)) {
            return false;
        }
        if (bl) {
            PivotField pivotField2;
            int n6;
            PivotField[] pivotFieldArray = this._pivotDataModel.getRowFields();
            int n7 = Math.max(n3, n4);
            for (n6 = 0; n6 < pivotFieldArray.length && n7 * 2 + 1 != (pivotField2 = pivotFieldArray[n6]).getAreaIndex(); ++n6) {
            }
            return n6 < pivotFieldArray.length && pivotFieldArray[n6].isFilterable();
        }
        PivotField[] pivotFieldArray = this._pivotDataModel.getColumnFields();
        int n8 = Math.max(n, n2);
        for (n5 = 0; n5 < pivotFieldArray.length && n8 * 2 + 1 != (pivotField = pivotFieldArray[n5]).getAreaIndex(); ++n5) {
        }
        return n5 < pivotFieldArray.length && pivotFieldArray[n5].isFilterable();
    }

    public boolean isFiltering(boolean bl, int n, int n2, int n3, int n4) {
        if (bl) {
            PivotField[] pivotFieldArray = this._pivotDataModel.getRowFields();
            for (int i = n3; i <= n4; ++i) {
                for (PivotField pivotField : pivotFieldArray) {
                    if (i * 2 + 1 != pivotField.getAreaIndex()) continue;
                    Object[] objectArray = this._pivotDataModel.getPossibleValues(pivotField);
                    Object[] objectArray2 = pivotField.getSelectedPossibleValues();
                    if (objectArray2 != null && !Arrays.equals(objectArray, objectArray2)) {
                        return true;
                    }
                    Object[] objectArray3 = pivotField.getFilteredPossibleValues();
                    if (objectArray3 == null || objectArray3.length <= 0) continue;
                    return true;
                }
            }
        } else {
            PivotField[] pivotFieldArray = this._pivotDataModel.getColumnFields();
            for (int i = n; i <= n2; ++i) {
                for (PivotField pivotField : pivotFieldArray) {
                    if (i * 2 + 1 != pivotField.getAreaIndex()) continue;
                    Object[] objectArray = this._pivotDataModel.getPossibleValues(pivotField);
                    Object[] objectArray4 = pivotField.getSelectedPossibleValues();
                    if (objectArray4 != null && !Arrays.equals(objectArray, objectArray4)) {
                        return true;
                    }
                    Object[] objectArray5 = pivotField.getFilteredPossibleValues();
                    if (objectArray5 == null || objectArray5.length <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void clearFilter(boolean bl, int n, int n2, int n3, int n4) {
        if (bl) {
            PivotField[] pivotFieldArray = this._pivotDataModel.getRowFields();
            for (int i = n3; i <= n4; ++i) {
                if (i < 0 || i >= pivotFieldArray.length) continue;
                pivotFieldArray[i].setSelectedPossibleValues(null);
                pivotFieldArray[i].setFilteredPossibleValues(null);
            }
        } else {
            PivotField[] pivotFieldArray = this._pivotDataModel.getColumnFields();
            for (int i = n; i <= n2; ++i) {
                if (i < 0 || i >= pivotFieldArray.length) continue;
                pivotFieldArray[i].setSelectedPossibleValues(null);
                pivotFieldArray[i].setFilteredPossibleValues(null);
            }
        }
    }

    void filterSelectedHeaderValues(boolean bl, boolean bl2) {
        if (bl) {
            int n;
            HeaderTable headerTable = (HeaderTable)this.getRowHeaderTable();
            PivotField[] pivotFieldArray = this._pivotDataModel.getRowFields();
            ArrayList arrayList = new ArrayList();
            for (n = 0; n < pivotFieldArray.length; ++n) {
                boolean bl3 = false;
                HashSet<Object> hashSet = new HashSet<Object>();
                HashSet<Object> hashSet2 = new HashSet<Object>();
                for (int i = 0; i < headerTable.getRowCount(); ++i) {
                    boolean bl4 = headerTable.isCellSelected(i, n);
                    if (bl4) {
                        bl3 = true;
                        CellSpan cellSpan = headerTable.getCellSpanAt(i, n);
                        if (cellSpan != null && (cellSpan.getRow() < i || cellSpan.getColumn() < n)) continue;
                    }
                    if (bl4 ^ bl2) {
                        hashSet.add(headerTable.getValueAt(i, n));
                        continue;
                    }
                    hashSet2.add(headerTable.getValueAt(i, n));
                }
                if (bl3) {
                    if (bl2) {
                        hashSet.removeAll(hashSet2);
                    }
                    arrayList.add(hashSet);
                    continue;
                }
                arrayList.add(null);
            }
            for (n = 0; n < pivotFieldArray.length; ++n) {
                Set set = (Set)arrayList.get(n);
                if (set == null || set.size() <= 0) continue;
                pivotFieldArray[n].setSelectedPossibleValues(set.toArray());
            }
        } else {
            int n;
            HeaderTable headerTable = (HeaderTable)this.getColumnHeaderTable();
            PivotField[] pivotFieldArray = this._pivotDataModel.getColumnFields();
            ArrayList arrayList = new ArrayList();
            for (n = 0; n < pivotFieldArray.length; ++n) {
                boolean bl5 = false;
                HashSet<Object> hashSet = new HashSet<Object>();
                HashSet<Object> hashSet3 = new HashSet<Object>();
                for (int i = 0; i < headerTable.getColumnCount(); ++i) {
                    boolean bl6 = headerTable.isCellSelected(n, i);
                    if (bl6) {
                        bl5 = true;
                    }
                    if (bl6 ^ bl2) {
                        hashSet.add(headerTable.getValueAt(n, i));
                        continue;
                    }
                    hashSet3.add(headerTable.getValueAt(n, i));
                }
                if (bl5) {
                    if (bl2) {
                        hashSet.removeAll(hashSet3);
                    }
                    arrayList.add(hashSet);
                    continue;
                }
                arrayList.add(null);
            }
            for (n = 0; n < pivotFieldArray.length; ++n) {
                Set set = (Set)arrayList.get(n);
                if (set == null) continue;
                pivotFieldArray[n].setSelectedPossibleValues(set.toArray());
            }
        }
    }

    public void filterSelectedHeaderValues(boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        HashSet<Object> hashSet = new HashSet<Object>();
        if (bl) {
            PivotField pivotField;
            int n5;
            PivotField[] pivotFieldArray = this._pivotDataModel.getRowFields();
            int n6 = Math.max(n3, n4);
            for (n5 = 0; n5 < pivotFieldArray.length && n6 * 2 + 1 != (pivotField = pivotFieldArray[n5]).getAreaIndex(); ++n5) {
            }
            if (n5 >= pivotFieldArray.length) {
                return;
            }
            pivotField = pivotFieldArray[n5];
            if (bl2) {
                for (int i = 0; i < this._pivotDataModel.getRowHeaderTableModel().getRowCount(); ++i) {
                    if (i >= n && i <= n2) continue;
                    Object object = this._pivotDataModel.getRowHeaderTableModel().getValueAt(i, n6);
                    hashSet.add(object);
                }
            } else {
                for (int i = n; i <= n2; ++i) {
                    Object object = this._pivotDataModel.getRowHeaderTableModel().getValueAt(i, n6);
                    hashSet.add(object);
                }
            }
            pivotField.setSelectedPossibleValues(hashSet.toArray(new Object[hashSet.size()]));
        } else {
            PivotField pivotField;
            int n7;
            PivotField[] pivotFieldArray = this._pivotDataModel.getColumnFields();
            int n8 = Math.max(n, n2);
            for (n7 = 0; n7 < pivotFieldArray.length && n8 * 2 + 1 != (pivotField = pivotFieldArray[n7]).getAreaIndex(); ++n7) {
            }
            if (n7 >= pivotFieldArray.length) {
                return;
            }
            pivotField = pivotFieldArray[n7];
            if (bl2) {
                for (int i = 0; i < this._pivotDataModel.getColumnHeaderTableModel().getColumnCount(); ++i) {
                    if (i >= n3 && i <= n4) continue;
                    Object object = this._pivotDataModel.getColumnHeaderTableModel().getValueAt(n8, i);
                    hashSet.add(object);
                }
            } else {
                for (int i = n3; i <= n4; ++i) {
                    Object object = this._pivotDataModel.getColumnHeaderTableModel().getValueAt(n8, i);
                    hashSet.add(object);
                }
            }
            pivotField.setSelectedPossibleValues(hashSet.toArray(new Object[hashSet.size()]));
        }
    }

    public void selectDataCells(boolean bl, int n, int n2) {
        this.selectDataCells(bl, n, n2, false);
    }

    protected void selectDataCells(boolean bl, int n, int n2, boolean bl2) {
        HeaderTableModel headerTableModel = (HeaderTableModel)(bl ? this.getRowHeaderTable().getModel() : this.getColumnHeaderTable().getModel());
        CellSpan cellSpan = headerTableModel.getCellSpanAt(n, n2);
        int n3 = cellSpan.getRow();
        int n4 = n3 + cellSpan.getRowSpan() - 1;
        int n5 = cellSpan.getColumn();
        int n6 = n5 + cellSpan.getColumnSpan() - 1;
        this.applySelection(bl, n3, n4, n5, n6, bl2);
    }

    public void selectDataCellsBetween(boolean bl, int n, int n2, int n3, int n4) {
        this.selectDataCellsBetween(bl, n, n2, n3, n4, false);
    }

    protected void selectDataCellsBetween(boolean bl, int n, int n2, int n3, int n4, boolean bl2) {
        int n5;
        int n6;
        int n7;
        int n8;
        HeaderTableModel headerTableModel = (HeaderTableModel)(bl ? this.getRowHeaderTable().getModel() : this.getColumnHeaderTable().getModel());
        CellSpan cellSpan = headerTableModel.getCellSpanAt(n, n2);
        CellSpan cellSpan2 = headerTableModel.getCellSpanAt(n3, n4);
        if (cellSpan == null || cellSpan2 == null) {
            return;
        }
        int n9 = Math.min(cellSpan2.getRow(), cellSpan.getRow());
        int n10 = Math.max(cellSpan2.getRow() + cellSpan2.getRowSpan(), cellSpan.getRow() + cellSpan.getRowSpan()) - 1;
        int n11 = Math.min(cellSpan2.getColumn(), cellSpan.getColumn());
        int n12 = Math.max(cellSpan2.getColumn() + cellSpan2.getColumnSpan(), cellSpan.getColumn() + cellSpan.getColumnSpan()) - 1;
        if (bl) {
            n8 = n11;
            n7 = n12;
            n6 = n9 == cellSpan.getRow() ? n9 : n10;
            n5 = n9 == cellSpan.getRow() ? n10 : n9;
        } else {
            n6 = n9;
            n5 = n10;
            n8 = n11 == cellSpan.getColumn() ? n11 : n12;
            n7 = n11 == cellSpan.getColumn() ? n12 : n11;
        }
        this.applySelection(bl, n6, n5, n8, n7, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applySelection(boolean bl, int n, int n2, int n3, int n4, boolean bl2) {
        TableSelectionModel tableSelectionModel = ((JideTable)this._dataTable).getTableSelectionModel();
        ListSelectionModel listSelectionModel = this._dataTable.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this._dataTable.getColumnModel().getSelectionModel();
        if (((JideTable)this._dataTable).isNonContiguousCellSelection()) {
            tableSelectionModel.setValueAdjusting(true);
            listSelectionModel.setValueIsAdjusting(true);
            listSelectionModel2.setValueIsAdjusting(true);
            try {
                if (!bl2) {
                    tableSelectionModel.clearSelection();
                    listSelectionModel.clearSelection();
                    listSelectionModel2.clearSelection();
                }
                if (bl) {
                    if (!bl2) {
                        listSelectionModel.setAnchorSelectionIndex(n);
                        listSelectionModel2.setAnchorSelectionIndex(0);
                        tableSelectionModel.setAnchorSelection(n, 0);
                    }
                    int n5 = this._dataTable.getColumnCount();
                    for (int i = Math.min(n, n2); i <= Math.max(n, n2); ++i) {
                        for (int j = 0; j < n5; ++j) {
                            if (bl2 && tableSelectionModel.isSelected(i, j)) {
                                tableSelectionModel.removeSelection(i, j);
                                continue;
                            }
                            tableSelectionModel.addSelection(i, j);
                        }
                    }
                    if (bl2 && !tableSelectionModel.isSelected(n2, n5 - 1)) return;
                    tableSelectionModel.setAnchorSelection(n2, n5 - 1);
                    listSelectionModel.setAnchorSelectionIndex(n2);
                    listSelectionModel2.setAnchorSelectionIndex(n5 - 1);
                    tableSelectionModel.setLeadSelection(n2, n5 - 1);
                    listSelectionModel.setLeadSelectionIndex(n2);
                    listSelectionModel2.setLeadSelectionIndex(n5 - 1);
                    return;
                }
                if (!bl2) {
                    listSelectionModel2.setAnchorSelectionIndex(n3);
                    listSelectionModel.setAnchorSelectionIndex(0);
                    tableSelectionModel.setAnchorSelection(0, n3);
                }
                int n6 = this._dataTable.getRowCount();
                for (int i = Math.min(n3, n4); i <= Math.max(n3, n4); ++i) {
                    for (int j = 0; j < n6; ++j) {
                        if (bl2 && tableSelectionModel.isSelected(j, i)) {
                            tableSelectionModel.removeSelection(j, i);
                            continue;
                        }
                        tableSelectionModel.addSelection(j, i);
                    }
                }
                if (bl2 && !tableSelectionModel.isSelected(n6 - 1, n4)) return;
                tableSelectionModel.setAnchorSelection(n6 - 1, n4);
                listSelectionModel2.setAnchorSelectionIndex(n4);
                listSelectionModel.setAnchorSelectionIndex(n6 - 1);
                tableSelectionModel.setLeadSelection(n6 - 1, n4);
                listSelectionModel2.setLeadSelectionIndex(n4);
                listSelectionModel.setLeadSelectionIndex(n6 - 1);
                return;
            }
            finally {
                tableSelectionModel.setValueAdjusting(false);
                listSelectionModel.setValueIsAdjusting(false);
                listSelectionModel2.setValueIsAdjusting(false);
                this._dataTable.requestFocus();
            }
        }
        if (bl && this._dataTable.getRowSelectionAllowed()) {
            listSelectionModel.setValueIsAdjusting(true);
            try {
                listSelectionModel.clearSelection();
                listSelectionModel.addSelectionInterval(Math.min(n, n2), Math.max(n, n2));
                listSelectionModel.setAnchorSelectionIndex(n);
                listSelectionModel.setLeadSelectionIndex(n2);
                return;
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
                this._dataTable.requestFocus();
            }
        }
        if (bl || !this._dataTable.getColumnSelectionAllowed()) return;
        listSelectionModel2.setValueIsAdjusting(true);
        try {
            listSelectionModel2.clearSelection();
            listSelectionModel2.addSelectionInterval(Math.min(n3, n4), Math.max(n3, n4));
            listSelectionModel2.setAnchorSelectionIndex(n3);
            listSelectionModel2.setLeadSelectionIndex(n4);
            return;
        }
        finally {
            listSelectionModel2.setValueIsAdjusting(false);
            this._dataTable.requestFocus();
        }
    }

    void installPropertyChangeListenerForColumn(TableColumn tableColumn) {
        PropertyChangeListener[] propertyChangeListenerArray;
        boolean bl = true;
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = tableColumn.getPropertyChangeListeners()) {
            if (propertyChangeListener != this._columnProertyChangeListener) continue;
            bl = false;
        }
        if (bl) {
            tableColumn.addPropertyChangeListener(this._columnProertyChangeListener);
        }
    }

    public boolean isColumnHidden(int n) {
        PivotField pivotField;
        Values values;
        IPivotDataModel iPivotDataModel = this.getPivotDataModel();
        return !iPivotDataModel.isColumnVisible(values = iPivotDataModel.getColumnHeaderTableModel().getValuesAt(n), pivotField = ((DataTableModel)iPivotDataModel.getDataTableModel()).getDataFieldAt(0, n));
    }

    boolean isRowHidden(int n) {
        PivotField pivotField;
        Values values;
        IPivotDataModel iPivotDataModel = this.getPivotDataModel();
        return !iPivotDataModel.isRowVisible(values = iPivotDataModel.getRowHeaderTableModel().getValuesAt(n), pivotField = ((DataTableModel)iPivotDataModel.getDataTableModel()).getDataFieldAt(n, 0));
    }

    public void hideColumns(int[] nArray) {
        IPivotDataModel iPivotDataModel = this.getPivotDataModel();
        for (int n : nArray) {
            PivotField pivotField;
            Values values = iPivotDataModel.getColumnHeaderTableModel().getValuesAt(n);
            if (!iPivotDataModel.isColumnVisible(values, pivotField = ((DataTableModel)iPivotDataModel.getDataTableModel()).getDataFieldAt(0, n))) continue;
            TableColumnModel tableColumnModel = this.getDataTable().getColumnModel();
            TableColumnModel tableColumnModel2 = this.getColumnHeaderTable().getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            String string = "" + tableColumn.getMinWidth() + '\t' + tableColumn.getPreferredWidth() + '\t' + tableColumn.getWidth();
            iPivotDataModel.addHiddenColumn(values, pivotField, string);
            tableColumn = tableColumnModel.getColumn(n);
            this.installPropertyChangeListenerForColumn(tableColumn);
            tableColumn.setMinWidth(0);
            tableColumn.setPreferredWidth(0);
            tableColumn.setWidth(0);
            tableColumn = tableColumnModel2.getColumn(n);
            this.installPropertyChangeListenerForColumn(tableColumn);
            tableColumn.setMinWidth(0);
            tableColumn.setPreferredWidth(0);
            tableColumn.setWidth(0);
        }
    }

    void showAllRows() {
        ((DataTable)this.getDataTable()).clearHiddenRows();
        ((HeaderTable)this.getRowHeaderTable()).clearHiddenRows();
    }

    void showAllColumns() {
        int[] nArray = new int[this.getDataTable().getColumnCount()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        this.showColumns(nArray);
    }

    public void showColumns(int[] nArray) {
        IPivotDataModel iPivotDataModel = this.getPivotDataModel();
        for (int n : nArray) {
            Values values = iPivotDataModel.getColumnHeaderTableModel().getValuesAt(n);
            PivotField pivotField = ((DataTableModel)iPivotDataModel.getDataTableModel()).getDataFieldAt(0, n);
            this.showColumn(n, values, pivotField);
        }
    }

    private void showColumn(int n, Values values, PivotField pivotField) {
        IPivotDataModel iPivotDataModel = this.getPivotDataModel();
        if (iPivotDataModel.isColumnVisible(values, pivotField)) {
            return;
        }
        TableColumnModel tableColumnModel = this.getDataTable().getColumnModel();
        TableColumnModel tableColumnModel2 = this.getColumnHeaderTable().getColumnModel();
        if (n < 0 || n >= tableColumnModel2.getColumnCount()) {
            return;
        }
        String string = iPivotDataModel.removeHiddenColumn(values, pivotField);
        String[] stringArray = new String[]{};
        if (string != null) {
            stringArray = string.split("\t");
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (stringArray.length > 0) {
            try {
                n2 = Integer.valueOf(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
        }
        if (stringArray.length > 1) {
            try {
                n3 = Integer.valueOf(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                n3 = -1;
            }
        }
        if (stringArray.length > 2) {
            try {
                n4 = Integer.valueOf(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                n4 = -1;
            }
        }
        if (n2 < 0) {
            n2 = 15;
        }
        if (n3 < 0) {
            n3 = 75;
        }
        if (n4 < 0) {
            n4 = 75;
        }
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.removePropertyChangeListener(this._columnProertyChangeListener);
        TableColumn tableColumn2 = tableColumnModel2.getColumn(n);
        tableColumn2.removePropertyChangeListener(this._columnProertyChangeListener);
        tableColumn2.setMinWidth(n2);
        tableColumn2.setPreferredWidth(n3);
        tableColumn2.setWidth(n4);
        tableColumn.setMinWidth(n2);
        tableColumn.setPreferredWidth(n3);
        tableColumn.setWidth(n4);
    }

    void hideSelectedHeaderValues(boolean bl) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        HeaderTable headerTable = (HeaderTable)(bl ? this.getRowHeaderTable() : this.getColumnHeaderTable());
        for (n = headerTable.getColumnCount() - 1; n >= 0; --n) {
            for (int i = headerTable.getRowCount() - 1; i >= 0; --i) {
                boolean bl2 = headerTable.isCellSelected(i, n);
                if (!bl2) continue;
                arrayList.add(i);
                arrayList2.add(n);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.hideValuesAt(bl, (Integer)arrayList.get(n), (Integer)arrayList2.get(n));
        }
    }

    public void hideValuesAt(boolean bl, int n, int n2) {
        int n3;
        boolean bl2;
        HeaderTableModel headerTableModel = (HeaderTableModel)(bl ? this.getRowHeaderTable().getModel() : this.getColumnHeaderTable().getModel());
        Values values = headerTableModel.getValuesAt(bl ? n : n2);
        boolean bl3 = bl ? this.getPivotDataModel().getRowFields().length - 1 == n2 : (bl2 = this.getPivotDataModel().getColumnFields().length - 1 == n);
        boolean bl4 = bl ? this.getPivotDataModel().getRowFields().length - 1 < n2 : this.getPivotDataModel().getColumnFields().length - 1 < n;
        int n4 = n3 = bl ? n2 : n;
        if (!(values instanceof SummaryValues || values instanceof GrandTotalValues || bl4)) {
            this.addHiddenValues(values);
        }
        if (bl2 || n3 >= values.getCount()) {
            return;
        }
        for (int i = 0; i <= n3; ++i) {
            if (values.getValueAt(i) != null) continue;
            return;
        }
        List list = headerTableModel.getFlatData();
        int n5 = list.size();
        int n6 = headerTableModel.getIndexInFlatData(bl ? n : n2);
        if (n6 < 0) {
            return;
        }
        boolean bl5 = true;
        for (int i = n6; i < n5 && bl5; ++i) {
            Values values2 = (Values)list.get(i);
            if (values2 instanceof SummaryValues || values2 instanceof GrandTotalValues || n3 >= values2.getCount()) continue;
            for (int j = 0; j <= n3; ++j) {
                if (values.getValueAt(j).equals(values2.getValueAt(j))) continue;
                bl5 = false;
            }
            if (!bl5) continue;
            this.addHiddenValues(values2);
        }
    }

    public void addHiddenValues(Values values) {
        final Object[] objectArray = this.saveSelection();
        this.getPivotDataModel().addHiddenValues(values);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PivotTablePane.this.bothHeadersUpdated();
                PivotTablePane.this.loadSelection(objectArray);
                PivotTablePane.this.hideRowHeaderTableColumns();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void clearHiddenRowFields() {
        if (this._hiddenHeaderField == null) {
            return;
        }
        for (PivotField pivotField : this._hiddenHeaderField.keySet()) {
            this.internalRemoveHiddenRowField(pivotField, this._hiddenHeaderField.get(pivotField));
        }
        this._hiddenHeaderField.clear();
        this._hiddenHeaderField = null;
    }

    public void removeHiddenRowField(PivotField pivotField) {
        if (this._hiddenHeaderField == null || this._hiddenHeaderField.get(pivotField) == null) {
            return;
        }
        Integer n = this._hiddenHeaderField.remove(pivotField);
        this.internalRemoveHiddenRowField(pivotField, n);
    }

    private void internalRemoveHiddenRowField(PivotField pivotField, Integer n) {
        this.unsynchronizeFieldAreaWithColumnWidth(this._rowHeaderTable, this._rowFieldsArea);
        pivotField.setPreferredWidth(n);
        PivotField[] pivotFieldArray = this.getPivotDataModel().getRowFields();
        for (int i = 0; i < this.getRowHeaderTable().getColumnCount() && i < pivotFieldArray.length; ++i) {
            Object object;
            if (pivotFieldArray[i] != pivotField || ((TableColumn)(object = this.getRowHeaderTable().getColumnModel().getColumn(i))).getWidth() != 0) continue;
            ((TableColumn)object).setWidth(pivotField.getPreferredWidth());
            ((TableColumn)object).setPreferredWidth(pivotField.getPreferredWidth());
        }
        Component[] componentArray = this.getRowFieldsArea().getFieldBoxes();
        for (Component component : componentArray) {
            if (!(component instanceof FieldBox) || ((FieldBox)component).getField() != pivotField) continue;
            component.setVisible(true);
        }
        this.synchronizeFieldAreaWithColumnWidth(this._rowHeaderTable, this._rowFieldsArea);
    }

    public void addHiddenRowField(PivotField pivotField) {
        if (this._hiddenHeaderField == null) {
            this._hiddenHeaderField = new HashMap<PivotField, Integer>();
        }
        int n = -1;
        PivotField[] pivotFieldArray = this.getPivotDataModel().getRowFields();
        for (int i = 0; i < pivotFieldArray.length; ++i) {
            if (pivotFieldArray[i] != pivotField) continue;
            n = i;
            break;
        }
        if (this._hiddenHeaderField.get(pivotField) == null && n >= 0) {
            this._hiddenHeaderField.put(pivotField, pivotField.getPreferredWidth());
            this.hideRowHeaderTableColumns();
        }
    }

    public PivotField[] getHiddenRowFields() {
        if (this._hiddenHeaderField == null) {
            return new PivotField[0];
        }
        return this._hiddenHeaderField.keySet().toArray(new PivotField[this._hiddenHeaderField.size()]);
    }

    boolean hasHiddenRowField() {
        return this._hiddenHeaderField != null && this._hiddenHeaderField.size() > 0;
    }

    int getVisibleHeaderTableColumnCount() {
        PivotField[] pivotFieldArray = this.getPivotDataModel().getRowFields();
        int n = pivotFieldArray.length;
        if (this.hasHiddenRowField()) {
            n -= this._hiddenHeaderField.size();
        }
        return n;
    }

    public void hideRowHeaderTableColumns() {
        if (this._hiddenHeaderField == null) {
            return;
        }
        this.unsynchronizeFieldAreaWithColumnWidth(this._rowHeaderTable, this._rowFieldsArea);
        PivotField[] pivotFieldArray = this.getPivotDataModel().getRowFields();
        HashSet<PivotField> hashSet = new HashSet<PivotField>();
        hashSet.addAll(this._hiddenHeaderField.keySet());
        for (int i = pivotFieldArray.length - 1; i >= 0; --i) {
            boolean bl = false;
            PivotField pivotField = pivotFieldArray[i];
            for (PivotField pivotField2 : hashSet) {
                if (pivotField2 != pivotField) continue;
                bl = true;
                break;
            }
            hashSet.remove(pivotField);
            if (!bl || i >= this.getRowHeaderTable().getColumnCount()) continue;
            TableColumn tableColumn = this.getRowHeaderTable().getColumnModel().getColumn(i);
            tableColumn.setMinWidth(0);
            tableColumn.setWidth(0);
            tableColumn.setPreferredWidth(0);
            Component[] componentArray = this.getRowFieldsArea().getFieldBoxes();
            if (i >= componentArray.length || i < 0) continue;
            componentArray[i].setVisible(false);
        }
        for (PivotField pivotField : hashSet) {
            this._hiddenHeaderField.remove(pivotField);
        }
        this.synchronizeFieldAreaWithColumnWidth(this._rowHeaderTable, this._rowFieldsArea, false);
    }

    public void removeHiddenValues(Values values) {
        final Object[] objectArray = this.saveSelection();
        this.getPivotDataModel().removeHiddenValues(values);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PivotTablePane.this.bothHeadersUpdated();
                PivotTablePane.this.loadSelection(objectArray);
                PivotTablePane.this.hideRowHeaderTableColumns();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void clearHiddenValues() {
        final Object[] objectArray = this.saveSelection();
        this.getPivotDataModel().clearHiddenValues();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PivotTablePane.this.bothHeadersUpdated();
                PivotTablePane.this.loadSelection(objectArray);
                PivotTablePane.this.hideRowHeaderTableColumns();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    private ResourceBundle getResourceBundle() {
        return PivotResources.getResourceBundle(this.getLocale());
    }

    @Override
    public String getResourceString(String string) {
        try {
            return this.getResourceBundle().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public String convertElementToString(Locale locale, Object object, Class<?> clazz, ConverterContext converterContext) {
        if ("(All)".equals(object)) {
            return GridResource.getResourceBundle(locale).getString("Filter.all");
        }
        if ("(Custom...)".equals(object)) {
            return GridResource.getResourceBundle(locale).getString("Filter.custom");
        }
        if (object == null || "(Empty)".equals(object)) {
            return GridResource.getResourceBundle(locale).getString("Filter.null");
        }
        if ("".equals(object)) {
            return " ";
        }
        if (object instanceof DynamicTableFilter) {
            return ((DynamicTableFilter)object).getName();
        }
        String string = ObjectConverterManager.toString(object, clazz == null ? object.getClass() : clazz, converterContext);
        if (string == null || string.length() == 0) {
            string = " ";
        }
        return string;
    }

    public boolean isShrinkDataFieldArea() {
        return this._shrinkDataFieldArea;
    }

    public void setShrinkDataFieldArea(boolean bl) {
        this._shrinkDataFieldArea = bl;
        if (this._rowHeaderTable != null && this._dataFieldsArea != null && this._rowFieldsArea != null) {
            this.updateDataFieldAreaWidth(this._rowHeaderTable, this._dataFieldsArea, this._rowFieldsArea);
        }
    }

    public boolean isHideFieldOnDraggingOut() {
        return this._hideFieldOnDraggingOut;
    }

    public void setHideFieldOnDraggingOut(boolean bl) {
        this._hideFieldOnDraggingOut = bl;
    }

    boolean isKeepFieldAreaFit() {
        return this._keepFieldAreaFit;
    }

    public boolean isShowFilterIcon() {
        return this._showFilterIcon;
    }

    public void setShowFilterIcon(boolean bl) {
        if (this._showFilterIcon != bl) {
            this._showFilterIcon = bl;
            this.updateFilterIcons();
        }
    }

    public void setFilterIcon(Icon icon) {
        this._filterIcon = icon;
        this.updateFilterIcons();
    }

    private void updateFilterIcons() {
        if (this._fieldBoxMap != null) {
            Collection<FieldBox> collection = this._fieldBoxMap.values();
            for (FieldBox fieldBox : collection) {
                fieldBox.updateFilterIcon();
            }
        }
    }

    public Icon getFilterIcon() {
        if (this._filterIcon == null) {
            this._filterIcon = GridIconsFactory.getImageIcon("icons/filter.png");
        }
        return this._filterIcon;
    }

    protected void setKeepFieldAreaFit(boolean bl) {
        this._keepFieldAreaFit = bl;
    }

    public FieldArea getFilterFieldsArea() {
        return this._filterFieldsArea;
    }

    public FieldArea getDataFieldsArea() {
        return this._dataFieldsArea;
    }

    public FieldArea getRowFieldsArea() {
        return this._rowFieldsArea;
    }

    public FieldArea getColumnFieldsArea() {
        return this._columnFieldsArea;
    }

    public boolean isColumnAutoResizable() {
        return this._columnAutoResizer != null && this._columnAutoResizer.length == 2 && this._columnAutoResizer[0] != null && this._columnAutoResizer[1] != null;
    }

    public void setColumnAutoResizable(boolean bl) {
        if (bl) {
            if (this._columnAutoResizer == null) {
                this._columnAutoResizer = new TableColumnAutoResizer[2];
                this._columnAutoResizer[0] = new TableColumnAutoResizer(this.getRowHeaderTable(), false){

                    @Override
                    protected void resizeColumn(TableColumn tableColumn) {
                        JTable jTable = PivotTablePane.this.getRowHeaderTable();
                        if (TableUtils.isTableColumnResizable(jTable, tableColumn)) {
                            int n = jTable.convertColumnIndexToView(tableColumn.getModelIndex());
                            int n2 = 0;
                            if (PivotTablePane.this.isConsiderRowFieldWidth()) {
                                int[] nArray = PivotTablePane.this.getRowFieldsWidth();
                                if (n >= 0 && n < nArray.length) {
                                    n2 = nArray[n];
                                }
                            }
                            TableUtils.autoResizeColumn(jTable, n, false, true, n2);
                        }
                    }
                };
                this._columnAutoResizer[1] = new TableColumnAutoResizer(this.getColumnHeaderTable(), false){

                    @Override
                    protected void resizeColumn(TableColumn tableColumn) {
                        int n;
                        int n2;
                        JTable jTable = PivotTablePane.this.getColumnHeaderTable();
                        if (TableUtils.isTableColumnResizable(jTable, tableColumn) && (n2 = TableUtils.autoResizeColumn(jTable, jTable.convertColumnIndexToView(tableColumn.getModelIndex()), false)) > (n = TableUtils.autoResizeColumn(PivotTablePane.this.getDataTable(), PivotTablePane.this.getDataTable().convertColumnIndexToView(tableColumn.getModelIndex()), false))) {
                            tableColumn.setPreferredWidth(n2);
                        }
                    }
                };
            }
        } else if (this._columnAutoResizer != null) {
            if (this._columnAutoResizer.length >= 2) {
                this._columnAutoResizer[0].uninstall();
                this._columnAutoResizer[1].uninstall();
            }
            this._columnAutoResizer = null;
        }
    }

    public boolean isConsiderRowFieldWidth() {
        return this._considerRowFieldWidth;
    }

    public void setConsiderRowFieldWidth(boolean bl) {
        this._considerRowFieldWidth = bl;
    }

    private boolean isRestoreColumnWidthNeeded() {
        return this._restoreColumnWidthNeeded;
    }

    private void setRestoreColumnWidthNeeded(boolean bl) {
        this._restoreColumnWidthNeeded = bl;
    }

    public Cursor getDragRemoveCursor() {
        return this._dragRemoveCursor;
    }

    public void setDragRemoveCursor(Cursor cursor) {
        this._dragRemoveCursor = cursor;
    }

    public Cursor getDragNoDropCursor() {
        return this._dragNoDropCursor;
    }

    public void setDragNoDropCursor(Cursor cursor) {
        this._dragNoDropCursor = cursor;
    }

    public boolean isRespectFieldPreferredWidth() {
        return this._respectFieldPreferredWidth;
    }

    public void setRespectFieldPreferredWidth(boolean bl) {
        this._respectFieldPreferredWidth = bl;
        this.adjustColumnWidth((HeaderTable)this._columnHeaderTable);
    }

    public int getHeaderSelectionMode() {
        return this.isFlatLayout() ? 0 : this._headerSelectionMode;
    }

    public void setHeaderSelectionMode(int n) {
        int n2 = this._headerSelectionMode;
        if (n != this._headerSelectionMode) {
            this._headerSelectionMode = n;
            if (this._headerSelectionMode != 1) {
                TableUtils.synchronizeNavigationKeys(new JTable[]{this._rowHeaderTable, this._dataTable});
            } else {
                TableUtils.unsynchronizeNavigationKeys(new JTable[]{this._rowHeaderTable, this._dataTable});
            }
            this.firePropertyChange(PROPERTY_HEADER_SELECTION_MODEL, n2, n);
            this.repaint();
        }
    }

    public boolean isHideExpandIconOnSingleRow() {
        return this._hideExpandIconOnSingleRow;
    }

    public void setHideExpandIconOnSingleRow(boolean bl) {
        boolean bl2 = this._hideExpandIconOnSingleRow;
        if (bl2 != bl) {
            this._hideExpandIconOnSingleRow = bl;
            if (this._pivotDataModel instanceof PivotDataModel) {
                ((PivotDataModel)this._pivotDataModel).setHideExpandIconOnSingleRow(bl);
            }
            this.firePropertyChange(PROPERTY_HIDE_EXPAND_ICON_ON_SINGLE_ROW, bl2, this._hideExpandIconOnSingleRow);
            this.getRowHeaderTable().repaint();
            this.getColumnHeaderTable().repaint();
        }
    }

    public void stopCellEditing() {
        if (this.getRowHeaderTable() != null && this.getRowHeaderTable().isEditing()) {
            this.getRowHeaderTable().getCellEditor().stopCellEditing();
        }
        if (this.getColumnHeaderTable() != null && this.getColumnHeaderTable().isEditing()) {
            this.getColumnHeaderTable().getCellEditor().stopCellEditing();
        }
        if (this.getDataTable() != null && this.getDataTable().isEditing()) {
            this.getDataTable().getCellEditor().stopCellEditing();
        }
        if (this.getCornerTable() != null && this.getCornerTable().isEditing()) {
            this.getCornerTable().getCellEditor().stopCellEditing();
        }
    }

    public boolean isScrollSelectionToVisible() {
        return this._scrollSelectionToVisible;
    }

    public void setScrollSelectionToVisible(boolean bl) {
        if (this._scrollSelectionToVisible != bl) {
            boolean bl2 = this._scrollSelectionToVisible;
            this._scrollSelectionToVisible = bl;
            this.firePropertyChange(PROPERTY_SCROLL_SELECTION_TO_VISIBLE, bl2, this._scrollSelectionToVisible);
        }
    }

    public boolean isFlatLayout() {
        return this._flatLayout;
    }

    public void setFlatLayout(boolean bl) {
        if (this._flatLayout != bl) {
            boolean bl2 = this._flatLayout;
            this._flatLayout = bl;
            if (this._contentPanel != null && this._fieldsPanel != null) {
                this.setupLayout(this._contentPanel, this._fieldsPanel);
            }
            this.firePropertyChange(PROPERTY_FLAT_LAYOUT, bl2, this._flatLayout);
        }
    }

    public boolean isAllowSortByRow() {
        return this._allowSortByRow;
    }

    public void setAllowSortByRow(boolean bl) {
        this._allowSortByRow = bl;
    }

    public Object[] saveSelection() {
        Object[] objectArray = this.saveDataTableSelection();
        if (this.getHeaderSelectionMode() == 0 && objectArray.length <= 1) {
            return this.saveHeaderTableSelection(objectArray);
        }
        return objectArray;
    }

    private void saveFieldsInformation() {
        this._previousRowFields = this.getPivotDataModel().getRowFields();
        this._previousColumnFields = this.getPivotDataModel().getColumnFields();
    }

    private void clearFieldsInformation() {
        this._previousRowFields = null;
        this._previousColumnFields = null;
    }

    private boolean rowColumnFieldsChanged() {
        return !JideSwingUtilities.equals(this._previousRowFields, this.getPivotDataModel().getRowFields(), true) || !JideSwingUtilities.equals(this._previousColumnFields, this.getPivotDataModel().getColumnFields(), true);
    }

    private Object[] saveDataTableSelection() {
        HeaderTableModel headerTableModel = this.getPivotDataModel().getRowHeaderTableModel();
        HeaderTableModel headerTableModel2 = this.getPivotDataModel().getColumnHeaderTableModel();
        JideTable jideTable = (JideTable)this.getDataTable();
        int[] nArray = TableUtils.saveSelection(jideTable);
        Object[] objectArray = new Object[nArray.length * 2 + 1];
        objectArray[0] = "data";
        if (jideTable.isNonContiguousCellSelection()) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                objectArray[i * 2 + 2] = null;
                if (i % 2 == 0) {
                    objectArray[i * 2 + 1] = headerTableModel.getValuesAt(nArray[i]);
                    objectArray[i * 2 + 2] = headerTableModel.getFieldAt(nArray[i], headerTableModel.getDataIndex());
                    continue;
                }
                objectArray[i * 2 + 1] = headerTableModel2.getValuesAt(nArray[i]);
                objectArray[i * 2 + 2] = headerTableModel2.getFieldAt(headerTableModel2.getDataIndex(), nArray[i]);
            }
        } else if (jideTable.getColumnSelectionAllowed() && !jideTable.getRowSelectionAllowed()) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                objectArray[i * 2 + 2] = null;
                if (i == 0 || i == 2) {
                    objectArray[i * 2 + 1] = headerTableModel.getValuesAt(nArray[i]);
                    objectArray[i * 2 + 2] = headerTableModel.getFieldAt(nArray[i], headerTableModel.getDataIndex());
                    continue;
                }
                objectArray[i * 2 + 1] = headerTableModel2.getValuesAt(nArray[i]);
                objectArray[i * 2 + 2] = headerTableModel2.getFieldAt(headerTableModel2.getDataIndex(), nArray[i]);
            }
        } else if (!jideTable.getColumnSelectionAllowed() && jideTable.getRowSelectionAllowed()) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                objectArray[i * 2 + 2] = null;
                if (i != 1 && i != 3) {
                    objectArray[i * 2 + 1] = headerTableModel.getValuesAt(nArray[i]);
                    objectArray[i * 2 + 2] = headerTableModel.getFieldAt(nArray[i], headerTableModel.getDataIndex());
                    continue;
                }
                objectArray[i * 2 + 1] = headerTableModel2.getValuesAt(nArray[i]);
                objectArray[i * 2 + 2] = headerTableModel2.getFieldAt(headerTableModel2.getDataIndex(), nArray[i]);
            }
        } else {
            for (int i = nArray.length - 1; i >= 0; --i) {
                objectArray[i * 2 + 2] = null;
                if (i % 2 == 0) {
                    objectArray[i * 2 + 1] = headerTableModel.getValuesAt(nArray[i]);
                    objectArray[i * 2 + 2] = headerTableModel.getFieldAt(nArray[i], headerTableModel.getDataIndex());
                    continue;
                }
                objectArray[i * 2 + 1] = headerTableModel2.getValuesAt(nArray[i]);
                objectArray[i * 2 + 2] = headerTableModel2.getFieldAt(headerTableModel2.getDataIndex(), nArray[i]);
            }
        }
        return objectArray;
    }

    private Object[] saveHeaderTableSelection(Object[] objectArray) {
        JTable jTable = null;
        boolean bl = false;
        if (((JideTable)this.getColumnHeaderTable()).isNonContiguousCellSelection() && !((JideTable)this.getColumnHeaderTable()).getTableSelectionModel().isSelectionEmpty()) {
            jTable = this.getColumnHeaderTable();
        } else if (((JideTable)this.getRowHeaderTable()).isNonContiguousCellSelection() && !((JideTable)this.getRowHeaderTable()).getTableSelectionModel().isSelectionEmpty()) {
            jTable = this.getRowHeaderTable();
            bl = true;
        }
        if (jTable == null) {
            return objectArray;
        }
        int[] nArray = TableUtils.saveSelection(jTable);
        objectArray = new Object[nArray.length + 1];
        objectArray[0] = "header";
        HeaderTableModel headerTableModel = (HeaderTableModel)jTable.getModel();
        for (int i = nArray.length - 1; i >= 0; --i) {
            objectArray[i + 1] = i % 2 == 0 ? headerTableModel.getValuesAt(nArray[i + (bl ? 0 : 1)]) : (nArray[i - 1] >= 0 && nArray[i] >= 0 ? headerTableModel.getValueAt(nArray[i - 1], nArray[i]) : null);
        }
        return objectArray;
    }

    public void loadSelection(Object[] objectArray) {
        this.loadSelection(objectArray, true);
    }

    public void loadSelection(Object[] objectArray, boolean bl) {
        this.loadSelection(objectArray, bl, false);
    }

    public void loadSelection(Object[] objectArray, boolean bl, boolean bl2) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        if ("data".equals(objectArray[0])) {
            this.loadDataTableSelection(objectArray, bl, bl2);
        } else if (this.getHeaderSelectionMode() == 0) {
            this.loadHeaderTableSelection(objectArray, bl);
        }
    }

    private void loadDataTableSelection(Object[] objectArray, boolean bl, boolean bl2) {
        HeaderTableModel headerTableModel = this.getPivotDataModel().getRowHeaderTableModel();
        HeaderTableModel headerTableModel2 = this.getPivotDataModel().getColumnHeaderTableModel();
        JideTable jideTable = (JideTable)this.getDataTable();
        int[] nArray = new int[objectArray.length / 2];
        if (jideTable.isNonContiguousCellSelection()) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                nArray[i] = i % 2 == 0 ? this.calculateRowIndex(objectArray[i * 2 + 1], objectArray[i * 2 + 2], headerTableModel) : this.calculateColumnIndex(objectArray[i * 2 + 1], objectArray[i * 2 + 2], headerTableModel2);
            }
        } else if (jideTable.getColumnSelectionAllowed() && !jideTable.getRowSelectionAllowed()) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                nArray[i] = i == 0 || i == 2 ? this.calculateRowIndex(objectArray[i * 2 + 1], objectArray[i * 2 + 2], headerTableModel) : (bl2 ? this.getPossibleIndex(objectArray[i * 2 + 1], objectArray[i * 2 + 2], headerTableModel2) : this.calculateColumnIndex(objectArray[i * 2 + 1], objectArray[i * 2 + 2], headerTableModel2));
            }
        } else if (!jideTable.getColumnSelectionAllowed() && jideTable.getRowSelectionAllowed()) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (i != 1 && i != 3) {
                    if (bl2) {
                        nArray[i] = this.getPossibleIndex(objectArray[i * 2 + 1], null, headerTableModel);
                        continue;
                    }
                    nArray[i] = this.calculateRowIndex(objectArray[i * 2 + 1], objectArray[i * 2 + 2], headerTableModel);
                    continue;
                }
                nArray[i] = this.calculateColumnIndex(objectArray[i * 2 + 1], objectArray[i * 2 + 2], headerTableModel2);
            }
        } else {
            for (int i = nArray.length - 1; i >= 0; --i) {
                nArray[i] = i % 2 == 0 ? this.calculateRowIndex(objectArray[i * 2 + 1], objectArray[i * 2 + 2], headerTableModel) : this.calculateColumnIndex(objectArray[i * 2 + 1], objectArray[i * 2 + 2], headerTableModel2);
            }
        }
        TableUtils.loadSelection(jideTable, nArray, bl);
    }

    private void loadHeaderTableSelection(Object[] objectArray, boolean bl) {
        JTable jTable = null;
        boolean bl2 = false;
        if (objectArray.length <= 1) {
            return;
        }
        if (((JideTable)this.getRowHeaderTable()).isNonContiguousCellSelection() && this.calculateMajorIndex((DefaultValues)objectArray[1], (HeaderTableModel)this.getRowHeaderTable().getModel()) != null) {
            jTable = (HeaderTable)this.getRowHeaderTable();
            bl2 = true;
        } else if (((JideTable)this.getColumnHeaderTable()).isNonContiguousCellSelection() && this.calculateMajorIndex((DefaultValues)objectArray[1], (HeaderTableModel)this.getColumnHeaderTable().getModel()) != null) {
            jTable = (HeaderTable)this.getColumnHeaderTable();
        }
        if (jTable == null) {
            return;
        }
        HeaderTableModel headerTableModel = (HeaderTableModel)jTable.getModel();
        int[] nArray = new int[objectArray.length - 1];
        PivotField[] pivotFieldArray = bl2 ? this.getPivotDataModel().getRowFields() : this.getPivotDataModel().getColumnFields();
        PivotField[] pivotFieldArray2 = this.getPivotDataModel().getDataFields();
        List list = headerTableModel.getFlatData();
        block0: for (int i = objectArray.length - 1; i >= 1; --i) {
            DefaultValues defaultValues;
            if (bl2) {
                if (i % 2 == 1) {
                    defaultValues = this.calculateMajorIndex((DefaultValues)objectArray[i], headerTableModel);
                    if (defaultValues != null) {
                        nArray[i - 1] = list.indexOf(defaultValues);
                    }
                    if (pivotFieldArray.length != 0 || !(objectArray[i] instanceof GrandTotalValues) || objectArray[i + 1] == null) continue;
                    for (int j = 0; j < pivotFieldArray2.length; ++j) {
                        if (!objectArray[i + 1].equals(pivotFieldArray2[j].getTitle())) continue;
                        int n = i - 1;
                        nArray[n] = nArray[n] + j;
                        continue block0;
                    }
                    continue;
                }
                if (objectArray[i] != null) {
                    int n;
                    for (n = 0; n < ((Values)objectArray[i - 1]).getCount() && !objectArray[i].equals(((Values)objectArray[i - 1]).getValueAt(n).getValue()); ++n) {
                    }
                    nArray[i - 1] = n;
                    continue;
                }
                nArray[i - 1] = 0;
                continue;
            }
            if (i % 2 == 1) {
                if (objectArray[i + 1] != null) {
                    int n;
                    for (n = 0; n < ((Values)objectArray[i]).getCount() && !objectArray[i + 1].equals(((Values)objectArray[i]).getValueAt(n).getValue()); ++n) {
                    }
                    nArray[i - 1] = n;
                    DefaultValues defaultValues2 = this.calculateMajorIndex((DefaultValues)objectArray[i], headerTableModel);
                    if (defaultValues2 != null) {
                        nArray[i - 1] = defaultValues2.getCount() - 1;
                    }
                    if (n < ((Values)objectArray[i]).getCount()) continue;
                    for (int j = 0; j < pivotFieldArray2.length; ++j) {
                        if (!objectArray[i + 1].equals(pivotFieldArray2[j].getTitle())) continue;
                        if (pivotFieldArray.length == 0 && objectArray[i] instanceof GrandTotalValues && objectArray[i + 1] != null) {
                            nArray[i - 1] = 1;
                        }
                        int n2 = i;
                        nArray[n2] = nArray[n2] + j;
                        continue block0;
                    }
                    continue;
                }
                nArray[i - 1] = 0;
                continue;
            }
            defaultValues = this.calculateMajorIndex((DefaultValues)objectArray[i - 1], headerTableModel);
            nArray[i - 1] = defaultValues == null ? -1 : (pivotFieldArray2.length > 0 ? list.indexOf(defaultValues) * pivotFieldArray2.length : list.indexOf(defaultValues));
        }
        TableUtils.loadSelection(jTable, nArray, bl);
    }

    private DefaultValues calculateMajorIndex(DefaultValues defaultValues, HeaderTableModel headerTableModel) {
        List list = headerTableModel.getFlatData();
        int n = list.indexOf(defaultValues);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        for (int i = 0; i < defaultValues.getCount(); ++i) {
            arrayList.add(defaultValues.getValueAt(i));
        }
        while (n == -1 && (defaultValues instanceof SummaryValues || arrayList.size() > 1)) {
            if (!(defaultValues instanceof SummaryValues)) {
                arrayList.remove(arrayList.size() - 1);
            }
            defaultValues = new DefaultValues(arrayList);
            n = list.indexOf(defaultValues);
        }
        if (n == -1) {
            defaultValues = null;
        }
        return defaultValues;
    }

    private int calculateRowIndex(Object object, Object object2, HeaderTableModel headerTableModel) {
        int n = headerTableModel.getFlatData().indexOf(object);
        PivotField[] pivotFieldArray = this.getPivotDataModel().getDataFields();
        if (this.getPivotDataModel().getRowFields().length == 0 && pivotFieldArray.length > 1) {
            int n2;
            for (n2 = pivotFieldArray.length - 1; n2 >= 0 && !pivotFieldArray[n2].equals(object2); --n2) {
            }
            n += n2;
        }
        return n;
    }

    private int calculateColumnIndex(Object object, Object object2, HeaderTableModel headerTableModel) {
        int n = headerTableModel.getFlatData().indexOf(object);
        PivotField[] pivotFieldArray = this.getPivotDataModel().getDataFields();
        if (n >= 0 && pivotFieldArray.length > 0 && this.getPivotDataModel().getRowFields().length > 0) {
            int n2;
            for (n2 = pivotFieldArray.length - 1; n2 >= 0 && !pivotFieldArray[n2].equals(object2); --n2) {
            }
            n = n2 < 0 ? -1 : n * pivotFieldArray.length + n2;
        }
        return n;
    }

    private int getPossibleIndex(Object object, Object object2, HeaderTableModel headerTableModel) {
        int n = object2 == null ? headerTableModel.getFlatData().indexOf(object) : this.calculateColumnIndex(object, object2, headerTableModel);
        if (n == -1) {
            int n2;
            ArrayList<Value> arrayList = new ArrayList<Value>();
            for (n2 = ((Values)object).getCount() - 1; n2 >= 0; --n2) {
                arrayList.add(0, ((Values)object).getValueAt(n2));
            }
            if (object instanceof SummaryValues) {
                for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                    CopiedExpandableValue copiedExpandableValue = new CopiedExpandableValue(new DefaultExpandableValue(((Value)arrayList.get(n2)).getValue()));
                    arrayList.remove(n2);
                    arrayList.add(n2, copiedExpandableValue);
                }
                arrayList.add(new DummyValue());
            }
            if (object instanceof DefaultValues) {
                arrayList.remove(arrayList.size() - 1);
                while (arrayList.size() > 0) {
                    DefaultValues defaultValues = new DefaultValues(arrayList);
                    n = headerTableModel.getFlatData().indexOf(defaultValues);
                    if (n >= 0) break;
                    arrayList.remove(arrayList.size() - 1);
                }
            }
        }
        return n;
    }

    String getRunningTypeName(int n) {
        switch (n) {
            case 0: {
                return this.getResourceString("RunningType.Difference");
            }
            case 1: {
                return this.getResourceString("RunningType.PercentageOfItem");
            }
            case 2: {
                return this.getResourceString("RunningType.PercentageFromItem");
            }
            case 3: {
                return this.getResourceString("RunningType.Total");
            }
            case 4: {
                return this.getResourceString("RunningType.PercentageOfTotal");
            }
        }
        return "";
    }

    public boolean isShowFilterButtonsOnMouseOver() {
        return this._showFilterButtonsOnMouseOver;
    }

    public void setShowFilterButtonsOnMouseOver(boolean bl) {
        boolean bl2 = this._showFilterButtonsOnMouseOver;
        if (bl2 != bl) {
            FieldBox fieldBox;
            this._showFilterButtonsOnMouseOver = bl;
            for (Component component : this._columnFieldsArea.getComponents()) {
                if (!(component instanceof FieldBox)) continue;
                fieldBox = (FieldBox)component;
                this.setFieldBoxPreferredSize(fieldBox);
            }
            for (Component component : this._filterFieldsArea.getComponents()) {
                if (!(component instanceof FieldBox)) continue;
                fieldBox = (FieldBox)component;
                this.setFieldBoxPreferredSize(fieldBox);
            }
            JideSwingUtilities.setRecursively(this, new JideSwingUtilities.Handler(){

                @Override
                public boolean condition(Component component) {
                    return component instanceof FieldBox;
                }

                @Override
                public void action(Component component) {
                    FieldBox fieldBox = (FieldBox)component;
                    if (fieldBox.getField().getAreaType() == 3) {
                        ((FieldBox)component).showFilterButtonVisible(!PivotTablePane.this._showFilterButtonsOnMouseOver && PivotTablePane.this.isDataFieldFilterable());
                    } else {
                        fieldBox.showFilterButtonVisible(!PivotTablePane.this._showFilterButtonsOnMouseOver);
                    }
                }

                @Override
                public void postAction(Component component) {
                }
            });
            this.firePropertyChange(PROPERTY_SHOW_FILTER_BUTTONS_ON_MOUSE_OVER, bl2, this._showFilterButtonsOnMouseOver);
        }
    }

    public boolean isDataFieldsDuplicationEnabled() {
        return this._dataFieldsDuplicationEnabled;
    }

    public void setDataFieldsDuplicationEnabled(boolean bl) {
        if (this._dataFieldsDuplicationEnabled != bl) {
            boolean bl2 = this._dataFieldsDuplicationEnabled;
            this._dataFieldsDuplicationEnabled = bl;
            if (this.getPivotDataModel() instanceof PivotDataModel) {
                PivotField pivotField;
                for (int i = this.getPivotDataModel().getFields().length - 1; i >= 0 && (pivotField = this.getPivotDataModel().getField(i)).isDuplicated(); --i) {
                    PivotField pivotField2 = this.getPivotDataModel().getField(pivotField.getModelIndex());
                    pivotField2.setAreaType(3);
                    ((PivotDataModel)this.getPivotDataModel()).removeDuplicatedField(pivotField);
                }
                this.getPivotDataModel().updateFields();
                this.setPivotDataModel(this.getPivotDataModel());
            }
            this.firePropertyChange(PROPERTY_DATA_FIELDS_DUPLICATION_ENABLED, bl2, this._dataFieldsDuplicationEnabled);
        }
    }

    static /* synthetic */ Object[] access$402(PivotTablePane pivotTablePane, Object[] objectArray) {
        pivotTablePane._savedSelections = objectArray;
        return objectArray;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(32)) {
            Lm.showInvalidProductMessage(PivotTablePane.class.getName(), 32);
        }
        CONVERTER_CONTEXT_RUNNING_TYPE = new ConverterContext("RunningType");
        EDITOR_CONTEXT_RUNNING_TYPE = new EditorContext("RunningType");
        CONVERTER_CONTEXT_PIVOT_FIELD = new ConverterContext("PivotField");
        EDITOR_CONTEXT_PIVOT_FIELD = new EditorContext("PivotField");
        EDITOR_CONTEXT_COMPARE_TO = new EditorContext("CompareTo");
    }

    protected static class JideScrollPaneEx
    extends JideScrollPane {
        protected JideScrollPaneEx() {
        }

        @Override
        protected JViewport createViewport() {
            return new JViewport(){

                @Override
                public Dimension getViewSize() {
                    Dimension dimension = super.getViewSize();
                    if (this.getView() == this.getViewport().getView()) {
                        if (rowHeader != null) {
                            Dimension dimension2 = rowHeader.getViewSize();
                            if (dimension.height < dimension2.height) {
                                dimension.height = dimension2.height;
                            }
                        } else if (columnHeader != null) {
                            Dimension dimension3 = columnHeader.getViewSize();
                            if (dimension.width < dimension3.width) {
                                dimension.width = dimension3.width;
                            }
                        }
                    }
                    return dimension;
                }
            };
        }

        @Override
        public void setUI(ScrollPaneUI scrollPaneUI) {
            super.setUI(new FixScrollPaneUI());
        }
    }

    private class FlatJideScrollPane
    extends JideScrollPane
    implements Scrollable {
        private FlatJideScrollPane() {
        }

        @Override
        protected JViewport createViewport() {
            return new JViewport(){

                @Override
                public void scrollRectToVisible(Rectangle rectangle) {
                    Rectangle rectangle2 = SwingUtilities.convertRectangle(this, rectangle, this.getParent());
                    ((JComponent)this.getParent()).scrollRectToVisible(rectangle2);
                }
            };
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = PivotTablePane.this._dataTable.getPreferredScrollableViewportSize();
            dimension.width = (int)((double)dimension.width + PivotTablePane.this._rowHeaderTable.getPreferredSize().getWidth());
            dimension.height = (int)((double)dimension.height + PivotTablePane.this._columnHeaderTable.getPreferredSize().getHeight());
            return dimension;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return PivotTablePane.this._dataTable.getScrollableUnitIncrement(rectangle, n, n2);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return PivotTablePane.this._dataTable.getScrollableBlockIncrement(rectangle, n, n2);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return PivotTablePane.this._dataTable.getScrollableTracksViewportWidth();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return PivotTablePane.this._dataTable.getScrollableTracksViewportHeight();
        }

        @Override
        public void doLayout() {
            super.doLayout();
            if (PivotTablePane.this._scrollPane != null && PivotTablePane.this._scrollPane != this && PivotTablePane.this._scrollPane.getViewport() != null) {
                PivotTablePane.this._scrollPane.getViewport().doLayout();
                PivotTablePane.this._scrollPane.doLayout();
            }
        }
    }

    private class UnassignedFieldsAreaSearchable
    extends Searchable {
        public UnassignedFieldsAreaSearchable(JComponent jComponent) {
            super(jComponent);
        }

        @Override
        protected int getSelectedIndex() {
            for (int i = 0; i < this.getElementCount(); ++i) {
                Component component = ((Container)this.getComponent()).getComponent(i);
                if (!(component instanceof FieldBox) || !((FieldBox)component).isSelected()) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected void setSelectedIndex(int n, boolean bl) {
            Component component = ((Container)this.getComponent()).getComponent(n);
            if (component instanceof FieldBox) {
                FieldBox fieldBox = (FieldBox)component;
                PivotTablePane.this.selectFieldBox(fieldBox);
                fieldBox.scrollRectToVisible(fieldBox.getBounds());
            }
        }

        @Override
        protected int getElementCount() {
            return ((Container)this.getComponent()).getComponentCount();
        }

        @Override
        protected Object getElementAt(int n) {
            Component component = ((Container)this.getComponent()).getComponent(n);
            if (component instanceof FieldBox) {
                return ((FieldBox)component).getField().getTitle();
            }
            return "";
        }

        @Override
        protected String convertElementToString(Object object) {
            return object.toString();
        }
    }

    public static interface TablePopupMenuCustomizer
    extends PopupMenuCustomizer {
        public void customize(JPopupMenu var1, Component var2, int var3, int var4);
    }

    public static interface PopupMenuCustomizer {
        public void customize(JPopupMenu var1, Component var2);
    }
}

