/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pane;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideBoxLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.Scrollable;

public class CollapsiblePanes
extends JPanel
implements Scrollable {
    private LayoutManager _layout;
    private ThemePainter _painter;
    public static final String PROPERTY_AXIS = "axis";
    public static final String PROPERTY_GAP = "gap";

    public CollapsiblePanes() {
        this.updateUI();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this._painter != null) {
            this._painter.paintCollapsiblePanesBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0, 0);
        }
    }

    public void addExpansion() {
        this.add(Box.createVerticalGlue(), "vary");
    }

    public int getAxis() {
        return this._layout instanceof JideBoxLayout ? ((JideBoxLayout)this._layout).getAxis() : 0;
    }

    public void setAxis(int n) {
        if (!(this._layout instanceof JideBoxLayout)) {
            return;
        }
        int n2 = ((JideBoxLayout)this._layout).getAxis();
        if (n2 != n) {
            ((JideBoxLayout)this._layout).setAxis(n);
            this.firePropertyChange(PROPERTY_AXIS, n2, n);
            this.doLayout();
        }
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get("CollapsiblePanes.border") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        LookAndFeel.installBorder(this, "CollapsiblePanes.border");
        if (this._layout == null) {
            this._layout = this.createLayoutManager();
            this.setLayout(this._layout);
        } else {
            if (this._layout instanceof JideBoxLayout) {
                ((JideBoxLayout)this._layout).setGap(UIDefaultsLookup.getInt("CollapsiblePanes.gap"));
            }
            this.doLayout();
        }
    }

    protected JideBoxLayout createLayoutManager() {
        return new JideBoxLayout(this, 1, UIDefaultsLookup.getInt("CollapsiblePanes.gap"));
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return rectangle.height;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            int n = jViewport.getHeight();
            Dimension dimension = this.getPreferredSize();
            Dimension dimension2 = this.getMaximumSize();
            if (n >= dimension.height && n <= dimension2.height) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            int n = jViewport.getWidth();
            Dimension dimension = this.getMinimumSize();
            Dimension dimension2 = this.getMaximumSize();
            if (n >= dimension.width && n <= dimension2.width) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public void setGap(int n) {
        if (!(this._layout instanceof JideBoxLayout)) {
            return;
        }
        int n2 = ((JideBoxLayout)this._layout).getGap();
        if (n2 != n) {
            ((JideBoxLayout)this._layout).setGap(n);
            this.firePropertyChange(PROPERTY_GAP, n2, n);
            this.doLayout();
        }
    }

    public int getGap() {
        return this._layout instanceof JideBoxLayout ? ((JideBoxLayout)this._layout).getGap() : 0;
    }
}

