/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.paging;

import com.jidesoft.paging.PageNavigationEvent;
import com.jidesoft.paging.PageNavigationListener;
import com.jidesoft.paging.PageNavigationSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public abstract class AbstractPageNavigationSupport
implements PageNavigationSupport {
    private int _pageSize = 10;
    private int _currentPage = -1;
    private int _pageCount;
    private EventListenerList _listenerList;
    private static final Logger LOGGER_EVENT = Logger.getLogger(PageNavigationEvent.class.getName());
    private transient int _startRowIndex = -1;
    private transient boolean _saveRowIndex = true;

    public AbstractPageNavigationSupport(EventListenerList eventListenerList) {
        this._listenerList = eventListenerList;
    }

    public AbstractPageNavigationSupport(int n, EventListenerList eventListenerList) {
        this._pageSize = n;
        this._listenerList = eventListenerList;
    }

    @Override
    public int getPageSize() {
        return this._pageSize == 0 ? 10 : this._pageSize;
    }

    @Override
    public void setPageSize(int n) {
        int n2;
        if (n == 0) {
            n = 10;
        }
        if ((n2 = this._pageSize) != n) {
            this._pageSize = n;
            this.pageSizeChanged(n2, this._pageSize);
            this.firePageNavigationEvent(this, 14100, n2, this._pageSize);
        }
    }

    @Override
    public int getCurrentPage() {
        return this._currentPage;
    }

    @Override
    public void setCurrentPage(int n) {
        int n2 = this._currentPage;
        if (n2 != n && (this.getPageCount() < 0 || n <= this.getPageCount() - 1) && n >= 0) {
            this._currentPage = n;
            this.pageIndexChanged(n2, this._currentPage);
            this.firePageNavigationEvent(this, 14101, n2, this._currentPage);
            if (this._saveRowIndex) {
                this.saveRowIndex();
            }
        }
    }

    private void saveRowIndex() {
        this._startRowIndex = this.getPageSize() > 0 ? this.getCurrentPage() * this.getPageSize() : 0;
    }

    protected void setPageCount(int n) {
        int n2 = this._pageCount;
        if (n2 != n) {
            this._pageCount = n;
            this.pageCountChanged(n2, this._pageCount);
            this.firePageNavigationEvent(this, 14099, n2, this._pageCount);
        }
    }

    @Override
    public int getPageCount() {
        return this._pageCount;
    }

    @Override
    public void nextPage() {
        int n = this.getCurrentPage();
        if (n < this.getPageCount() - 1) {
            this.setCurrentPage(n + 1);
        }
    }

    @Override
    public void previousPage() {
        int n = this.getCurrentPage();
        if (n > 0) {
            this.setCurrentPage(n - 1);
        }
    }

    @Override
    public void firstPage() {
        if (this.getCurrentPage() > 0) {
            this.setCurrentPage(0);
        }
    }

    @Override
    public void lastPage() {
        int n = this.getPageCount();
        if (this.getCurrentPage() < n - 1) {
            this.setCurrentPage(n - 1);
        }
    }

    @Override
    public void addPageNavigationListener(PageNavigationListener pageNavigationListener) {
        this._listenerList.add(PageNavigationListener.class, pageNavigationListener);
    }

    @Override
    public void removePageNavigationListener(PageNavigationListener pageNavigationListener) {
        this._listenerList.remove(PageNavigationListener.class, pageNavigationListener);
    }

    @Override
    public PageNavigationListener[] getPageNavigationListeners() {
        return (PageNavigationListener[])this._listenerList.getListeners(PageNavigationListener.class);
    }

    @Override
    public void firePageNavigationEvent(Object object, int n, int n2, int n3) {
        if (object == null) {
            object = this;
        }
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n) {
                case 14099: {
                    LOGGER_EVENT.fine("Total page count is changed from " + n2 + " => " + n3 + ", source is " + object.getClass().getName());
                    break;
                }
                case 14100: {
                    LOGGER_EVENT.fine("Page size is changed from " + n2 + " => " + n3 + ", source is " + object.getClass().getName());
                    break;
                }
                case 14101: {
                    LOGGER_EVENT.fine("The current page index is changed from " + n2 + " => " + n3 + ", source is " + object.getClass().getName());
                    break;
                }
            }
        }
        Object[] objectArray = this._listenerList.getListenerList();
        PageNavigationEvent pageNavigationEvent = new PageNavigationEvent(object, n, n2, n3);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PageNavigationListener.class) continue;
            ((PageNavigationListener)objectArray[i + 1]).pageNavigationEventFired(pageNavigationEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pageSizeChanged(int n, int n2) {
        int n3 = this.getCurrentPage();
        int n4 = this.getTotalRecordCount();
        if (n4 >= 0) {
            this.setPageCount(n4 / n2 + (n4 % n2 == 0 ? 0 : 1));
        } else {
            this.setPageCount(-1);
        }
        this._saveRowIndex = false;
        try {
            if (this._startRowIndex > 0) {
                this.setCurrentPage(this._startRowIndex / n2);
            } else {
                this.setCurrentPage(0);
            }
        }
        finally {
            this._saveRowIndex = true;
        }
        int n5 = this.getCurrentPage();
        if (n5 == n3) {
            this.pageIndexChanged(n3, n5);
        }
    }

    abstract void pageCountChanged(int var1, int var2);

    abstract void pageIndexChanged(int var1, int var2);
}

