/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.navigation;

import com.jidesoft.icons.RolloverIcon;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.swing.NavigationComponentHelper;
import com.jidesoft.tooltip.ExpandedTipUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NavigationTree
extends JTree
implements NavigationComponent,
RolloverIcon.IconRolloverSupport {
    private NavigationComponentHelper _helper;
    private float _iconAlpha = 0.0f;
    private Animator _exitAnimator;
    private Animator _enterAnimator;
    public static final String PROPERTY_SHOW_TREE_LINES = "showTreeLines";
    public static final String PROPERTY_WIDE_SELECTION = "wideSelection";
    public static final String PROPERTY_FADE_ICON = "fadeIcon";
    public static final String PROPERTY_EXPANDED_TIP = "expandedTip";
    private boolean _showTreeLines = false;
    private boolean _wideSelection = true;
    private boolean _fadeIcon = true;
    private boolean _expandedTip = true;

    public NavigationTree() {
        this.initComponents();
    }

    public NavigationTree(Object[] objectArray) {
        super(objectArray);
        this.initComponents();
    }

    public NavigationTree(Vector<?> vector) {
        super(vector);
        this.initComponents();
    }

    public NavigationTree(Hashtable<?, ?> hashtable) {
        super(hashtable);
        this.initComponents();
    }

    public NavigationTree(TreeNode treeNode) {
        super(treeNode);
        this.initComponents();
    }

    public NavigationTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
        this.initComponents();
    }

    public NavigationTree(TreeModel treeModel) {
        super(treeModel);
        this.initComponents();
    }

    @Override
    public void updateUI() {
        boolean bl = UIManager.getBoolean("Tree.paintLines");
        if (!this.isShowTreeLines()) {
            UIManager.put("Tree.paintLines", Boolean.FALSE);
        }
        super.updateUI();
        ((BasicTreeUI)this.getUI()).setExpandedIcon(new RolloverIcon((RolloverIcon.IconRolloverSupport)this, 0));
        ((BasicTreeUI)this.getUI()).setCollapsedIcon(new RolloverIcon((RolloverIcon.IconRolloverSupport)this, 1));
        if (!this.isShowTreeLines()) {
            UIManager.put("Tree.paintLines", bl);
        }
    }

    private void initComponents() {
        this._exitAnimator = new Animator(this, 100, 30, 30);
        this._exitAnimator.addAnimatorListener(new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
            }

            @Override
            public void animationFrame(Component component, int n, int n2) {
                float f = 1.0f * (float)(n - n2) / (float)n;
                if (f <= NavigationTree.this.getIconAlpha()) {
                    NavigationTree.this.setIconAlpha(f);
                }
                NavigationTree.this.repaint();
            }

            @Override
            public void animationEnds(Component component) {
                NavigationTree.this.setIconAlpha(0.0f);
                NavigationTree.this.repaint();
            }
        });
        this._enterAnimator = new Animator(this, 100, 5, 10);
        this._enterAnimator.addAnimatorListener(new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
            }

            @Override
            public void animationFrame(Component component, int n, int n2) {
                float f = 1.0f * (float)n2 / (float)n;
                if (f >= NavigationTree.this.getIconAlpha()) {
                    NavigationTree.this.setIconAlpha(f);
                }
                NavigationTree.this.repaint();
            }

            @Override
            public void animationEnds(Component component) {
                NavigationTree.this.setIconAlpha(1.0f);
                NavigationTree.this.repaint();
            }
        });
        this._helper = this.createNavigationHelper();
        this._helper.setup(this);
        if (this._expandedTip) {
            ExpandedTipUtils.install(this);
        }
    }

    protected NavigationComponentHelper createNavigationHelper() {
        return new NavigationTreeHelper();
    }

    @Override
    public boolean isIconRollover(int n, int n2, int n3, int n4) {
        Point point = this._helper.getMousePosition();
        return point != null && point.x >= n && point.x <= n + n3 && point.y >= n2 && point.y <= n2 + n4;
    }

    private TreePath getPathForLocationInternal(int n, int n2) {
        Rectangle rectangle;
        TreePath treePath = this.getClosestPathForLocation(n, n2);
        if (treePath != null && (rectangle = this.getPathBoundsInternal(treePath)) != null && n >= rectangle.x && n < rectangle.x + rectangle.width && n2 >= rectangle.y && n2 < rectangle.y + rectangle.height) {
            return treePath;
        }
        return null;
    }

    private int getRowForLocationInternal(int n, int n2) {
        return this.getRowForPath(this.getPathForLocationInternal(n, n2));
    }

    private Rectangle getPathBoundsInternal(TreePath treePath) {
        Rectangle rectangle = super.getPathBounds(treePath);
        if (rectangle != null && this.isWideSelection()) {
            rectangle.x = 0;
            rectangle.width = this.getWidth();
        }
        return rectangle;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this._helper.paint(graphics, this);
    }

    private Rectangle getRowBoundsInternal(int n) {
        Rectangle rectangle = this.getRowBounds(n);
        if (rectangle != null) {
            if (this.isWideSelection()) {
                rectangle.x = 0;
                rectangle.width = this.getWidth();
            }
            return rectangle;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public boolean isRowSelected(int n) {
        return false;
    }

    public boolean isRowSelectedOriginal(int n) {
        return super.isRowSelected(n);
    }

    @Override
    public float getIconAlpha() {
        return this._iconAlpha;
    }

    public void setIconAlpha(float f) {
        this._iconAlpha = f;
    }

    public boolean isShowTreeLines() {
        return this._showTreeLines;
    }

    public void setShowTreeLines(boolean bl) {
        boolean bl2 = this._showTreeLines;
        if (bl != this._showTreeLines) {
            this._showTreeLines = bl;
            this.firePropertyChange(PROPERTY_SHOW_TREE_LINES, bl2, this._showTreeLines);
            this.updateUI();
        }
    }

    public boolean isWideSelection() {
        return this._wideSelection;
    }

    public void setWideSelection(boolean bl) {
        boolean bl2 = this._wideSelection;
        if (bl != this._wideSelection) {
            this._wideSelection = bl;
            this.firePropertyChange(PROPERTY_WIDE_SELECTION, bl2, this._wideSelection);
            this._helper.repaintSelections(this);
        }
    }

    @Override
    public boolean isIconFade() {
        return this._fadeIcon;
    }

    public void setFadeIcon(boolean bl) {
        boolean bl2 = this._fadeIcon;
        if (bl != this._fadeIcon) {
            this._fadeIcon = bl;
            this.firePropertyChange(PROPERTY_FADE_ICON, bl2, this._fadeIcon);
            this.repaint();
        }
    }

    public boolean isExpandedTip() {
        return this._expandedTip;
    }

    public void setExpandedTip(boolean bl) {
        boolean bl2 = this._expandedTip;
        if (bl != this._expandedTip) {
            this._expandedTip = bl;
            this.firePropertyChange(PROPERTY_EXPANDED_TIP, bl2, this._expandedTip);
            if (this._expandedTip) {
                ExpandedTipUtils.install(this);
            } else {
                ExpandedTipUtils.uninstall(this);
            }
        }
    }

    public int getNavigationRolloverRow() {
        return this._helper.getRolloverRow();
    }

    public void setNavigationRolloverRow(int n) {
        int n2 = this._helper.getRolloverRow();
        if (n2 != n) {
            this._helper.setRolloverRow(n);
            Rectangle rectangle = this.getRowBounds(n2);
            if (rectangle != null) {
                this.repaint(rectangle);
            }
            if ((rectangle = this.getRowBounds(n)) != null) {
                this.repaint(rectangle);
            }
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(NavigationTree.class.getName(), 2);
        }
    }

    public class NavigationTreeHelper
    extends NavigationComponentHelper {
        @Override
        public Rectangle getRowBounds(int n) {
            return NavigationTree.this.getRowBoundsInternal(n);
        }

        @Override
        public int rowAtPoint(Point point) {
            return NavigationTree.this.getRowForLocationInternal(point.x, point.y);
        }

        @Override
        public int[] getSelectedRows() {
            return NavigationTree.this.getSelectionRows();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (NavigationTree.this.isIconFade() && !NavigationTree.this.hasFocus()) {
                NavigationTree.this._enterAnimator.stop();
                NavigationTree.this._exitAnimator.start();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (NavigationTree.this.isIconFade() && !NavigationTree.this.hasFocus()) {
                NavigationTree.this._exitAnimator.stop();
                NavigationTree.this._enterAnimator.start();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (NavigationTree.this.isWideSelection()) {
                Object object;
                int n = this.rowAtPoint(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                Rectangle rectangle = NavigationTree.this.getRowBounds(n);
                TreePath treePath = NavigationTree.this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                Object object2 = null;
                try {
                    object = (BasicTreeUI)NavigationTree.this.getUI();
                    Method method = BasicTreeUI.class.getDeclaredMethod("isLocationInExpandControl", TreePath.class, Integer.TYPE, Integer.TYPE);
                    method.setAccessible(true);
                    object2 = method.invoke(object, treePath, mouseEvent.getX(), mouseEvent.getY());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!Boolean.TRUE.equals(object2) && !rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    object = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), rectangle.x + rectangle.width - 1, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                    NavigationTree.this.dispatchEvent((AWTEvent)object);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (NavigationTree.this.isIconFade()) {
                NavigationTree.this._exitAnimator.stop();
                NavigationTree.this._enterAnimator.start();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (NavigationTree.this.isIconFade()) {
                NavigationTree.this._enterAnimator.stop();
                NavigationTree.this._exitAnimator.start();
            }
        }
    }
}

